<?php

/**
 * Parses a template and replaces the tags found in the template
 *
 * @param string $template		The template to search and replace in
 * @param array $data					The tags and it's data to be used for replacing
 * @param array $tags					The original tags array
 * @return string							The template with the replaced tags
 */
function replace_ar_tags($template, $data, $tags) {

	//replace the data with the keys
	foreach($data AS $key=>$val) {
		$template = str_replace($key, $val, $template);
		unset($tags[$key]);
		}

	return $template;
	}

/**
 * Create an assoc array with the tags and the corresponding data
 *
 * @param array $buffer			An array with a record extracted from the DB
 * @param array $tags				An array with the tags data
 * @return array						An assoc array with tags and the corresponding data
 */
function create_ar_data($buffer, $tags) {
	$data = array();
	foreach($tags AS $tag) {
		if (isset ($buffer[$tag['field']])) {
			$data[$tag['tag']] = $buffer[$tag['field']];
			}
		}
	return $data;
	}

/**
 * Returns an array only with the tags
 *
 * @param array $tags		The original tags array
 * @return array
 */
function extract_ar_tags($tags) {
	$res_tag = array();
	foreach($tags AS $tag) {
		$res_tag[] = $tag['tag'];
		}

	return $res_tag;
	}

$ar_tags = array(
	  array('tag'=>'[lead_first_name]', 'field'=>'ar_leads_firstname', 'desc'=>'The lead\'s first name')
	, array('tag'=>'[lead_last_name]', 'field'=>'ar_leads_lastname', 'desc'=>'The lead\'s last name')
	, array('tag'=>'[lead_email]', 'field'=>'ar_leads_email', 'desc'=>'The lead\'s email address')
	, array('tag'=>'[lead_phone]', 'field'=>'ar_leads_phone', 'desc'=>'The lead\'s phone number')
	
	, array('tag'=>'[join_link]', 'field'=>'subscribe_link', 'desc'=>'The lead\'s join page link')
	
	, array('tag'=>'[member_first_name]', 'field'=>'First_Name', 'desc'=>'The sponsor\'s first name')
	, array('tag'=>'[member_last_name]', 'field'=>'Last_Name', 'desc'=>'The sponsor\'s last name')
	, array('tag'=>'[member_phone]', 'field'=>'phone', 'desc'=>'The sponsor\'s phone number')
	, array('tag'=>'[member_email]', 'field'=>'email', 'desc'=>'The sponsor\'s email')
	, array('tag'=>'[member_website]', 'field'=>'member_website', 'desc'=>'The sponsor\'s website')
	, array('tag'=>'[member_username]', 'field'=>'Username', 'desc'=>'The sponsor\'s username')		
	
	
	, array('tag'=>'[confirm_link]', 'field'=>'confirm_link', 'desc'=>'The opt-in confirmation link')
	, array('tag'=>'[unsubscribe_url]', 'field'=>'unsubscribe_url', 'desc'=>'The unsubscribe link')
	);