<?php
//---------------------------------------------------------------
//Made by: Nikolay Kolev
//Firm: Kaizen
//Date: 29th May 2009
//Last Modified: 22th January 2010
//----------------------------------------------------------------

include_once $Global['path'].'admin/Lib/OrderSubscription.inc.php';
include_once $Global['path'].'Store_inc/Lang/English.language.php';

/**
 * From specific date format we convert it to Y-m-d
 *
 * @param string $date
 * @param string $format
 * @return string
 */
function get_mysql_date($date, $format = 'Y-m-d') {

    //the position of the parts of the date (m=month, d=day, Y=year)
    $pos = array('Y'=>1, 'm'=>2, 'd'=>3);

    $format = str_replace('YYYY', 'Y', $format);
    $format = str_replace('mm', 'm', $format);
    $format = str_replace('dd', 'd', $format);

    //find the positions of the date parts
    $y = strpos($format, 'Y');
    $m = strpos($format, 'm');
    $d = strpos($format, 'd');

    if ($y !== false && $m !== false && $y > $m) {

	    $tmp = $pos['Y'];
	    $pos['Y'] = $pos['m'];
	    $pos['m'] = $tmp;
	    }

    if ($y !== false && $d !== false && $y > $d) {

	    $tmp = $pos['Y'];
	    $pos['Y'] = $pos['d'];
	    $pos['d'] = $tmp;
	    }

    if ($d !== false && $m !== false && $m > $d) {

	    $tmp = $pos['m'];
	    $pos['m'] = $pos['d'];
	    $pos['d'] = $tmp;
	    }

    $pattern = str_replace('Y', '([0-9]{4})', $format);
    $pattern = str_replace('m', '([0-9]{2})', $pattern);
    $pattern = str_replace('d', '([0-9]{2})', $pattern);
    $pattern = str_replace('.', '\.', $pattern);
    $pattern = '/^'.$pattern.'$/';

    //match the format of the date
    if (preg_match ($pattern, $date, $parts)) {

	    //check weather the date is valid of not
	    if(checkdate($parts[$pos['m']],$parts[$pos['d']],$parts[$pos['Y']])) {

		    return $parts[$pos['Y']].'-'.$parts[$pos['m']].'-'.$parts[$pos['d']];
		    }
	    else {

		    return $date;
		    }
	    }
    else {

	    return $date;
	    }
    }

/**
 * Adds all permissions for a member to a store
 *
 * @param int $member_id
 * @param int $store_id
 */
function add_store_permissions($member_id, $store_id) {

    for($i=16;$i < 39;++$i) {

	$sql = 'INSERT INTO members_stores_permissions SET member_id='.(int)$member_id.', store_id='.(int)$store_id.', permission_id='.$i;
	mysql_query($sql);
	}

	$sql = 'INSERT INTO members_stores(member_id, store_id) VALUES('.$member_id.', '.$store_id.')';
	mysql_query($sql);
    }

/**
 * Creates an empty store with default data
 */
function empty_store($member_id, $store_name, $store_seo_name, $store_email) {

    global $Global;
    
    $sql = 'INSERT INTO store(store_name, store_seo_name, country_iso, member_id, store_email, store_email_title, store_processing_fee_ship, store_processing_fee_down, store_header, store_footer, store_enabled, store_closed, owner_info, owner_company_name, owner_name, owner_address, owner_zip, owner_city, owner_state, owner_region, owner_country, owner_phone, owner_email, redirect_link) VALUES("'.mysql_escape_string($store_name).'", "'.mysql_escape_string($store_seo_name).'", "US", '.($member_id==1?'NULL':$member_id).', "'.mysql_escape_string($store_email).'", "", 0, 0, "header_tpl.php", "footer_tpl.php", "N", "N", "", "", "", "", "", "", NULL, NULL, "US", "", "", "")';
    mysql_query($sql) or die(mysql_error());
    $new_store_id = mysql_insert_id();

    $email['pased_subject'] = '[store_name] Payment Received Order #[order_id]';
    $email['pased_message'] = <<<EOD
Hello [firstname],

Thank you for the order.

Order number #[order_id]

Billing Information:
[firstname]
[lastname]
[address]
[city], [state] [zip]
[country]

Phone:
[phone]

Shipping Information:
[ship_firstname]
[ship_lastname]
[ship_address]
[ship_city], [ship_state] [ship_zip]
[ship_country]

Courier:
[courier]

Ordered products:
[products]


Order total:
Amount:			$[amount]
Shipping & handeling:	$[shipping_amount]
Discount:		$[discount_amount]
Tax:			$[tax_amount]

Total:			$[total_amount]


Note:
[note]

If you have ordered downloadable products or giftcard(s) you will receive another email with information on how to collect the product.

Thanks

Regards
Store
EOD;

			$email['sub_subject'] = '[store_name] Subscription Order #[order_id]';
			$email['sub_message'] = <<<EOD
Hello [firstname],

Thank you for the order. Your subscription payment has been received and your subscription period is prolonged.

Please look below for the subscription details:

Order number: [order_id]
Key: [order_key]

Ordered products:
[products]


Order total:
Total:			$[total_amount]

To remove your subscription follow the link below and input your Order number and your Key
from the details above:
[order_cancel_url]

Thanks

Regards
Store
EOD;

			//order require shipping international
			$email['pasei_subject'] = '[store_name] Payment Received Order #[order_id]';
			$email['pasei_message'] = <<<EOD
Hello [firstname],

Thank you for the order.

Order number #[order_id]

Billing Information:
[firstname]
[lastname]
[address]
[zip] [city], [state]
[country]

Phone:
[phone]

Shipping Information:
[ship_firstname]
[ship_lastname]
[ship_address]
[ship_city], [ship_state] [ship_zip]
[ship_country]

Courier:
[courier]

Ordered products:
[products]


Order total:
Amount:			$[amount]
Shipping & handeling:	$[shipping_amount]
Discount:		$[discount_amount]
Tax:			$[tax_amount]

Total:			$[total_amount]


Note:
[note]

If you have ordered downloadable products or giftcard(s) you will receive another email with information on how to collect the product.

Thanks

Regards
Store
EOD;

			//order not requireing shipping domestic
			$email['paed_subject'] = '[store_name] Processed Order #[order_id]';
			$email['paed_message'] = <<<EOD
Hello [firstname],

Thank you for the order.

Order number #[order_id]

Billing Information:
[firstname]
[lastname]
[address]
[city], [state] [zip]
[country]

Phone:
[phone]


Ordered products:
[products]


Order total:
Amount:			$[amount]
Shipping & handeling:	$[shipping_amount]
Discount:		$[discount_amount]
Tax:			$[tax_amount]

Total:			$[total_amount]


Note:
[note]

If you have ordered downloadable products or giftcard(s) you will receive another email with information on how to collect the product.

Thanks

Regards
Store
EOD;

		//order not requireing shipping international
			$email['paei_subject'] = '[store_name] Processed Order #[order_id]';
			$email['paei_message'] = <<<EOD
Hello [firstname],

Thank you for the order.

Order number #[order_id]

Billing Information:
[firstname]
[lastname]
[address]
[zip] [city], [state]
[country]

Phone:
[phone]


Ordered products:
[products]


Order total:
Amount:			$[amount]
Shipping & handeling:	$[shipping_amount]
Discount:		$[discount_amount]
Tax:			$[tax_amount]

Total:			$[total_amount]


Note:
[note]

If you have ordered downloadable products or giftcard(s) you will receive another email with information on how to collect the product.

Thanks

Regards
Store
EOD;

			//order pending payment
			$email['pe_subject'] = '[store_name] Pending Order #[order_id]';
			$email['pe_message'] = <<<EOD
Hello [firstname],

Thank you for the order, payment pending.

Please look below for payment link if you have not processed the payment yet.

Order number #[order_id]

Ordered products:
[products]


Order total:
Amount:			$[amount]
Shipping & handeling:	$[shipping_amount]
Discount:		$[discount_amount]
Tax:			$[tax_amount]

Total:			$[total_amount]


The order will not be handeled before the payment has been received.

Please click on the url below to process the payment.
[payment_url]

Thanks

Regards
Store
EOD;

			//admin email
			$email['ae_subject'] = '[store_name] [status] Order #[order_id]';
			$email['ae_message'] = <<<EOD
Order number #[order_id]

Status: [status]

Note:
[note]

Billing Information:
[firstname]
[lastname]
[address]
[city], [state] [zip]
[country]

Phone:
[phone]

E-mail:
[email]

Shipping Information:
[ship_firstname]
[ship_lastname]
[ship_address]
[ship_city], [ship_state] [ship_zip]
[ship_country]

Ordered products:
[products]


Order total:
Amount:			$[amount]
Shipping & handeling:	$[shipping_amount]
Discount:		$[discount_amount]
Tax:			$[tax_amount]

Total:			$[total_amount]
EOD;

			//download email
			$email['dle_subject'] = '[store_name] Download Information Order #[order_id]';
			$email['dle_message'] = <<<EOD
Hello [firstname],

Here is your download information.

Order number #[order_id]

Download Key - Product Name
[download_hash]

You can download the products from [download_url]

Access the webpage above, and enter the download key into the form and press submit. You will then get the ability to download the product.

Thanks

Regards
Store
EOD;

			//giftcard email
			$email['gce_subject'] = '[store_name] Giftcard Information Order #[order_id]';
			$email['gce_message'] = <<<EOD
Hello [firstname],

Here is your giftcard information.

Order number #[order_id]

Giftcard Key - Giftcard Description
[giftcard_hash]

For cash giftcards you can apply them during the checkout on the store.

If the giftcard contain products or programs you can obtain the products / programs from [giftcard_url]

Access the webpage above, and enter the giftcard key into the form and press submit. You will then receive the products / programs.

Thanks

Regards
Store
EOD;

    $query = 'INSERT INTO email (store_id, email_type, email_subject, email_message) VALUES';
    //Pending Order
    $query .= "($new_store_id, 'pe', '".mysql_escape_string($email['pe_subject'])."', '".mysql_escape_string($email['pe_message'])."'), ";

    //Confirmed Order Domestic
    $query .= "($new_store_id, 'paed', '".mysql_escape_string($email['paed_subject'])."', '".mysql_escape_string($email['paed_message'])."'), ";

    //Confirmed Order International
    $query .= "($new_store_id, 'paei', '".mysql_escape_string($email['paei_subject'])."', '".mysql_escape_string($email['paei_message'])."'), ";

    //Confirmed Order Shipping Domestic
    $query .= "($new_store_id, 'pased', '".mysql_escape_string($email['pased_subject'])."', '".mysql_escape_string($email['pased_message'])."'), ";

    //Confirmed Order Shipping International
    $query .= "($new_store_id, 'pasei', '".mysql_escape_string($email['pasei_subject'])."', '".mysql_escape_string($email['pasei_message'])."'), ";

		//Subscription Order
    $query .= "($new_store_id, 'sub', '".mysql_escape_string($email['sub_subject'])."', '".mysql_escape_string($email['sub_message'])."'), ";

    //Admin Order
    $query .= "($new_store_id, 'ae', '".mysql_escape_string($email['ae_subject'])."', '".mysql_escape_string($email['ae_message'])."'), ";

    //Download
    $query .= "($new_store_id, 'dle', '".mysql_escape_string($email['dle_subject'])."', '".mysql_escape_string($email['dle_message'])."'), ";

    //Giftcard
    $query .= "($new_store_id, 'gce', '".mysql_escape_string($email['gce_subject'])."', '".mysql_escape_string($email['gce_message'])."')";

    $query .= ';';
    mysql_query($query) or die(mysql_error());

    //insert in the invoice template table
    $tpl['email_subject'] = 'You have one invoice: [invoice_id]';
    $tpl['email_product'] = <<<EOD
----------------------------------------------------------------------------------

Product Real ID:  [product_real_id]; Product Name:  [product_name]; Product Amount: [product_amount]; Product Price:  [product_price]

EOD;
			$tpl['email'] = <<<EOD
Dear Mr/Mrs [purchaser_last_name],

Thank you for your purchase!

You have a due invoice for:

[product]

----------------------------------------------------------------------------------
Shipping address:
[ship_address]
[ship_city], [ship_country]

Customer information:
[purchaser_company_name]
[purchaser_first_name] [purchaser_last_name]
[purchaser_city], [purchaser_country]

Customer_note:  [customer_note]

Total_shipping:  [total_shipping]
Total_tax:  [total_tax]
Total_discount:  [total_discount]
Total_price:  [total_price]
Invoice_id:  [invoice_id]
Due date: [invoice_due_date]

Please use the following link to complete the payment for invoice [invoice_id]:

Invoice_link:  [invoice_link]

Please note that the payment should be completed before:  [invoice_due_date].

We look forward to doing business with you again.

Best regards:
[owner_company_name]
[owner_name]
[owner_city]
[owner_phone]

EOD;
			$tpl['text_product'] = <<<EOD
<tr>
<td>[product_real_id]</td>
<td>[product_name]</td>
<td style="text-align:center">[product_description]</td>
<td style="text-align:center">[product_amount]</td>
<td style="text-align:right">$ [product_price]</td>
</tr>
EOD;
			$tpl['text'] = <<<EOD
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">

<html xmlns="http://www.w3.org/1999/xhtml">

<head>

<meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
<style type="text/css" >
body,th,td
	{
	color:#333333;
	font:12px/16px Arial,Helvetica,Geneva,Verdana;
	}
div.print-container
	{
	border-top:10px solid #dde1e8;
	margin:30px;
	padding:20px 0px;
	width:700px;
	}
div.left-container
	{
	float:left;
	width:40%;
	}
div.right-container
	{
	float:right;
	width:35%;
	}
div.clear
	{
	clear:both;
	}
p
	{
	margin-top:0px;
	margin-bottom:20px;
	padding:0px;
	}
.center
	{
	text-align:center !important;
	}
ul
	{
	list-style:none;
	margin:0px;
	padding:0px;
	}
h1
	{
	padding:0px;
	margin:0px;
	font:18px/18px Arial,Helvetica,Geneva,Verdana;
	font-weight:bold;
	}
h2
	{
	padding:0px;
	margin:0px;
	font:18px/18px Arial,Helvetica,Geneva,Verdana;
	padding-bottom:10px;
	}
h3
	{
	padding:0px;
	margin:0px;
	font:13px Arial,Helvetica,Geneva,Verdana;
	font-weight:bold;
	padding-bottom:3px;
	}
table
	{
	border-top:1px solid #004d82;
	border-left:1px solid #004d82;
	margin-bottom:10px;
	}
table tr th, table tr td
	{
	border-bottom:1px solid #004d82;
	border-right:1px solid #004d82;
	padding:2px 5px;
	}
table tr td
	{
	background:#e8f3ff;
	}
table tr td.white
	{
	background:white;
	}
table tr td.blue
	{
	font:12px/20px Arial,Helvetica,Geneva,Verdana;
	font-weight:bold;
	color:white;
	background:#004d82;
	}
table tr th
	{
	font:12px/20px Arial,Helvetica,Geneva,Verdana;
	font-weight:bold;
	color:white;
	background:#004d82;
	text-align:left;
	text-transform:uppercase;
	}

</style>
<title>UCC</title>
</head>

<body>
<div class="print-container">
	<div class="left-container">
		<ul>
			<li><h1>[owner_name]</h1>
			<li><h2>[owner_company_name]</h2>
			<li>[owner_address]</li>
			<li>[owner_address2]</li>
			<li>[owner_zip]</li>
			<li>[owner_city], [owner_region]</li>
			<li>[owner_country]</li>
			<li><span>Phone:</span> [owner_phone]</li>
			<li><span>Email:</span> [owner_email]</li>
		</ul>
	</div>
	<div class="right-container">
		<table class="table-list" width="100%" cellpadding="0" cellspacing="0" border="0">
			<tr>
				<td><strong>Invoice Order ID</strong></td>
				<td>[orders_id]</td>
		 </tr>
			<tr>
				<td class="blue"><strong>Invoice</strong></td>
				<td class="blue">[invoice_id]</td>
			</tr>
			<tr>
				<td>Type:</td>
				<td>[invoice_type]</td>
			</tr>
			<tr>
				<td>Due/Paid Date:</td>
				<td>[invoice_due_date]</td>
			</tr>
		</table>
	</div>
	<div class="clear"><!----></div>
	<p> </p>
	<div class="left-container">
		<ul>
			<li><h3>Bill to:</h3></li>
			<li>[purchaser_first_name] [purchaser_last_name]</li>
			<li>[purchaser_company_name]</li>
			<li>[purchaser_address]</li>
			<li>[purchaser_address2]</li>
			<li>[purchaser_zip]</li>
			<li>[purchaser_city], [purchaser_region]</li>
			<li>[purchaser_country]</li>
			<li>Email: [purchaser_email]</li>
			<li>Phone: [purchaser_phone]</li>
		</ul>
	</div>
	<div class="right-container">
		<ul>
			<li><h3>Ship to:</h3></li>
			<li>[ship_firstname] [ship_lastname]</li>
			<li>[ship_address]</li>
			<li>[ship_address2]</li>
			<li>[ship_zip]</li>
			<li>[ship_city], [ship_region]</li>
			<li>[ship_country]</li>
		</ul>
	</div>

	<div class="clear"><!----></div>
	<p> </p>

	<table class="table-list" width="100%" cellpadding="0" cellspacing="0" border="0">
		<tr>
			<th width="18%">Id</th>
			<th width="30%">Product</th>
			<th width="30%" style="text-align:center">Description</th>
			<th width="10%" style="text-align:center">Amount</th>
			<th width="12%" style="text-align:right">Price</th>
		</tr>
		[product]
	</table>

	<div class="left-container">
		<div class="note"><h3>Note:</h3> [customer_note]</div>
	</div>

	<div class="right-container">
		<table width="100%" cellpadding="0" cellspacing="0" border="0">
			<tr>
				<td class="white" width="65%">Shipping:</td>
				<td style="text-align:right" width="35%">$[total_shipping]</td>
			</tr>
			<tr>
				<td class="white">Taxes:</td>
				<td style="text-align:right">$[total_tax]</td>
			</tr>
			<tr>
				<td class="white">Total Discount</td>
				<td style="text-align:right">$[total_discount]</td>
			</tr>
		</table>
		<table width="100%" cellpadding="0" cellspacing="0" border="0">
			<tr>
				<td class="white" width="65%"><strong>Total Price:</strong></td>
				<td style="text-align:right" width="35%"><strong>$[total_price]</strong></td>
			</tr>
		</table>
	</div>

</div>
</body>
</html>
EOD;
			$tpl['isend_subject'] = 'Invoice [invoice_id] was sent to [purchaser_first_name] [purchaser_last_name]';
			$tpl['isend'] = <<<EOD
Hello [owner_name],

An invoice [invoice_id] was sent to [purchaser_first_name] [purchaser_last_name] for:

[product]

----------------------------------------------------------------------------------
Shipping address:
[ship_address]
[ship_city], [ship_country]

Customer information:
[purchaser_company_name]
[purchaser_first_name] [purchaser_last_name]
[purchaser_city], [purchaser_country]
[purchaser_address]

Customer note:  [customer_note]

Private note: [private_note]

Total_shipping:  [total_shipping]
Total_tax:  [total_tax]
Total_discount:  [total_discount]
Total_price:  [total_price]
Invoice_id:  [invoice_id]
Due date: [invoice_due_date]

The payment should be completed before:  [invoice_due_date]

Note: This email was automatically generated for:
[owner_company_name]
[owner_name]
[owner_address], [owner_country]
[owner_email]

EOD;
			$tpl['isend_product'] = <<<EOD
Product Real ID:  [product_real_id]; Product Name:  [product_name]; Product Amount: [product_amount]; Product Price:  [product_price]
EOD;
			$tpl['ipaid_subject'] = 'Invoice [invoice_id] paid successfully!';
			$tpl['ipaid'] = <<<EOD
Dear Mr/Mrs [purchaser_last_name],

Your invoice [invoice_id] was successfully paid!

You have purchased:

[product]

----------------------------------------------------------------------------------
Shipping address:
[ship_address]
[ship_city], [ship_country]

Customer information:
[purchaser_company_name]
[purchaser_first_name] [purchaser_last_name]
[purchaser_city], [purchaser_country]

Customer_note:  [customer_note]

Total_shipping:  [total_shipping]
Total_tax:  [total_tax]
Total_discount:  [total_discount]
Total_price:  [total_price]
Invoice_id:  [invoice_id]

We look forward to doing business with you again.

Best regards:
[owner_company_name]
[owner_name]
[owner_city]
[owner_phone]

EOD;
			$tpl['ipaid_product'] = <<<EOD
Product Real ID:  [product_real_id]; Product Name:  [product_name]; Product Amount: [product_amount]; Product Price:  [product_price]
EOD;
			$tpl['invoice_thank'] = <<<EOD
Thank you! Your order will be processed automatically upon receiving notification of payment. If no payment was required for the product(s) selected, and or you purchased downloadable product(s), please check your email for further instructions.

EOD;

    $sql = "INSERT INTO invoices_templates(store_id, template, template_type) VALUES($new_store_id, '".mysql_escape_string($tpl['email'])."', 1),($new_store_id, '".mysql_escape_string($tpl['email_product'])."', 2),($new_store_id, '".mysql_escape_string($tpl['text'])."', 4),($new_store_id, '".mysql_escape_string($tpl['text_product'])."', 8),($new_store_id, '".mysql_escape_string($tpl['invoice_thank'])."', 16),($new_store_id, '".mysql_escape_string($tpl['isend'])."', 32),($new_store_id, '".mysql_escape_string($tpl['isend_product'])."', 64),($new_store_id, '".mysql_escape_string($tpl['ipaid'])."', 128),($new_store_id, '".mysql_escape_string($tpl['ipaid_product'])."', 255),($new_store_id, '".mysql_escape_string($tpl['email_subject'])."', 3),($new_store_id, '".mysql_escape_string($tpl['isend_subject'])."', 48),($new_store_id, '".mysql_escape_string($tpl['ipaid_subject'])."', 192)";
    mysql_query($sql) or die(mysql_error());

    //Text query
    $query = 'INSERT INTO text (store_id, text_type, text_data) VALUES ';

    //Store closed/disabled text message
    $query .= "($new_store_id, 'disabled', '')";

		//Store order item
		$query .= "({$new_store_id}, 'order_item', 'Order [order_id]')";

		//Store order description
		$query .= "({$new_store_id}, 'order_desc', 'Payment for Order [order_id] in \"[store_name]\"')";

    $query .= ';';

    mysql_query($query) or die(mysql_error());

    //Insert the processors into the fee database
    $query = '';

    foreach ($Global['processor_type'] as $key => $value) {
	    if (!empty($query)) $query .= ',';

	    $query .= "($new_store_id, '$key', 0)";
	    }

    $query = 'INSERT INTO processor_fee (store_id, processor_fee_type, processor_fee_amount) VALUES '.$query.';';
    mysql_query($query) or die(mysql_error());

    add_store_permissions($member_id, $new_store_id);


    return $new_store_id;
    }

/**
 * Copies a store with all it's data except orders/invoices
 * Files are copied too
 * Return the id of the new store
 */
function copy_store($store_id, $member_id, $store_name, $store_seo_name, $store_email) {

	//check if this store exists
	$sql = 'SELECT store_id FROM store WHERE store_id='.(int)$store_id;
	$result = mysql_query($sql);
	$buffer = mysql_fetch_assoc($result);
	if (empty($buffer['store_id'])) {

	    return false;
	    }

	global $Global;

	$sql = 'INSERT INTO store(store_name, store_seo_name, country_iso, member_id, store_email, store_email_title, store_processing_fee_ship, store_processing_fee_down, store_header, store_footer, store_enabled, store_closed, owner_info, owner_company_name, owner_name, owner_address, owner_zip, owner_city, owner_state, owner_region, owner_country, owner_phone, owner_email, redirect_link, store_affiliate_payout, store_admin_accept_all, store_payment_keep_period, only_registered_members, store_commission_expire, min_required_rep_members, store_commission_flush_period) SELECT "'.mysql_escape_string($store_name).'", "'.mysql_escape_string($store_seo_name).'", country_iso, '.($member_id==1?'NULL':$member_id).', "'.mysql_escape_string($store_email).'", store_email_title, store_processing_fee_ship, store_processing_fee_down, store_header, store_footer, store_enabled, store_closed, owner_info, owner_company_name, owner_name, owner_address, owner_zip, owner_city, owner_state, owner_region, owner_country, owner_phone, owner_email, redirect_link, store_affiliate_payout, store_admin_accept_all, store_payment_keep_period, only_registered_members, store_commission_expire, min_required_rep_members, store_commission_flush_period FROM store WHERE store_id='.(int)$store_id;
	mysql_query($sql) or die(mysql_error());
	$new_store_id = mysql_insert_id();

	//copy the e-mail subjects
	$sql = 'INSERT INTO email (store_id, email_type, email_subject, email_message) SELECT '.$new_store_id.', email_type, email_subject, email_message FROM email WHERE store_id='.(int)$store_id;
	mysql_query($sql) or die(mysql_error());

	//Text query
	$sql = 'INSERT INTO text (store_id, text_type, text_data) SELECT '.$new_store_id.', text_type, text_data FROM text WHERE store_id='.(int)$store_id;
	mysql_query($sql) or die(mysql_error());

	//copy tax info
	$sql = 'INSERT INTO tax (country_iso, store_id, state_id, tax_percent, tax_on, tax_created, tax_modified) SELECT country_iso, '.$new_store_id.', state_id, tax_percent, tax_on, tax_created, tax_modified FROM tax WHERE store_id='.(int)$store_id;
	mysql_query($sql) or die(mysql_error());

	//copy invoice templates
	$sql = 'INSERT INTO invoices_templates (store_id, template, template_type) SELECT '.$new_store_id.', template, template_type FROM invoices_templates WHERE store_id='.(int)$store_id;
	mysql_query($sql) or die(mysql_error());

	//copy ship info
	$sql = 'SELECT * FROM ship WHERE store_id='.(int)$store_id;
	$result = mysql_query($sql) or die(mysql_error());
	$ship_info = array();
	while ($buffer = mysql_fetch_assoc($result)) {

	    $sql = 'INSERT INTO ship(store_id, ship_name, ship_type, ship_enabled, ship_created, ship_modified) VALUES('.$new_store_id.', "'.mysql_escape_string($buffer['ship_name']).'", "'.mysql_escape_string($buffer['ship_type']).'", "'.mysql_escape_string($buffer['ship_enabled']).'", '.time().', '.time().')';
	    mysql_query($sql) or die(mysql_error());
	    $ship = mysql_insert_id();
	    $ship_info[$buffer['ship_id']] = array_merge($buffer, array('new_id'=>$ship));

	    //get all the ship info
	    $sql = 'INSERT INTO ship_info(ship_id, ship_info_weight_from, ship_info_weight_to, ship_info_price, ship_info_created, ship_info_modified) SELECT '.$ship.', ship_info_weight_from, ship_info_weight_to, ship_info_price, '.time().', '.time().' FROM ship_info WHERE ship_id='.$buffer['ship_id'];
	    mysql_query($sql) or die(mysql_error());
	    }

	//copy the processor fee
	$sql = 'INSERT INTO processor_fee (program_id, program_plan_id, store_id, processor_fee_type, processor_fee_sub, processor_fee_normal_api, processor_fee_sub_api, processor_fee_amount) SELECT program_id, program_plan_id, '.$new_store_id.', processor_fee_type, processor_fee_sub, processor_fee_normal_api, processor_fee_sub_api, processor_fee_amount FROM processor_fee WHERE store_id='.(int)$store_id;
	mysql_query($sql) or die(mysql_error());

	//----------- copy the prodcuts -------------

	//get all the product for the store we copy from
	$products_match = array();	//holds the ids of the old store and the value of the new one
	$products = array();
	$product_ids = array(0);
	$sql = 'SELECT * FROM product WHERE store_id='.(int)$store_id;
	$result = mysql_query($sql) or die(mysql_error());
	while ($buffer = mysql_fetch_assoc($result)) {

		$products[$buffer['product_id']] = $buffer;
		$products[$buffer['product_id']]['images'] = array();
		$products[$buffer['product_id']]['giftcards'] = array();
		$products[$buffer['product_id']]['order_links'] = array();
		$product_ids[] = $buffer['product_id'];
		}

	//copy all the downloads into the new store
	$sql = 'SELECT * FROM download WHERE store_id='.(int)$store_id;
	$result = mysql_query($sql) or die(mysql_error());
	while ($buffer = mysql_fetch_assoc($result)) {

	    //insert the new download
	    $sql = 'INSERT INTO download SET store_id='.$new_store_id.', program_id="'.$buffer['program_id'].'", member_id="'.$buffer['member_id'].'", download_name="'.mysql_escape_string($buffer['download_name']).'", download_filename="'.mysql_escape_string($buffer['download_filename']).'", download_real_filename="'.mysql_escape_string($buffer['download_real_filename']).'", download_filetype="'.mysql_escape_string($buffer['download_filetype']).'", download_filesize="'.$buffer['download_filesize'].'", download_created='.time().', download_modified="'.time().'"';
	    mysql_query($sql) or die(mysql_error());
	    $download_id = mysql_insert_id();

	    //the old download paths
	    $dir_from = $Global['store']['download_path'].ceil($buffer['download_id'] / 100);
	    $file_path_from = $dir_from.'/'.$buffer['download_id'];

	    //the new download paths
	    $dir = $Global['store']['download_path'].ceil($download_id / 100);
	    if (!is_dir($dir)) mkdir($dir, 0755);	    
	    $file_path = $dir.'/'.$download_id;

	    copy($file_path_from, $file_path);

	    //go through all the products and change the download id to the new one
	    foreach ($products as &$tmp_product) {

		if ($tmp_product['download_id'] == $buffer['download_id']) {

		    $tmp_product['download_id'] = $download_id;
		    }
		}
	    }

	//get all the images for the products
	$sql = 'SELECT * FROM images WHERE product_id IN ('.implode(',', $product_ids).')';
	$result = mysql_query($sql) or die(mysql_error());
	while ($buffer = mysql_fetch_assoc($result)) {

		$products[$buffer['product_id']]['images'][] = $buffer;
		}

	//get the giftcards for the products
	$sql = 'SELECT * FROM giftcard WHERE product_id IN ('.implode(',', $product_ids).')';
	$result = mysql_query($sql) or die(mysql_error());
	while ($buffer = mysql_fetch_assoc($result)) {

		$products[$buffer['product_id']]['giftcards'][] = $buffer;
		}

	//get the product categories
	$sql = 'SELECT * FROM category WHERE store_id='.(int)$store_id;
	$result = mysql_query($sql);
	while ($buffer = mysql_fetch_assoc($result)) {

		mysql_query('INSERT INTO category SET store_id='.(int)$new_store_id.', category_name="'.mysql_escape_string($buffer['category_name']).'", category_seo_name="'.mysql_escape_string($buffer['category_seo_name']).'", category_display="'.mysql_escape_string($buffer['category_display']).'"') or die(mysql_error());
		$cat_id = mysql_insert_id();

		//go through all the products and change their old ids with the new one
		foreach($products as &$tmp_product) {

			if ($buffer['category_id'] == $tmp_product['category_id']) {

				$tmp_product['category_id'] = $cat_id;
				}
			}
		}

	//get the product discounts
	$sql = 'SELECT * FROM discount WHERE store_id='.(int)$store_id;
	$result = mysql_query($sql) or die(mysql_error());
	$discounts = array();
	while ($buffer = mysql_fetch_assoc($result)) {

		//insert the discount
		mysql_query('INSERT INTO discount SET store_id='.(int)$store_id.', discount_name="'.mysql_escape_string($buffer['discount_name']).'", discount_enabled="'.mysql_escape_string($buffer['discount_enabled']).'", discount_amount="'.$buffer['discount_amount'].'", discount_product_total="'.$buffer['discount_product_total'].'", discount_modified="'.$buffer['discount_modified'].'", discount_created="'.$buffer['discount_created'].'"') or die(mysql_error());
		$disc_id = mysql_insert_id();

		$discounts[$buffer['discount_id']] = array_merge($buffer, array('new_id'=>$disc_id));
		}

	//get order link records that are from invoice templates
	$sql = 'SELECT * FROM orders o INNER JOIN invoice_link il ON il.orders_id=o.orders_id INNER JOIN invoices_common i ON i.invoice_id=il.invoice_id INNER JOIN invoice_tpl it ON i.invoice_id=it.invoice_id WHERE o.store_id='.$store_id;
	$result = mysql_query($sql) or die(mysql_error());
	$orders = array();
	while ($buffer = mysql_fetch_assoc($result)) {

	    $sql = 'INSERT INTO orders SET store_id='.$new_store_id.', member_id='.$member_id.', ship_id="'.(isset($ship_info[$buffer['ship_id']])?$ship_info[$buffer['ship_id']]['new_id']:'').'", orders_status="'.mysql_escape_string($buffer['orders_status']).'", orders_total_shipping="'.$buffer['orders_total_shipping'].'", orders_total_tax="'.$buffer['orders_total_tax'].'", orders_total_discount="'.$buffer['orders_total_discount'].'", orders_total_price="'.$buffer['orders_total_price'].'", orders_note="'.mysql_escape_string($buffer['orders_note']).'", orders_paid_date="'.$buffer['orders_paid_date'].'", orders_packed_date="'.$buffer['orders_packed_date'].'", orders_shipped_date="'.$buffer['orders_shipped_date'].'", orders_final_date="'.$buffer['orders_final_date'].'", orders_company_name="'.mysql_escape_string($buffer['orders_company_name']).'", orders_firstname="'.mysql_escape_string($buffer['orders_firstname']).'", orders_lastname="'.mysql_escape_string($buffer['orders_lastname']).'", orders_address="'.mysql_escape_string($buffer['orders_address']).'", orders_address2="'.mysql_escape_string($buffer['orders_address2']).'", orders_zip="'.mysql_escape_string($buffer['orders_zip']).'", orders_city="'.mysql_escape_string($buffer['orders_city']).'", orders_state="'.$buffer['orders_state'].'", orders_region="'.mysql_escape_string($buffer['orders_region']).'", orders_country="'.mysql_escape_string($buffer['orders_country']).'", orders_email="'.mysql_escape_string($buffer['orders_email']).'", orders_phone="'.mysql_escape_string($buffer['orders_phone']).'", orders_ship_company_name="'.mysql_escape_string($buffer['orders_ship_company_name']).'", orders_ship_firstname="'.mysql_escape_string($buffer['orders_ship_firstname']).'", orders_ship_lastname="'.mysql_escape_string($buffer['orders_ship_lastname']).'", orders_ship_address="'.mysql_escape_string($buffer['orders_ship_address']).'", orders_ship_address2="'.mysql_escape_string($buffer['orders_ship_address2']).'", orders_ship_zip="'.mysql_escape_string($buffer['orders_ship_zip']).'", orders_ship_city="'.mysql_escape_string($buffer['orders_ship_city']).'", orders_ship_state="'.$buffer['orders_ship_state'].'", orders_ship_region="'.mysql_escape_string($buffer['orders_ship_region']).'", orders_ship_country="'.mysql_escape_string($buffer['orders_ship_country']).'", orders_ip="'.$buffer['orders_ip'].'", orders_dns="'.mysql_escape_string($buffer['orders_dns']).'", ship_name="'.mysql_escape_string($buffer['ship_name']).'", ship_type="'.mysql_escape_string($buffer['ship_type']).'", shipping="'.mysql_escape_string($buffer['shipping']).'", invoice="'.mysql_escape_string($buffer['invoice']).'"';
	    mysql_query($sql) or die (mysql_error());
	    $new_orders_id = mysql_insert_id();
	    $orders[$buffer['orders_id']] = array_merge($buffer, array('new_id'=>$new_orders_id));

	    //insert into the invoice table
	    $sql = 'INSERT INTO invoices_common (owner_name, owner_company_name, owner_address, owner_address2, owner_zip, owner_city, owner_state, owner_region, owner_country, owner_phone, owner_email, invoice_type, invoice_due_date, invoice_due, invoice_subscription, invoice_sub_period, invoice_sub_times, invoice_sub_times_sent, private_note, customer_note, invoices_send_date, invoices_send_active, invoices_send_count) SELECT owner_name, owner_company_name, owner_address, owner_address2, owner_zip, owner_city, owner_state, owner_region, owner_country, owner_phone, owner_email, invoice_type, invoice_due_date, invoice_due, invoice_subscription, invoice_sub_period, invoice_sub_times, invoice_sub_times_sent, private_note, customer_note, invoices_send_date, invoices_send_active, invoices_send_count FROM invoices_common WHERE invoice_id='.$buffer['invoice_id'];
	    mysql_query($sql) or die(mysql_error());
	    $invoice_id = mysql_insert_id();

	    //insert in the invoice_link table
	    $sql = 'INSERT INTO invoice_link(invoice_id, orders_id, invoice_md5, invoice_send) SELECT '.$invoice_id.', '.$new_orders_id.', invoice_md5, invoice_send FROM invoice_link WHERE invoice_id='.$buffer['invoice_id'].' AND orders_id='.$buffer['orders_id'];
	    mysql_query($sql) or die(mysql_error());

	    //insert in the invoice_tpl table
	    $sql = 'INSERT INTO invoice_tpl(invoice_id, invoice_tpl_name) SELECT '.$invoice_id.', invoice_tpl_name FROM invoice_tpl WHERE invoice_id='.$buffer['invoice_id'];
	    mysql_query($sql) or die (mysql_error());
	    }

	//get all order_link records
	$sql = 'SELECT ol.* FROM order_link ol INNER JOIN orders o ON ol.orders_id=o.orders_id INNER JOIN invoice_link il ON il.orders_id=o.orders_id INNER JOIN invoices_common i ON i.invoice_id=il.invoice_id INNER JOIN invoice_tpl it ON i.invoice_id=it.invoice_id WHERE ol.product_id IN ('.implode(',', $product_ids).')';
	$result = mysql_query($sql) or die(mysql_error());
	while ($buffer = mysql_fetch_assoc($result)) {

	    foreach ($products as &$tmp_product) {

		if ($tmp_product['product_id'] == $buffer['product_id']) {

		    $tmp_product['order_links'][] = $buffer;
		    break 1;
		    }
		}
	    }

	//copy the image files, giftcards and discounts
	foreach ($products as $prod_id => $product) {

		$sql = 'INSERT INTO 
							product
						SET
							category_id='.$product['category_id'].'
							, store_id='.$new_store_id.'
							, download_id="'.$product['download_id'].'"
							, product_real_id="'.mysql_escape_string($product['product_real_id']).'"
							, product_name="'.mysql_escape_string($product['product_name']).'"
							, product_seo_name="'.mysql_escape_string($product['product_seo_name']).'"
							, product_type="'.mysql_escape_string($product['product_type']).'"
							, product_weight="'.$product['product_weight'].'"
							, product_stock_use="'.mysql_escape_string($product['product_stock_use']).'"
							, product_price="'.$product['product_price'].'"
							, product_description="'.mysql_escape_string($product['product_description']).'"
							, product_tax_exempt="'.mysql_escape_string($product['product_tax_exempt']).'"
							, product_display="'.mysql_escape_string($product['product_display']).'"
							, tier1="'.$product['tier1'].'"
							, tier2="'.$product['tier2'].'"
							, tier3="'.$product['tier3'].'"
							, tier4="'.$product['tier4'].'"
							, tier5="'.$product['tier5'].'"
							, product_service="'.$product['product_service'].'"
							, product_stock="'.$product['product_stock'].'"
							, product_download_nr="'.$buffer['product_download_nr'].'"
							, product_created="'.$buffer['product_created'].'"
							, product_modified="'.$buffer['product_modified'].'"
							, product_commission_hook_enabled="'.$product['product_commission_hook_enabled'].'"
							, product_commission_hook="'.$product['product_commission_hook'].'"
							, product_subscription_period='.($product['product_subscription_period'] == '' ? 'NULL':'"'.$product['product_subscription_period'].'"').'
							, product_subscription_enabled="'.$product['product_subscription_enabled'].'"
							, product_requires_registration="'.$product['product_requires_registration'].'"
							, product_subscription_price='.($product['product_subscription_price'] == '' ? 'NULL':'"'.$product['product_subscription_price'].'"').'
							';
		mysql_query($sql) or die(mysql_error().' - '.$sql);

		$new_prod_id = mysql_insert_id();
		$products_match[$prod_id] = $new_prod_id;

		$folder_to = $Global['store']['img_path'].floor((int) $new_prod_id / 100);
		$folder_from = $Global['store']['img_path'].floor((int) $prod_id / 100);
		if (!is_dir($folder_to)) {

			mkdir($folder_to);
			chmod($folder_to, 0755);
			}

		//copy all the image files and insert the records in the database
		foreach($product['images'] as $image) {

			//insert the new image in the database
			$sql = 'INSERT INTO images SET product_id='.$new_prod_id.', images_title="'.$image['images_title'].'", images_name="'.$image['images_name'].'", images_extension="'.$image['images_extension'].'", images_type="'.$image['images_type'].'", images_order='.$image['images_order'];
			mysql_query($sql) or die(mysql_error());
			$new_img_id = mysql_insert_id();

			if (file_exists($folder_from.'/'.$image['images_id'].$image['images_extension'])) {

				copy($folder_from.'/'.$image['images_id'].$image['images_extension'], $folder_to.'/'.$new_img_id.$image['images_extension']);
				}
			if (file_exists($folder_from.'/'.$image['images_id'].'_thumb'.$image['images_extension'])) {
				
				copy($folder_from.'/'.$image['images_id'].'_thumb'.$image['images_extension'], $folder_to.'/'.$new_img_id.'_thumb'.$image['images_extension']);
				}
			if (file_exists($folder_from.'/'.$image['images_id'].'_thumb2'.$image['images_extension'])) {
				
				copy($folder_from.'/'.$image['images_id'].'_thumb2'.$image['images_extension'], $folder_to.'/'.$new_img_id.'_thumb2'.$image['images_extension']);
				}
			}

		//insert the giftcards
		foreach($product['giftcards'] as $giftcard) {

			$sql = 'INSERT INTO giftcard SET product_id='.$new_prod_id.', giftcard_type="'.mysql_escape_string($giftcard['giftcard_type']).'", giftcard_amount="'.$giftcard['giftcard_amount'].'", giftcard_expire='.$giftcard['giftcard_expire'];
			mysql_query($sql) or die(mysql_error());
			$giftcard_id = mysql_insert_id();

			//insert all the giftcard links
			$sql = 'INSERT INTO giftcard_link(program_id, giftcard_id, product_id, giftcard_link_amount) SELECT program_id, '.$giftcard_id.', '.$new_prod_id.', giftcard_link_amount FROM giftcard_link WHERE giftcard_id='.$giftcard['giftcard_id'].' AND product_id='.$prod_id;
			mysql_query($sql) or die(mysql_error());
			}

		//copy the discount link records
		$sql = 'SELECT * FROM discount_link WHERE product_id='.$prod_id;
		$result = mysql_query($sql) or die(mysql_error());
		while ($buffer = mysql_fetch_assoc($result)) {

			$sql = 'INSERT INTO discount_link SET discount_id='.$discounts[$buffer['discount_id']]['new_id'].', product_id='.$new_prod_id.', discount_link_amount="'.$buffer['discount_link_amount'].'"';
			mysql_query($sql);
			}

		//insert all the new order link objects
		foreach ($product['order_links'] as $order_link) {

		    $sql = 'INSERT INTO order_link SET product_id='.$new_prod_id.', orders_id='.$orders[$order_link['orders_id']]['new_id'].', product_name="'.mysql_escape_string($order_link['product_name']).'", product_price="'.$order_link['product_price'].'", product_weight="'.$order_link['product_weight'].'", product_download_nr="'.$order_link['product_download_nr'].'", giftcard_type="'.$order_link['giftcard_type'].'", giftcard_amount="'.$order_link['giftcard_amount'].'", giftcard_link="'.mysql_escape_string($order_link['giftcard_link']).'", giftcard_expire="'.$order_link['giftcard_expire'].'", order_amount="'.$order_link['order_amount'].'"';
		    mysql_query($sql) or die(mysql_error());
		    }
		}

	//--------- copy the commission system data ------------

	//get all addpools and copy them to the new store
	$addpools_match = array();
	$query = "SELECT
							*
						FROM
							addpool
						WHERE
							store_id=".(int)$store_id;
	$result = mysql_query($query) or die(mysql_error());
	while ($buffer = mysql_fetch_assoc($result)) {
		$query = "INSERT INTO
								addpool
							SET
								addpool_name='".mysql_escape_string($buffer['addpool_name'])."'
								, store_id=".$new_store_id."
								, addpool_flush_days='".$buffer['addpool_flush_days']."'";
		mysql_query($query) or die(mysql_error());
		$addpools_match[$buffer['addpool_id']] = mysql_insert_id();
		}

	//get all commissions and copy them to the new store
	$commissions_match = array();
	$query = "SELECT
							*
						FROM
							commission
						WHERE
							store_id=".($store_id);
	$result = mysql_query($query) or die(mysql_error());
	while ($buffer = mysql_fetch_assoc($result)) {
		$query = "INSERT INTO
								commission
							SET
								name='".mysql_escape_string($buffer['name'])."'
								, tier1='".mysql_escape_string($buffer['tier1'])."'
								, tier2='".mysql_escape_string($buffer['tier2'])."'
								, tier3='".mysql_escape_string($buffer['tier3'])."'
								, tier4='".mysql_escape_string($buffer['tier4'])."'
								, tier5='".mysql_escape_string($buffer['tier5'])."'
								, use_percent='".mysql_escape_string($buffer['use_percent'])."'
								, store_id=".$new_store_id."
								, seq_number='".mysql_escape_string($buffer['seq_number'])."'";
		mysql_query($query) or die(mysql_error());
		$commissions_match[$buffer['commission_id']] = mysql_insert_id();
		}

	//copy the commission requirements
	$query = "SELECT
							cl.*
						FROM
							commission_link cl
							INNER JOIN commission c
								USING(commission_id)
						WHERE
							c.store_id=".(int)$store_id;
	$result = mysql_query($query) or die(mysql_error());
	while ($buffer = mysql_fetch_assoc($result)) {
		$query = "INSERT INTO
								commission_link
							SET
								commission_id=".(int)$commissions_match[$buffer['commission_id']]."
								, req_commission_id=".(int)$commissions_match[$buffer['req_commission_id']]."
								, commission_link_amount=".(int)$buffer['commission_link_amount'];
		mysql_query($query) or die(mysql_error());
		}

	//get all product commissions and copy them to the new store
	$prod_comm_match = array();
	$query = "SELECT
							cpl.*
						FROM
							commission_product_link cpl
							INNER JOIN commission c
								USING(commission_id)
						WHERE
							c.store_id=".(int)$store_id;
	$result = mysql_query($query) or die(mysql_error());
	while ($buffer = mysql_fetch_assoc($result)) {
		$query = "INSERT INTO
								commission_product_link
							SET
								tier1='".mysql_escape_string($buffer['tier1'])."'
								, tier2='".mysql_escape_string($buffer['tier2'])."'
								, tier3='".mysql_escape_string($buffer['tier3'])."'
								, tier4='".mysql_escape_string($buffer['tier4'])."'
								, tier5='".mysql_escape_string($buffer['tier5'])."'
								, use_percent='".mysql_escape_string($buffer['use_percent'])."'
								, product_id=".(int)$products_match[$buffer['product_id']]."
								, commission_id=".(int)$commissions_match[$buffer['commission_id']];
		mysql_query($query) or die(mysql_error());
		$prod_comm_match[$buffer['commission_product_link_id']] = mysql_insert_id();
		}

	//copy the addpool_comm records
	$query = "SELECT
							ac.*
						FROM
							addpool_comm ac
							INNER JOIN addpool a
								USING(addpool_id)
						WHERE
							a.store_id=".(int)$store_id;
	$result = mysql_query($query) or die(mysql_error());
	while ($buffer = mysql_fetch_assoc($result)) {
		$query = "INSERT INTO
								addpool_comm
							SET
								addpool_id=".(int)$addpools_match[$buffer['addpool_id']]."
								, commission_id=".(int)$commissions_match[$buffer['commission_id']]."
								, addpool_amount='".$buffer['addpool_amount']."'";
		mysql_query($query) or die(mysql_error());
		}

	//copy the addpool_comm_percent records
	$query = "SELECT
							acp.*
						FROM
							addpool_comm_percent acp
							INNER JOIN addpool a
								USING(addpool_id)
						WHERE
							a.store_id=".(int)$store_id;
	$result = mysql_query($query) or die(mysql_error());
	while ($buffer = mysql_fetch_assoc($result)) {
		$query = "INSERT INTO
								addpool_comm_percent
							SET
								addpool_id=".(int)$addpools_match[$buffer['addpool_id']]."
								, commission_id=".(int)$commissions_match[$buffer['commission_id']]."
								, percent='".$buffer['percent']."'";
		mysql_query($query) or die(mysql_error());
		}

	//copy the addpool_product_link records
	$query = "SELECT
							apl.*
						FROM
							addpool_product_link apl
							INNER JOIN addpool a
								USING(addpool_id)
						WHERE
							a.store_id=".(int)$store_id;
	$result = mysql_query($query) or die(mysql_error());
	while ($buffer = mysql_fetch_assoc($result)) {
		$query = "INSERT INTO
								addpool_product_link
							SET
								addpool_id=".(int)$addpools_match[$buffer['addpool_id']]."
								, commission_product_link_id=".(int)$prod_comm_match[$buffer['commission_product_link_id']]."
								, addpool_amount='".$buffer['addpool_amount']."'
								, use_percent='".$buffer['use_percent']."'";
		mysql_query($query) or die(mysql_error());
		}

	if ($member_id > 1) {
	    
	    add_store_permissions($member_id, $new_store_id);
	    }

	return $new_store_id;
	}

/**
 * Sets the payment processors
 *
 * @global array $Global
 */
function set_processors(&$Global, $store_id) {

	$Global['processor'] = array();
	
	//get the memeber info to see which of the enabled processors have login credentials
	$sql = 'SELECT member_id FROM store WHERE store_id='.(int)$store_id.' LIMIT 1';
	$result = mysql_query($sql);

	if (mysql_num_rows($result) == 0) {

		return;
		}
	$row = mysql_fetch_assoc($result);

	if (empty($row['member_id'])) {

		$member_id = 1;
		}
	else {

		$member_id = $row['member_id'];
		}
	$sql = 'SELECT * FROM members WHERE ID='.$member_id.' LIMIT 1';
	$result = mysql_query($sql);

	if (mysql_num_rows($result) == 0) {

		return;
		}
	$row = mysql_fetch_assoc($result);

	$sql = "SELECT processor_fee_type as processor, processor_fee_normal as normal, processor_fee_sub as sub, processor_fee_normal_api as api_normal, processor_fee_sub_api as api_sub FROM processor_fee WHERE store_id={$store_id} GROUP BY processor_fee_type";
	$result = mysql_query($sql);
	while ($buffer = mysql_fetch_assoc($result))
		{

		if (in_array($buffer['processor'], $Global['enabled_processors_store'])) {
			$Global['processor'][$buffer['processor']] = array('normal' => false);

			switch ($buffer['processor']) {
				case 'AN':
					if (!empty($row['paymentprocessor3']) && !empty($row['paymentprocessor4'])) {

						$Global['processor'][$buffer['processor']]['normal'] = true;
						}
					break;
				case 'LP':
					if (!empty($row['paymentprocessor5']) && strtolower($row['paymentprocessor6']) == 'yes') {

						$Global['processor'][$buffer['processor']]['normal'] = true;
						}
					break;
				case 'A':
					if (!empty($row['alertpay']) && !empty($row['alertpay_passphrase'])) {

						$Global['processor'][$buffer['processor']]['normal'] = true;
						}
					break;
				case 'P':
					if (!empty($row['paypalaccount'])) {

						$Global['processor'][$buffer['processor']]['normal'] = true;
						}
					break;
//				case 'GC':
//					if (!empty($row['gc_id']) && !empty($row['gc_key'])) {
//
//						$Global['processor'][$buffer['processor']]['normal'] = true;
//						}
//					break;
				}
			}
		}
	}

function get_processor_credentials($member_id, $processor) {

	global $Global;

	if (empty($member_id)) {
		$member_id = 1;
		}

	$credentials = array();

	if (!in_array($processor, $Global['enabled_processors_store'])) {
		return $credentials;
		}

	$query = 'SELECT * FROM members WHERE ID='.$member_id.' LIMIT 1';
	$result = mysql_query($query) or die(mysql_error());
	$buffer = mysql_fetch_assoc($result);

	if (empty($buffer['ID'])) {
		return $credentials;
		}

	switch ($processor) {
		case 'AN':
			$credentials[] = $buffer['paymentprocessor3'];
			$credentials[] = base64_decode($buffer['paymentprocessor4']);
			break;
		case 'LP':
			$credentials[] = $buffer['paymentprocessor5'];
			$credentials[] = $buffer['paymentprocessor6'];
			break;
		case 'A':
			$credentials[] = $buffer['alertpay'];
			$credentials[] = $buffer['alertpay_passphrase'];
			break;
		case 'P':
			$credentials[] = $buffer['paypalaccount'];
			break;
/*		case 'GC':
			$credentials[] = $buffer['gc_id'];
			$credentials[] = $buffer['gc_key'];
			break;*/
		}
		
	return $credentials;
	}

/**
 * Sets the payment processors
 *
 * @global array $Global
 */
function set_processors_by_member(&$Global, $member_id) {

	$member_id = (int)$member_id;

	$Global['processor'] = array();

	$sql = 'SELECT * FROM members WHERE ID='.$member_id.' LIMIT 1';
	$result = mysql_query($sql);

	if (mysql_num_rows($result) == 0) {

		return;
		}
	$row = mysql_fetch_assoc($result);

	foreach($Global['enabled_processors_store'] AS $processor)
		{

		$Global['processor'][$processor] = array('normal' => false);

		switch ($processor) {
			case 'AN':
				if (!empty($row['paymentprocessor3']) && !empty($row['paymentprocessor4'])) {

					$Global['processor'][$processor]['normal'] = true;
					}
				break;
			case 'LP':
				if (!empty($row['paymentprocessor5']) && strtolower($row['paymentprocessor6']) == 'yes') {

					$Global['processor'][$processor]['normal'] = true;
					}
				break;
			case 'A':
				if (!empty($row['alertpay']) && !empty($row['alertpay_passphrase'])) {

					$Global['processor'][$processor]['normal'] = true;
					}
				break;
			case 'P':
				if (!empty($row['paypalaccount'])) {

					$Global['processor'][$processor]['normal'] = true;
					}
				break;
/*			case 'GC':
				if (!empty($row['gc_id']) && !empty($row['gc_key'])) {

					$Global['processor'][$processor]['normal'] = true;
					}
				break;*/
			}
		}
	}

/**
 * For a given invoice id and store id it returns
 * the emails of the site administrator, store owner and
 * the user that the invoice is for
 *
 * @param int $invoice_id
 * @param int $store_id
 * @return array
 */
function get_emails($invoice_id, $store_id) {

	global $Global;

	$emails = array('admin'=>$Global['admin_email'], 'owner'=>'', 'user'=>array());
	
	//get the store owner email
	$sql = 'SELECT m.email FROM store s INNER JOIN members m ON s.member_id=m.ID WHERE s.store_id='.(int)$store_id.' LIMIT 1';
	$result = mysql_query($sql) or die(mysql_error());
	if (mysql_num_rows($result) == 1) {

		$row = mysql_fetch_assoc($result);
		$emails['owner'] = $row['email'];
		}

	//get the user email
	$sql = 'SELECT email FROM invoices_email_recepients ir WHERE invoice_id='.(int)$invoice_id;
	$result = mysql_query($sql) or die(mysql_error());
	while ($row = mysql_fetch_assoc($result)) {

		$emails['user'][] = $row['email'];
		}

	return $emails;
	}

/**
 * Sets an order status as paid/finilized (if there are no shippable items)
 * and sends the download emails
 *
 * @param int $orders_id
 */
function pay_order($orders_id, $store_id, $finalize = false, $state_ord = '') {

	global $Global;

	//check to see if we have any shippable/giftcard items
	$download_email = '';
	$download_exist = false;

	$giftcard_email = '';
	$giftcard_exist = false;
	
	$shippable = false;

	$first = true;
	
	$inv_data = array();

	$sql = 'SELECT s.store_email, s.store_email_title, s.store_name, ol.product_weight, gh.giftcard_hash_md5, dh.dl_hash_md5, ol.product_id, ol.product_name, ol.product_download_nr, o.* FROM orders o INNER JOIN order_link ol ON ol.orders_id=o.orders_id INNER JOIN store s ON s.store_id=o.store_id LEFT JOIN dl_hash dh ON ol.order_link_id=dh.order_link_id LEFT JOIN giftcard_hash gh ON ol.order_link_id=gh.order_link_id WHERE s.store_id='.(int)$store_id.' AND o.orders_id='.(int)$orders_id;
	$result = mysql_query($sql);
	$row = mysql_fetch_assoc($result);
	if (!empty($row['orders_id'])) {

		do {

			if ($first === true) {

				$Global['store_email'] = $row['store_email'];
				$Global['store_email_title'] = $row['store_email_title'];
				$inv_data['store_id'] = $row['store_id'];
				$inv_data['orders_email'] = $row['orders_email'];
				$inv_data['orders_status'] = $row['orders_status'];
				$inv_data['store_name'] = $row['store_name'];
				$inv_data['client_ship_first_name'] = $row['orders_ship_firstname'];
				$inv_data['client_ship_last_name'] = $row['orders_ship_lastname'];

				$first = false;
				}

			$store_id = $row['store_id'];
			
			if (!empty($row['giftcard_type'])) {

				$giftcard_email .= ((!empty($giftcard_email))?"\r\n":'').$row['giftcard_hash_md5'].' - '.$row['product_name'].' :: '.$Language['checkout']['giftcard_cash'];
				$giftcard_exist = true;
				}

			if ($row['product_download_nr'] > 0) {

				$download_email .= ((!empty($download_email))?"\r\n":'').$row['dl_hash_md5'].' - '.$row['product_name'];
				$download_exist = true;
				}

			if ($row['product_download_nr'] == 0 && $row['product_weight'] > 0) {

				$shippable = true;
				}
			}
		while ($row = mysql_fetch_assoc($result));
		}
	else {

		//if there is no such order
		return;
		}

	//when we pay invoices there is no subscription in this function
	$is_subscription_payment = false;

	if ($shippable === true) {

		switch ($state_ord) {
			case 'PK':
				$date_order = 'orders_packed_date';
				break;
			case 'S':
				$date_order = 'orders_shipped_date';
				break;
			case 'DS':
				$date_order = 'orders_drop_shipped_date';
				break;
			case 'D':
				$date_order = 'orders_delivered_date';
				break;
			case 'F':
				$date_order = 'orders_final_date';
				break;
			default:
				$date_order = 'orders_paid_date';
				break;
			}

		$sql = 'UPDATE orders SET orders_status="'.(!empty($state_ord)?$state_ord:'PA').'", '.$date_order.'='.time().' WHERE orders_id='.(int)$orders_id.' LIMIT 1';
		mysql_query($sql);

		if (!empty($state_ord) && strtoupper($state_ord) == 'F') {

			if ($inv_data['orders_status'] == 'P') {
				mark_next_subscription_order($orders_id);	//add the payment for the current period and calculate the next
				}

			//include the commission give away file
			$GLOBALS['orders_id'] = $orders_id;
			define('IPN_PROCESS', true);
			include $Global['path'].'Ipn/Give/Orders.give.php';
			}
		}
	else {

		$sql = 'UPDATE orders SET orders_status="F", orders_final_date='.time().' WHERE orders_id='.(int)$orders_id.' LIMIT 1';
		mysql_query($sql);

		if ($inv_data['orders_status'] == 'P') {
				mark_next_subscription_order($orders_id);	//add the payment for the current period and calculate the next
				}

		//include the commission give away file
		$GLOBALS['orders_id'] = $orders_id;
		define('IPN_PROCESS', true);
		include $Global['path'].'Ipn/Give/Orders.give.php';
		}

	//if the previous state of the order is Paid then skip sending the download cause they should already be sent
	if ($inv_data['orders_status'] == 'PA') {

		return;
		}

	//mark all downloads and giftcard hashes enabled
	$sql = 'UPDATE dl_hash, order_link SET dl_hash.dl_hash_status="E" WHERE dl_hash.order_link_id=order_link.order_link_id AND order_link.orders_id='.(int)$orders_id;
	mysql_query($sql) or die(mysql_error());
	$sql = 'UPDATE giftcard_hash, order_link SET giftcard_hash.giftcard_hash_status="E" WHERE giftcard_hash.order_link_id=order_link.order_link_id AND order_link.orders_id='.(int)$orders_id;
	mysql_query($sql) or die(mysql_error());

	/**
	 * Send out the giftcard/download emails
	 */
	if ($download_exist === true || $giftcard_exist === true) {

		$result = mysql_query("SELECT email_type, email_subject, email_message FROM email WHERE store_id={$inv_data['store_id']} && email_type IN ('non_existing'".($download_exist === true ? ", 'dle'" : "").($giftcard_exist === true ? ", 'gce'" : "").")");

		while ($buffer = mysql_fetch_assoc($result))
			{

			$message = '';
			$subject = '';
			//Download email
			if ($buffer['email_type'] == 'dle') {
				//Custom Tags subject: [store_name] [order_id] [firstname] [lastname]
				$subject_replace = array('[store_name]', '[order_id]', '[firstname]', '[lastname]');
				$subject_replace_with = array($inv_data['store_name'], $orders_id, $inv_data['client_ship_first_name'], $inv_data['client_ship_last_name']);

				//Custom Tags message: [store_name] [firstname] [lastname] [order_id] [download_hash] [download_url]
				$message_replace = array('[store_name]', '[firstname]', '[lastname]', '[order_id]', '[download_hash]', '[download_url]');
				$message_replace_with = array($inv_data['store_name'], $inv_data['client_ship_first_name'], $inv_data['client_ship_last_name'], $orders_id, $download_email, $Global['webpage_url_ssl'].'download.php');

				$subject = str_replace($subject_replace, $subject_replace_with, $buffer['email_subject']);
				$message = str_replace($message_replace, $message_replace_with, $buffer['email_message']);

				}
			elseif ($buffer['email_type'] == 'gce') {
				//Custom Tags subject: [store_name] [order_id] [firstname] [lastname]
				$subject_replace = array('[store_name]', '[order_id]', '[firstname]', '[lastname]');
				$subject_replace_with = array($inv_data['store_name'], $orders_id, $inv_data['client_ship_first_name'], $inv_data['client_ship_last_name']);

				//Custom Tags message: [store_name] [firstname] [lastname] [order_id] [giftcard_hash] [giftcard_url]
				$message_replace = array('[store_name]', '[firstname]', '[lastname]', '[order_id]', '[giftcard_hash]', '[giftcard_url]');
				$message_replace_with = array($inv_data['store_name'], $inv_data['client_ship_first_name'], $inv_data['client_ship_last_name'], $orders_id, $giftcard_email, $Global['webpage_url_ssl'].'giftcard.php');

				$subject = str_replace($subject_replace, $subject_replace_with, $buffer['email_subject']);
				$message = str_replace($message_replace, $message_replace_with, $buffer['email_message']);

				}

			if (!empty($message) && !empty($subject)) {

				mail($inv_data['orders_email'], $subject, $message, "From: {$Global['store_email_title']} <{$Global['store_email']}>\r\n");
				}
			}
		}
	}

/**
 * Mark an invoice as paid/calceled
 *
 * @param int $invoice_id
 * @param array $store_id
 * @param string $state
 * @return string
 */
function mark_invoice_state($orders_id, &$inv_data, $selected_processor, $transaction_id, $state = 'paid') {

	global $Global, $Language;
	$Global['default_country'] = 'US';
	$paid_times = 'Thank you! Your order will be processed automatically upon receiving notification of payment. If no payment was required for the product(s) selected, and or you purchased downloadable product(s), please check your email for further instructions. ';
	$inv_data = array('store_id'=>0, 'invoice_id'=>0, 'client_name'=>'', 'client_company_name'=>'', 'client_address'=>'', 'client_address2'=>'', 'client_zip'=>'', 'client_city'=>'', 'client_state'=>'', 'client_region'=>'', 'client_country'=>'', 'client_email'=>'', 'client_phone'=>'', 'client_ship_company_name'=>'', 'client_ship_name'=>'', 'client_ship_address'=>'', 'client_ship_address2'=>'', 'client_ship_zip'=>'', 'client_ship_state'=>'', 'client_ship_region'=>'', 'client_ship_country'=>'', 'client_ship_city'=>'');
	switch ($state) {

		case 'paid':

			//get all the products for the selected invoice and check if any of them is not a downloadable one
			$sql = 'SELECT s.store_name, s.store_email, s.store_email_title, il.invoice_md5, ol.product_weight, gh.giftcard_hash_md5, dh.dl_hash_md5, ol.product_id, ol.product_name, ol.product_download_nr, i.invoice_subscription, i.invoice_id, i.invoice_sub_times_sent, o.* FROM store s INNER JOIN orders o ON s.store_id=o.store_id INNER JOIN invoice_link il ON il.orders_id=o.orders_id INNER JOIN invoices_common i ON il.invoice_id=i.invoice_id INNER JOIN order_link ol ON ol.orders_id=o.orders_id LEFT JOIN dl_hash dh ON ol.order_link_id=dh.order_link_id LEFT JOIN giftcard_hash gh ON ol.order_link_id=gh.order_link_id WHERE o.invoice="Y" AND o.orders_id='.(int)$orders_id;
			$result = mysql_query($sql) or die(mysql_error());

			if (mysql_num_rows($result) > 0) {
				
				$shippable = false;
				$subscription = false;
				$invoice_id = 0;
				$times_sent = 0;
				$first = true;
				$download_email = '';
				$giftcard_email = '';
				$download_exist = false;
				$giftcard_exist = false;
				$product_ids = array(0);
				$emails = array();
				$orders_hash = '';
				while ($row = mysql_fetch_assoc($result)) {

					if ($first === true) {

						$Global['store_name'] = $row['store_name'];
						$Global['store_email'] = $row['store_email'];
						$Global['store_email_title'] = $row['store_email_title'];
						$orders_hash = $row['invoice_md5'];
						$invoice_id = $row['invoice_id'];
						$times_sent = $row['invoice_sub_times_sent'];
						$inv_data['store_id'] = $row['store_id'];
						$inv_data['invoice_id'] = $row['invoice_id'];

						//fill in the country and state names
						$states = array();
						$result1 = mysql_query("SELECT state_id, state_name FROM state ORDER BY country_iso ASC");
						while ($row1 = mysql_fetch_assoc($result1)) {

							$states[$row1['state_id']] = $row1['state_name'];
							}

						$countries = array();
						$result1 = mysql_query("SELECT iso, printable_name FROM country ORDER BY name ASC");
						while ($row1 = mysql_fetch_assoc($result1)) {

							$countries[$row1['iso']] = $row1['printable_name'];
							}

						if (!empty($row['orders_ship_country'])) {

							if ($row['orders_ship_country'] == $Global['default_country']) $ship_type = 'D';
							else $ship_type = 'I';
							}
						else {

							if ($row['orders_country'] == $Global['default_country']) $ship_type = 'D';
							else $ship_type = 'I';
							}

						$inv_data['client_name'] = $row['orders_firstname'].' '.$row['orders_lastname'];
						$inv_data['client_fisrt_name'] = $row['orders_firstname'];
						$inv_data['client_last_name'] = $row['orders_lastname'];
						$inv_data['client_company_name'] = $row['orders_company_name'];

						$inv_data['client_address'] = $row['orders_address'];
						$inv_data['client_address2'] = $row['orders_address2'];
						$inv_data['client_zip'] = $row['orders_zip'];
						$inv_data['client_city'] = $row['orders_city'];
						$inv_data['client_state'] = isset($states[$row['orders_state']])?$states[$row['orders_state']]:'';
						$inv_data['client_region'] = $row['orders_region'];
						$inv_data['client_country'] = isset($countries[$row['orders_country']])?$countries[$row['orders_country']]:'';
						$inv_data['client_country_or'] = $row['orders_country'];
						$inv_data['client_email'] = $row['orders_email'];
						$inv_data['client_phone'] = $row['orders_phone'];
						$inv_data['client_ship_company_name'] = $row['orders_ship_company_name'];
						$inv_data['client_ship_name'] = $row['orders_ship_firstname'].' '.$row['orders_ship_lastname'];
						$inv_data['client_ship_first_name'] = $row['orders_ship_firstname'];
						$inv_data['client_ship_last_name'] = $row['orders_ship_lastname'];
						$inv_data['client_ship_address'] = $row['orders_ship_address'];
						$inv_data['client_ship_address2'] = $row['orders_ship_address2'];
						$inv_data['client_ship_zip'] = $row['orders_ship_zip'];
						$inv_data['client_ship_state'] = isset($states[$row['orders_ship_state']])?$states[$row['orders_ship_state']]:'';
						$inv_data['client_ship_region'] = $row['orders_ship_region'];
						$inv_data['client_ship_country'] = isset($countries[$row['orders_ship_country']])?$countries[$row['orders_ship_country']]:'';
						$inv_data['client_ship_country_or'] = $row['orders_ship_country'];
						$inv_data['client_ship_city'] = $row['orders_ship_city'];
						$inv_data['total_price'] = $row['orders_total_price'];
						$inv_data['total_tax'] = $row['orders_total_tax'];

						//get the emails for the current invoice
						$sql = 'SELECT email FROM invoices_email_recepients WHERE invoice_id='.$row['invoice_id'];
						$res = mysql_query($sql) or die(mysql_error());
						while ($r = mysql_fetch_assoc($res)) {

							$emails[] = $r['email'];
							}

						$first = false;
						}

					$product_ids[] = $row['product_id'];

					if (!empty($row['giftcard_type'])) {

						$giftcard_email .= ((!empty($giftcard_email))?"\r\n":'').$row['giftcard_hash_md5'].' - '.$row['product_name'].' :: '.$Language['checkout']['giftcard_cash'];
						$giftcard_exist = true;
						}
						
					if ($row['product_download_nr'] > 0) {
					    
						$download_email .= ((!empty($download_email))?"\r\n":'').$row['dl_hash_md5'].' - '.$row['product_name'];
						$download_exist = true;
						}
						
					if ($row['invoice_subscription'] == 'Y') {

						$subscription = true;
						}

					if (empty($row['product_download_nr']) && $row['product_weight'] > 0) {

						$shippable = true;
						}
					}
					
				$store_id = $inv_data['store_id'];
					
				//if it's a subscription increase the number of times the invoice has been paid
				//if ($subscription === true) {
					
					$sql = 'UPDATE invoices_common, invoice_link SET invoices_common.invoice_sub_times_sent='.((int)$times_sent+1).' WHERE invoice_link.orders_id='.(int)$orders_id.' AND invoice_link.invoice_id=invoices_common.invoice_id';
					mysql_query($sql) or die(mysql_error());
				//	}

				if ($shippable === true) {

					if ($ship_type == 'D') $order_email = 'paed';
					else $order_email = 'paei';

					$sql = 'UPDATE orders SET orders_status="PA", orders_paid_date="'.time().'" WHERE orders_id='.(int)$orders_id;
					}
				else {

					if ($ship_type == 'D') $order_email = 'pased';
					else $order_email = 'pasei';

					$sql = 'UPDATE orders SET orders_status="F", orders_final_date="'.time().'" WHERE orders_id='.(int)$orders_id;
					}
				mysql_query($sql) or die(mysql_error());

				$total_pay_amount = $inv_data['total_price'];
				$total_tax = $inv_data['total_tax'];

				//Add the order payment information
				mysql_query("UPDATE order_payment SET order_payment_processor='$selected_processor', order_payment_paid_date=now(), order_payment_paid='Y' WHERE orders_id={$orders_id}");
				
				$result = mysql_query('SELECT order_payment_id FROM order_payment WHERE receiver_id IS NULL AND orders_id='.$orders_id) or die(mysql_error());
				$buffer = mysql_fetch_assoc($result);

				$order_payment_id = $buffer['order_payment_id']; //remember to get the correct id... when the giftcards are added, i.e. if processor use the correct one!

				$Global['order_payment_id'] = $order_payment_id;

				//Update the payment history table
				$customer_ip = $_SERVER['REMOTE_ADDR'];
				$customer_ip_long = sprintf("%u", ip2long($customer_ip));
				$customer_dns = @gethostbyaddr($customer_ip);
				switch ($selected_processor) {
					case 'AN':
						mysql_query("UPDATE authorize_history SET order_payment_id=".(int)$order_payment_id.", transaction_id='$transaction_id', success='Y' WHERE invoice_md5='".$orders_hash."'") or die(mysql_error());
						break;
					case 'LP':
						mysql_query('UPDATE linkpoint_history SET order_payment_id='.(int)$order_payment_id.' WHERE invoice_md5="'.mysql_escape_string($orders_hash).'"');
						break;
					}

				//if it's a subscription show how many times the invoice has been paid
				if ($subscription === true) {

					//get the number of times it's downloaded
					$paid_times = 'You have payed this invoice '.((int)$times_sent+1).' times';
					}

				//mark all downloads and giftcard hashes enabled
				$sql = 'UPDATE dl_hash, order_link SET dl_hash.dl_hash_status="E" WHERE dl_hash.order_link_id=order_link.order_link_id AND order_link.product_id IN ('.implode(',', $product_ids).')';
				mysql_query($sql) or die(mysql_error());
				$sql = 'UPDATE giftcard_hash, order_link SET giftcard_hash.giftcard_hash_status="E" WHERE giftcard_hash.order_link_id=order_link.order_link_id AND order_link.product_id IN ('.implode(',', $product_ids).')';
				mysql_query($sql) or die(mysql_error());

				$total_emails = count($emails);
				/**
				 * Send out the giftcard/download emails
				 */
				if ($download_exist === true || $giftcard_exist === true) {

					$result = mysql_query("SELECT email_type, email_subject, email_message FROM email WHERE store_id=$store_id && email_type IN ('non_existing'".($download_exist === true ? ", 'dle'" : "").($giftcard_exist === true ? ", 'gce'" : "").")");

					while ($buffer = mysql_fetch_assoc($result))
						{

						$message = '';
						$subject = '';
						//Download email
						if ($buffer['email_type'] == 'dle') {
							//Custom Tags subject: [store_name] [order_id] [firstname] [lastname]
							$subject_replace = array('[store_name]', '[order_id]', '[firstname]', '[lastname]');
							$subject_replace_with = array($Global['store_name'], $orders_id, $inv_data['client_ship_first_name'], $inv_data['client_ship_last_name']);

							//Custom Tags message: [store_name] [firstname] [lastname] [order_id] [download_hash] [download_url]
							$message_replace = array('[store_name]', '[firstname]', '[lastname]', '[order_id]', '[download_hash]', '[download_url]');
							$message_replace_with = array($Global['store_name'], $inv_data['client_ship_first_name'], $inv_data['client_ship_last_name'], $orders_id, $download_email, $Global['webpage_url_ssl'].'download.php');

							$subject = str_replace($subject_replace, $subject_replace_with, $buffer['email_subject']);
							$message = str_replace($message_replace, $message_replace_with, $buffer['email_message']);

							}
						elseif ($buffer['email_type'] == 'gce') {
							//Custom Tags subject: [store_name] [order_id] [firstname] [lastname]
							$subject_replace = array('[store_name]', '[order_id]', '[firstname]', '[lastname]');
							$subject_replace_with = array($Global['store_name'], $orders_id, $inv_data['client_ship_first_name'], $inv_data['client_ship_last_name']);

							//Custom Tags message: [store_name] [firstname] [lastname] [order_id] [giftcard_hash] [giftcard_url]
							$message_replace = array('[store_name]', '[firstname]', '[lastname]', '[order_id]', '[giftcard_hash]', '[giftcard_url]');
							$message_replace_with = array($Global['store_name'], $inv_data['client_ship_first_name'], $inv_data['client_ship_last_name'], $orders_id, $giftcard_email, $Global['webpage_url_ssl'].'giftcard.php');

							$subject = str_replace($subject_replace, $subject_replace_with, $buffer['email_subject']);
							$message = str_replace($message_replace, $message_replace_with, $buffer['email_message']);

							}

						if (!empty($message) && !empty($subject)) {

							mail($inv_data['client_email'], $subject, $message, "From: {$Global['store_email_title']} <{$Global['store_email']}>\r\n");
							}
						}
					}
				
				}

			break;
		case 'cancel':
			
			//check if this invoice exists
			$sql = 'SELECT COUNT(*) AS total FROM orders o WHERE o.invoice="Y" AND o.orders_id='.(int)$orders_id;
			$result = mysql_query($sql) or die(mysql_error());
			$row = mysql_fetch_assoc($result);

			if ($row['total'] > 0) {

				$sql = 'UPDATE orders SET orders_status="C" WHERE orders_id='.(int)$orders_id;
				mysql_query($sql) or die(mysql_error());
				}
			break;

		}
	return $paid_times;
	}

/**
 * Fills the $product, $product_order and $req_info variables
 *
 * @param mixed $product
 * @param mixed $product_order
 * @param mixed $req_info
 * @param int $store_id
 */
function get_products(&$product, &$product_order, &$req_info, $store_id) {
	
	//Select the products
	$result = mysql_query("SELECT 
													prod.product_real_id
													, prod.product_id
													, prod.download_id
													, prod.product_name
													, prod.product_type
													, prod.product_weight
													, prod.product_stock
													, prod.product_stock_use
													, prod.product_price
													, prod.product_download_nr
													, prod.product_description
													, prod.product_tax_exempt
													, prod.product_display
													, prod.product_subscription_enabled
													, prod.product_subscription_period
													, prod.product_subscription_price
													, img.images_id
												FROM
													product as prod
													LEFT JOIN images as img
														USING (product_id)
												WHERE
													prod.store_id=$store_id
													&& prod.product_display='Y'
													&& img.images_type='L'");

	$product = array();
	$product_order = array();
	$req_info = array();

	while ($buffer = mysql_fetch_assoc($result))
		{
		if (!in_array($buffer['product_id'], $product_order)) $product_order[] = $buffer['product_id'];

		if ($buffer['product_tax_exempt'] == 'N') {
			if (!empty($buffer['download_id'])) {
				$tax_ship = 0;
				$tax_down = $buffer['product_price'];
				$download = $buffer['download_id'];
				}
			else {
				$tax_ship = $buffer['product_price'];
				$tax_down = 0;
				$download = false;
				}
			}
		else {
			$tax_ship = 0;
			$tax_down = 0;
			$download = false;
			}

		$product[$buffer['product_id']] = array(
																				'real_id'=> $buffer['product_real_id']
																				,'price' => $buffer['product_price']
																				, 'tax_price_ship' => $tax_ship
																				, 'tax_price_down' => $tax_down
																				, 'weight' => $buffer['product_weight']
																				, 'name' => $buffer['product_name']
																				, 'type' => $buffer['product_type']
																				, 'stock' => $buffer['product_stock']
																				, 'stock_use' => $buffer['product_stock_use']
																				, 'desc' => $buffer['product_description']
																				, 'download' => $download
																				, 'download_nr' => $buffer['product_download_nr']
																				, 'subscription_enabled' => $buffer['product_subscription_enabled']
																				, 'subscription_price' => $buffer['product_subscription_price']
																				, 'subscription_period' => $buffer['product_subscription_period']
																				, 'img' => $buffer['images_id']
																			);

		if ($buffer['product_type'] == 'G') $req_info[] = $buffer['product_id'];
		}

	//Select additional information from the giftcards
	if (!empty($req_info)) {
		$result = mysql_query("SELECT gift.product_id, gift.giftcard_type, link.giftcard_link_amount, prod.download_id, prod.product_price, prod.product_weight, prod.product_tax_exempt, prod.product_stock, prod.product_stock_use FROM giftcard as gift, giftcard_link as link, product as prod WHERE gift.product_id IN (".implode(',', $req_info).") && gift.giftcard_type='P' && gift.giftcard_id=link.giftcard_id && link.product_id=prod.product_id");

		//how should the stock system be used????
		$processed_prod = array();

		while ($buffer = mysql_fetch_assoc($result))
			{
			if (!isset($processed_prod[$buffer['product_id']])) {
				$processed_prod[$buffer['product_id']] = true;

				if (!empty($product_id)) {
					if ($tax_ship > 0) {
						$tax_grade_ship = $tax_ship / ($price / 100);

						$product[$product_id]['tax_price_ship'] = number_format((($product[$product_id]['price'] / 100) * $tax_grade_ship), 2);
						}
					else {
						$product[$product_id]['tax_price_ship'] = 0;
						}

					if ($tax_down > 0) {
						$tax_grade_down = $tax_down / ($price / 100);

						$product[$product_id]['tax_price_down'] = number_format((($product[$product_id]['price'] / 100) * $tax_grade_down), 2);
						}
					else {
						$product[$product_id]['tax_price_down'] = 0;
						}

					if ($weight > 0) $product[$product_id]['weight'] = $weight;
					}

				$product_id = $buffer['product_id'];
				$price = 0;
				$tax_ship = 0;
				$tax_down = 0;
				$weight = 0;
				}

			$price += $buffer['product_price'] * $buffer['giftcard_link_amount'];

			if ($buffer['product_tax_exempt'] == 'N') {
				if (!empty($buffer['download_id'])) {
					$tax_down += $price;
					}
				else {
					$tax_ship += $price;
					}
				}

			$weight += ($buffer['product_weight'] > 0)?($buffer['product_weight'] * $buffer['giftcard_link_amount']):0;
			}

		if (!empty($product_id)) {
			if ($tax_ship > 0) {
				$tax_grade_ship = ($tax_ship / ($price / 100));

				$product[$product_id]['tax_price_ship'] = number_format((($product[$product_id]['price'] / 100) * $tax_grade_ship), 2);
				}
			else {
				$product[$product_id]['tax_price_ship'] = 0;
				}

			if ($tax_down > 0) {
				$tax_grade_down = ($tax_down / ($price / 100));

				$product[$product_id]['tax_price_down'] = number_format((($product[$product_id]['price'] / 100) * $tax_grade_down), 2);
				}
			else {
				$product[$product_id]['tax_price_down'] = 0;
				}

			if ($weight > 0) $product[$product_id]['weight'] = $weight;
			}
		}
	}

/**
 * Given an invoice id and a store id (for security)
 * we return an array with all the data for an invoice
 * We also pass all the available products for this store
 * (we don't extract them for optimization)
 *
 * @param int $invoice_id
 * @param int $store_id
 * @param array $product
 * @return array
 */
function get_invoice_data($invoice_id, $store_id, $product) {

	global $Global;
	$populate_data = array();

	//get all info for the selected invoice
	$sql = 'SELECT o.orders_total_subscription_price, m.Username AS affiliate, o.store_id, o.orders_id, o.ship_id, o.orders_total_shipping, o.orders_total_tax, o.orders_total_discount, o.orders_total_price, o.orders_company_name, o.orders_firstname, o.orders_lastname, o.orders_address, o.orders_address2, o.orders_zip, o.orders_city, o.orders_state, o.orders_region, o.orders_country, o.orders_email, o.orders_phone, o.orders_ship_company_name, o.orders_ship_firstname, o.orders_ship_lastname, o.orders_ship_address, o.orders_ship_address2, o.orders_ship_zip, o.orders_ship_city, o.orders_ship_state, o.orders_ship_region, o.orders_ship_country, o.ship_name, o.ship_type, o.shipping, o.orders_status,
				i.invoices_send_date, i.invoice_id, i.owner_name, i.owner_company_name, i.owner_address, i.owner_address2, i.owner_zip, i.owner_city, i.owner_state, i.owner_region, i.owner_country, i.owner_phone, i.owner_email, i.invoice_type, i.invoice_due_date, i.invoice_due, i.invoice_subscription, i.invoice_sub_period, i.invoice_sub_times, i.private_note, i.customer_note, il.invoice_md5
			FROM orders o
			INNER JOIN invoice_link il ON il.orders_id=o.orders_id
			INNER JOIN invoices_common i ON il.invoice_id=i.invoice_id
			LEFT JOIN members m ON o.member_id=m.ID
			WHERE o.orders_id='.(int)$invoice_id.' AND o.invoice="Y" AND o.store_id='.(int)$store_id;
    
	$result = mysql_query($sql) or die(mysql_error());

	//if we have a valid invoice then we fill in the $populate_data variable
	if (mysql_num_rows($result) == 1) {

		$row = mysql_fetch_assoc($result);
		$populate_data['orders_status'] = $row['orders_status'];
		$populate_data['store_id'] = $row['store_id'];
		$populate_data['affiliate'] = $row['affiliate'];
		$populate_data['owner_name'] = $row['owner_name'];
		$populate_data['owner_company_name'] = $row['owner_company_name'];
		$populate_data['owner_address'] = $row['owner_address'];
		$populate_data['owner_address2'] = $row['owner_address2'];
		$populate_data['zip'] = $row['owner_zip'];
		$populate_data['owner_city'] = $row['owner_city'];
		$populate_data['owner_state'] = $row['owner_state'];
		$populate_data['owner_region'] = $row['owner_region'];
		$populate_data['owner_country'] = $row['owner_country'];
		$populate_data['owner_phone'] = $row['owner_phone'];
		$populate_data['owner_email'] = $row['owner_email'];
		$populate_data['invoice_type'] = $row['invoice_type'];
		$populate_data['invoice_due_date'] = $row['invoice_due_date'];
		$populate_data['invoices_send_date'] = date($Global['invoice_date_syntax'], strtotime($row['invoices_send_date']));
		if (!empty($row['invoices_send_date'])) {
		    
		    $populate_data['invoice_date_send'] = date($Global['invoice_date_syntax'], strtotime($row['invoices_send_date']));
		    }
		$populate_data['invoice_due'] = $row['invoice_due'];
		$populate_data['invoice_subscription'] = $row['invoice_subscription'];
		$populate_data['invoice_subperiod'] = $row['invoice_sub_period'];
		$populate_data['invoice_subtimes'] = $row['invoice_sub_times'];
		$populate_data['private_note'] = $row['private_note'];
		$populate_data['customer_note'] = $row['customer_note'];

		$populate_data['orders_id'] = $row['orders_id'];
		$populate_data['courier'] = $row['ship_id'];
		$populate_data['total_shipping'] = $row['orders_total_shipping'];
		$populate_data['total_tax'] = $row['orders_total_tax'];
		$populate_data['total_discount'] = $row['orders_total_discount'];
		$populate_data['total_price'] = $row['orders_total_price'];
		$populate_data['total_sub_price'] = $row['orders_total_subscription_price'];
		$populate_data['purchaser_company_name'] = $row['orders_company_name'];
		$populate_data['purchaser_first_name'] = $row['orders_firstname'];
		$populate_data['purchaser_last_name'] = $row['orders_lastname'];
		$populate_data['purchaser_address'] = $row['orders_address'];
		$populate_data['purchaser_address2'] = $row['orders_address2'];
		$populate_data['purchaser_zip'] = $row['orders_zip'];
		$populate_data['purchaser_city'] = $row['orders_city'];
		$populate_data['state'] = $row['orders_state'];
		$populate_data['purchaser_region'] = $row['orders_region'];
		$populate_data['country'] = $row['orders_country'];
		$populate_data['purchaser_email'] = $row['orders_email'];
		$populate_data['purchaser_phone'] = $row['orders_phone'];
		$populate_data['ship_company_name'] = $row['orders_ship_company_name'];
		$populate_data['ship_firstname'] = $row['orders_ship_firstname'];
		$populate_data['ship_lastname'] = $row['orders_ship_lastname'];
		$populate_data['ship_address'] = $row['orders_ship_address'];
		$populate_data['ship_address2'] = $row['orders_ship_address2'];
		$populate_data['ship_zip'] = $row['orders_ship_zip'];
		$populate_data['ship_city'] = $row['orders_ship_city'];
		$populate_data['ship_state'] = $row['orders_ship_state'];
		$populate_data['ship_region'] = $row['orders_ship_region'];
		$populate_data['ship_country'] = $row['orders_ship_country'];
		$populate_data['ship_name'] = $row['ship_name'];
		$populate_data['ship_type'] = $row['ship_type'];
		$populate_data['shipment'] = $row['shipping'];
		$populate_data['invoice_md5'] = $row['invoice_md5'];

		//get the email recepients
		$sql = 'SELECT email FROM invoices_email_recepients WHERE invoice_id='.$row['invoice_id'];
		$result = mysql_query($sql) or die (mysql_error());

		$populate_data['emails'] = array();
		while ($row = mysql_fetch_assoc($result)) {

			$populate_data['emails'][] = $row['email'];
			}

		//populate the products
		$populate_data['product'] = array();
		$populate_data['product_name'] = array();
		$populate_data['product_amount'] = array();
		$populate_data['product_price'] = array();
		$populate_data['product_description'] = array();
		$populate_data['product_real_id'] = array();
		$populate_data['product_id'] = array();
		$populate_data['weight'] = 0;

		if ($product !== false) {

			$sql = 'SELECT
								product_id
								, product_name
								, product_price
								, product_weight
								, order_amount
								, product_subscription_enabled
								, product_subscription_price
								, product_subscription_period
							FROM
								order_link
							WHERE
								orders_id='.(int)$populate_data['orders_id'];
			$result = mysql_query($sql) or die(mysql_error());
			$cnt = 0;
			while ($row = mysql_fetch_assoc($result)) {
				
				if ($row['product_weight'] > 0) {

					$populate_data['weight'] = 1;
					}
				$populate_data['product'][$cnt] = $row['product_id'];
				$populate_data['product_name'][$cnt] = isset($product[$row['product_id']])?$product[$row['product_id']]['name']:'';
				$populate_data['product_amount'][$cnt] = $row['order_amount'];
				$populate_data['product_price'][$cnt] = $row['order_amount'] > 0? number_format($row['product_price']/$row['order_amount'], 2):'0.00';
				$populate_data['product_sub_price'][$cnt] = $row['order_amount'] > 0? number_format($row['product_subscription_price']/$row['order_amount'], 2):'0.00';
				$populate_data['product_description'][$cnt] = isset($product[$row['product_id']])?$product[$row['product_id']]['desc']:'';
				$populate_data['product_real_id'][$cnt] = isset($product[$row['product_id']])?$product[$row['product_id']]['real_id']:'';
				$populate_data['product_id'][$cnt] = $row['product_id'];
				++$cnt;
				}
			}
		return $populate_data;
		}
	return array();
	}

/**
 * Return the number of templates we have for a store
 *
 * @param int $store_id
 * @return int
 */
function get_template_count($store_id) {

	$sql = 'SELECT COUNT(*) AS total FROM invoices_templates WHERE store_id='.(int)$store_id;
	$result = mysql_query($sql) or die(mysql_error());

	$row = mysql_fetch_assoc($result);
	return $row['total'];
	}

/**
 * For a given store returns it's html/text invoice templates
 *
 * @param int $store_id
 * @return array
 */
function get_templates($store_id) {

	$sql = 'SELECT template, template_type FROM invoices_templates WHERE store_id='.(int)$store_id;
	$result = mysql_query($sql) or die(mysql_error());

	$data = array(1 => '', 2 => '', 4 => '', 8 => '', 16 => '');

	while ($row = mysql_fetch_assoc($result)) {

		$data[(int)$row['template_type']] = $row['template'];
		}
	return $data;
	}

/**
 * Fills in and returns an email/text/email (depending on $type var) invoice template
 *
 * @param int $invoice_id
 * @param int $store_id
 * @param array $invoice_tags
 * @param boolean $type
 * @return string
 */
function get_filled_template(&$inv_data, $store_id, $invoice_tags, $type = 'email') {

	$tpl = '';
	$tpl_prod = '';

	//get all the products for the current store
	get_products($product, $product_order, $req_info, $store_id);

	if (!is_array($inv_data)) {

		$inv_data = get_invoice_data($inv_data, $store_id, $product);
		}

	$inv_data['product_name'] = array();
	$inv_data['product_description'] = array();
	$inv_data['product_real_id'] = array();
	
	//set the product name, description and real id
	for($i=0,$total=count($inv_data['product_id']);$i < $total;++$i) {

		foreach($product as $key=>$val) {

			if ($key == $inv_data['product_id'][$i]) {

				$inv_data['product_name'][$i] = $val['name'];
				$inv_data['product_description'][$i] = $val['desc'];
				$inv_data['product_real_id'][$i] = ($type == 'text' && empty($val['real_id']) ? '&nbsp;':$val['real_id']);
				break 1;
				}
			}
		}

	//fill in the country and state names
	$states = array();
	$result = mysql_query("SELECT state_id, state_name FROM state ORDER BY country_iso ASC");
	while ($row = mysql_fetch_assoc($result)) {

		$states[$row['state_id']] = $row['state_name'];
		}

	$countries = array();
	$result = mysql_query("SELECT iso, printable_name FROM country ORDER BY name ASC");
	while ($row = mysql_fetch_assoc($result)) {

		$countries[$row['iso']] = $row['printable_name'];
		}
	$result = mysql_query("SELECT country_iso FROM store WHERE store_id=$store_id && store_enabled='Y' && store_closed='N'");

	$buffer = mysql_fetch_assoc($result);

	$Global = array();
	$Global['default_country'] = $buffer['country_iso'];

	if (isset ($inv_data['owner_region'])) {

		$inv_data['owner_region_original_field'] = $inv_data['owner_region'];
		}
	else {

		$inv_data['owner_region_original_field'] = '';
		}
	if ($inv_data['owner_country'] == $Global['default_country']) {
		
		$inv_data['owner_region'] = isset($states[$inv_data['owner_state']]) ? $states[$inv_data['owner_state']] : '';
		}
	$inv_data['owner_country_original_field'] = $inv_data['owner_country'];
	$inv_data['owner_country'] = isset($countries[$inv_data['owner_country']]) ? $countries[$inv_data['owner_country']] : '';

	if (isset ($inv_data['purchaser_region'])) {
		
		$inv_data['purchaser_region_original_field'] = $inv_data['purchaser_region'];
		}
	else {

		$inv_data['purchaser_region_original_field'] = '';
		}
	if ($inv_data['country'] == $Global['default_country']) {
		
		$inv_data['purchaser_region'] = isset($states[$inv_data['state']]) ? $states[$inv_data['state']] : '';
		}
	$inv_data['country_original_field'] = $inv_data['country'];
	$inv_data['country'] = isset($countries[$inv_data['country']]) ? $countries[$inv_data['country']] : '';

	if (isset ($inv_data['ship_region'])) {
		
		$inv_data['ship_region_original_field'] = $inv_data['ship_region'];
		}
	else {

		$inv_data['ship_region_original_field'] = '';
		}
	if ($inv_data['ship_country'] == $Global['default_country']) {
		
		$inv_data['ship_region'] = isset($states[$inv_data['ship_state']]) ? $states[$inv_data['ship_state']] : '';
		}
	$inv_data['ship_country_original_field'] = $inv_data['ship_country'];
	$inv_data['ship_country'] = isset($countries[$inv_data['ship_country']]) ? $countries[$inv_data['ship_country']] : '';

	if (count($inv_data) == 0) {

		return $tpl;
		}

	$template = get_templates($store_id);
	if ($type == 'email') {
		
		$tpl = $template[1];
		$tpl_prod = $template[2];
		}
	elseif ($type == 'text') {

		$tpl = $template[4];
		$tpl_prod = $template[8];
		}
	elseif ($type == 'isend') {

		$tpl = $template[32];
		$tpl_prod = $template[64];
		}
	else {

		$tpl = $template[128];
		$tpl_prod = $template[255];
		}

	return fill_template($inv_data, $tpl, $tpl_prod, $invoice_tags);
	}

/**
 * A function to fill in the template vars from existing info
 * Depending on the $tpl_get var we can return the combination of the
 * 2 templates or one of them
 *
 * @param array $inv_data
 * @param string $tpl
 * @param string $tpl_prod
 * @param array $invoice_tags
 * @param string $tpl_get
 * @return string
 */
function fill_template(&$inv_data, $tpl, $tpl_prod, $invoice_tags, $tpl_get = 'combined') {
	
	global $Global;

	//if we have the orders id but we don't have the md5 hash and the invoice id then get them
	if ((!isset($inv_data['invoice_md5']) || !isset($inv_data['invoice_id'])) && (int)$inv_data['orders_id'] > 0) {

		$sql = 'SELECT il.invoice_md5, i.invoice_id FROM invoices_common i INNER JOIN invoice_link il ON il.invoice_id=i.invoice_id INNER JOIN orders o ON o.orders_id=il.orders_id WHERE o.orders_id='.(int)$inv_data['orders_id'].' LIMIT 1';
		$res = mysql_query($sql) or die(mysql_error());
		if (mysql_num_rows($res) == 1) {

			$row = mysql_fetch_assoc($res);
			$inv_data['invoice_md5'] = $row['invoice_md5'];
			$inv_data['invoice_id'] = $row['invoice_id'];
			}
		}

	$invoice_types = array(1=>'Goods', 2=>'Services');

	//iterate through all the invoice tags and replace them with appropriate values
	for ($total=count($invoice_tags['invoice']),$i=0;$i < $total;++$i) {

		if ($invoice_tags['invoice'][$i]['show'] === true && isset($inv_data[$invoice_tags['invoice'][$i]['field']])) {

			switch ($invoice_tags['invoice'][$i]['tag']) {

				case '[invoice_type]':
					$tpl = str_replace($invoice_tags['invoice'][$i]['tag'], $invoice_types[$inv_data[$invoice_tags['invoice'][$i]['field']]], $tpl);
					break;
				default:
					$tpl = str_replace($invoice_tags['invoice'][$i]['tag'], $inv_data[$invoice_tags['invoice'][$i]['field']], $tpl);
				}
			}
		}
		
	if (isset($inv_data['invoice_md5'])) {

		$tpl = str_replace('[invoice_link]', $Global['webpage_url'].'view_invoice.php?inv='.$inv_data['invoice_md5'], $tpl);
		}
	else {

		$tpl = str_replace('[invoice_link]', '', $tpl);
		$tpl = str_replace('[invoice_id]', '', $tpl);
		}

	//iterate through all the invoice tags again and remove the ones we don't have data for
	for ($total=count($invoice_tags['invoice']),$i=0;$i < $total;++$i) {

		if ($invoice_tags['invoice'][$i]['show'] === true && !isset($inv_data[$invoice_tags['invoice'][$i]['field']])) {

			$tpl = str_replace($invoice_tags['invoice'][$i]['tag'], '', $tpl);
			}
		}

	//iterate through all the product tags and replace them with appropriate values
	$temp = '';
	for ($total=count($inv_data['product']),$i=0;$i < $total;++$i) {

		$temp_tpl = $tpl_prod;
		for ($total_tags=count($invoice_tags['product']),$j=0;$j < $total_tags;++$j) {

			if (isset($inv_data[$invoice_tags['product'][$j]['field']])) {

				$temp_tpl = str_replace($invoice_tags['product'][$j]['tag'], $inv_data[$invoice_tags['product'][$j]['field']][$i], $temp_tpl);
				}
			}
		$temp .= $temp_tpl;
		}

	switch ($tpl_get) {

		//get only the product template
		case 'product':
			$tpl = $temp;
			break;

		//get only the main template
		case 'main':
			break;

		//combine both templates
		default:
			$tpl = str_replace('[product]', $temp, $tpl);
			break;
		}
	return $tpl;
	}

/**
 * Given data, specific template and tags we fill in
 * the template var replacing the data in the found tags
 *
 * @param array $data
 * @param array $tags
 * @param string $tpl
 * @return string
 */
function specific_tpl($data, $tags, $tpl) {

	for ($total=count($tags),$i=0;$i < $total;++$i) {

		if ($tags[$i]['show'] === true && isset($data[$tags[$i]['field']])) {

			$tpl = str_replace($tags[$i]['tag'], $data[$tags[$i]['field']], $tpl);
			}
		}

	return $tpl;
	}

/**
 * Return all tag and their descriptions for a specified index
 *
 * @param array $invoice_tags
 * @param string $index
 * @return string
 */
function get_tag_info($invoice_tags, $index) {

	$info = '';

	if (!isset($invoice_tags[$index])) {

		return $info;
		}

	for($total=count($invoice_tags[$index]),$i=0;$i < $total;++$i) {

		if ($invoice_tags[$index][$i]['show'] === true) {

			$info .= $invoice_tags[$index][$i]['tag'].' - '.$invoice_tags[$index][$i]['desc'].',';
			}
		}

	return $info;
	}

$invoice_tags = array(
		'invoice'=>array(
				array('field'=>'owner_name', 'tag'=>'[owner_name]', 'desc'=>'', 'show'=>true),
				array('field'=>'owner_company_name', 'tag'=>'[owner_company_name]', 'desc'=>'', 'show'=>true),
				array('field'=>'owner_address', 'tag'=>'[owner_address]', 'desc'=>'', 'show'=>true),
				array('field'=>'owner_address2', 'tag'=>'[owner_address2]', 'desc'=>'', 'show'=>true),
				array('field'=>'zip', 'tag'=>'[owner_zip]', 'desc'=>'', 'show'=>true),
				array('field'=>'owner_city', 'tag'=>'[owner_city]', 'desc'=>'', 'show'=>true),
				array('field'=>'owner_state', 'tag'=>'[owner_state]', 'desc'=>'', 'show'=>false),
				array('field'=>'owner_region', 'tag'=>'[owner_region]', 'desc'=>'', 'show'=>true),
				array('field'=>'owner_country', 'tag'=>'[owner_country]', 'desc'=>'', 'show'=>true),
				array('field'=>'owner_phone', 'tag'=>'[owner_phone]', 'desc'=>'', 'show'=>true),
				array('field'=>'owner_email', 'tag'=>'[owner_email]', 'desc'=>'', 'show'=>true),
				array('field'=>'purchaser_first_name', 'tag'=>'[purchaser_first_name]', 'desc'=>'', 'show'=>true),
				array('field'=>'purchaser_last_name', 'tag'=>'[purchaser_last_name]', 'desc'=>'', 'show'=>true),
				array('field'=>'purchaser_company_name', 'tag'=>'[purchaser_company_name]', 'desc'=>'', 'show'=>true),
				array('field'=>'purchaser_address', 'tag'=>'[purchaser_address]', 'desc'=>'', 'show'=>true),
				array('field'=>'purchaser_address2', 'tag'=>'[purchaser_address2]', 'desc'=>'', 'show'=>true),
				array('field'=>'purchaser_zip', 'tag'=>'[purchaser_zip]', 'desc'=>'', 'show'=>true),
				array('field'=>'purchaser_city', 'tag'=>'[purchaser_city]', 'desc'=>'', 'show'=>true),
				array('field'=>'state', 'tag'=>'[purchaser_state]', 'desc'=>'', 'show'=>false),
				array('field'=>'purchaser_region', 'tag'=>'[purchaser_region]', 'desc'=>'', 'show'=>true),
				array('field'=>'country', 'tag'=>'[purchaser_country]', 'desc'=>'', 'show'=>true),
				array('field'=>'purchaser_email', 'tag'=>'[purchaser_email]', 'desc'=>'', 'show'=>true),
				array('field'=>'purchaser_phone', 'tag'=>'[purchaser_phone]', 'desc'=>'', 'show'=>true),
				array('field'=>'ship_firstname', 'tag'=>'[ship_firstname]', 'desc'=>'', 'show'=>true),
				array('field'=>'ship_lastname', 'tag'=>'[ship_lastname]', 'desc'=>'', 'show'=>true),
				array('field'=>'ship_address', 'tag'=>'[ship_address]', 'desc'=>'', 'show'=>true),
				array('field'=>'ship_address2', 'tag'=>'[ship_address2]', 'desc'=>'', 'show'=>true),
				array('field'=>'ship_zip', 'tag'=>'[ship_zip]', 'desc'=>'', 'show'=>true),
				array('field'=>'ship_city', 'tag'=>'[ship_city]', 'desc'=>'', 'show'=>true),
				array('field'=>'ship_state', 'tag'=>'[ship_state]', 'desc'=>'', 'show'=>false),
				array('field'=>'ship_region', 'tag'=>'[ship_region]', 'desc'=>'', 'show'=>true),
				array('field'=>'ship_country', 'tag'=>'[ship_country]', 'desc'=>'', 'show'=>true),
				array('field'=>'invoice_type', 'tag'=>'[invoice_type]', 'desc'=>'', 'show'=>true),
				array('field'=>'invoice_due_date', 'tag'=>'[invoice_due_date]', 'desc'=>'', 'show'=>true),
				array('field'=>'invoice_due', 'tag'=>'[invoice_due]', 'desc'=>'', 'show'=>true),
				array('field'=>'customer_note', 'tag'=>'[customer_note]', 'desc'=>'', 'show'=>true),
				array('field'=>'total_shipping', 'tag'=>'[total_shipping]', 'desc'=>'', 'show'=>true),
				array('field'=>'total_tax', 'tag'=>'[total_tax]', 'desc'=>'', 'show'=>true),
				array('field'=>'total_discount', 'tag'=>'[total_discount]', 'desc'=>'', 'show'=>true),
				array('field'=>'total_price', 'tag'=>'[total_price]', 'desc'=>'', 'show'=>true),
				array('field'=>'invoice_link', 'tag'=>'[invoice_link]', 'desc'=>'', 'show'=>true),
				array('field'=>'invoice_id', 'tag'=>'[invoice_id]', 'desc'=>'', 'show'=>true),
				array('field'=>'orders_id', 'tag'=>'[orders_id]', 'desc'=>'', 'show'=>true),
			),
		'product'=>array(
				array('field'=>'product_name', 'tag'=>'[product_name]', 'desc'=>'', 'show'=>true),
				array('field'=>'product_amount', 'tag'=>'[product_amount]', 'desc'=>'', 'show'=>true),
				array('field'=>'product_price', 'tag'=>'[product_price]', 'desc'=>'', 'show'=>true),
				array('field'=>'product_description', 'tag'=>'[product_description]', 'desc'=>'', 'show'=>true),
				array('field'=>'product_real_id', 'tag'=>'[product_real_id]', 'desc'=>'', 'show'=>true),
			),
		'subject'=>array(
				array('field'=>'purchaser_first_name', 'tag'=>'[purchaser_first_name]', 'desc'=>'', 'show'=>true),
				array('field'=>'purchaser_last_name', 'tag'=>'[purchaser_last_name]', 'desc'=>'', 'show'=>true),
				array('field'=>'invoice_id', 'tag'=>'[invoice_id]', 'desc'=>'', 'show'=>true),
			)
	);