<?php
//---------------------------------------------------------------
//Made by: Nikolay Kolev
//Firm: Kaizen
//Date: 25th May 2009
//Last Modified: 25th June 2009
//----------------------------------------------------------------

/**
 * Validates if the passed variable is a valid yyyy-mm-dd date
 *
 * @param string $date
 * @return boolean
 */
function check_date($date, $format = 'Y-m-d') {

	//the position of the parts of the date (m=month, d=day, Y=year)
	$pos = array('Y'=>1, 'm'=>2, 'd'=>3);

	$format = str_replace('YYYY', 'Y', $format);
	$format = str_replace('mm', 'm', $format);
	$format = str_replace('dd', 'd', $format);

	//find the positions of the date parts
	$y = strpos($format, 'Y');
	$m = strpos($format, 'm');
	$d = strpos($format, 'd');

	if ($y !== false && $m !== false && $y > $m) {

		$tmp = $pos['Y'];
		$pos['Y'] = $pos['m'];
		$pos['m'] = $tmp;
		}

	if ($y !== false && $d !== false && $y > $d) {

		$tmp = $pos['Y'];
		$pos['Y'] = $pos['d'];
		$pos['d'] = $tmp;
		}

	if ($d !== false && $m !== false && $m > $d) {

		$tmp = $pos['m'];
		$pos['m'] = $pos['d'];
		$pos['d'] = $tmp;
		}

	$pattern = str_replace('Y', '([0-9]{4})', $format);
	$pattern = str_replace('m', '([0-9]{2})', $pattern);
	$pattern = str_replace('d', '([0-9]{2})', $pattern);
	$pattern = str_replace('.', '\.', $pattern);
	$pattern = '/^'.$pattern.'$/';

	//match the format of the date
	if (preg_match ($pattern, $date, $parts)) {

		//check weather the date is valid of not
		if(checkdate($parts[$pos['m']],$parts[$pos['d']],$parts[$pos['Y']])) {

			return true;
			}
		else {
			
			return false;
			}
		}
	else {

		return false;
		}
	}

/**
 * Adds an error $msg message to the $errorArr array
 *
 * @param array $errorArr
 * @param string $key
 * @param string $msg
 */
function add_error(&$errorArr, $key, $msg) {

	if (isset($errorArr[$key]) === false) {

		$errorArr[$key] = array();
		}
	$errorArr[$key][] = $msg;
	}

/**
 * This function checks if the keys from the $keys array
 * exist in the $arr array and they don't have empty value
 * If they don't exist or have empty values then an error
 * message is written for that key in the $errorArr array
 *
 * @param array $arr The array to check in
 * @param array $errorArr Where all the errors are written to
 * @param array $keys The keys to check and the error messages
 */
function checkRequired($arr, &$errorArr, $keys) {

	foreach($keys AS $key => &$val) {

		if (isset($arr[$key]) === false || empty($arr[$key]) === true) {

			add_error($errorArr, $key, $val);
			}
		}
	}

/**
 * Checks if a given email is valid
 *
 * @param string $email
 * @return boolean
 */
function check_email_address($email) {

	// First, we check that there's one @ symbol,
	// and that the lengths are right.
	if (!ereg("^[^@]{1,64}@[^@]{1,255}$", $email)) {
		// Email invalid because wrong number of characters
		// in one section or wrong number of @ symbols.
		return false;
		}

	// Split it into sections to make life easier
	$email_array = explode("@", $email);
	$local_array = explode(".", $email_array[0]);
	for ($i = 0; $i < sizeof($local_array); $i++) {
		if (!ereg("^(([A-Za-z0-9!#$%&'*+/=?^_`{|}~-][A-Za-z0-9!#$%&'*+/=?^_`{|}~\.-]{0,63})|(\"[^(\\|\")]{0,62}\"))$",	$local_array[$i])) {
			return false;
			}
		}

	// Check if domain is IP. If not,
	// it should be valid domain name
	if (!ereg("^\[?[0-9\.]+\]?$", $email_array[1])) {
		
		$domain_array = explode(".", $email_array[1]);

		if (sizeof($domain_array) < 2) {
			
			return false; // Not enough parts to domain
			}
		for ($i = 0; $i < sizeof($domain_array); $i++) {
			if (!ereg("^(([A-Za-z0-9][A-Za-z0-9-]{0,61}[A-Za-z0-9])|([A-Za-z0-9]+))$", $domain_array[$i])) {

				return false;
				}
			}
		}
	return true;
	}

/**
 * Given $value we chekc whether it's an integer or not
 *
 * @param mixed $value
 * @return boolean
 */
function is_integer_value($value) {

	return ctype_digit((string) $value);
	}

/**
 * Checks if a given value is numeric and in the interval between min and max
 *
 * @param mixed $value
 * @param int $min
 * @param int $max
 * @return boolean
 */
function in_range($value, $min, $max) {

	if (is_integer_value($value) === false) {

		return false;
		}

	if ($value >= $min && $value <= $max) {

		return true;
		}
	return false;
	}

/**
 * Returns all error messages for a $field in the error array $errorArr
 * if there are any
 *
 * @param array $errorArr
 * @param string $field
 * @return string
 */
function show_error($errorArr, $field) {

	$err = '';
	if (isset($errorArr[$field]) === true) {

		$err = '<span style="color:red;">';
		foreach($errorArr[$field] as &$val) {

			$err .= $val.'<br />';
			}
		$err .= '</span>';
		}

	return $err;
	}