<?php
//---------------------------------------------------------------
//Made by: Sven Arild Helleland 
//Firm: Kaizen Web-Productions (http://www.kaizen-web.com)
//Date: 8th June 2006
//Last Modified: 28th January 2007
//----------------------------------------------------------------
include './../../Sub/Config.inc.php';
include './../../phpcpr.php';
/*if ($Global['use_html_email'] == true) {
include './../../Inc/cuteeditor_files/include_CuteEditor.php';
}*/

include './../Inc/Login.inc.php';
$pageName = 'Add / Edit Program';
if ($loggedUser->checkPermisson('ADD_PROGRAM') === false){
  $errorMessage = 'You are not allowed to access this page.';
  require_once('./../Inc/error.php');
  exit();   
}

$fields = [
    'sub_period', 'tier', 'powerline', 'tier_amount', 'tier_amount2', 'tier_amount3',
    'tier_amount4', 'tier_amount5', 'powerline_amount', 'forced_number', 'admin_amount',
    'total_amount', 'cc_fee', 'cc_fee_year', 'cc_fee_life', 'unpaid_tier',
    'year_tier_amount', 'year_tier_amount2', 'year_tier_amount3', 'year_tier_amount4',
    'year_tier_amount5', 'year_powerline_amount', 'year_admin_amount', 'year_total_amount',
    'life_tier_amount', 'life_tier_amount2', 'life_tier_amount3', 'life_tier_amount4',
    'life_tier_amount5', 'life_powerline_amount', 'life_admin_amount', 'life_total_amount',
    'year_period', 'life_admin2_amount', 'year_admin2_amount', 'admin2_amount', 'type_admin2'
];

foreach ($fields as $field) {
    if (empty($_POST[$field])) {
        $_POST[$field] = 0;
    }
}

if (!empty($_POST['step1'])) {
	//Calculate total amount
	$total = (float) $_POST['tier_amount'] + (float) $_POST['tier_amount2'] + (float) $_POST['tier_amount3'] + (float) $_POST['tier_amount4'] + (float) $_POST['tier_amount5'] + (float) $_POST['powerline_amount'] + (float) $_POST['admin_amount'] + (float) $_POST['admin2_amount'];
	$total_year = (float) $_POST['year_tier_amount'] + (float) $_POST['year_tier_amount2'] + (float) $_POST['year_tier_amount3'] + (float) $_POST['year_tier_amount4'] + (float) $_POST['year_tier_amount5'] + (float) $_POST['year_powerline_amount'] + (float) $_POST['year_admin_amount'] + (float) $_POST['year_admin2_amount'];
	$total_life = (float) $_POST['life_tier_amount'] + (float) $_POST['life_tier_amount2'] + (float) $_POST['life_tier_amount3'] + (float) $_POST['life_tier_amount4'] + (float) $_POST['life_tier_amount5'] + (float) $_POST['life_powerline_amount'] + (float) $_POST['life_admin_amount'] + (float) $_POST['life_admin2_amount'];
	
	$powerline_order_temp = explode(',', $_POST['powerline_order']);

	/*
       Check the powerline order
       the order should be progresseve, i.e. it should start from low to high. For example,
       1,3, 2 is invalid order
	*/
    $powerline_order_failure = false;
	$powerline_numbers = array();
	$prev_nr = 0;
	
	foreach ($powerline_order_temp as $key) {
		if (!is_numeric($key) || in_array($key, $powerline_numbers) || $key < $prev_nr) $powerline_order_failure = true;
		
		$prev_nr = $key;
		$powerline_numbers[] = $key;
		}

	//Check that the child programs actually exist in the database
	if (!empty($_POST['program_child'])) {
		$child_program = true;
		
		$child_temp = explode(' ', $_POST['program_child']);
		
		foreach ($child_temp as $key) {

			$key = intval($key); // Ensure $key is an integer
			$conditions = [
				'program_approved' => 'Y',
				'program_id' => $key
			];

			// Using the select method from PHPCPR
			$result = select("program_id", "program", [], $conditions, null, null, null, 0, 1);

			// Assuming the result is fetched as an associative array
			if ($result) {
				$buffer = $result[0]; // Get the first row from the result
			} else {
				$buffer = null; // Or handle this case as per your application logic
			}
			
			
			if (empty($buffer['program_id']) || !ctype_digit($key)) $child_program = false;
			}
		}
	
  //Check the link programs
	if (!empty($_POST['pr_downlinks'])) {
		$link_program = true;
		
		$link_temp = explode(' ', $_POST['pr_downlinks']);
		
		foreach ($link_temp as $key) {
			$key = intval($key); // Ensure $key is an integer
			$conditions = [
				'program_approved' => 'Y',
				'program_id' => $key
			];

			// Using the select method from PHPCPR
			$result = select("program_id", "program", [], $conditions, null, null, null, 0, 1);

			// Assuming the result is fetched as an associative array
			if ($result) {
				$buffer = $result[0]; // Get the first row from the result
			} else {
				$buffer = null; // Or handle this case as per your application logic
			}
			
			if (empty($buffer['program_id']) || !ctype_digit($key)) $link_program = false;
			}
		}	
		
	//Check the second administrator payment receiver if set
	$admin_receiver_name = true;
	
	if ((float) $_POST['admin2_amount'] > 0 && empty($_POST['program_admin2_receiver'])) {
	  
		$programAdmin2Receiver = $_POST['program_admin2_receiver'];

		// Preparing the select fields
		$selectFields = 'ID';

		// Specifying the main table
		$mainTable = 'members';

		// No join conditions are needed for this query
		$joinConditions = [];

		// Preparing the where conditions
		$where = [
			'Username' => ['=', $programAdmin2Receiver],
			'Username' => ['!=', 'DELETED'],
			'dummy_qualify' => ['=', 'N']
		];

		// No grouping, having, or ordering needed for this query
		$groupBy = null;
		$having = null;
		$orderBy = null;

		// Limit and debug settings
		$limit = 1;
		$show_debug = 1;

		// Using your PHPCPR select function
		$result = select($selectFields, $mainTable, $joinConditions, $where, $groupBy, $having, $orderBy, $limit, $show_debug);

		// Fetching the first row from the result
		$buffer = $result ? $result[0] : null;
	  
	  
	  if (empty($buffer['ID'])) $admin_receiver_name = false;
	  }	
	  
$errorFields = [];

$fields = [
    'tier', 'unpaid_tier', 'powerline', 'tier_amount', 'tier_amount2', 'tier_amount3', 
    'tier_amount4', 'tier_amount5', 'powerline_amount', 'admin_amount', 'admin2_amount', 
    'total_amount', 'sub_period', 'cc_fee', 'cc_fee_year', 'cc_fee_life', 
    'year_tier_amount', 'year_tier_amount2', 'year_tier_amount3', 'year_tier_amount4', 
    'year_tier_amount5', 'year_powerline_amount', 'year_admin_amount', 'year_admin2_amount', 
    'year_total_amount', 'life_tier_amount', 'life_tier_amount2', 'life_tier_amount3', 
    'life_tier_amount4', 'life_tier_amount5', 'life_powerline_amount', 'life_admin_amount', 
    'life_admin2_amount', 'life_total_amount', 'year_period'
];

foreach ($fields as $field) {
    if (!is_numeric($_POST[$field])) {
        $errorFields[] = str_replace('_', ' ', $field);
    }
}

if (count($errorFields) > 0) {
    $Error_msg = 'Please note that the following fields can only contain numeric values. Use a dot to divide decimal numbers, not a comma: ';
    $Error_msg .= implode(', ', $errorFields) . '.';
}
	  
		
	if (empty($_POST['program_name']) || strlen($_POST['program_name']) > 250) {
		$Error_msg = 'Please fill in a program name, please note the program name can not be more than 250 characters long.';
		}
	elseif (empty($_POST['program_desc']) || empty($_POST['program_short_desc']) || strlen($_POST['program_short_desc']) > 50) {
		$Error_msg = 'Please fill in program short description and program description, please note the program short description can not be more than 50 characters long.';
		}
	elseif ($_POST['program_redirect_url'] == '') {
		$Error_msg = 'Please add a program redirect URL.';
		}
	elseif (isset($_POST['freetrial_enabled']) && empty($_POST['freetrial_days'])) {
		$Error_msg = 'If you want to use the free trial function, please add a trial time period.';
		}
	elseif (!isset($_POST['freetrial_enabled']) && !empty($_POST['freetrial_days'])) {
		$Error_msg = 'If you want to use the free trial function, please enable it.';
		}
	elseif (!isset($_POST['freetrial_enabled']) && !empty($_POST['freetrial_require_cc'])) {
		$Error_msg = 'If you want to use the free trial function, please enable it. Otherwise, uncheck Free Trial Requires Credit Card.';
		}
	elseif (isset($_POST['giveaway_enabled']) && empty($_POST['giveaway_file'])) {
		$Error_msg = 'If you want to use the giveaway function, please add the filename of the file that will process it.';
		}
	elseif (!isset($_POST['giveaway_enabled']) && !empty($_POST['giveaway_file'])) {
		$Error_msg = 'If you want to use the giveaway function, please enable it.';
		}
	elseif (isset($_POST['lock_enabled']) && empty($_POST['unlock_key'])) {
		$Error_msg = 'If you want to use the lock function, please add the unlock key.';
		}
	elseif (!isset($_POST['lock_enabled']) && !empty($_POST['unlock_key'])) {
		$Error_msg = 'If you want to use the lock function, please enable it.';
		}
	elseif (!empty($_POST['program_child']) && $child_program === false) {
		$Error_msg = 'Please only add valid program id\'s to the child programs! Remember to seperate the different program id\'s with a space.';
		}	
	elseif (!empty($_POST['pr_downlinks']) && $link_program === false) {
		$Error_msg = 'Please only add valid program id\'s to the link programs! Remember to seperate the different program id\'s with a space.';
		}	
	elseif (empty($_POST['upgrade_program']) || ($_POST['upgrade_program'] != 'Y' && $_POST['upgrade_program'] != 'N')) {
    $Error_msg = 'Please select if you want to allow your members to upgrade to a higher priced program for the cost of difference.';
	  }
	elseif ($_POST['upgrade_program'] == 'Y' && (empty($_POST['program_child']) || $_POST['program_child'] != $_POST['pr_downlinks'])) {
	  $Error_msg = 'Please make sure that the programs in the child and linked settings are in the exact same order.';
	  }
	elseif (empty($_POST['type']) || ($_POST['type'] != 'S' && $_POST['type'] != 'N')) {
		$Error_msg = 'Please select the program type.';
		}
	elseif (empty($_POST['year_payment']) || ($_POST['year_payment'] != 'Y' && $_POST['year_payment'] != 'N')) {
		$Error_msg = 'Please select if the year payment should be enabled or not.';
		}
	elseif (empty($_POST['life_payment']) || ($_POST['life_payment'] != 'Y' && $_POST['life_payment'] != 'N')) {
		$Error_msg = 'Please select if the life payment should be enabled or not.';
		}
	elseif ((empty($_POST['type_tier']) || ($_POST['type_tier'] != 'S' && $_POST['type_tier'] != 'N')) || (empty($_POST['type_powerline']) || ($_POST['type_powerline'] != 'S' && $_POST['type_powerline'] != 'N')) || (empty($_POST['type_admin']) || ($_POST['type_admin'] != 'S' && $_POST['type_admin'] != 'N')) || (empty($_POST['type_admin2']) || ($_POST['type_admin2'] != 'S' && $_POST['type_admin2'] != 'N'))) {
		$Error_msg = 'Please select the payment types.';
		}
  elseif (empty($_POST['collected_by']) || ($_POST['collected_by'] != 'A' && $_POST['collected_by'] != 'E' && $_POST['collected_by'] != 'EAT')) {
		$Error_msg = 'Please select who the payment will be collected.';
		}
elseif (empty($_POST['tier_system']) || ($_POST['tier_system'] != 'N' && $_POST['tier_system'] != 'P' && $_POST['tier_system'] != 'RP')) {
		$Error_msg = 'Please select how the tier system should work.';
		}		
	/*elseif (!is_numeric($_POST['tier']) || !is_numeric($_POST['unpaid_tier']) || !is_numeric($_POST['powerline']) || !is_numeric($_POST['tier_amount']) || !is_numeric($_POST['tier_amount2']) || !is_numeric($_POST['tier_amount3']) || !is_numeric($_POST['tier_amount4']) || !is_numeric($_POST['tier_amount5']) || !is_numeric($_POST['powerline_amount']) || !is_numeric($_POST['admin_amount']) || !is_numeric($_POST['admin2_amount']) || !is_numeric($_POST['total_amount']) || !is_numeric($_POST['sub_period']) || !is_numeric($_POST['cc_fee']) || !is_numeric($_POST['cc_fee_year']) || !is_numeric($_POST['cc_fee_life']) || !is_numeric($_POST['year_tier_amount']) || !is_numeric($_POST['year_tier_amount2']) || !is_numeric($_POST['year_tier_amount3']) || !is_numeric($_POST['year_tier_amount4']) || !is_numeric($_POST['year_tier_amount5']) || !is_numeric($_POST['year_powerline_amount']) || !is_numeric($_POST['year_admin_amount']) || !is_numeric($_POST['year_admin2_amount']) || !is_numeric($_POST['year_total_amount']) || !is_numeric($_POST['life_tier_amount']) || !is_numeric($_POST['life_tier_amount2']) || !is_numeric($_POST['life_tier_amount3']) || !is_numeric($_POST['life_tier_amount4']) || !is_numeric($_POST['life_tier_amount5']) || !is_numeric($_POST['life_powerline_amount']) || !is_numeric($_POST['life_admin_amount']) || !is_numeric($_POST['life_admin2_amount']) || !is_numeric($_POST['life_total_amount']) || !is_numeric($_POST['year_period'])) {
		$Error_msg = 'Please note that the credit card fee, sub and year period, tier, powerline and normal, year and life payment fields can only contain numeric values. Please note you should use dot to divide decimal numnbers, not a comma.';
		}*/
	elseif ((int) $_POST['powerline'] > 0 && count($powerline_order_temp) != $_POST['powerline']) {
		$Error_msg = 'Please make sure the powerline number and the amount of numbers in powerline order match.';
		}
		elseif ((int) $_POST['powerline'] > 0 && $powerline_order_failure === true) {
		$Error_msg = 'The powerline_order can only contain numbers seperated by a comma, and it can not contain the same number twice. The numbers should also go from the lowest to the highest.';
		}
	elseif (!is_numeric($_POST['pass_up_every_nth'])) {
$Error_msg = 'The Pass Up Every Nth field must be a numeric value. Set this field to 0 to disable it.';
}
/* QQQ THIS ERROR MSG DOES NOT ALLOW COMMAS, BUT WE NEED TO ALLOW COMMAS. NEED TO MAKE THIS ERROR IF NOT NUMBERIC, BUT TO ALLOW COMMAS
elseif (!is_numeric($_POST['pass_ups_to_admin'])) {
$Error_msg = 'Pass Ups To Admin may only contain numeric values. Set the number of each sale you want passed to admin, separated by commas.';
}*/

elseif (($_POST['pass_ups_to_admin'] !=0) && ($_POST['require_pass_ups_to_admin'] != 'Y')) {
		$Error_msg = 'If you want sales passed up to admin, you must set "Require Pass Ups To Admin" to "Yes".';
}
/* QQQ THIS ERROR MSG NEEDS TO USE ARRAYS
elseif ($_POST['pass_ups_to_admin'] NOT IN $_POST['require_pass_ups_to_admin']) {
        $Error_msg = 'Pass Ups To Admin must be listed in the "Which are powerlines" field, above.';
} 
}*/
	elseif (!ctype_digit($_POST['forced_number'])) {
		//$Error_msg = 'The forced passup can only contain a number.';
		}
	elseif ((float) $_POST['admin2_amount'] > 0 && empty($_POST['program_admin2_receiver'])) {
    $Error_msg = 'If you want to add a second administrator payment; you need to add the username of the receiver. Note. if you want it to go to the default admin, please add '.$Global['administratior'].' as username.';
	  }
  elseif ($admin_receiver_name === false) {
    $Error_msg = 'Please make sure that you add a valid username in the second administrator payment receiver field.';
	  }
	elseif (number_format($_POST['total_amount']+0, 2, '.', '') != number_format($total+0, 2, '.', '')) {
		$Error_msg = 'The total amount of payments required is different than the total payment amount. Every signup will require $'.number_format($total, 2, '.', '').', and the total payment is on $'.number_format($_POST['total_amount'], 2, '.', '').'. Please look over the payments and correct the problem.';
		}
	elseif (number_format($_POST['year_total_amount']+0, 2, '.', '') != number_format($total_year+0, 2, '.', '')) {
		$Error_msg = 'The total amount of payments required is different than the year total payment amount. Every signup will require $'.number_format($total_year, 2, '.', '').', and the year total payment is on $'.number_format($_POST['year_total_amount'], 2, '.', '').'. Please look over the year payments and correct the problem.';
		}
	elseif (number_format($_POST['life_total_amount']+0, 2, '.', '') != number_format($total_life+0, 2, '.', '')) {
		$Error_msg = 'The total amount of payments required is different than the life total payment amount. Every signup will require $'.number_format($total_life, 2, '.', '').', and the life total payment is on $'.number_format($_POST['life_total_amount'], 2, '.', '').'. Please look over the life payments and correct the problem.';
		}
	elseif ($total <= 0) {
		$Error_msg = 'You can not create a program without any payments.';
		}
	elseif ($_POST['tier'] > 5) {
		$Error_msg = 'You can not have more than five tiers.';
		}
  elseif(!empty($_POST['pr_downlinks'])) {
    //Go over the linked programs, making certain they are valid
    $prd = explode(" ", $_POST['pr_downlinks']);
    
    foreach ($prd as $key) {
			$key = intval($key); // Ensure $key is an integer
			$conditions = [
				'program_id' => $key
			];

			// Using the select method from PHPCPR
			$result = select("*", "program", [], $conditions, null, null, null, 0, 1);

			// Assuming the result is fetched as an associative array
			if ($result) {
				$b_link = $result[0]; // Get the first row from the result
			} else {
				$b_link = null; // Or handle this case as per your application logic
			}	  
	  
      
      if ($b_link['program_tier'] != (int) $_POST['tier']) {
        $err_link = "Program tier {$b_link['program_tier']} different for linked program #$key {$_POST['tier']}";	
        }
      elseif ($b_link['program_tier_unpaid_level'] != (int) $_POST['unpaid_tier']) {
        $err_link = "Program tier unpaid level different for linked program #$key";	
        }
      elseif ($b_link['program_up'] != (int) $_POST['powerline']) {
        $err_link = "Program powerline {$b_link['program_up']} different for linked program #$key ,".$_POST['powerline'];	
      	}
      elseif ($b_link['program_up_order'] != $_POST['powerline_order']) {
      	$err_link = "Program powerline order different for linked program #$key";	      	
        }
      elseif ($b_link['program_type'] != $_POST['type']) {
      	$err_link = "Program type {$b_link['program_type']} different for linked program #$key";	
        }
      elseif ($b_link['program_up_type'] != $_POST['type_powerline']) {
      	$err_link = "Program powerline type different for linked program #$key";	
        }
      elseif ($b_link['program_tier_type'] != $_POST['type_tier']){
      	$err_link = "Program tier {$b_link['program_tier_type']} type different for linked program #$key";	
        }
      elseif ($b_link['program_admin_type'] != $_POST['type_admin']){
      	$err_link = "Program admin type different for linked program #$key";	
        }
      elseif ($b_link['program_admin2_type'] != $_POST['type_admin2']){
      	$err_link = "Program admin type 2 different for linked program #$key";	
        }  
      elseif ($b_link['program_sub_period'] != $_POST['sub_period']) {
      	$err_link = "Program sub period different for linked program #$key";	
        }
      elseif ($b_link['program_year_enabled'] != $_POST['year_payment']) {
      	$err_link = "Linked program and main program should have same year enable for program #$key";	
        }
      elseif ($b_link['program_life_enabled'] != $_POST['life_payment']) {
      	$err_link = "Linked program and main program should have same life enable for program #$key";	
        }
        
        
      elseif ($b_link['program_tier_pay'] > 0 && number_format((float) $_POST['tier_amount'], 2, '.', '') < number_format((float) $b_link['program_tier_pay'], 2, '.', '')) {
      	$err_link = "Linked program has more tier 1 pay (NORMAL) for program #$key";	
        }
      elseif ($b_link['program_tier_pay2'] > 0 && number_format((float) $_POST['tier_amount2'], 2, '.', '') < number_format((float) $b_link['program_tier_pay2'], 2, '.', '')) {
      	$err_link = "Linked program has more tier 2 pay (NORMAL) for program #$key";	
        }  
      elseif ($b_link['program_tier_pay3'] > 0 && number_format((float) $_POST['tier_amount3'], 2, '.', '') < number_format((float) $b_link['program_tier_pay3'], 2, '.', '')) {
      	$err_link = "Linked program has more tier 3 pay (NORMAL) for program #$key";	
        }
      elseif ($b_link['program_tier_pay4'] > 0 && number_format((float) $_POST['tier_amount4'], 2, '.', '') < number_format((float) $b_link['program_tier_pay4'], 2, '.', '')) {
      	$err_link = "Linked program has more tier 4 pay (NORMAL) for program #$key";	
        }
      elseif ($b_link['program_tier_pay5'] > 0 && number_format((float) $_POST['tier_amount5'], 2, '.', '') < number_format((float) $b_link['program_tier_pay5'], 2, '.', '')) {
      	$err_link = "Linked program has more tier 5 pay (NORMAL) for program #$key";	
        }
      elseif ($b_link['program_up_pay'] > 0 && number_format((float) $_POST['powerline_amount'], 2, '.', '') < number_format((float) $b_link['program_up_pay'], 2, '.', '')) {
      	$err_link = "Linked program has more powerline pay (NORMAL) for program #$key";	      	
        }
      elseif ($b_link['program_admin_pay'] > 0 && number_format((float) $_POST['admin_amount'], 2, '.', '') < number_format((float) $b_link['program_admin_pay'], 2, '.', '')) {
      	$err_link = "Linked program has more admin pay (NORMAL) for program #$key";	
        }
      elseif ($b_link['program_admin2_pay'] > 0 && number_format((float) $_POST['admin2_amount'], 2, '.', '') < number_format((float) $b_link['program_admin2_pay'], 2, '.', '')) {
      	$err_link = "Linked program has more admin2 pay (NORMAL) for program #$key";	      	
        }  
      elseif ($b_link['program_tier_year'] > 0 && number_format((float) $_POST['year_tier_amount'], 2, '.', '') < number_format((float) $b_link['program_tier_year'], 2, '.', '')) {
      	$err_link = "Linked program has more tier 1 pay (YEAR) for program #$key";	
        }
      elseif ($b_link['program_tier_year2'] > 0 && number_format((float) $_POST['year_tier_amount2'], 2, '.', '') < number_format((float) $b_link['program_tier_year2'], 2, '.', '')) {
      	$err_link = "Linked program has more tier 2 pay (YEAR) for program #$key";	
        }
      elseif ($b_link['program_tier_year3'] > 0 && number_format((float) $_POST['year_tier_amount3'], 2, '.', '') < number_format((float) $b_link['program_tier_year3'], 2, '.', '')) {
      	$err_link = "Linked program has more tier 3 pay (YEAR) for program #$key";	
        }
      elseif ($b_link['program_tier_year4'] > 0 && number_format((float) $_POST['year_tier_amount4'], 2, '.', '') < number_format((float) $b_link['program_tier_year4'], 2, '.', '')) {
      	$err_link = "Linked program has more tier 4 pay (YEAR) for program #$key";	
        }
      elseif ($b_link['program_tier_year5'] > 0 && number_format((float) $_POST['year_tier_amount5'], 2, '.', '') < number_format((float) $b_link['program_tier_year5'], 2, '.', '')) {
      	$err_link = "Linked program has more tier 5 pay (YEAR) for program #$key";	
        }    
      elseif ($b_link['program_up_year'] > 0 && number_format((float) $_POST['year_powerline_amount'], 2, '.', '') < number_format((float) $b_link['program_up_year'], 2, '.', '')) {  
      	$err_link = "Linked program has more powerline pay (YEAR) for program #$key";	
        }  
      elseif ($b_link['program_admin_year'] > 0 && number_format((float) $_POST['year_admin_amount'], 2, '.', '') < number_format((float) $b_link['program_admin_year'], 2, '.', '')) {
      	$err_link = "Linked program has more admin pay(YEAR) for program #$key";	
        }
      elseif ($b_link['program_admin2_year'] > 0 && number_format((float) $_POST['year_admin2_amount'], 2, '.', '') < number_format((float) $b_link['program_admin2_year'], 2, '.', '')) {
      	$err_link = "Linked program has more admin2 pay (YEAR) for program #$key";	      	
        }
      elseif ($b_link['program_tier_life'] > 0 && number_format((float) $_POST['life_tier_amount'], 2, '.', '') < number_format((float) $b_link['program_tier_life'], 2, '.', '')) {
      	$err_link = "Linked program has more tier pay (LIFE) for program #$key";	
        }
      elseif ($b_link['program_tier_life2'] > 0 && number_format((float) $_POST['life_tier_amount2'], 2, '.', '') < number_format((float) $b_link['program_tier_life2'], 2, '.', '')) {
      	$err_link = "Linked program has more tier 2 pay (LIFE) for program #$key";	
        }
      elseif ($b_link['program_tier_life3'] > 0 && number_format((float) $_POST['life_tier_amount3'], 2, '.', '') < number_format((float) $b_link['program_tier_life3'], 2, '.', '')) {
      	$err_link = "Linked program has more tier 3 pay (LIFE) for program #$key";	
        }
      elseif ($b_link['program_tier_life4'] > 0 && number_format((float) $_POST['life_tier_amount4'], 2, '.', '') < number_format((float) $b_link['program_tier_life4'], 2, '.', '')) {
      	$err_link = "Linked program has more tier 4 pay (LIFE) for program #$key";	
        }
      elseif ($b_link['program_tier_life5'] > 0 && number_format((float) $_POST['life_tier_amount5'], 2, '.', '') < number_format((float) $b_link['program_tier_life5'], 2, '.', '')) {
      	$err_link = "Linked program has more tier 5 pay (LIFE) for program #$key";	
        }  
      elseif ($b_link['program_up_life'] > 0 && number_format((float) $_POST['life_powerline_amount'], 2, '.', '') < number_format((float) $b_link['program_up_life'], 2, '.', '')) {
      	$err_link = "Linked program has more powerline pay (LIFE) for program #$key";	
        }  
      elseif ($b_link['program_admin_life'] > 0 && number_format((float) $_POST['life_admin_amount'], 2, '.', '') < number_format((float) $b_link['program_admin_life'], 2, '.', '')) {
      	$err_link = "Linked program has more admin pay (LIFE) for program #$key";	
        }
      elseif ($b_link['program_admin2_life'] > 0 && number_format((float) $_POST['life_admin2_amount'], 2, '.', '') < number_format((float) $b_link['program_admin2_life'], 2, '.', '')) {
      	$err_link = "Linked program has more admin pay (LIFE) for program #$key";	
        }  
    	
      if(!empty($err_link)) {
        $Error_msg = $err_link.'<br/>Following payment attributes should be same of linked program and main program : tiers,tier type,powerlines,powerline type,powerline order,admin type,subscription period';
        break;	
        }
	    }
    }
	
	if (empty($Error_msg) && empty($_SESSION['step1'])) {	
		if ($_POST['program_type'] == 'store') $_POST['program_type'] = 'S';
		else $_POST['program_type'] = 'N';
		
		if (!empty($_POST['editstep1'])) {
			
			// Assuming all $_POST variables are set and available
			$data = [
				'pass_ups_to_admin' => $_POST['pass_ups_to_admin'],
				'require_pass_ups_to_admin' => $_POST['require_pass_ups_to_admin'],
				'force_downline_pass_ups' => $_POST['force_downline_pass_ups'],
				'freetrial_enabled' => isset($_POST['freetrial_enabled']) && $_POST['freetrial_enabled'] == 'yes' ? 'Y' : 'N',
				'freetrial_require_cc' => isset($_POST['freetrial_require_cc']) && $_POST['freetrial_require_cc'] == 'yes' ? 'Y' : 'N',
				'freetrial_days' => intval($_POST['freetrial_days']),
				'program_redirect_url' => $_POST['program_redirect_url'],
				'program_tier_system' => $_POST['tier_system'],
				'program_collect' => $_POST['collected_by'],
				'upgrade_program' => $_POST['upgrade_program'],
				'pr_downlinks' => $_POST['pr_downlinks'],
				'program_admin2_year' => (float)$_POST['year_admin2_amount'],
				'program_admin2_life' => (float)$_POST['life_admin2_amount'],
				'program_admin2_pay' => (float)$_POST['admin2_amount'],
				'program_admin2_type' => $_POST['type_admin2'],
				'program_admin2_receiver' => $_POST['program_admin2_receiver'],
				'program_tier' => intval($_POST['tier']),
				'program_up' => intval($_POST['powerline']),
				'program_up_order' => $_POST['powerline_order'],
				'program_forced' => (int)$_POST['forced_number'],
				'program_tier_pay' => floatval($_POST['tier_amount']),
				'program_tier_pay2' => floatval($_POST['tier_amount2']),
				'program_tier_pay3' => floatval($_POST['tier_amount3']),
				'program_tier_pay4' => floatval($_POST['tier_amount4']),
				'program_tier_pay5' => floatval($_POST['tier_amount5']),
				'program_up_pay' => floatval($_POST['powerline_amount']),
				'program_admin_pay' => floatval($_POST['admin_amount']),
				'program_type' => $_POST['type'],
				'program_sub_period' => intval($_POST['sub_period']),
				'program_name' => $_POST['program_name'],
				'program_short_desc' => $_POST['program_short_desc'],
				'program_desc' => $_POST['program_desc'],
				'giveaway_file' => $_POST['giveaway_file'],
				'giveaway_enabled' => isset($_POST['giveaway_enabled']) && $_POST['giveaway_enabled'] == 'yes' ? 'Y' : 'N',
				'program_cc_fee' => $_POST['cc_fee'],
				'program_cc_fee_year' => $_POST['cc_fee_year'],
				'program_cc_fee_life' => $_POST['cc_fee_life'],
				'program_tier_unpaid_level' => $_POST['unpaid_tier'],
				'program_tier_type' => $_POST['type_tier'],
				'program_up_type' => $_POST['type_powerline'],
				'program_admin_type' => $_POST['type_admin'],
				'program_link' => empty($_POST['program_child']) ? '' : $_POST['program_child'],
				'program_year_enabled' => $_POST['year_payment'],
				'program_tier_year' => $_POST['year_tier_amount'],
				'program_tier_year2' => $_POST['year_tier_amount2'],
				'program_tier_year3' => $_POST['year_tier_amount3'],
				'program_tier_year4' => $_POST['year_tier_amount4'],
				'program_tier_year5' => $_POST['year_tier_amount5'],
				'program_up_year' => $_POST['year_powerline_amount'],
				'program_admin_year' => $_POST['year_admin_amount'],
				'program_life_enabled' => $_POST['life_payment'],
				'program_tier_life' => $_POST['life_tier_amount'],
				'program_tier_life2' => $_POST['life_tier_amount2'],
				'program_tier_life3' => $_POST['life_tier_amount3'],
				'program_tier_life4' => $_POST['life_tier_amount4'],
				'program_tier_life5' => $_POST['life_tier_amount5'],
				'program_up_life' => $_POST['life_powerline_amount'],
				'program_admin_life' => $_POST['life_admin_amount'],
				'program_year_period' => $_POST['year_period'],
				'program_setup_type' => $_POST['program_setup_type'],
				'pass_up_every_nth' => $_POST['pass_up_every_nth'],
				'unlock_key' => $_POST['unlock_key'],
				'lock_enabled' => isset($_POST['lock_enabled']) && $_POST['lock_enabled'] == 'yes' ? 'Y' : 'N'
			];

			$where = [
				'program_id' => intval($_POST['program_id'])
			];

			// Call PHPCPR update function
			update('program', $data, [], $where, 1, 0, 1);
			
		
			$_SESSION['program_id'] = intval($_POST['program_id']);
		
			$_SESSION['step1'] = true;
		
			$step = 3;
			}
		else {
			
			$data = [
				'pass_ups_to_admin' => $_POST['pass_ups_to_admin'],
				'require_pass_ups_to_admin' => $_POST['require_pass_ups_to_admin'],
				'force_downline_pass_ups' => $_POST['force_downline_pass_ups'],
				'freetrial_enabled' => (isset($_POST['freetrial_enabled']) && $_POST['freetrial_enabled'] == 'yes') ? 'Y' : 'N',
				'freetrial_require_cc' => (isset($_POST['freetrial_require_cc']) && $_POST['freetrial_require_cc'] == 'yes') ? 'Y' : 'N',
				'freetrial_days' => intval($_POST['freetrial_days']),
				'program_redirect_url' => $_POST['program_redirect_url'],
				'program_forced' => (int) $_POST['forced_number'],
				'program_tier_system' => $_POST['tier_system'],
				'program_collect' => $_POST['collected_by'],
				'upgrade_program' => $_POST['upgrade_program'],
				'pr_downlinks' => $_POST['pr_downlinks'],
				'program_admin2_year' => (float) $_POST['year_admin2_amount'],
				'program_admin2_life' => (float) $_POST['life_admin2_amount'],
				'program_admin2_pay' => (float) $_POST['admin2_amount'],
				'program_admin2_type' => $_POST['type_admin2'],
				'program_admin2_receiver' => $_POST['program_admin2_receiver'],
				'program_tier' => intval($_POST['tier']),
				'program_up' => intval($_POST['powerline']),
				'program_up_order' => $_POST['powerline_order'],
				'program_tier_pay' => floatval($_POST['tier_amount']),
				'program_tier_pay2' => floatval($_POST['tier_amount2']),
				'program_tier_pay3' => floatval($_POST['tier_amount3']),
				'program_tier_pay4' => floatval($_POST['tier_amount4']),
				'program_tier_pay5' => floatval($_POST['tier_amount5']),
				'program_up_pay' => floatval($_POST['powerline_amount']),
				'program_admin_pay' => floatval($_POST['admin_amount']),
				'program_type' => $_POST['type'],
				'program_sub_period' => intval($_POST['sub_period']),
				'program_name' => $_POST['program_name'],
				'program_short_desc' => $_POST['program_short_desc'],
				'program_desc' => $_POST['program_desc'],
				'giveaway_file' => $_POST['giveaway_file'],
				'giveaway_enabled' => (isset($_POST['giveaway_enabled']) && $_POST['giveaway_enabled'] == 'yes') ? 'Y' : 'N',
				'program_cc_fee' => $_POST['cc_fee'],
				'program_cc_fee_year' => $_POST['cc_fee_year'],
				'program_cc_fee_life' => $_POST['cc_fee_life'],
				'program_tier_unpaid_level' => $_POST['unpaid_tier'],
				'program_tier_type' => $_POST['type_tier'],
				'program_tier_year2' => $_POST['year_tier_amount2'],
				'program_tier_year3' => $_POST['year_tier_amount3'],
				'program_tier_year4' => $_POST['year_tier_amount4'],
				'program_tier_year5' => $_POST['year_tier_amount5'],
				'program_up_type' => $_POST['type_powerline'],
				'program_admin_type' => $_POST['type_admin'],
				'program_link' => empty($_POST['program_child']) ? 'NULL' : $_POST['program_child'],
				'program_year_enabled' => $_POST['year_payment'],
				'program_tier_year' => $_POST['year_tier_amount'],
				'program_up_year' => $_POST['year_powerline_amount'],
				'program_admin_year' => $_POST['year_admin_amount'],
				'program_life_enabled' => $_POST['life_payment'],
				'program_tier_life' => $_POST['life_tier_amount'],
				'program_tier_life2' => $_POST['life_tier_amount2'],
				'program_tier_life3' => $_POST['life_tier_amount3'],
				'program_tier_life4' => $_POST['life_tier_amount4'],
				'program_tier_life5' => $_POST['life_tier_amount5'],
				'program_up_life' => $_POST['life_powerline_amount'],
				'program_admin_life' => $_POST['life_admin_amount'],
				'program_year_period' => $_POST['year_period'],
				'program_setup_type' => $_POST['program_setup_type'],
				'pass_up_every_nth' => $_POST['pass_up_every_nth'],
				'unlock_key' => $_POST['unlock_key'],
				'lock_enabled' => (isset($_POST['lock_enabled']) && $_POST['lock_enabled'] == 'yes') ? 'Y' : 'N'
			];

			$res = insert('program', $data, 1, 1);
			
			
			$_SESSION['program_id'] = $res['last_insert_id'];
		
			$_SESSION['step1'] = true;
		
			if (!empty($_SESSION['step2'])) unset($_SESSION['step2']);
		
			$step = 2;
			}
		}
	else {
		if (!empty($_SESSION['step1'])) {
			$Error_msg = '';
			$step = 2;
			}
		else {
			$step = 1;
			}
		}
	}
elseif (!empty($_POST['step2'])) {
	
	if (empty($_POST['header']) || empty($_POST['footer']) || strlen($_POST['header']) > 250 || strlen($_POST['footer']) > 250)	{
		$Error_msg = 'Please fill in the header and footer file name including extension, please note the file names can not be more than 250 characters long.';
		}
	elseif (empty($_POST['new_member_subject']) || empty($_POST['new_member_message']) || empty($_POST['sponsor_subject']) || empty($_POST['sponsor_message']) || empty($_POST['sponsor_qualify_subject']) || empty($_POST['sponsor_qualify_message']) || empty($_POST['powerline_subject']) || empty($_POST['powerline_message']) || empty($_POST['unpaid_subject']) || empty($_POST['unpaid_message']) || strlen($_POST['new_member_subject']) > 250 || strlen($_POST['sponsor_subject']) > 250 || strlen($_POST['sponsor_qualify_subject']) > 250 || strlen($_POST['powerline_subject']) > 250 || strlen($_POST['unpaid_subject']) > 250) {
		$Error_msg = 'Please fill out all email fields, please note the subject can not be more than 250 characters long.';
		}
	elseif (empty($_POST['text_thankyou'])) {
		$Error_msg = 'Please fill out all text fields.';
		}

	if (empty($Error_msg) && intval($_POST['program_id']) > 0 && empty($_SESSION['step2'])) {
		if (!empty($_POST['editstep2'])) {
			$program_id = intval($_POST['program_id']);
			
			// New member email update
			update(
				'program_email',
				[
					'email_subject' => $_POST['new_member_subject'],
					'email_message' => $_POST['new_member_message']
				],
				[],
				['program_id' => $program_id, 'email_type' => 'nm'],
				1
			);

			// Sponsor email update
			update(
				'program_email',
				[
					'email_subject' => $_POST['sponsor_subject'],
					'email_message' => $_POST['sponsor_message']
				],
				[],
				['program_id' => $program_id, 'email_type' => 's'],
				1
			);

			// Sponsor qualifier email update
			update(
				'program_email',
				[
					'email_subject' => $_POST['sponsor_qualify_subject'],
					'email_message' => $_POST['sponsor_qualify_message']
				],
				[],
				['program_id' => $program_id, 'email_type' => 'sq'],
				1
			);

			// Powerline email update
			update(
				'program_email',
				[
					'email_subject' => $_POST['powerline_subject'],
					'email_message' => $_POST['powerline_message']
				],
				[],
				['program_id' => $program_id, 'email_type' => 'p'],
				1
			);

			// Unpaid email update
			update(
				'program_email',
				[
					'email_subject' => $_POST['unpaid_subject'],
					'email_message' => $_POST['unpaid_message']
				],
				[],
				['program_id' => $program_id, 'email_type' => 'u'],
				1
			);

			// Thank you page update
			update(
				'program_text',
				['text' => $_POST['text_thankyou']],
				[],
				['program_id' => $program_id, 'text_type' => 'thankyou'],
				1
			);

			// Header/Footer update
			update(
				'program',
				[
					'header_file' => $_POST['header'],
					'footer_file' => $_POST['footer']
				],
				[],
				['program_id' => intval($_POST['program_id'])],
				1
			);
			
			
			$_SESSION['program_id'] = intval($_POST['program_id']);
			
			$_SESSION['step2'] = true;
			
			$step = 3;
			}
		else {
			// Insert for program_email table
			$emailData = [
				[
					'program_id' => intval($_POST['program_id']),
					'email_type' => 'nm',
					'email_subject' => $_POST['new_member_subject'],
					'email_message' => $_POST['new_member_message']
				],
				[
					'program_id' => intval($_POST['program_id']),
					'email_type' => 's',
					'email_subject' => $_POST['sponsor_subject'],
					'email_message' => $_POST['sponsor_message']
				],
				[
					'program_id' => intval($_POST['program_id']),
					'email_type' => 'sq',
					'email_subject' => $_POST['sponsor_qualify_subject'],
					'email_message' => $_POST['sponsor_qualify_message']
				],
				[
					'program_id' => intval($_POST['program_id']),
					'email_type' => 'p',
					'email_subject' => $_POST['powerline_subject'],
					'email_message' => $_POST['powerline_message']
				],
				[
					'program_id' => intval($_POST['program_id']),
					'email_type' => 'u',
					'email_subject' => $_POST['unpaid_subject'],
					'email_message' => $_POST['unpaid_message']
				]
			];

			foreach ($emailData as $data) {
				insert('program_email', $data, 1, 1);
			}

			// Insert for program_text table
			$textData = [
				'program_id' => intval($_POST['program_id']),
				'text_type' => 'thankyou',
				'text' => $_POST['text_thankyou']
			];

			insert('program_text', $textData, 1, 1);
			
			
			//Header/Footer update			
			update(
				'program',
				[
					'header_file' => $_POST['header'],
					'footer_file' => $_POST['footer']
				],
				[],
				['program_id' => intval($_POST['program_id'])],
				1,1,1
			);
			
			
			$_SESSION['step2'] = true;
			
			if (!empty($_SESSION['step3'])) unset($_SESSION['step3']);
			
			$step = 3;
			}
		}
	else {
		if (!empty($_SESSION['step2'])) {
			$Error_msg = '';
			$step = 3;
			}
		else {
			$step = 2;
			}
		}
	}
elseif (!empty($_POST['step3'])) {
	// Using PHPCPR's select function
	$conditions = ['program_id' => intval($_POST['program_id'])];
	$result = select('*', 'program', [], $conditions, null, null, null, 0, 1);

	if ($result) {
		$buffer = $result[0];
	}

        $_POST['require_pass_ups_to_admin'] = $buffer['require_pass_ups_to_admin'];
        $_POST['pass_ups_to_admin'] = $buffer['pass_ups_to_admin'];
	$_POST['force_downline_pass_ups'] = $buffer['force_downline_pass_ups'];
	$_POST['pass_up_every_nth'] = $buffer['pass_up_every_nth'];
	$_POST['program_setup_type'] = $buffer['program_setup_type'];
	$_POST['program_name'] = $buffer['program_name'];
	$_POST['tier'] = $buffer['program_tier'];
	$_POST['powerline'] = $buffer['program_up'];
	$_POST['tier_amount'] = $buffer['program_tier_pay'];
	$_POST['powerline_amount'] = $buffer['program_up_pay'];
	$_POST['admin_amount'] = $buffer['program_admin_pay'];
	$_POST['header'] = $buffer['header_file'];
	$_POST['footer'] = $buffer['footer_file'];
	$_POST['freetrial_enabled'] = $buffer['freetrial_enabled'];
	$_POST['freetrial_require_cc'] = $buffer['freetrial_require_cc'];
	$_POST['freetrial_days'] = $buffer['freetrial_days'];
	$_POST['giveaway_enabled'] = $buffer['giveaway_enabled'];
	$_POST['giveaway_file'] = $buffer['giveaway_file'];
	$_POST['program_redirect_url'] = $buffer['program_redirect_url'];
	$_POST['lock_enabled'] = $buffer['lock_enabled'];
	$_POST['unlock_key'] = $buffer['unlock_key'];
	$header_path = './../../Sub/tpl/'.$_POST['header'];
	$footer_path = './../../Sub/tpl/'.$_POST['footer'];
	$giveaway_path = './../../Ipn/Give/'.$_POST['giveaway_file'];
		
	// Select from program_email table
	$emailConditions = ['program_id' => $buffer['program_id']];
	$result_email = select('*', 'program_email', [], $emailConditions, null, null, null, 0, 1);

	// Select from program_text table
	$textConditions = ['program_id' => $buffer['program_id']];
	$result_text = select('*', 'program_text', [], $textConditions, null, null, null, 0, 1);
	

	//Error messages
	if (empty($_POST['program_name'])) {
		$Error_msg = 'You require a program name. Please add one.';
		}
	elseif (!is_numeric($_POST['tier']) || !is_numeric($_POST['powerline']) || !is_numeric($_POST['tier_amount']) || !is_numeric($_POST['powerline_amount']) || !is_numeric($_POST['admin_amount'])) {
		$Error_msg = 'Please note that the tier, powerline and payment fields can only contain numeric values. Please note you should use dot to divide decimal numnbers, not a comma.';
		}
	elseif (!file_exists($header_path))	{
		$Error_msg = 'The header file does not exist. Please make sure that the header file name is correct, and that you have uploaded the file.';
		}
	elseif (!file_exists($footer_path))	{
		$Error_msg = 'The footer file does not exist. Please make sure that the footer file name is correct, and that you have uploaded the file.';
		}
	elseif ($_POST['giveaway_enabled'] == 'Y' && !file_exists($giveaway_path))	{
		$Error_msg = 'The giveaway file does not exist. Please make sure that the giveaway file name is correct, and that you have uploaded the file.';
		}
	elseif ($_POST['lock_enabled'] == 'Y' && !($_POST['unlock_key']))	{
		$Error_msg = 'The unlock key is empty. You cant use the lock unless you provide the unlock key.';
		}
	if (empty($Error_msg)) {
		foreach ($result_email as $buffer) {
			{
			if (empty($buffer['email_type']) || empty($buffer['email_subject']) || empty($buffer['email_message'])) {
				$Error_msg = 'There was a problem with one of the emails. Please make sure all the email fields has been filled out.';
				break;
				}
			}
		}	
	}
		if (empty($Error_msg)) {
		foreach ($result_text as $buffer) { 
			{
			if (empty($buffer['text_type']) || empty($buffer['text'])) {
				$Error_msg = 'There was a problem with one of the text pages. Please make sure all the text page fields has been filled out.';
				break;
				}
			}
		}	

		} // REPLACING WHERE CLOSE MAY GO		
	if (empty($Error_msg) && empty($_SESSION['step3'])) {
		update('program',
			['program_approved' => 'Y'],
			[],
			['program_id' => intval($_POST['program_id'])],
			1, 1, 1);
		
		
		define('ADMIN', true);
		
		$program_id = intval($_POST['program_id']);
		
		include './Populate_table.inc.php';
		
		$_SESSION['step3'] = true;
		
		unset($_SESSION['step1'], $_POST);
		
		$Error_msg = 'Program was added successfully!';
		
		$step = 1;
		}
	else {
		if (!empty($_SESSION['step3'])) {
			$Error_msg = '';
			$step = 1;
			}
		else {
			$step = 3;
			}
		}
	}
else {
	unset($_SESSION['step1'], $_SESSION['step2'], $_SESSION['step3']);
	
	$step = 1;
	}

if ((!empty($_GET['step']) && !empty($_GET['program']))) {
	$program_do = 'Edit';
	
	$step = intval($_GET['step']);
	}
elseif (!empty($_POST['editstep1']) || !empty($_POST['editstep2'])) {
	$program_do = 'Edit';
	}
else {
	$program_do = 'Add';
	}
	
include './../Inc/Header.inc.php';

echo '<h1>'.$program_do.' Program - Step '.$step.' / 3</h1>';

if ($step == 1) include './Inc/Program_step1.inc.php';
elseif ($step == 2) include './Inc/Program_step2.inc.php';
elseif ($step == 3) include './Inc/Program_step3.inc.php';

include './../Inc/Footer.inc.php';
?>