<?php
//-----------------------------------------------------------------
// Software: Automatic Web Software (AWS) built with PHPCPR
// Firm: DirectSalesMLM.com / AutomaticWebSoftware.com / PHPCPR.com
// Author: Jim Symonds Email: jim@directsalesmlm.com
// Copyright 2006 - 2024 Jim Symonds All Rights Reserved.
//-----------------------------------------------------------------
include './../../Sub/Config.inc.php';
include './../../phpcpr.php';
include './../Lib/Pagination.function.php';
include './../Inc/Login.inc.php';
if ($loggedUser->checkPermisson('AUTORESPONDER') === false) {
	$errorMessage = 'You are not allowed to access this page.';
	require_once('./../Inc/error.php');
	exit;
}

$pageName = 'New Autoresponder';

if ($_GET['ar'] != '') $pageName = 'Edit Autoresponder';

$pageDesc = '';
$pageIcon = '';
$pageAlign = 'center';
$pageClass = '';

//set the ar data array values
$ar = array('id' => '', 'name' => '', 'reset' => 0, 'enabled' => 1, 'url' => '');

//if we edit an auto responder get it's data
if (isset($_GET['ar']) && ctype_digit((string)$_GET['ar'])) {
    $arId = (int)$_GET['ar'];
    $selectFields = 'ar_master_id AS id, ar_master_name AS name, ar_list_type, ar_master_reset_type AS reset, ar_master_enabled AS enabled, ar_master_url AS url';
    $mainTable = 'ar_master';
    $where = ['ar_master_id' => $arId];
    $result = select($selectFields, $mainTable, [], $where, null, null, null, 1, 1);
    if ($result !== false && count($result) > 0) {
        $ar_buff = $result[0];
        if (!empty($ar_buff['id'])) {
            $ar = array_merge($ar, $ar_buff);
        }
    } else {
        echo 'No records found or an error occurred.';
    }
}

$error = '';

//if the user submited the form
if (!empty($_POST)) {

	//validate user input
	if (empty($_POST['name'])) {
		$error = 'Please input a name';
		}
	elseif (empty($_POST['url'])) {
		$error = 'Please input a Redirect URL';
		}

	//if there is no error save the changes
	if (empty($error)) {

		$data = [
			'ar_master_name' => $_POST['name'], // Assuming sanitization/validation is handled internally
			'ar_list_type' => $_POST['ar_list_type'],
			'ar_master_reset_type' => !empty($_POST['reset']) ? 1 : 0,
			'ar_master_url' => $_POST['url'],
			'ar_master_enabled' => !empty($_POST['enabled']) ? 1 : 0
		];

		if (!empty($ar['id'])) {
			$where = ['ar_master_id' => (int)$ar['id']];
			update('ar_master', $data, [], $where, 1, 1, 1);
			
			$_POST['id'] = $ar['id'];

			//if the reset tyoe is set to off then change all records in ar_member_master to off as well
			// Update
			$data = [
				'ar_member_reset_type' => !empty($_POST['reset']) ? 1 : 0,
				'ar_member_url' => $_POST['url']
			];
			$where = [
				'ar_master_id' => (int)$ar['id'],
				'ar_member_edited' => 0
			];
			update('ar_member_master', $data, [], $where, 1, 1, 1);
					
		} else {
			
			// Insert operation for ar_master
			$data = [
				'ar_master_name' => $_POST['name'],
				'ar_list_type' => $_POST['ar_list_type'],
				'ar_master_reset_type' => !empty($_POST['reset']) ? 1 : 0,
				'ar_master_url' => $_POST['url'],
				'ar_master_enabled' => !empty($_POST['enabled']) ? 1 : 0
			];
			$res = insert('ar_master', $data, 1, 1);
			$_POST['id'] = $res['last_insert_id']; // Adapt this line to use your PHPCPR's method to retrieve the last inserted ID
			
			//insert the new record in the ar_member_master table for all members
			// NOT WORKING IN PHPCPR YET
			/*$insertIntoTable = 'ar_member_master';
			$columns = 'ar_master_id, ID, ar_member_reset_type, ar_member_url';
			$selectColumns = [
				$_POST['id'],
				'ID',
				(!empty($_POST['reset']) ? 1 : 0),
				$_POST['url']
			];
			$fromTable = 'members';
			$additionalConditions = "Username <> 'DELETED'";

			// Execute the insertSelect operation
			//insertSelect($insertIntoTable, $columns, $selectColumns, $fromTable, $additionalConditions, 1, 1);
			}*/

		$error = 'The auto responder was saved.';
		}

	$ar = array_merge($ar, $_POST);
	}
}
include './../Inc/Header.inc.php';
?>
<style>
table, th, td {
    border: 1px solid #eeeeee;
}

th, td {
    padding: 10px;
	text-align:center;
}
</style>
<h1><?php echo (!empty($ar['id']) ? 'Edit':'New'); ?> Autoresponder <?php echo (!empty($ar['id']) ? '"'.$ar['name'].'"':''); ?></h1>

<div class="col-md-4 col-md-offset-4" style="text-align:center"> 

	<a href="Ar_list.php" class="btn btn-info btn-sm"><i class="fa fa-angle-double-left" aria-hidden="true" style="color:white"></i>
	&nbsp; Back to list</a><br />&nbsp;

	<?php if (!empty($error)) { ?>
	<br /><span class="error"><?php echo $error; ?></span><br />&nbsp;
	<?php } ?>

	<form method="post" action="Ar_edit.php?ar=<?php echo $ar['id']; ?>">
<div class="table-responsive">
<table class="col-md-4 table">
			<tr>
				<th>Name:</th>
				<td><input type="text" class="form-control" name="name" value="<?php echo $ar['name']; ?>" /></td>
			</tr>

			<tr>
				<th>AR List Type:</td>

				<td><select name="ar_list_type" class="form-control">
				<?php
				echo '<option value="leads" '.((!empty($ar['ar_list_type']) && $ar['ar_list_type'] == 'leads')?'selected':'').'>Leads</option>';
				echo '<option value="members" '.((!empty($ar['ar_list_type']) && $ar['ar_list_type'] == 'members')?'selected':'').'>Members</option>';
				?>
				</select></td>

			</tr>			
			
			
			<tr>
				<th>Redirect URL:</td>
				<td>
					<strong>Tags:</strong>
					<br />
					[sponsor] - The affiliate member username<br />
					<input type="text" class="form-control" name="url" value="<?php echo $ar['url']; ?>" />
				</td>
			</tr>
			<tr>
				<th>Reset Available:</td>

				<td><input type="checkbox" class="" name="reset" value="1" <?php echo (!empty($ar['reset']) ? 'checked="checked"':''); ?> /></td>

			</tr>
			<tr>
				<th>Enabled:</td>
				<td><input type="checkbox" class="form-check-input" name="enabled" value="1" <?php echo (!empty($ar['enabled']) ? 'checked="checked"':''); ?> /></td>
			</tr>
			<tr>
				<td colspan="2"><input type="submit" class="btn btn-info" value="Save" /></td>
			</tr>
		</table>
	</form>
</div>
</div>
<div class="clearfix"></div> 
<?php include './../Inc/Footer.inc.php'; ?>