<?php
//-----------------------------------------------------------------
// Software: Automatic Web Software (AWS) built with PHPCPR
// Firm: DirectSalesMLM.com / AutomaticWebSoftware.com / PHPCPR.com
// Author: Jim Symonds Email: jim@directsalesmlm.com
// Copyright 2006 - 2024 Jim Symonds All Rights Reserved.
//-----------------------------------------------------------------
include './../../Sub/Config.inc.php';
include './../../phpcpr.php';
include './../Lib/TimeFormatting.function.php';
include './../Inc/Login.inc.php';
if ($loggedUser->checkPermisson('AUTORESPONDER') === false) {
	$errorMessage = 'You are not allowed to access this page.';
	require_once('./../Inc/error.php');
	exit();
}

//check if we have email passed
if (!isset($_GET['email']) || !ctype_digit((string)$_GET['email'])) {
	header('location: Ar_emails_list.php');
	exit;
}

$where = ['ar_master_email_id' => $_GET['email']];

delete('ar_master_email', [], $where, null, 1, 1, 1);
header('location: Ar_emails_list.php');
exit;


include './../Inc/Header.inc.php';

if ($buffer_autor['ar_master_email_timeout'] == 0) $timeout = '0 Days';
else $timeout = readable_time($buffer_autor['ar_master_email_timeout']);
?>

<div class="col-md-6 col-md-offset-3">
	<h2>Delete Email?</h2>
<div class="table-responsive">
<table class="col-md-6 table">	
	
		<tr>
			<td style="text-align:right"><strong>Subject:</strong></td>
			<td style="text-align:left"><?php echo $buffer_autor['ar_master_email_subject']; ?></td>
		</tr>
		<tr style="background-color:#eeeeee">
			<td style="text-align:right"><strong>Timeout:</strong></td>
			<td style="text-align:left"><?php echo $timeout; ?></td>
		</tr>
</table>
</div>	
	<form method="post" action="Ar_emails_delete.php?email=<?php echo $buffer_autor['ar_master_email_id']; ?>">
		<input type="submit" name="submit" value="Delete" class="btn btn-danger"/> 
		<input type="button" value="Cancel" onclick="window.location.href='Ar_emails_list.php'" class="btn btn-default"/>	
	</form>
</div>
<div class="clearfix"></div> 
<?php include './../Inc/Footer.inc.php'; ?>