<?php
//-----------------------------------------------------------------
// Software: Automatic Web Software (AWS) built with PHPCPR
// Firm: DirectSalesMLM.com / AutomaticWebSoftware.com / PHPCPR.com
// Author: Jim Symonds Email: jim@directsalesmlm.com
// Copyright 2006 - 2024 Jim Symonds All Rights Reserved.
//-----------------------------------------------------------------
include './../../Sub/Config.inc.php';
include './../../phpcpr.php';
include './../Lib/Pagination.function.php';
include './../Inc/Login.inc.php';
if ($loggedUser->checkPermisson('AUTORESPONDER') === false) {
	$errorMessage = 'You are not allowed to access this page.';
	require_once('./../Inc/error.php');
	exit;
}

//reset the search result if we are coming from the menu
if (isset($_GET['reset']) && $_GET['reset'] == 1) {
	unset($_SESSION['ar_leads_search']);
}

$lead_statuses = array(1=>'Enabled', 2=>'Blacklisted', 3=>'Unsubscribed', 4=>'Unconfirmed');
$month_select["01"] = "January";
$month_select["02"] = "February";
$month_select["03"] = "March";
$month_select["04"] = "April";
$month_select["05"] = "May";
$month_select["06"] = "June";
$month_select["07"] = "July";
$month_select["08"] = "August";
$month_select["09"] = "September";
$month_select["10"] = "October";
$month_select["11"] = "November";
$month_select["12"] = "December";

$error = '';

if (isset ($_GET['deleted']) && $_GET['deleted'] == 'yes') {
	$error = 'The lead was successfully deleted.';
}

if (!empty($_POST)) {

	unset($_SESSION['ar_leads_search']);

	//validate user input
	if (empty($_POST['find'])) {
		$error = 'Please input a search string';
		}
	elseif (empty($_POST['colname']) || $_POST['colname'] < 1 || $_POST['colname'] > 6) {
		$error = 'Please choose a column to search on';
		}
	elseif (empty($_POST['way']) || !in_array($_POST['way'], array(1, 2))) {
		$error = 'Please choose the comparison';
		}

	//if there are no errors save the search query
	if (empty($error)) {
		$_SESSION['ar_leads_search'] = $_POST;
	}
}

include './../Inc/Header.inc.php';
echo '<h1>Leads</h1>';

			
			if($_GET['ffield']=='ar_leads_firstname'){
				if($_GET['sort']=='DESC')
				$_GET[sort1]='ASC';
				else
				$_GET[sort1]='DESC';
			}  else $_GET[sort1]='ASC';
				if($_GET['ffield']=='ar_leads_lastname'){
				if($_GET['sort']=='DESC')
				$_GET[sort11]='ASC';
				else
				$_GET[sort11]='DESC';
			}  else $_GET[sort11]='ASC';
			if($_GET['ffield']=='ar_leads_email'){
				if($_GET['sort']=='DESC')
				$_GET[sort2]='ASC';
				else
				$_GET[sort2]='DESC';
			}  else $_GET[sort2]='ASC';
			if($_GET['ffield']=='ar_leads_phone'){
				if($_GET['sort']=='DESC')
				$_GET[sort3]='ASC';
				else
				$_GET[sort3]='DESC';
			}  else $_GET[sort3]='ASC';
			if($_GET['ffield']=='stdate'){
				if($_GET['sort']=='DESC')
				$_GET[sort4]='ASC';
				else
				$_GET[sort4]='DESC';
			}  else $_GET[sort4]='ASC';
			if($_GET['ffield']=='age'){
				if($_GET['sort']=='DESC')
				$_GET[sort5]='ASC';
				else
				$_GET[sort5]='DESC';
			} else $_GET[sort5]='ASC';
			if($_GET['ffield']=='rating'){
				if($_GET['sort']=='DESC')
				$_GET[sort6]='ASC';
				else
				$_GET[sort6]='DESC';
			} else $_GET[sort6]='ASC';
			if($_GET['ffield']=='campaign_name'){
				if($_GET['sort']=='DESC')
				$_GET[sort7]='ASC';
				else
				$_GET[sort7]='DESC';
			} else $_GET[sort7]='ASC';
			if($_GET['ffield']=='status'){
				if($_GET['sort']=='DESC')
				$_GET[sort8]='ASC';
				else
				$_GET[sort8]='DESC';
			} 
			else $_GET[sort8]='ASC';

?>

<?php if (!empty($error)) { ?>
<div style="text-align:center" class="error"><?php echo $error; ?></div>
<?php } ?>

<form method="POST" action="Ar_leads_list.php" target="_self" name="f">
<p />
<input type="text" name="find" value="<?php if (isset($_POST['find'])) echo $_POST['find'];?>" onMouseover="this.focus()">
<select name="way">
<option value="1" <?php if (isset($_POST['way']) && $_POST['way'] == '1') echo 'selected';?>>Contains</option>
<option value="2" <?php if (isset($_POST['way']) && $_POST['way'] == '2') echo 'selected';?>>Exact Match</option>
</select> in the
<select name="colname">
<option value="1" <?php if (isset($_POST['colname']) && $_POST['colname'] == 1) echo 'selected';?>>Member Username</option>
<option value="2" <?php if (isset($_POST['colname']) && $_POST['colname'] == 2) echo 'selected';?>>Member ID</option>
<option value="3" <?php if (isset($_POST['colname']) && $_POST['colname'] == 3) echo 'selected';?>>First Name</option>
<option value="4" <?php if (isset($_POST['colname']) && $_POST['colname'] == 4) echo 'selected';?>>Last Name</option>
<option value="5" <?php if (isset($_POST['colname']) && $_POST['colname'] == 5) echo 'selected';?>>Email</option>
<option value="6" <?php if (isset($_POST['colname']) && $_POST['colname'] == 6) echo 'selected';?>>Phone</option>
</select>
column. <input type="submit" value="SEARCH"> <a href="Ar_leads_list.php?reset=1">Clear Search</a></form>

<br />&nbsp;

<table width="845px" align="center" cellpadding="3" cellspacing="0" border=1 bordercolor="#CCCCCC">
<tr>
	<td align="center" width="px" style="font-weight: bold">Member</td>
	<td align="center" width="px" style="font-weight: bold">AR</td>
	<td align="center" width="px" style="font-weight: bold">AR Name</td>

	<td align="center" width="px" style="font-weight: bold"><a href="Ar_leads_list.php?reset=<?=$_GET[reset]?>&ffield=ar_leads_firstname&sort=<?=$_GET[sort1]?>">First Name</a></td>
	<td align="center" width="px" style="font-weight: bold"><a href="Ar_leads_list.php?reset=<?=$_GET[reset]?>&ffield=ar_leads_lastname&sort=<?=$_GET[sort11]?>">Last Name</a></td>
	<td align="center" width="px" style="font-weight: bold"><a href="Ar_leads_list.php?reset=<?=$_GET[reset]?>&ffield=ar_leads_email&sort=<?=$_GET[sort2]?>">Email</a></td>
	<td align="center" width="px" style="font-weight: bold"><a href="Ar_leads_list.php?reset=<?=$_GET[reset]?>&ffield=ar_leads_phone&sort=<?=$_GET[sort3]?>">Phone</a></td>
	<td align="center" width="px" style="font-weight: bold"><a href="Ar_leads_list.php?reset=<?=$_GET[reset]?>&ffield=stdate&sort=<?=$_GET[sort4]?>">Date</a></td>
		<td align="center" width="px" style="font-weight: bold"><a href="Ar_leads_list.php?reset=<?=$_GET[reset]?>&ffield=age&sort=<?=$_GET[sort5]?>">Age</a></td>
	<td align="center" width="px" style="font-weight: bold"><a href="Ar_leads_list.php?reset=<?=$_GET[reset]?>&ffield=rating&sort=<?=$_GET[sort6]?>">Rating</a></td>
	<td align="center" width="px" style="font-weight: bold"><a href="Ar_leads_list.php?reset=<?=$_GET[reset]?>&ffield=campaign_name&sort=<?=$_GET[sort7]?>">Campaign</a></td>
	<td align="center" width="px" style="font-weight: bold"><a href="Ar_leads_list.php?reset=<?=$_GET[reset]?>&ffield=status&sort=<?=$_GET[sort8]?>">Status</a></td>
	<td align="center" width="px" style="font-weight: bold">Actions</td>
</tr>

<?php

//create the where query if we have criteria
$where = ' WHERE 1 ';
if (!empty($_SESSION['ar_leads_search'])) {

	//determine the colname we search on
	switch ($_SESSION['ar_leads_search']['colname']) {
		case '1':
			$colname = 'm.Username';
			break;
		case '2':
			$colname = 'm.ID';
			break;
		case '3':
			$colname = 'al.ar_leads_firstname';
			break;
		case '4':
			$colname = 'al.ar_leads_lastname';
			break;
		case '5':
			$colname = 'al.ar_leads_email';
			break;
		case '6':
			$colname = 'al.ar_leads_phone';
			break;
		}

	//determine the search way
	if ($_SESSION['ar_leads_search']['way'] == 2 || $_SESSION['ar_leads_search']['colname'] == '2') {
		$where .= ' AND '.$colname."='".mysql_real_escape_string($_SESSION['ar_leads_search']['find'])."'";
	 }
	else {
		$where .= ' AND '.$colname." LIKE '".mysql_real_escape_string($_SESSION['ar_leads_search']['find'])."%'";
		}
	}

//get the count of the leads


if(!$_GET[ffield])$_GET[ffield]='ar_leads_id';
if(!$_GET[sort])$_GET[sort]='DESC';

if($_GET[ffield]=='status')$_GET[ffield]='al.status';
$orderby=" Order by $_GET[ffield] $_GET[sort]";


$query = "SELECT
						COUNT(ar_leads_id) AS cnt
					FROM
						ar_leads al
						INNER JOIN members m
							USING(ID)
					".$where;
// DEBUG XXX
//echo "<br>".$query."<br>";
$result = mysql_query($query) or die (mysql_error());
$buffer = mysql_fetch_assoc($result);

//paging params
$results_per_page = 25;
$total_pages = ceil($buffer['cnt']/$results_per_page);
$page = (isset($_GET['page']) && ctype_digit((string)$_GET['page']) ? $_GET['page']:1);
if ($page > $total_pages && $total_pages > 0) {
	$page = $total_pages;
	}
elseif ($page < 1) {
	$page = 1;
	}

//the styling of the results table
$nr = 1;
$color[0] = 'FFFFFF';
$color[1] = 'A3FFA3';

//get the leads
/*
$query = "SELECT
						al.*,(to_days(NOW())-to_days(al.stdate)) as age
						, m.*
					FROM
						ar_leads al
						INNER JOIN members m
							USING(ID)
					".$where." $orderby 
					LIMIT ".(($page-1)*$results_per_page).', '.$results_per_page;
*/
					
/*
$query="SELECT
								al.*,(to_days(NOW())-to_days(al.stdate)) as age
						, m.ID,m.Username,arm.ar_master_name,amm.ar_master_id
								, amm.ar_member_reset_type
								, alnk.ar_link_id
								, alnk.ar_link_sent
							FROM
								ar_master arm	
								INNER JOIN ar_member_master amm
									USING(ar_master_id)
								INNER JOIN ar_member_email ame
									USING(ar_member_master_id)
								INNER JOIN ar_link alnk
									USING(ar_member_email_id)
								INNER JOIN ar_leads al
									USING(ar_leads_id)
								INNER JOIN members m ON
									m.ID=al.ID 
									WHERE ".$where." $orderby 
					LIMIT ".(($page-1)*$results_per_page).', '.$results_per_page;	
*/		


// XXX GET THE LEADS // USING THIS SECTION - FEB 18 2013 - ISSUES - DOES NOT SHOW LEADS BY AR, SEARCH DOES NOT WORK - WE WANT TO FIX AND USE THIS CODE, AS IT ALLOWS SORTING BY HEADERS - AND WE NEED THAT!
/*
if ($_GET['ar']!=0 && $_GET['ar']!='') $where.=" AND arm.ar_master_id=".$_GET['ar']." AND al.AR='".$_GET['ar']."' ";

				
								$query="SELECT
								al.*,(to_days(NOW())-to_days(al.stdate)) as age
						, m.ID,m.Username,arm.ar_master_name,amm.ar_master_id
								, amm.ar_member_reset_type
								, alnk.ar_link_id
								, alnk.ar_link_sent
							FROM
								ar_master arm,ar_member_master amm, ar_member_email ame,ar_link alnk,ar_leads al,members m 
								
					WHERE
arm.ar_master_id=amm.ar_master_id and amm.ar_member_master_id=ame.ar_member_master_id and ame.ar_member_email_id=alnk.ar_member_email_id and alnk.ar_leads_id=al.ar_leads_id and al.ID=m.ID ".$where." $orderby 
					LIMIT ".(($page-1)*$results_per_page).', '.$results_per_page;
							
$result = mysql_query($query) or die(mysql_error());
while ($buffer = mysql_fetch_assoc($result)) {
 
*/


// XXX GET THE LEADS // ADDED FEB 18 2013 - THIS CODE WORKS TO SHOW LEADS IN THE CORRECT AR - BUT DOES NOT ALLOW SORTING BY COLLUMN HEADER AND SEARCH NOT WORKING

if ($_GET['ar']!=0 && $_GET['ar']!='') $where .= " AND al.AR='".$_GET['ar']."' ";
	

$query = "SELECT
						  al.*,(to_days(NOW())-to_days(al.stdate)) as age
						, m.ID
						, m.Username
						, ar_master_name
					FROM
						ar_leads AS al
						INNER JOIN members AS m
						JOIN ar_master AS arm
					".$where." AND al.ID=m.ID AND arm.ar_master_id=al.ar
					$orderby 
					LIMIT ".(($page-1)*$results_per_page).', '.$results_per_page;
// DEBUG XXX
//echo  "<br>" . $query . "<br>";
$result = mysql_query($query) or die(mysql_error());
while ($buffer = mysql_fetch_assoc($result)) {


/*
$query = "SELECT
								amm.ar_master_id
								, amm.ar_member_reset_type
								, alnk.ar_link_id
								, alnk.ar_link_sent
							FROM
								ar_member_master amm
								INNER JOIN ar_member_email ame
									USING(ar_member_master_id)
								INNER JOIN ar_link alnk
									USING(ar_member_email_id)
								INNER JOIN ar_leads al
									USING(ar_leads_id)
							WHERE
								al.ar_leads_id ='".$buffer[ar_leads_id]."'";
								
		$ARLEADS_INFO_1 = mysql_fetch_array(mysql_query($query)); 
		$ARLEADS_INFO = mysql_fetch_array(mysql_query("select * from ar_master where ar_master_id='".$ARLEADS_INFO_1['ar_master_id']."'"));
		
		if($ARLEADS_INFO_1['ar_master_id']!=$_GET['ar'] && $_GET['ar']) continue;

*/
		
if(eregi("-",$buffer[stdate]) && $buffer[stdate]!='0000-00-00'){
$datearr=split("-", $buffer[stdate]);
$buffer[stdate]=substr($month_select[$datearr[1]],0,3)." ".(int)$datearr[2]." ".$datearr[0];
		}else
		$buffer[stdate]='';
		
?>
<tr bgcolor="<?php echo (($nr % 2 == 0)?$color[0]:$color[1]); ?>">
	<td align="left"><a href="Finduser.php?username=<?php echo $buffer['Username']; ?>" target="_blank"><?php echo $buffer['Username']; ?></a></td>
	<td align="left"><?php echo $buffer['ar']; ?></td>
	<td align="left"><?php echo $buffer['ar_master_name']; ?></td>
	<td align="left"><?php echo $buffer['ar_leads_firstname']; ?></td>
	<td align="left"><?php echo $buffer['ar_leads_lastname']; ?></td>
	<td align="left"><a href="mailto:<?php echo $buffer['ar_leads_email']; ?>?subject=<?php echo $Global [webpage_name];?> Follow Up&body=Hi <?php echo $buffer['ar_leads_firstname']; ?>,"><?php echo $buffer['ar_leads_email']; ?></a></td>
	<td align="left"><?php echo $buffer['ar_leads_phone']; ?></td>
	<td align="left"><?php echo $buffer[stdate]; ?></td>
		<td align="left"><?php echo $buffer['age']; ?></td>
	<td align="left"><?php echo $buffer['rating']; ?></td>
		<td align="left"><?php echo stripslashes($buffer['campaign_name']); ?></td>
	<td align="left"><?php echo $lead_statuses[$buffer['ar_leads_status']]; ?></td>
	<td align="left">
	<!--
		<a href="Ar_leads_edit.php?lead=<?php echo $buffer['ar_leads_id']; ?>">Edit</a> |
		-->
		<a href="Ar_leads_delete.php?lead=<?php echo $buffer['ar_leads_id']; ?>">Delete</a>|
		<a href="Ar_leads_email.php?lead=<?php echo $buffer['ar_leads_id']; ?>">Email</a>
	</td>
</tr>
<?php
	++$nr;
	}
?>

<tr>
	<td colspan="8" align="right"><?php echo pagination_links($page, $total_pages, 6, 'Ar_leads_list.php?', array('page' => 'Page', 'first' => 'first', 'last' => 'last')); ?></td>
</tr>

</table>

<?php include './../Inc/Footer.inc.php'; ?>