<?php
//-----------------------------------------------------------------
// Software: Automatic Web Software (AWS) built with PHPCPR
// Firm: DirectSalesMLM.com / AutomaticWebSoftware.com / PHPCPR.com
// Author: Jim Symonds Email: jim@directsalesmlm.com
// Copyright 2006 - 2024 Jim Symonds All Rights Reserved.
//-----------------------------------------------------------------
include './../../Sub/Config.inc.php';
include './../../phpcpr.php';
include './../Inc/Login.inc.php';
set_time_limit(0); //Make sure it will not expire before its complete

$pageName = 'Extract Members';
$pageDesc = '';
$pageIcon = '';
$pageAlign = 'center';
$pageClass = '';

if ($loggedUser->checkPermisson('VIEW_PROGRAM') !== true){
  $errorMessage = 'You are not allowed to access this page.';
  require_once('./../Inc/error.php');
  exit();
}

$error = '';

if (!empty($_POST)) {
	
	//print_r($_POST); exit;
	
	if (empty($_POST['separator']) || empty($_POST['wrapper']) || empty($_POST['fetch'])) {
		//$error = 'Please fill in all fields';
		}
	elseif ($_POST['separator'] == $_POST['wrapper']) {
		$error = 'The separator and the wrapper values cannot be the same.';
		}
		$separator = $_POST['separator'];
		//$wrapper = str_replace(chr(92),"",$_POST['wrapper']);
		if ($_POST['separator'] == "tab") $separator = chr(15);
		if ($_POST['wrapper'] == "double quote") $wrapper = chr(34);
		if ($_POST['wrapper'] == "none") $wrapper = "";
		
		// THESE NEXT 2 FIELDS WIPED OUT BY PHPCPR AUTO SCRUBBING, SO SETTING THEM HERE INSTEAD!
		$separator = ",";
		$wrapper = '"';
		
		$esc = chr(92);
	
	if (empty($error)) {

		$member = array();
		$limit = '';	

		header("Cache-Control: must-revalidate, post-check=0, pre-check=0");
		header("Pragma: public");
		header("Content-Type: application/octet-stream");
		header("Content-Transfer-Encoding: binary");
		header("Accept-Ranges: bytes");
		header('Content-Disposition: attachment; filename="members_'.date('m-d-Y').'.csv"');
		header("Connection: close");

		//echo 'Lotto Numbers'.$separator.'Username'.$separator.'First Name'.$separator.'Last Name'.$separator.'Address'.$separator.'Address 2'.$separator.'City'.$separator.'State/Province'.$separator.'Zip'.$separator.'Country'

		echo 'Username'.$separator.'Sponsor Username'.$separator.'First Name'.$separator.'Last Name'.$separator.'Address'.$separator.'Address 2'.$separator.'City'.$separator.'State/Province'.$separator.'Zip'.$separator.'Country'		
		
		/*
		.$separator.'Shipping Address'.$separator.'Shipping Address 2'.$separator.'Shipping City'.$separator.'Shipping State/Province'.$separator.'Shipping Zip'.$separator.'Shipping Country'
		*/
		.$separator.'Phone'.$separator.'E-mail'.$separator.'Paid Date'.$separator.'Status'.$separator.'IP Address'."\r\n";

		if ($_POST['fetch'] != 'all' && $_POST['fetch'] != 'free' && $_POST['fetch'] != 'paid') {
			list ($program, $status) = explode('-', $_POST['fetch']);
		}
			//'memb.lotto_numbers',
		$selectFields = [
			'prog.expire', 'memb.ID', 'memb.Username', 'memb.sponsorid',
			'memb.First_Name', 'memb.ip', 'memb.Last_Name', 
			'link.address', 'link.address2', 'link.city', 'link.state', 
			'memb.province', 'link.zip', 'link.country', 
			'link.ship_address', 'link.ship_address2', 'link.ship_city', 
			'link.ship_state', 'link.ship_zip', 'link.ship_country', 
			'link.phone', 'memb.email', 'prog.started', 'prog.user_status', 'prog.program_id'
		];
		$mainTable = ['table' => 'members', 'as' => 'memb'];
		$joinConditions = [
			[
				'table' => 'member_link',
				'as' => 'link',
				'condition' => 'memb.ID = link.ID'
			],
			[
				'table' => 'user_program',
				'as' => 'prog',
				'condition' => 'memb.ID = prog.ID'
			]			
		];		
		$where = [
			'AND' => [
			'memb.Username' => ['!=', 'DELETED']
			]
			];
				
		if (isset($program)) {
			//$where['AND']['prog.program_id'] = ['=', $program];
		}	
		
		if (isset($status) && $status == 'F') {
			$where['AND']['prog.user_status'] = ['=', 'Unpaid'];
		}	
		if (isset($status) && $status == 'A') {
			$where['AND']['prog.user_status'] = ['=', 'Active'];			
		}	
		if (isset($status) && $status == 'C') {
			$where['AND']['prog.user_status'] = ['=', 'Comped'];
		}	
		if (isset($status) && $status == 'S') {
			$where['AND']['prog.user_status'] = ['=', 'Suspended'];
		}
		if (isset($status) && $status == 'CANC') {
			$where['AND']['prog.user_status'] = ['=', 'Cancelled'];
			$where['AND']['memb.Status'] = ['!=', 'Cancelled'];
		}	
		
		$groupBy = 'prog.ID';
		$limit = array($_POST['limit']);

		$result = select($selectFields, $mainTable, $joinConditions, $where, $groupBy, null, null, $limit, 1);		
		
		foreach ($result as $buffer) {

			if ($buffer['started'] === NULL || $buffer['started'] == '') {
				$join = '';
			} else {
				$join = date('Y-m-d', $buffer['started']);
			}	
			$status = $buffer['user_status'];

			if (isset($buffer['state']) && $buffer['state'] != 1) {
				$province = stripslashes($buffer['state']);
			} else {
				$province = stripslashes($buffer['province']);
			}
				
			if (isset($buffer['ship_state']) && $buffer['ship_state'] != 1) {
				$ship_province = stripslashes($buffer['ship_state']);
			} else {
				$ship_province = stripslashes($buffer['ship_province']);
			}
			
			$buffer['First_Name'] = stripslashes($buffer['First_Name']);
			$buffer['Last_Name'] = stripslashes($buffer['Last_Name']);
			$buffer['address'] = stripslashes($buffer['address']);
			$buffer['address2'] = stripslashes($buffer['address2']);
			$buffer['city'] = stripslashes($buffer['city']);
			$buffer['zip'] = stripslashes($buffer['zip']);
			$buffer['country'] = stripslashes($buffer['country']);
			$buffer['phone'] = stripslashes($buffer['phone']);
			$buffer['email'] = stripslashes($buffer['email']);
			$ip = '';
			$ip = $buffer['ip'];
			
			echo //(strpos($buffer['lotto_numbers'], $separator) === false ? $buffer['lotto_numbers'].$separator:$wrapper.str_replace($wrapper, $esc.$wrapper, $buffer['lotto_numbers']).$wrapper.$separator).
			 (strpos($buffer['Username'], $separator) === false ? $buffer['Username'].$separator:$wrapper.str_replace($wrapper, $esc.$wrapper, $buffer['Username']).$wrapper.$separator)
			. (strpos($buffer['sponsorid'], $separator) === false ? $buffer['sponsorid'].$separator:$wrapper.str_replace($wrapper, $esc.$wrapper, $buffer['sponsorid']).$wrapper.$separator)			 
			. (strpos($buffer['First_Name'], $separator) === false ? $buffer['First_Name'].$separator:$wrapper.str_replace($wrapper, $esc.$wrapper, $buffer['First_Name']).$wrapper.$separator)
			. (strpos($buffer['Last_Name'], $separator) === false ? $buffer['Last_Name'].$separator:$wrapper.str_replace($wrapper, $esc.$wrapper, $buffer['Last_Name']).$wrapper.$separator)
			. (strpos($buffer['address'], $separator) === false ? $buffer['address'].$separator:$wrapper.str_replace($wrapper, $esc.$wrapper, $buffer['address']).$wrapper.$separator)
			. (strpos($buffer['address2'], $separator) === false ? $buffer['address2'].$separator:$wrapper.str_replace($wrapper, $esc.$wrapper, $buffer['address2']).$wrapper.$separator)
			. (strpos($buffer['city'], $separator) === false ? $buffer['city'].$separator:$wrapper.str_replace($wrapper, $esc.$wrapper, $buffer['city']).$wrapper.$separator)
			. (strpos($province, $separator) === false ? $province.$separator:$wrapper.str_replace($wrapper, $esc.$wrapper, $province).$wrapper.$separator)
			. (strpos($buffer['zip'], $separator) === false ? $buffer['zip'].$separator:$wrapper.str_replace($wrapper, $esc.$wrapper, $buffer['zip']).$wrapper.$separator)
			. (strpos($buffer['country'], $separator) === false ? $buffer['country'].$separator:$wrapper.str_replace($wrapper, $esc.$wrapper, $buffer['country']).$wrapper.$separator)
			
			/*
			. (strpos($buffer['ship_address'], $separator) === false ? $buffer['ship_address'].$separator:$wrapper.str_replace($wrapper, $esc.$wrapper, $buffer['ship_address']).$wrapper.$separator)
			. (strpos($buffer['ship_address2'], $separator) === false ? $buffer['ship_address2'].$separator:$wrapper.str_replace($wrapper, $esc.$wrapper, $buffer['ship_address2']).$wrapper.$separator)
			. (strpos($buffer['ship_city'], $separator) === false ? $buffer['city'].$separator:$wrapper.str_replace($wrapper, $esc.$wrapper, $buffer['ship_city']).$wrapper.$separator)
			. (strpos($ship_province, $separator) === false ? $ship_province.$separator:$wrapper.str_replace($wrapper, $esc.$wrapper, $ship_province).$wrapper.$separator)
			. (strpos($buffer['ship_zip'], $separator) === false ? $buffer['zip'].$separator:$wrapper.str_replace($wrapper, $esc.$wrapper, $buffer['ship_zip']).$wrapper.$separator)
			. (strpos($buffer['ship_country'], $separator) === false ? $buffer['country'].$separator:$wrapper.str_replace($wrapper, $esc.$wrapper, $buffer['ship_country']).$wrapper.$separator)
			*/
			
			. (strpos($buffer['phone'], $separator) === false ? $buffer['phone'].$separator:$wrapper.str_replace($wrapper, $esc.$wrapper, $buffer['phone']).$wrapper.$separator)
			. (strpos($buffer['email'], $separator) === false ? $buffer['email'].$separator:$wrapper.str_replace($wrapper, $esc.$wrapper, $buffer['email']).$wrapper.$separator)
			. (strpos($join, $separator) === false ? $join.$separator:$wrapper.str_replace($wrapper, $esc.$wrapper, $join).$wrapper.$separator)
			. (strpos($status, $separator) === false ? $status.$separator:$wrapper.str_replace($wrapper, $esc.$wrapper, $status).$wrapper.$separator)			
			. (strpos($ip, $separator) === false ? $ip:$wrapper.str_replace($wrapper, $esc.$wrapper, $ip).$wrapper)."\r\n";

			$member[$buffer['ID']] = true;
			unset($join, $status, $province, $buffer);
			} // END FOREACH
		exit();
		} // END NO ERROR - END EXPORT
	} // END POST


include './../Inc/Header.inc.php';

echo '<div style="text-align: center;"><center><h1>Extract Members</h1><br>';

//if we have an error display it
if (!empty($error)) {
	echo '<div style="color:red;">'.$error.'</div>';
}

echo '
<form action="Fetchmembers.php" method="POST">
<table class="form-group">
	<!--<tr>
		<td>Separator:</td>
		<td><select name="separator" class="form-control">
			<option value=",">,</option>
			<option value=";">;</option>
			<option value="tab">tab</option>
			</select>
		</td>
	</tr>
	<tr>
		<td>Wrapper:</td>
		<td><select name="wrapper" class="form-control">
			<option selected=selected value="double quote">"</option>
			<option value="none">None</option>
			</select>
		</td>
	</tr>-->
	<tr>
		<td>Find Members:</td>
		<td>
<select name="fetch" class="form-control">
<option value="all"'.((!empty($_POST['fetch']) && $_POST['fetch'] =='all')?' selected="selected"':'').'>All Members</option>
<option value="">-</option>';

$selectFields = ['program_id', 'program_name'];
$mainTable = 'program';
$where = ['program_approved' => ['=', 'Y']];

$result = select($selectFields, $mainTable, [], $where, null, null, null, 0, 1);

if (!isset($_POST['fetch'])) {
    $active_selected = ' selected="selected"';
} else {
    $active_selected = '';
}

foreach ($result as $buffer) { 

	if (!empty($_POST['fetch']) && $_POST['fetch'] == $buffer['program_id'].'-F') $free_selected = ' selected="selected"';
	else $free_selected = '';	

	if (!empty($_POST['fetch']) && $_POST['fetch'] == $buffer['program_id'].'-AC') $ac_selected = ' selected="selected"';
	else $ac_selected = '';
	
	if (!empty($_POST['fetch']) && $_POST['fetch'] == $buffer['program_id'].'-A') $active_selected = ' selected="selected"';
	//else $active_selected = '';

	if (!empty($_POST['fetch']) && $_POST['fetch'] == $buffer['program_id'].'-C') $comped_selected = ' selected="selected"';
	else $comped_selected = '';
	
	if (!empty($_POST['fetch']) && $_POST['fetch'] == $buffer['program_id'].'-S') $suspended_selected = ' selected="selected"';
	else $suspended_selected = '';

	if (!empty($_POST['fetch']) && $_POST['fetch'] == $buffer['program_id'].'-S') $cancelled_selected = ' selected="selected"';
	else $cancelled_selected = '';
	
	echo '
	<option value="'.$buffer['program_id'].'-F" '.$free_selected.'>Free - '.$buffer['program_name'].'</option>
	<option value="'.$buffer['program_id'].'-A" '.$active_selected.'>Active - '.$buffer['program_name'].'</option>
	<option value="'.$buffer['program_id'].'-C" '.$comped_selected.'>Comped - '.$buffer['program_name'].'</option>
	<option value="'.$buffer['program_id'].'-S" '.$suspended_selected.'>Suspended - '.$buffer['program_name'].'</option>
	<option value="'.$buffer['program_id'].'-CANC" '.$cancelled_selected.'>Cancelled - '.$buffer['program_name'].'</option>	
	<option value="">-</option>';
	}

echo '</select>';
?>
		</td>
	</tr>
</table>
Choose member rows
<br/>
<input type="radio" name="limit" value="1, 50000" <?php if ($_POST['limit'] == '1, 50000' || !isset($_POST['limit'])) echo 'checked'; ?>> 
1 - 50k

<input type="radio" name="limit" value="50001, 100000" <?php if ($_POST['limit'] == '50001, 100000') echo 'checked'; ?>> 
50k - 100k

<input type="radio" name="limit" value="100001, 150000" <?php if ($_POST['limit'] == '100001, 150000') echo 'checked'; ?>> 
100k - 150k

<input type="radio" name="limit" value="150001, 200000" <?php if ($_POST['limit'] == '150001, 020000') echo 'checked'; ?>> 
150k - 200k

<input type="radio" name="limit" value="200001, 250000" <?php if ($_POST['limit'] == '200001, 250000') echo 'checked'; ?>> 
200k - 250k

<input type="radio" name="limit" value="250001, 300000" <?php if ($_POST['limit'] == '250001, 300000') echo 'checked'; ?>> 
250k - 300k

<input type="radio" name="limit" value="300001, 350000" <?php if ($_POST['limit'] == '300001, 350000') echo 'checked'; ?>> 
300k - 350k

<input type="radio" name="limit" value="350001, 400000" <?php if ($_POST['limit'] == '350001, 400000') echo 'checked'; ?>> 
350k - 400k

<input type="radio" name="limit" value="400001, 450000" <?php if ($_POST['limit'] == '400001, 450000') echo 'checked'; ?>> 
400k - 450k<br />

<input type="radio" name="limit" value="450001, 500000" <?php if ($_POST['limit'] == '450001, 500000') echo 'checked'; ?>> 
450k - 500k<br />

<br/>


<input type="submit" name="submit" value="Download CSV File" class="btn btn-lg btn-primary"/>
</form>
<br/>
<strong>Program specific choices:</strong>
<p><blockquote>
<strong>Free:</strong> Members who have not joined this program yet.<br />
<!--<strong>Active & Comped:</strong> Members who have joined this program.<br />-->
<strong>Active:</strong> Members who paid to join this program.<br />
<strong>Comped:</strong> Members who got comped into this program.<br />
<strong>Suspended:</strong> Members who are suspended in this program.<br />
<strong>Cancelled:</strong> Members who are cancelled in this program.</blockquote><p />

<?php	
include './../Inc/Footer.inc.php';
?>