<?php
//-----------------------------------------------------------------
// Software: Automatic Web Software (AWS) built with PHPCPR
// Firm: DirectSalesMLM.com / AutomaticWebSoftware.com / PHPCPR.com
// Author: Jim Symonds Email: jim@directsalesmlm.com
// Copyright 2006 - 2024 Jim Symonds All Rights Reserved.
//-----------------------------------------------------------------
include './../../Sub/Config.inc.php';
include './../../phpcpr.php';
include './../Inc/Login.inc.php';
if ($loggedUser->checkPermisson('PAYMENT') === false){
    $errorMessage = 'You are not allowed to access this page.';
    require_once('./../Inc/error.php');
    exit();   
}

$pageName = 'General Program Statistics';
$pageDesc = '';
$pageIcon = '';
$pageAlign = 'center';
$pageClass = '';

include './../Inc/Header.inc.php';
echo '<h1>General Program Statistics</h1>';
//error_reporting(-1);

$selectFields = 'count(u.user_program_id) as qty, u.program_id, p.program_name, u.user_status';
$mainTable = ['table' => 'user_program', 'as' => 'u'];
$joinConditions = [['table' => 'program', 
					'as' => 'p', 
					'condition' => 'u.program_id = p.program_id']];
$groupBy = 'u.program_id, u.user_status';
$orderBy = 'u.program_id, u.user_status';
$result = select($selectFields, $mainTable, $joinConditions, ['1'], $groupBy, null, $orderBy, 0, 1);


$status_arr = array();
foreach ($result as $buffer) {

    $program_id = $buffer['program_id'];
    $program_name = $buffer['program_name'];
    $user_status = $buffer['user_status'];
    $cnt = $buffer['qty'];
    $status_arr[$program_id][$user_status] = $cnt; 
    $program_name_arr[$program_id]=$program_name;
	
}

foreach ($program_name_arr as $prog_num => $prog_name) {
	if (!isset($status_arr[$prog_num]['Active'])) $status_arr[$prog_num]['Active'] = 0;
	if (!isset($status_arr[$prog_num]['Comped'])) $status_arr[$prog_num]['Comped'] = 0;
	if (!isset($status_arr[$prog_num]['Suspended'])) $status_arr[$prog_num]['Suspended'] = 0;
	if (!isset($status_arr[$prog_num]['Cancelled'])) $status_arr[$prog_num]['Cancelled'] = 0;
	if (!isset($status_arr[$prog_num]['Unpaid'])) $status_arr[$prog_num]['Unpaid'] = 0;
}

echo '<div style="width: 40%; margin: auto; text-align: center;">';
echo "<table cellpadding='20'><tr><td>Program</td><td>Program Name</td><td>Active</td><td>Comped</td><td>Suspended</td><td>Cancelled</td><td>Unpaid</td></tr>";

foreach ($program_name_arr as $prog_num => $prog_name) {
	echo "<tr>
<td>{$prog_num}</td>
<td>{$prog_name}</td>
<td><a href='Finduser.php?status=Active&prog={$prog_num}' target='_blank'>{$status_arr[$prog_num]['Active']}</a></td>
<td><a href='Finduser.php?status=Comped&prog={$prog_num}' target='_blank'>{$status_arr[$prog_num]['Comped']}</a></td>
<td><a href='Finduser.php?status=Suspended&prog={$prog_num}' target='_blank'>{$status_arr[$prog_num]['Suspended']}</a></td>
<td><a href='Finduser.php?status=Cancelled&prog={$prog_num}' target='_blank'>{$status_arr[$prog_num]['Cancelled']}</a></td>
<td><a href='Finduser.php?status=Unpaid&prog={$prog_num}' target='_blank'>{$status_arr[$prog_num]['Unpaid']}</a></td></tr>";
}

echo '</table></div><p>&nbsp;</p>';

// **********

echo '<h1>Net Change In Last 7 Days</h1>';
//error_reporting(-1);
$seven_days_ago_date = date("Y-m-d",strtotime("-7 days"));
$seven_days_ago_datetime = $seven_days_ago_date . " 00:00:00";
$seven_days_ago_timestamp = strtotime($seven_days_ago_datetime);

echo '<div style="width: 50%; margin: auto; text-align: center;">';
echo "<table cellpadding='20'><tr><td>Program</td><td>Program Name</td><td>Added Since {$seven_days_ago_date}</td><td>Cancelled Since {$seven_days_ago_date}</td><td>Net Change</td></tr>";

foreach ($program_name_arr as $prog_num => $prog_name) {

	$selectFieldsAdded = 'user_program_id as added';
	$mainTableAdded = 'user_program';
	$whereAdded = [
		'program_id' => ['=', $prog_num],
		'started' => ['>=', $seven_days_ago_timestamp]
	];
	$addedResult = select($selectFieldsAdded, $mainTableAdded, [], $whereAdded, null, null, null, 0, 1);
	$num_added = count($addedResult);
		
	$selectFieldsCancelled = 'user_program_id as cancelled';
	$mainTableCancelled = 'user_program';
	$whereCancelled = [
		'program_id' => ['=', $prog_num],
		'date_cancelled' => ['>=', $seven_days_ago_datetime],
		'user_status' => ['=', 'Cancelled']
	];
	$cancelledResult = select($selectFieldsCancelled, $mainTableCancelled, [], $whereCancelled, null, null, null, 0, 1);
	
	$num_cancelled = isset($cancelledResult) && is_array($cancelledResult) ? count($cancelledResult) : 0;

	$num_net = $num_added - $num_cancelled;

	$active = isset($status_arr[$prog_num]['Active']) && is_numeric($status_arr[$prog_num]['Active']) ? $status_arr[$prog_num]['Active'] : 0;
	$comped = isset($status_arr[$prog_num]['Comped']) && is_numeric($status_arr[$prog_num]['Comped']) ? $status_arr[$prog_num]['Comped'] : 0;
	$suspended = isset($status_arr[$prog_num]['Suspended']) && is_numeric($status_arr[$prog_num]['Suspended']) ? $status_arr[$prog_num]['Suspended'] : 0;

	// Prevent division by zero by checking the denominator first.
	$denominator = $active + $comped + $suspended - $num_net;
	$num_net_percent = $denominator != 0 ? number_format(100 * $num_net / $denominator, 2) : '0.00';
	
	
	echo '<tr>
	<td style="text-align: center;">' . $prog_num . '</td>
	<td>' . $prog_name . '</td>
	<td style="text-align: right;">' . $num_added . '</td>
	<td style="text-align: right;">' . $num_cancelled . '</td>
	<td style="text-align: right;">' . $num_net . ' (' . $num_net_percent . ' %)</td>
	</tr>';
}

echo '</table></div><p>&nbsp;</p>';

// **********
$days_ago = 30;
echo '<h1>Net Change In Last '.$days_ago.' Days</h1>';
//error_reporting(-1);
$thirty_days_ago_date = date("Y-m-d",strtotime("-".$days_ago." days"));
$thirty_days_ago_datetime = $thirty_days_ago_date . " 00:00:00";
$thirty_days_ago_timestamp = strtotime($thirty_days_ago_datetime);

echo '<div style="width: 50%; margin: auto; text-align: center;">';
echo "<table cellpadding='20'><tr><td>Program</td><td>Program Name</td><td>Added Since {$thirty_days_ago_date}</td><td>Cancelled Since {$thirty_days_ago_date}</td><td>Net Change</td></tr>";

foreach ($program_name_arr as $prog_num => $prog_name) {
	$selectFieldsAdded = 'user_program_id as added';
	$mainTableAdded = 'user_program';
	$whereAdded = [
		'program_id' => ['=', $prog_num],
		'started' => ['>=', $thirty_days_ago_timestamp]
	];
	$addedResult = select($selectFieldsAdded, $mainTableAdded, [], $whereAdded, null, null, null, 0, 1);
	$num_added = count($addedResult);
		
	$selectFieldsCancelled = 'user_program_id as cancelled';
	$mainTableCancelled = 'user_program';
	$whereCancelled = [
		'program_id' => ['=', $prog_num],
		'date_cancelled' => ['>=', $thirty_days_ago_datetime],
		'user_status' => ['=', 'Cancelled']
	];
	$cancelledResult = select($selectFieldsCancelled, $mainTableCancelled, [], $whereCancelled, null, null, null, 0, 1);

	$num_cancelled = isset($cancelledResult) && is_array($cancelledResult) ? count($cancelledResult) : 0;

	$num_net = $num_added - $num_cancelled;

	$active = isset($status_arr[$prog_num]['Active']) && is_numeric($status_arr[$prog_num]['Active']) ? $status_arr[$prog_num]['Active'] : 0;
	$comped = isset($status_arr[$prog_num]['Comped']) && is_numeric($status_arr[$prog_num]['Comped']) ? $status_arr[$prog_num]['Comped'] : 0;
	$suspended = isset($status_arr[$prog_num]['Suspended']) && is_numeric($status_arr[$prog_num]['Suspended']) ? $status_arr[$prog_num]['Suspended'] : 0;

	// Prevent division by zero by checking the denominator first.
	$denominator = $active + $comped + $suspended - $num_net;
	$num_net_percent = $denominator != 0 ? number_format(100 * $num_net / $denominator, 2) : '0.00';
	
	echo '<tr>
	<td style="text-align: center;">' . $prog_num . '</td>
	<td>' . $prog_name . '</td>
	<td style="text-align: right;">' . $num_added . '</td>
	<td style="text-align: right;">' . $num_cancelled . '</td>
	<td style="text-align: right;">' . $num_net . ' (' . $num_net_percent . ' %)</td>
	</tr>';
}

echo '</table></div><p>&nbsp;</p>';

include './../Inc/Footer.inc.php';
?>