<?php
//-----------------------------------------------------------------
// Software: Automatic Web Software (AWS) built with PHPCPR
// Firm: DirectSalesMLM.com / AutomaticWebSoftware.com / PHPCPR.com
// Author: Jim Symonds Email: jim@directsalesmlm.com
// Copyright 2006 - 2024 Jim Symonds All Rights Reserved.
//-----------------------------------------------------------------
include './../../Sub/Config.inc.php';
include './../../phpcpr.php';
include './../Inc/Login.inc.php';
if ($loggedUser->checkPermisson('ADD_PROGRAM') === false){
  $errorMessage = 'You are not allowed to access this page.';
  require_once('./../Inc/error.php');
  exit();   
}
// THIS REPORT TALLIES RECORDS FROM latest_stats WHERE type='1day' 

//error_reporting(-1);
//$_SESSION['debug'] = true;

// COMMENT WHEN TESTING IS DONE!!!
//$_SESSION['dev'] = '';
 /*
if ($_GET['dev'] == '' && $_SESSION['dev'] == '' && $_SESSION['loggedin'] != 'testwalkthru') { // LOCKING PAGE FOR DEVELOPER USE ONLY!!
//include_once './header.php';
echo 'We\'re sorry. This area is temporarily down for maintenance. Please check back soon!';
//include_once './footer.php';
exit;
} else {
$_SESSION['dev'] = true;
}
 */
$datetimenow = date("Y-m-d H:i:s");
	
$pageName = 'Stats By Month';
$pageDesc = '';
$pageIcon = '';
$pageAlign = 'center';
$pageClass = '';

include './../Inc/Header.inc.php';

$this_year = date("Y");

$month = date('m');
//echo $month;
if ($_GET['month'] == '') $_GET['month'] = $month;

if ($_GET['month'] == '01') {
	$monthname = 'January';
	$nextmonth = '02';
} else if ($_GET['month'] == '02') {
	$monthname = 'February';
	$nextmonth = '03';
} else if ($_GET['month'] == '03') {
	$monthname = 'March';
	$nextmonth = '04';
} else if ($_GET['month'] == '04') {
	$monthname = 'April';
	$nextmonth = '05';
} else if ($_GET['month'] == '05') {
	$monthname = 'May';
	$nextmonth = '06';
} else if ($_GET['month'] == '06') {
	$monthname = 'June';
	$nextmonth = '07';
} else if ($_GET['month'] == '07') {
	$monthname = 'July';
	$nextmonth = '08';
} else if ($_GET['month'] == '08') {
	$monthname = 'August';
	$nextmonth = '09';
} else if ($_GET['month'] == '09') {
	$monthname = 'September';
	$nextmonth = '10';
} else if ($_GET['month'] == '10') {
	$monthname = 'October';
	$nextmonth = '11';
} else if ($_GET['month'] == '11') {
	$monthname = 'November';
	$nextmonth = '12';
} else if ($_GET['month'] == '12') {
	$monthname = 'December';
	$nextmonth = '01';
}	

$nextmonth = $this_year.'-'.$nextmonth.'-01';

if ($_GET['month'] == '12') {
	$next_year = $this_year + 1;
	$nextmonth = $nextmonth.'-01';
	//echo $nextmonth;
$nextYear = date('Y-m-d', strtotime('first day of january next year'));
//echo $nextYear;
$nextmonth = $nextYear;
}	

$thismonth = $this_year.'-'.$_GET['month'].'-01';

$timestamp = strtotime($thismonth); // MUST CONVERT STRING TO INT FIRST!
$displaydate = date('M j, Y', $timestamp); // Now using the timestamp
?>
<h2>Monthly Report For <?php echo $monthname; ?></h2>
<a href="Stats_by_month.php?month=01">Jan</a> | 
<a href="Stats_by_month.php?month=02">Feb</a> | 
<a href="Stats_by_month.php?month=03">Mar</a> | 
<a href="Stats_by_month.php?month=04">Apr</a> | 
<a href="Stats_by_month.php?month=05">May</a> | 
<a href="Stats_by_month.php?month=06">Jun</a> | 
<a href="Stats_by_month.php?month=07">Jul</a> | 
<a href="Stats_by_month.php?month=08">Aug</a> | 
<a href="Stats_by_month.php?month=09">Sep</a> | 
<a href="Stats_by_month.php?month=10">Oct</a> | 
<a href="Stats_by_month.php?month=11">Nov</a> | 
<a href="Stats_by_month.php?month=12">Dec</a>
<hr>
<?php
$selectFields = 'SUM(comm_earned_all) AS tot';
$mainTable = 'latest_stats';
$where = [
	'type' => ['=', '1day'], 
	'startdate' => ['>=', "{$thismonth}"],
	'enddate' => ['<', "{$nextmonth}"]
];
$orderBy = 'startdate ASC';
$limit = 0;

$result = select($selectFields, $mainTable, [], $where, null, null, $orderBy, $limit, 1);
$comm_earned_all = '$'.number_format($result[0]['tot']);
echo '<h3>Total Comms Earned: '.$comm_earned_all.'</h3>';

$selectFields = 'SUM(admin_earned) AS tot';
$result = select($selectFields, $mainTable, [], $where, null, null, $orderBy, $limit, 1);
$admin_earned_all = '$'.number_format($result[0]['tot']);
echo '<h3>Total Admin Earned: '.$admin_earned_all.'</h3>';

$selectFields = 'SUM(members_joined) AS tot';
$result = select($selectFields, $mainTable, [], $where, null, null, $orderBy, $limit, 1);
$members_joined = number_format($result[0]['tot']);
echo '<h3>Total Members Joined: '.$members_joined.'</h3>';

$selectFields = '*';
$orderBy = 'startdate DESC'; // ALWAYS LOOKING TO GET THE LAST END DATE IN THIS QUERY, FOR MOST UP TO DATE STATS RECORD!
$result = select($selectFields, $mainTable, [], $where, null, null, $orderBy, $limit, 1);


foreach ($result as $buffer) {
	//print_r($buffer);

	$comm_earned_all = '$'.number_format($buffer['comm_earned_all']);
	$comm_earned_cc = '$'.number_format($buffer['comm_earned_cc']);
	$comm_earned_other = '$'.number_format($buffer['comm_earned_other']);
	$comm_earned_man = '$'.number_format($buffer['comm_earned_man']);
	$admin_earned = '$'.number_format($buffer['admin_earned']);
	$members_joined = number_format($buffer['members_joined']);
	
	$total_sales = $buffer['comm_earned_all'] + $buffer['admin_earned'];
	$total_sales = '$'.number_format($total_sales);
	
	$startdate = substr($buffer['startdate'],0,-9); // WORKS TO GET JUST THE DATE!
	$enddate = substr($buffer['enddate'],0,-9); // WORKS TO GET JUST THE DATE!
	

	//Convert it into a Unix timestamp using strtotime.
	$startdate = strtotime($buffer['startdate']);
	// CONVERT TIMESTAMP TO THIS STYLE May 21, 2020 
	$startdate = date('M j, Y', $startdate);
 
	$enddate = strtotime($buffer['enddate']);
	$enddate = date('M j, Y', $enddate);	


	/*echo '<br>';
	echo $startdate.' - '.$enddate;
	echo ' Total comms earned: '.$comm_earned_all;
	echo '<br>CC comms earned: '.$comm_earned_cc;
	echo '<br>Other comms earned: '.$comm_earned_other;
	echo '<br>Manual marked paid comms earned: '.$comm_earned_man;
	echo '<br>Total members joined: '.$members_joined;*/

?>
<div class="table-responsive">
 <table class="table">
  <tr class="row" style="background-color:#eee">
  <td class="col-md-1">&nbsp;</td>
    <td class="col-md-2"><b><?php //echo $_GET['range'];?> Day Range</b></td>
    <td class="col-md-2"><b>Total Sales</b></td>	
    <td class="col-md-2"><b>Total Admin Earned</b></td>
    <td class="col-md-2"><b>Total Comms Earned</b></td>	
    <td class="col-md-2"><b>Total Members Joined</b></td>	
	<td class="col-md-1">&nbsp;</td>
  </tr>
  
  <tr class="row">
  <td class="col-md-1">&nbsp;</td>
    <td class="col-md-2"><?php echo $startdate;?></td>
	<td class="col-md-2"><?php echo $total_sales;?></td>
    <td class="col-md-2"><?php echo $admin_earned;?></td>
    <td class="col-md-2"><?php echo $comm_earned_all;?></td>	
    <td class="col-md-2"><?php echo $members_joined;?></td>	
	<td class="col-md-1">&nbsp;</td>
  </tr>  
  
 </table>
</div>

<?php } ?>



*Total Comms Earned are the total amount of member commissions earned. This does not include admin earnings. All numbers are gross amounts.
<br/>**This report is created from the Daily Stats data. Today's stats will be calculated and stored tomorrow, when the "Stats1day.cron" runs.


<?php
include './../Inc/Footer.inc.php';
?>
