<?php
//-----------------------------------------------------------------
// Software: Automatic Web Software (AWS) built with PHPCPR
// Firm: DirectSalesMLM.com / AutomaticWebSoftware.com / PHPCPR.com
// Author: Jim Symonds Email: jim@directsalesmlm.com
// Copyright 2006 - 2024 Jim Symonds All Rights Reserved.
//-----------------------------------------------------------------
include './../../Sub/Config.inc.php';
include './../../phpcpr.php';
// IF PAGE ERRORS (FOOTER DOES NOT SHOW) MAKE SURE Pagination.function.php IS IN WWW FOLDER!
include './../Inc/Login.inc.php';
include $Global['path'].'Pagination.function.php';
if ($loggedUser->checkPermisson('ADD_PROGRAM') === false){
  $errorMessage = 'You are not allowed to access this page.';
  require_once('./../Inc/error.php');
  exit();   
}
//echo date_default_timezone_get();
//exit;

//error_reporting(-1);
//$_SESSION['debug'] = true;

// COMMENT WHEN TESTING IS DONE!!!
//$_SESSION['dev'] = '';
 /*
if ($_GET['dev'] == '' && $_SESSION['dev'] == '' && $_SESSION['loggedin'] != 'testwalkthru') { // LOCKING PAGE FOR DEVELOPER USE ONLY!!
//include_once './header.php';
echo 'We\'re sorry. This area is temporarily down for maintenance. Please check back soon!';
//include_once './footer.php';
exit;
} else {
$_SESSION['dev'] = true;
}
 */
$datetimenow = date("Y-m-d H:i:s");


if ($_GET['range'] != '') $daterange = $_GET['range'];
else $daterange = 30;
if ($daterange == 1) {	
	$pageName = 'Daily Stats';
} else { 
	$pageName = '30 Day Period Reports';
}
//ALTER TABLE `latest_stats` ADD `type` VARCHAR(10) NOT NULL AFTER `members_joined` 
//VALUES ARE '1day' or '30day';

$pageDesc = '';
$pageIcon = '';
$pageAlign = 'center';
$pageClass = '';
include './../Inc/Header.inc.php';
echo '<h2>'.$pageName.'</h2>';
?>

<br/><br/>
<?php
$selectFields = '*';
$mainTable = 'latest_stats';
$where = ['type' => ['=', $daterange.'day']];
$orderBy = 'enddate DESC, idx DESC'; // ALWAYS LOOKING TO GET THE LAST END DATE IN THIS QUERY, FOR MOST UP TO DATE STATS RECORD!
$limit = 0;

$result = select($selectFields, $mainTable, [], $where, null, null, $orderBy, $limit, 1);
$rows = count($result); 


//PAGINATION PARAMS
$results_per_page = 25;
$total_pages = ceil($rows/$results_per_page);
$page = (isset($_GET['page']) && ctype_digit((string)$_GET['page']) ? $_GET['page']:1);
if ($page > $total_pages && $total_pages > 0) {
	$page = $total_pages;
} elseif ($page < 1) {
	$page = 1;
}

// NOW WE JUST CHANGE THE LIMIT, RUN SAME QRY AGAIN
$offset = ($page - 1) * $results_per_page;
	$limit = [
		'offset' => $offset,	
		'count' => $results_per_page
	];

$result = select($selectFields, $mainTable, [], $where, null, null, $orderBy, $limit, 1);

 foreach ($result as $buffer) {
	 
	//print_r($buffer);
	$comm_earned_all = '$'.number_format(isset($buffer['comm_earned_all']) ? $buffer['comm_earned_all'] : 0);
	$comm_earned_cc = '$'.number_format(isset($buffer['comm_earned_cc']) ? $buffer['comm_earned_cc'] : 0);
	$comm_earned_other = '$'.number_format(isset($buffer['comm_earned_other']) ? $buffer['comm_earned_other'] : 0);
	$comm_earned_man = '$'.number_format(isset($buffer['comm_earned_man']) ? $buffer['comm_earned_man'] : 0);
	$admin_earned = '$'.number_format(isset($buffer['admin_earned']) ? $buffer['admin_earned'] : 0);
	$members_joined = number_format(isset($buffer['members_joined']) ? $buffer['members_joined'] : 0);
	
	
	$total_sales = (isset($buffer['comm_earned_all']) ? $buffer['comm_earned_all'] : 0) + (isset($buffer['admin_earned']) ? $buffer['admin_earned'] : 0);
	$total_sales = '$'.number_format($total_sales);
	
	$startdate = substr($buffer['startdate'],0,-9); // WORKS TO GET JUST THE DATE!
	$enddate = substr($buffer['enddate'],0,-9); // WORKS TO GET JUST THE DATE!
	
	// WE'RE SEARCHING FOR ONE DAY STATS, BUT THESE RESULTS ARE NOT ONE DAY STATS, SO WE SKIP THEM
	if ($daterange == 1 && $startdate != $enddate) {
		continue;
	} 

	// WE'RE NOT SEARCHING FOR ONE DAY STATS, BUT THESE RESULTS ARE ONE DAY STATS, SO WE SKIP THEM
	if ($daterange != 1 && $startdate == $enddate) {
		continue;
	} 	
 
	//Convert it into a Unix timestamp using strtotime.
	$startdate = strtotime($buffer['startdate']);
	// CONVERT TIMESTAMP TO THIS STYLE May 21, 2020 
	$startdate = date('M j, Y', $startdate);
 
	$enddate = strtotime($buffer['enddate']);
	$enddate = date('M j, Y', $enddate);	


	/*echo '<br>';
	echo $startdate.' - '.$enddate;
	echo ' Total comms earned: '.$comm_earned_all;
	echo '<br>CC comms earned: '.$comm_earned_cc;
	echo '<br>Other comms earned: '.$comm_earned_other;
	echo '<br>Manual marked paid comms earned: '.$comm_earned_man;
	echo '<br>Total members joined: '.$members_joined;*/
	
	$display_date_range = $startdate.' - '.$enddate;
	if ($daterange == 1) $display_date_range = $startdate;
?>
<div class="table-responsive">
 <table class="table">

  <tr class="row" style="background-color:#eee">
  <td class="col-md-1">&nbsp;</td>
    <td class="col-md-2"><b><?php echo $_GET['range'];?> Day Range</b></td>
    <td class="col-md-2"><b>Total Sales</b></td>	
    <td class="col-md-2"><b>Total Admin Earned</b></td>
    <td class="col-md-2"><b>Total Comms Earned</b></td>	
    <td class="col-md-2"><b>Total Members Joined</b></td>	
	<td class="col-md-1">&nbsp;</td>
  </tr>
  
  <tr class="row">
  <td class="col-md-1">&nbsp;</td>
    <td class="col-md-2"><?php echo $display_date_range;?></td>
	<td class="col-md-2"><?php echo $total_sales;?></td>
    <td class="col-md-2"><?php echo $admin_earned;?></td>
    <td class="col-md-2"><?php echo $comm_earned_all;?></td>	
    <td class="col-md-2"><?php echo $members_joined;?></td>	
	<td class="col-md-1">&nbsp;</td>
  </tr>   
  
 </table>
</div>

<?php } ?>

	<div class="container" style="QQQbackground-color:#f2f2f2">
	<div class="row">
	
<div style="text-align:right; margin-right:40px;">
<ul class="pagination">
<?php echo pagination_links($page, $total_pages, 6, 'Stats_earnings.php?range='.$daterange.'&', array('page' => 'Page', 'first' => 'first', 'last' => 'last')); ?>
</ul>
</div>

	</div>
	</div>
*Total Comms Earned are the total amount of member commissions earned. This does not include admin earnings. All numbers are gross amounts.

<?php if ($daterange == 30) { ?>
<br/>**Today's stats get calculated and updated every 5 minutes, when the "Stats.cron" runs.	
<?php } else { ?>
<br/>**Today's daily stats will be calculated and stored tomorrow, when the "Stats1day.cron" runs.

<?php }
include './../Inc/Footer.inc.php';
?>
