<?php
//-----------------------------------------------------------------
// Software: Automatic Web Software (AWS) built with PHPCPR
// Firm: DirectSalesMLM.com / AutomaticWebSoftware.com / PHPCPR.com
// Author: Jim Symonds Email: jim@directsalesmlm.com
// Copyright 2006 - 2024 Jim Symonds All Rights Reserved.
//-----------------------------------------------------------------
include './../../Sub/Config.inc.php';
include './../Inc/Login.inc.php';
if ($loggedUser->checkPermisson('ADD_PROGRAM') === false){
  $errorMessage = 'You are not allowed to access this page.';
  require_once('./../Inc/error.php');
  exit();   
}
//error_reporting(-1);
//$_SESSION['debug'] = true;

 /*
if ($_GET['dev'] == '' && $_SESSION['dev'] == '') { // LOCKING PAGE FOR DEVELOPER USE ONLY!!
include_once './header.php';
echo 'We\'re sorry. This area is temporarily down for maintenance. Please check back soon!';
include_once './footer.php';
exit;
} else {
$_SESSION['dev'] = true;
}
 */
$pageName = 'View Payment Plan';
$pageDesc = '';
$pageIcon = '';
$pageAlign = 'left';
$pageClass = ''; 


include './../Inc/Header.inc.php';
?>
<style>
table {
    border: 1px solid #eeeeee; 
    padding: 10px;
}
</style>
<?php
	// UPDATE TO ALLOW PAGE TO WORK WITH USERNAME OR ID, SO WE CAN EASILY ACCESS THIS DIRECTLY FROM PAYMENT LOGS PAGE
	if ($_GET['username'] != '') {

		$username_passed = htmlspecialchars($_GET['username']);
		$result = mysql_query("SELECT ID FROM members WHERE Username='{$username_passed}'");
		$buffer = mysql_fetch_assoc($result);
		$_GET['id'] = $buffer['ID'];
	}

echo '<h1 style="text-align:center">View Payment Plan</h1>';

if ($Global['datetime_format'] == '') $Global['datetime_format'] = 'F j, Y H:i:s T';
$datetime = date("Y-m-d H:i:s");
$timestamp = time();

//Find all information about the user and display it...
$userid = htmlspecialchars($_GET['id']);
$result = mysql_query("SELECT First_Name, Username, email FROM members WHERE ID='{$userid}'");
$buffer = mysql_fetch_assoc($result);
$_SESSION['payer_username'] = $buffer['Username'];
$fname = $buffer['First_Name'];
$email = $buffer['email'];

if (!empty($_GET['do']) && $_GET['do'] == 'Process') {
	$options = '';

	foreach ($Global['processor_info'] as $key => $value)
		{
		$options .= '<option value="'.$key.'">'.$value.'</option>';
		}

	//Display a form with more payment information
	echo <<<EOD
<strong>Process a payment to payment plan {$_GET['plan']}</strong><br /><br />
If you process this payment, it will activate the user (if needed, and no more plans are required) and it will create a payment log showing the commission paid.<br /><br />
If the user is Active or is made Active, they will also get 30 days of time added to their membership due date for program {$_GET['prog']} (if no more plans are required)<br /><br />
<form action="{$_SERVER['PHP_SELF']}?id={$_GET['id']}&prog={$_GET['prog']}" method="POST">
<input type="hidden" name="plan" value="{$_GET['plan']}">
<input type="hidden" name="do" value="Process2">
<input type="hidden" name="processor" value="C">

<!--
Payment Processor: <select name="processor"> 
<option value="">Select a payment processor</option> 
{$options}
</select> (Required)<br />The processor the payment was done through.<br /><br />
Payment Processor Transaction ID: <input type="text" name="transaction" value=""> (Optional)<br />The transaction id from the successful payment, if any.<br />Note: If you do not add a transaction ID you lose the ability to do a chargeback.<br /><br />
Payment Account ID: <input type="text" name="account" value=""> (Optional)<br />The payment processor account name/id that the payment was done from.<br /><br />
-->
<input type="submit" value="Submit">
</form>
EOD;

	include './../Inc/Footer.inc.php';
	exit;
	}
elseif (!empty($_POST['do']) && $_POST['do'] == 'Process2') {
	//If something is missing terminate
	if (empty($_POST['plan']) || empty($_POST['processor'])) {

		$Error_msg = 'Need more information to process the payment on payment plan '.$_POST['plan'];
		}
	elseif (!empty($_POST['transaction']) && $_POST['processor'] == 'E' && !is_numeric($_POST['transaction'])) {

		$Error_msg = 'Need more information to process the payment on payment plan '.$_POST['plan'].'<br />The transaction id on a E-Gold transaction can only contain integers!';
		}
	else {
			$exists = false;

		//If a transaction id was added, check if it exists
		if (!empty($_POST['transaction'])) {
			if ($_POST['processor'] == 'S') {
				$result = mysql_query("SELECT transaction_id FROM safepay_history WHERE transaction_id='".mysql_escape_string($_POST['transaction'])."' && success='Y'");

				$buffer = mysql_fetch_assoc($result);

				if (!empty($buffer['transaction_id'])) $exists = true;
				}
			elseif ($_POST['processor'] == 'E') {
				$_POST['transaction'] = intval($_POST['transaction']);

				$result = mysql_query("SELECT payment_batch_num FROM egold_history WHERE payment_batch_num='".mysql_escape_string($_POST['transaction'])."' && success='Y'");

				$buffer = mysql_fetch_assoc($result);

				if (!empty($buffer['payment_batch_num'])) $exists = true;
				}
			elseif ($_POST['processor'] == 'P') {
				$result = mysql_query("SELECT tnx_id FROM paypal_history WHERE tnx_id='".mysql_escape_string($_POST['transaction'])."' && success='Y'");

				$buffer = mysql_fetch_assoc($result);

				if (!empty($buffer['tnx_id'])) $exists = true;
				}
			elseif ($_POST['processor'] == 'A') {
				$result = mysql_query("SELECT ap_referencenumber FROM alertpay_history WHERE ap_referencenumber='".mysql_escape_string($_POST['transaction'])."' && success='Y'");

				$buffer = mysql_fetch_assoc($result);

				if (!empty($buffer['ap_referencenumber'])) $exists = true;
				}
			elseif ($_POST['processor'] == 'AN') {
				$result = mysql_query("SELECT transaction_id FROM authorize_history WHERE transaction_id='".mysql_escape_string($_POST['transaction'])."' && success='Y'");

				$buffer = mysql_fetch_assoc($result);

				if (!empty($buffer['transaction_id'])) $exists = true;
				}
			elseif ($_POST['processor'] == 'GC') {
				$result = mysql_query("SELECT order_number FROM gc_history WHERE order_number='".mysql_escape_string($_POST['transaction'])."' && success='Y'");

				$buffer = mysql_fetch_assoc($result);

				if (!empty($buffer['order_number'])) $exists = true;
				}
			elseif ($_POST['processor'] == 'LP') {
				$result = mysql_query("SELECT linkpoint_history FROM linkpoint_history WHERE transaction_id='".mysql_escape_string($_POST['transaction'])."' && success='Y'");

				$buffer = mysql_fetch_assoc($result);

				if (!empty($buffer['transaction_id'])) $exists = true;
				}
			elseif ($_POST['processor'] == 'IP') {
				$result = mysql_query("SELECT ipayout_history_id FROM ipayout_history WHERE trnx_id='".mysql_escape_string($_POST['transaction'])."' && success='Y'");

				$buffer = mysql_fetch_assoc($result);

				if (!empty($buffer['transaction_id'])) $exists = true;
				}
			}
		
		if ($exists === true) $Error_msg = 'Need more information to process the payment on payment plan '.$_POST['plan'].'<br />The transaction id already exists on a successfull payment, please make sure you typed the correct transaction id!';

		if (empty($Error_msg)) {
			//Process the payment
			$payment_processor = $_POST['processor']; //The prefix of the processor
			$payment_processor_name = $Global['processor_info'][$_POST['processor']]; //The full name for the payment processor
			$program_id = intval($_GET['prog']); //The id of the program in question
			$payer = $_POST['account']; //The payment processor id that the person paid with

			$result = mysql_query("SELECT Username FROM members WHERE ID=".intval($_GET['id']));
			$buffer = mysql_fetch_assoc($result);
			
			$payer_username = $buffer['Username']; //The username of the person who is supposed to do the payment
			
			$result = mysql_query("SELECT plan.username, user.user_payment_plan_id, user.grace_enabled, user.signup_ip FROM payment_plan as plan LEFT JOIN user_payment_plan as user USING (user_payment_plan_id) WHERE plan.payment_plan_id=".intval($_POST['plan'])) or die(mysql_error());
			$buffer = mysql_fetch_assoc($result);

			$receiver_username = $buffer['username']; //Username of the person receiving the money
			$payer_grace_status = $buffer['grace_enabled']; //If the person paying has a active grace period
			$payer_signup_ip = $buffer['signup_ip']; //The logged ip on this program
			$user_payment_plan_id = $buffer['user_payment_plan_id']; //The id of the main payment plan system

			//Define security constant
			define('IPN_PROCESS', true);

			//Select the program settings in question
			$result = mysql_query("SELECT * FROM program WHERE program_id=$program_id");

			$buffer = mysql_fetch_assoc($result);

			$program_name = $buffer['program_name']; //The name of the program in question
			$program_type = $buffer['program_type']; //If its a subscription or a normal payment
			$program_sub_period = $buffer['program_sub_period']; //The period the subscription last, days
			$program_powerline = $buffer['program_up']; //The number of powerlines in the program

			if ($program_powerline == 0) $program_powerline = -1;  

			//Select the payer information
			$result = mysql_query("SELECT prog.* FROM members as memb LEFT JOIN user_program as prog USING (ID) WHERE memb.Username='$payer_username' && prog.program_id=$program_id");

			$buffer = mysql_fetch_assoc($result);

			$payer_id = $buffer['ID']; //ID of the person paying
			$payer_status = $buffer['user_status']; //If the user is active, unpaid etc
			$payer_expire = $buffer['expire']; //The time the sub expire
		
			//Select the payment_plan information
			$plan_info = array();
		
			$result = mysql_query("SELECT * FROM payment_plan WHERE user_payment_plan_id=$user_payment_plan_id && (plan_type='S' || (plan_type='N' && payment_period=0))");
			
			while ($buffer = mysql_fetch_assoc($result))
				{
				if ($receiver_username == $buffer['username'] && intval($_POST['plan']) == $buffer['payment_plan_id']) {			

					$expected_amount = $buffer['amount'] + $buffer['grace_amount']; //The amount that was paid to the person receiving the money

					$payment_plan_id = $buffer['payment_plan_id']; //The id of the payment plan, that the person receiving the money was paid under
		
					}
					
				$plan_info[$buffer['payment_plan_id']] = array('username' => $buffer['username'], 'status' => $buffer['user_status'], 'amount' => $buffer['amount'], 'type' => $buffer['payment_type'], 'tier' => $buffer['payment_tier_level'], 'complete' => $buffer['sec_payment_complete'], 'date' => $buffer['last_paid_date'], 'first_date' => $buffer['first_paid_date']); // An array containing all the payment_plans in this user_payment_plan.
				} // END WHILE LOOP!

$resultpayto = mysql_query("SELECT m.payment_collected_by FROM members as m WHERE m.Username='{$receiver_username}'");
$bufferpayto = mysql_fetch_assoc($resultpayto);

// IF ADMIN COLLECTS PAYMENT 
if ($bufferpayto['payment_collected_by'] == 'admin') {
$ccpending = 'Y';
$collected_by = 'admin';
$admin_collects = true;
} else {
$ccpending = 'N';
$collected_by = 'member';
$admin_collects = false;
}
			
/*
// QQQ assume admin never collects money outside of the system on behalf of members - overrides above code
// in 2 places in this file!!
$ccpending = 'N';
$collected_by = 'member';
$admin_collects = false;
*/
			
			//Initiate the real payment functions we are testing
			// REQUIRED FOR CAMP UPDATES IN LOGGING REAL.
			//$_SESSION['UserID'] = $_GET['id'];
// DO NOT USE ABOVE LINE - COULD CAUSE ISSUES ELSEWHERE
// SOLUTION IS TO NO LONGER USE THIS FILE FOR MARKING PAID!
			
			//Log the payment properly, + send out a payment received email
			include $Global['path'].'apay/Logging.inc.php';			  						
													
			//Check if eveyone has been paid, if update the account and do arrangements
			$nr = 0;
																								
			foreach ($plan_info as $key => $value) 
				{
				if ($value['complete'] == 'Y' && $key != $payment_plan_id) ++$nr; 
				}
																									
			$required_payments = count($plan_info);
															
			$total_payments =	$nr + 1;
							
			//If every payment has been completed, update the payer information!
			if ($total_payments == $required_payments) {
					$admin_processing = true;
				
					include $Global['path'].'apay/Finalize.inc.php';
					}

			//If a transaction id was added, add it 
			if (!empty($_POST['transaction'])) {
				if ($_POST['processor'] == 'S') {
					//Add the payment into the processor history table
					mysql_query("INSERT INTO safepay_history SET payment_plan_id=$payment_plan_id, payment_log_id=$payment_log, custom_transaction_id='".mysql_escape_string($_POST['transaction'])."', timestamp=".time().", success='Y'") or die(mysql_error());
					}
				elseif ($_POST['processor'] == 'E') {
					//Add the payment into the processor history table
					mysql_query("INSERT INTO egold_history SET payment_plan_id=$payment_plan_id, payment_log_id=$payment_log, custom_batch_num='".mysql_escape_string($_POST['transaction'])."', timestamp=".time().", success='Y'") or die(mysql_error());
					}
				elseif ($_POST['processor'] == 'P') {
					//Add the payment into the processor history table
					mysql_query("INSERT INTO paypal_history SET payment_plan_id=$payment_plan_id, payment_log_id=$payment_log, custom_tnx_id='".mysql_escape_string($_POST['transaction'])."', timestamp=".time().", success='Y'") or die(mysql_error());
					}
				elseif ($_POST['processor'] == 'A') {
					//Add the payment into the processor history table
					mysql_query("INSERT INTO alertpay_history SET payment_plan_id=$payment_plan_id, payment_log_id=$payment_log, custom_referencenumber='".mysql_escape_string($_POST['transaction'])."', timestamp=".time().", success='Y'") or die(mysql_error());
					}
				elseif ($_POST['processor'] == 'AN') {
					//Add the payment into the processor history table
					mysql_query("INSERT INTO authorize_history SET user_payment_plan_id=$user_payment_plan_id, custom_transaction_id='".mysql_escape_string($_POST['transaction'])."', timestamp=".time().", success='Y'") or die(mysql_error());
						
					$id = mysql_insert_id();

					mysql_query("INSERT INTO cc_history SET authorize_history_id=$id, payment_plan_id=$payment_plan_id, payment_log_id=$payment_log") or die(mysql_error());
					}
				elseif ($_POST['processor'] == 'GC') {
					//Add the payment into the processor history table
					mysql_query("INSERT INTO gc_history SET payment_plan_id=$payment_plan_id, payment_log_id=$payment_log, custom_order_number='".mysql_escape_string($_POST['transaction'])."', success='Y'") or die(mysql_error());
					}

				elseif ($_POST['processor'] == 'IP') {
					//Add the payment into the processor history table
					mysql_query("INSERT INTO ipayout_history SET payment_plan_id=$payment_plan_id, payment_log_id=$payment_log, trnx_id='".mysql_escape_string($_POST['transaction'])."', success='Y'") or die(mysql_error());
					}

				elseif ($_POST['processor'] == 'LP') {
					//Add the payment into the processor history table
					mysql_query("INSERT INTO linkpoint_history SET user_payment_plan_id=$user_payment_plan_id, custom_transaction_id='".mysql_escape_string($_POST['transaction'])."', timestamp=".time().", success='Y'") or die(mysql_error());

					$id = mysql_insert_id();

					mysql_query("INSERT INTO cc_history SET linkpoint_history_id=$id, payment_plan_id=$payment_plan_id, payment_log_id=$payment_log") or die(mysql_error());
					}
				}

			$Error_msg = 'Processed a payment period to payment plan '.$_POST['plan'];
			}
		}
	}
elseif (!empty($_GET['do']) && $_GET['do'] == 'Remove') {
	//Remove a period from the payment.
	mysql_query("UPDATE payment_plan SET payment_period=payment_period-1, sec_payment_complete='N' WHERE payment_plan_id=".intval($_GET['plan']));

	$Error_msg = 'Removed a payment period from payment plan '.$_GET['plan'];
	}


elseif (!empty($_GET['do']) && $_GET['do'] == 'CreateLog') {
	//CREATE A PAYMENT LOG FOR THIS PAYMENT PLAN


$paymentplan = $_GET['plan'];
$program_id = intval($_GET['prog']); //The id of the program in question

// FIND OUT IF PROGRAM IS SET TO ADMIN COLLECTS PAYMENT
$resultprog = mysql_query("SELECT program_collect FROM program WHERE program_id={$_GET['prog']}");
$bufferprog = mysql_fetch_assoc($resultprog);

// IF ADMIN COLLECTS PAYMENT 
// QQQ UPDATE THIS, ADD "OR" CONDITION - FOR "IF CASE IS EAT, AND THE PAYMENT PLAN payment_type='T'"
if ($bufferprog['program_collect'] == 'A') {
$ccpending = 'Y';
} else {
$ccpending = 'N';
}

$resultplan = mysql_query("SELECT username, payer_username, amount, last_paid_date FROM payment_plan WHERE payment_plan_id=".intval($_GET['plan']));
$bufferplan = mysql_fetch_assoc($resultplan);

$resultpayto = mysql_query("SELECT u.user_program_id, m.payment_collected_by, m.ID FROM user_program as u JOIN members as m WHERE m.Username='{$bufferplan['username']}' AND m.ID=u.ID AND u.program_id={$_GET['prog']}");
$bufferpayto = mysql_fetch_assoc($resultpayto);

// IF ADMIN COLLECTS PAYMENT 
if ($bufferpayto['payment_collected_by'] == 'admin') {
$ccpending = 'Y';
$collected_by = 'admin';
} else {
$ccpending = 'N';
$collected_by = 'member';
}

/*
// QQQ assume admin never collects money outside of the system on behalf of members - overrides above code
//set in 2 places in file!!
$ccpending = 'N';
$collected_by = 'member';
*/

mysql_query("INSERT INTO `payment_log` (`payment_log_id`, `user_program_id`, `manual_override`, `manual_override_date`, `old_user_program_id`, `payment_plan_id`, `program_id`, `user_custom_plan_id`, `collected_by`, `payment_processor`, `payment_processor_custom`, `payer_username`, `amount`, `timestamp`, `chargeback`, `chargeback_date`, `cc_pending`, `cc_pending_date`, `cc_fee`) 

VALUES (NULL, '{$bufferpayto['user_program_id']}', 'C', '{$datetime}', '0', '{$paymentplan}', '{$program_id}', NULL, '{$collected_by}', '{$_POST['processor']}', 'admin manual process', '{$bufferplan['payer_username']}', '{$bufferplan['amount']}', '{$bufferplan['last_paid_date']}', 'N', NULL, '{$ccpending}', NULL, '0.00')") or die('Could Not Create Log!'.mysql_error());

	$Error_msg2 = 'Payment Log Successfully Added For Payment Plan ID ' .$_GET['plan'];
	$Error_msg = 'If you like, check commissions earned now for <a href="memberlogin.php?id='.$bufferpayto['ID'].'&rd=viewpayment.php?program='.$program_id.'" target="_blank">'.$bufferplan['username'].'</a>';

} // END CREATE LOG


// REFUND CHARGEBACK OPTION - JS ADDED JULY 2013 - TO FIX PAYMENT LOGS, SET THEM AS CHARGEBACK AND NOT PENDING, CRITICAL FOR ADMIN TAKES ALL PROGRAMS!
elseif (!empty($_GET['do']) && $_GET['do'] == 'Refund') {

//echo 'HERE! ';
//echo $_GET['log'];


// FIND AMOUNT, CC FEE, CHARGEBACK STATUS FOR THIS PAYMENT LOG
$resultlog = mysql_query("SELECT payment_log_id, collected_by, user_program_id, amount, cc_pending, chargeback, cc_fee FROM payment_log WHERE payment_log_id={$_GET['log']} AND payment_plan_id=".intval($_GET['plan'])." ORDER BY payment_log_id DESC LIMIT 1");
$bufferlog = mysql_fetch_assoc($resultlog);

		if ($bufferlog['chargeback'] == 'Y') { 
		echo 'You already refunded this pay plan! No further action was performed.';
		include './../Inc/Footer.inc.php';
		exit;
		}	

	//Edit the payment plan.

// OVERVIEW
/* admin/Cron/Cc.cron - once payments are cleared the payment grace period ($Global['cc_grace']), this cron sets cc_pending='N', and moves payments owed (Amount Pending in mass pay page) to user_program "amount" field. Now it shows as "Available" to be paid out in the admin mass pay page. The amount pending in the mass pay page is drawn from payment logs where cc_pending='Y'. The amount Available in mass pay is from the user_program "amount" field.
*/

$resultplan = mysql_query("SELECT username, user_payment_plan_id FROM payment_plan WHERE payment_plan_id=".intval($_GET['plan']));
$bufferplan = mysql_fetch_assoc($resultplan);

// THIS WORKS - BUT AMOUNTS ARE NOT ADDED INTO USER_PROGRAM UNTIL CRON IS RUN
$resultloser = mysql_query("SELECT u.user_program_id, u.amount FROM user_program as u JOIN members as m WHERE m.Username='{$bufferplan['username']}' AND m.ID=u.ID AND u.program_id={$_GET['prog']}");
$bufferloser = mysql_fetch_assoc($resultloser);

// DEBUGGING SESSION
if (!empty($_SESSION['debug']) && $_SESSION['debug'] === true) {
echo 'The OLD fart\'s user_program_id who got paid, but is now gonna lose it, is: ' .$bufferloser['user_program_id'];
echo '<br/>';
} // END DEUGGING SESSION

// ALREADY HAVE THESE AT TOP OF FILE!
//$datetime = date("Y-m-d H:i:s");
//$timestamp = time();
$expire_timestamp = $timestamp + ($Global['grace']['C'] * 86400);
	
			// UPDATE PAYMENT PLANS ***************
			//Remove the sec payment complete, and one period on the payment plan
//			mysql_query("UPDATE payment_plan SET sec_payment_complete='N', payment_period=payment_period-1 WHERE payment_plan_id=".intval($_GET['plan']));

$resultgrace = mysql_query("SELECT u.user_program_id FROM user_program as u JOIN members as m WHERE m.Username='{$_SESSION['payer_username']}' AND m.ID=u.ID AND u.program_id={$_GET['prog']}");
$buffergrace = mysql_fetch_assoc($resultgrace);

			//remove a payment period on the user program
			// COMMENTED OUT 5/29/20 DUE TO IN STARTED PLANS, THIS VALUE IS 0, AND IT CANNOT GO NEGATIVE, CAUSING SQL ERROR!
			//mysql_query("UPDATE user_program SET payment_period=payment_period-1 WHERE user_program_id={$buffergrace['user_program_id']}") or die(mysql_error());
			

// FIND OUT IF PROGRAM IS SET TO ADMIN COLLECTS PAYMENT
$resultprog = mysql_query("SELECT program_collect FROM program WHERE program_id={$_GET['prog']}");
$bufferprog = mysql_fetch_assoc($resultprog);

// THE AMOUNT TO REFUND
// FLAWED!! ONLY WORKS IF CC CRON PUSHED MONEY INTO BANK!!
//$ramount = $bufferlog['amount']-$bufferlog['cc_fee'];

//echo 'ramount: '.$ramount;

// IF ADMIN COLLECTS PAYMENT 
// QQQ UPDATE THIS, ADD "OR" CONDITION - FOR "IF CASE IS EAT, AND THE PAYMENT PLAN payment_type='T'"
if ($bufferprog['program_collect'] == 'A' || $bufferlog['collected_by'] == 'admin') {

	// IF ADMIN COLLECTS, AND CC_PENDING='N' IN PAYMENT LOG, THAT MEANS CC CRON RAN, SO WE NEED TO UPDATE "EARNED AMOUNT" IN USER PROGRAM AND REMOVE THIS COMMISSION!

		if ($bufferlog['cc_pending'] == 'N' || $bufferlog['cc_pending'] == 'A') { // MONEY GOT ADDED TO USER PROGRAM, SO REMOVE IT
				// UPDATED FOR NEW BANKING SYSTEM - NOW USING earned_amount and amount is minus cc fees!
				// Remove the payment log amount from the program - taken from Cc.cron, and used in reverse.
			mysql_query("UPDATE user_program SET earned_amount=earned_amount-{$ramount}, amount_cc_fee=amount_cc_fee-{$bufferlog['cc_fee']} WHERE user_program_id={$bufferloser['user_program_id']}");

/* CANNOT WORK ON NWC- SINCE WE DID NOT TRACK PAYMENT LOG IDS TO START
// FIRST SEE IF TRANSACTIONS LOG IS STILL PENDING
$result = mysql_query("SELECT * FROM transactions_log as t JOIN payment_log as log
WHERE t.payment_log_id=log.payment_log_id AND t.payment_log_id={$_GET['log']}
$buffer = mysql_fetch_assoc($result);
*/
// FIND OUT WHO GOT PAID, SO WE CAN REMOVE THE COMMISSION
$resultid = mysql_query("SELECT ID FROM user_program as u JOIN payment_log as log 
WHERE log.user_program_id=u.user_program_id AND log.program_id=u.program_id AND log.payment_log_id={$_GET['log']} LIMIT 1");
$bufferid = mysql_fetch_assoc($resultid);

$qry = "SELECT First_Name, Username, email FROM members WHERE ID = '{$bufferid['ID']}'";
//echo $qry."<br/>";
$result = mysql_query($qry) or die($qry.' '.mysql_error());	
$buffer = mysql_fetch_assoc($result);
$paid_to_username = $buffer['Username'];
$paid_to_fname = $buffer['First_Name'];
$paid_to_email = $buffer['email'];

//echo ' bufferid id: '.$bufferid['ID'];

// GET BANK BALANCE!
// ALL TYPES, INCLUDING WITHDRAWAL AND DEBIT TYPES ARE ALLOWED IN QUERY HERE, SINCE NEGATIVE VALUES MUST BE SUBTRACTED!! 
// WE CAN NEVER CANCEL A WITHDRAWAL, SINCE IT WOULD EFFECTIVELY PUT MONEY INTO THEIR BANK!!
// INSTEAD (IF REQUIRED) WE CREATE A POSITIVE WITHDRAWAL LOG, TO CANCEL OUT ANY PENDING WITHDRAWAL THAT MUST BE CANCELLED, THEN BOTH WILL BE MARKED PAID AT MASSPAY
$result = mysql_query("SELECT sum(amount) as balance FROM transactions_log WHERE usrid = '{$bufferid['ID']}' AND description!='CHARGEBACKW'");
$buffer = mysql_fetch_assoc($result);
$balance = $buffer['balance'];

//echo ' bufferw amount: '.$bufferw['amount'];
//echo ' bufferw id: '.$bufferw['id'];


$result = mysql_query("SELECT sum(amount) as wbalance FROM transactions_log WHERE usrid = '{$bufferid['ID']}' AND transtype='WITHDRAWAL' and pay_status='PENDING'");
$buffer = mysql_fetch_assoc($result);
$wbalance = abs($buffer['wbalance']);


if ($wbalance > 0) { // DELETE WITHDRAWAL REQUEST!
	$qry = "DELETE FROM transactions_log WHERE usrid = '{$bufferid['ID']}' AND transtype='WITHDRAWAL' and pay_status='PENDING'";
	$result = mysql_query($qry) or die(mysql_error());	
}

if ($Global['cc_fee_rate'] == '') $Global['cc_fee_rate'] = .20;
$cc_fee_rate = $Global['cc_fee_rate'];

// CALCULATE AMOUNT OF CC FEES
$cc_fees = ($bufferlog['amount'] * $cc_fee_rate);

$ramount = $bufferlog['amount']-$cc_fees;


// CACLCULATE PENDING MINUS FEES
$pending_minus_fees = ($pending - $cc_fees);

// CREATE DEBIT IN BANK FOR THE CHARGEBACK!
$insert = "insert into `transactions_log` (`usrid`, `amount`, `payment_log_id`, `description`, `transtype`, `logdate`, `payout_date`, `pay_status`) values ";
$insert .= "('{$bufferid['ID']}','-{$ramount}','{$bufferlog['payment_log_id']}','CHARGEBACK','DEBIT','{$datetime}','','PAID')";
$result = mysql_query($insert) or die(mysql_error());


/*
		if ($wbalance >= $ramount) { // THEY HAVE ENOUGH IN WITHDRAWALS - CREATE A WITHDRAWAL TRANSACTION TO RECOVER COSTS AGAINST PENDING WITHDRAWALS, SET WITH A POSITIVE VALUE, SO IT IS AUTOMATICALLY REMOVED FROM ALL WITHDRAWAL REQUESTS!!
			echo ' CREATING WITHDRAWAL CANCELLATION<br/><br/>';
			echo ' Total Pending Withdrawals Before Refund: $'.$wbalance;

			$insert = "insert into `transactions_log` (`usrid`, `amount`, `payment_log_id`, `description`, `transtype`, `logdate`, `payout_date`, `pay_status`) values ";
			$insert .= "('{$bufferid['ID']}','{$ramount}','{$bufferlog['payment_log_id']}','CHARGEBACKW','WITHDRAWAL','{$datetime}','','PENDING')";
			$result = mysql_query($insert) or die(mysql_error());

			$Error_msg = $bufferplan['username'].'\'s pending withdrawals were $'.$wbalance.'. Created Withdrawal Cancellation in amount of $'.$ramount.' to recoup this loss against these pending withdrawal request(s)!';
			echo "<br/><br/><a href=\"pay_commissions.php?reset=yes\" target=\"_blank\">View Pending Withdrawals in Masspay</a> (opens new window - WARNING - ALSO Resets Session Cut Off!)<br/><br/>";

		} else { // CREATE A DEBIT TRANSACTION!
			echo ' DEBITING BANK<br/><br/>';
			echo ' Starting Bank Balance: '.$balance;

			$insert = "insert into `transactions_log` (`usrid`, `amount`, `payment_log_id`, `description`, `transtype`, `logdate`, `payout_date`, `pay_status`) values ";
			$insert .= "('{$bufferid['ID']}','-{$ramount}','{$bufferlog['payment_log_id']}','CHARGEBACK','DEBIT','{$datetime}','','PAID')";
			$result = mysql_query($insert) or die(mysql_error());
	

		if ($balance >= $ramount) {
			$Error_msg = $bufferplan['username'].'\'s Bank had enough funds to debit. Bank Balance Debited by $'.$ramount.'!';
		} else {
			$Error_msg = $bufferplan['username'].'\'s Bank did not have enough sufficient funds to cover this debit. Bank Balance Debited by $'.$ramount.'. Account is overdrawn with a negative balance!';
		}

		echo '<br/><br/><a href="memberlogin.php?id='.$bufferid['ID'].'&rd=bank.php" target="_blank">Login to '.$bufferplan['username'].'\'s Bank</a> (opens new window)<br/><br/>';

		} // END WITHDRAWAL OR DEBIT
		*/
		} else { // END CC_PENDING IS N OR A
		$Error_msg = 'This log was still pending, (had not yet been released from the cc grace period), so the commission from this log was never put into '.$bufferplan['username'].'\'s Bank.';
		}
} // END IF ADMIN COLLECTS PAYMENT

	// UPDATE PAYMENT LOG **************** SET CC PENDING TO N, JUST IN CASE THE CRON HAS NOT RUN YET!
	//Mark the payment as chargeback
mysql_query("UPDATE payment_log SET chargeback='Y', chargeback_date='{$timestamp}', cc_pending='N' WHERE payment_log_id={$_GET['log']} AND payment_plan_id=".intval($_GET['plan']));

// MAIL USER TO ALERT THEM!	

$message_text = "Hi {$paid_to_fname}, 

Someone in your payline has unfortunately retracted their payment.

A debit has therefore been applied to your {$Global['webpage_name']} bank.

If you had any withdrawal(s) pending, they (may have) have been removed (and the money returned to your bank). This is only done if those funds had already been released to your bank - in an effort to protect the company and recoup such funds before paying out commissions.

More information is available in your back office. Please login to review, and make a new withdrawal request (if needed, and you still have positive funds and wish to withdrawal them).

Your account username is: {$paid_to_username} 

Thank you.
{$Global['webpage_name']} Support";

$subject_text = "{$Global['webpage_name']} Customer Refund Notice";

$message_text = htmlspecialchars(trim($message_text));
$subject_text = htmlspecialchars(trim($subject_text));

if ($Global['use_sendgrid'] == true) {
	include $Global['path'].'sendgrid.inc.php';
	sendgrid_email($paid_to_email,$subject_text,$message_text);
} else {
	mail($paid_to_email,$subject_text,$message_text,"From: {$Global['webpage_name']} <{$Global['admin_email']}>\r\n","-f{$Global['admin_email']}");	
}

		$Error_msg2 = 'This refund or chargeback has been processed, successfully.';

		if ($_GET['log'] == '') { 
		$Error_msg = 'There is no payment log to refund! The payment plan has been updated.';
		$Error_msg2 = '';
		}

if (!empty($Error_msg)) {
echo '<font color="FF0000">'.$Error_msg.'</font><br /><br />';
}	
if (!empty($Error_msg2)) {
echo '<font color="FF0000">'.$Error_msg2.'</font><br /><br />';
}	

	include './../Inc/Footer.inc.php';
	exit;

} // END REFUND CHARGEBACK EDIT PAYMENT PLAN OPTION


// REMOVE GRACE STATUS FROM USER ACCOUNT!!

if (!empty($_GET['do']) && $_GET['do'] == 'RemoveGrace') {
// UPDATE PAYMENT PLAN - REMOVE USER FROM GRACE PERIOD!

mysql_query("UPDATE `payment_plan` SET `sec_payment_complete` =  'Y', `grace_enabled` =  'N', `grace_start_date` =  '0',
`grace_end_date` =  '0' WHERE `payment_plan_id` =".intval($_GET['plan']));

// UPDATE USER PAYMENT PLAN - REMOVE USER FROM GRACE PERIOD!

$resultplan = mysql_query("SELECT user_payment_plan_id FROM payment_plan WHERE payment_plan_id=".intval($_GET['plan']));
$bufferplan = mysql_fetch_assoc($resultplan);

mysql_query("UPDATE `user_payment_plan` SET `grace_enabled` = 'N' WHERE `user_payment_plan_id` ='{$bufferplan['user_payment_plan_id']}'");

$result = mysql_query("SELECT user_program_id FROM user_payment_plan WHERE `user_payment_plan_id` ='{$bufferplan['user_payment_plan_id']}'");

$buffer = mysql_fetch_assoc($result);

// UPDATE USER PROGRAM - REMOVE USER FROM GRACE PERIOD!

mysql_query("UPDATE `user_program` SET `grace_start` =  '0', `grace_expire` =  '0', `grace_checked` =  '0' WHERE `user_program_id` ='{$buffer['user_program_id']}'");

//echo 'user program id';
//echo $buffer['user_program_id'];
//echo '<br />';
echo 'Grace status removed. Start and expire times were not affected.<br /><br />';


} // END REMOVE GRACE STATUS 

// DELETE PLAN OPTION
if (!empty($_GET['do']) && $_GET['do'] == 'DeletePlan') {
	//Delete the payment plan.
	mysql_query("DELETE FROM payment_plan WHERE payment_plan_id=".intval($_GET['plan']));

	$Error_msg = 'Deleted payment plan '.$_GET['plan'];
	}



// EDIT PAYMENT PLAN OPTION ***** CHANGE WHO GETS PAID!!! ******
elseif (!empty($_GET['do']) && $_GET['do'] == 'EditPlan') {
	//Edit the payment plan.

if ($_POST['username'] == $_SESSION['payer_username']) {
   echo 'You cannot have members paying themselves. If sort of defeats the purpose. Do you need a cup of coffee? :)';
   echo '<br/><br/><a href="Viewplan.php?id='.$_GET['id'].'&prog='.$_GET['prog'].'">Go Back</a>';
	include './../Inc/Footer.inc.php';
	exit;
   }

$resultplan = mysql_query("SELECT username, user_payment_plan_id FROM payment_plan WHERE payment_plan_id=".intval($_GET['plan']));
$bufferplan = mysql_fetch_assoc($resultplan);

if ($_POST['username'] == $bufferplan['username']) {
   echo 'This pay plan is already set to pay '.$_POST['username'] .'!';
   echo '<br/><br/><a href="Viewplan.php?id='.$_GET['id'].'&prog='.$_GET['prog'].'">Go Back</a>';
	include './../Inc/Footer.inc.php';
	exit;
   }

$resultfind = mysql_query("SELECT Username FROM members WHERE Username='".mysql_escape_string($_POST['username'])."'");
$bufferfind = mysql_fetch_assoc($resultfind);

if (empty($bufferfind['Username'])) {
   echo 'That username does not exist! Too bad, space cadet. Please insert another quarter and try again! :)';
   echo '<br/><br/><a href="Viewplan.php?id='.$_GET['id'].'&prog='.$_GET['prog'].'">Go Back</a>';
	include './../Inc/Footer.inc.php';
	exit;
   } else {  // THEY ENTERED A VALID USERNAME TO RESET TO - LET'S RESET THE PLAN TO PAY THIS NEW USER!


// IF WE NEED TO RESET THE CURRENT USERNAME'S EARNED AMOUNTS
// AMOUNTS ARE NOT ADDED INTO USER_PROGRAM UNTIL CRON IS RUN!
// WE MAY HAVE NO WAY OF KNOWING IF A CRON WAS RUN, SO WE NEED TO MAKE SURE EVERY ACTION LEAVES A TRAIL!
$resultloser = mysql_query("SELECT user_program_id FROM user_program as u JOIN members as m WHERE m.Username='{$bufferplan['username']}' AND m.ID=u.ID AND u.program_id={$_GET['prog']}");
$bufferloser = mysql_fetch_assoc($resultloser);

// DEBUGGING SESSION
if (!empty($_SESSION['debug']) && $_SESSION['debug'] === true) {
echo 'The OLD fart\'s user_program_id who got paid, but is now gonna lose it, is: ' .$bufferloser['user_program_id'];
echo '<br/>';
} // END DEUGGING SESSION

$datetime = date("Y-m-d H:i:s");
	
	// UPDATE PAYMENT PLAN ***************
	mysql_query("UPDATE payment_plan SET username='".$bufferfind['Username']."', manual_override='Y', manual_override_date='{$datetime}', old_username='{$bufferplan['username']}' WHERE payment_plan_id=".intval($_GET['plan']));


// FIND OUT IF PROGRAM IS SET TO ADMIN COLLECTS PAYMENT
$resultprog = mysql_query("SELECT program_collect FROM program WHERE program_id={$_GET['prog']}");
$bufferprog = mysql_fetch_assoc($resultprog);

// UPDATE PAYMENT LOG - BUT ONLY IF PROGRAM IS SET WHERE ADMIN COLLECTS PAYMENT - OTHERWISE IT WAS ALREADY PAID OUT.
//if ($bufferprog['program_collect'] == A) {

// GET NEW USER PROGRAM ID TO UPDATE PAYMENT LOG
$resultlog = mysql_query("SELECT user_program_id FROM user_program as u JOIN members as m WHERE m.Username='{$_POST['username']}' AND m.ID=u.ID AND program_id={$_GET['prog']}");
$bufferlog = mysql_fetch_assoc($resultlog);

$logplan = $_GET['plan'];

// FIND CURRENT USER PROGRAM ID TO UPDATE PAYMENT LOG BY SETTING THIS TO OLD USER PROGRAM ID
// UPDATE SEPT 13TH 2013 TO ALSO FIND LOG ID TO UPDATE, AND NOT UPDATE ALL LOGS WITH THE PAYMENT PLAN ID!!
$resultoldlog = mysql_query("SELECT user_program_id, cc_pending, payment_log_id, collected_by FROM payment_log WHERE payment_plan_id={$logplan}
ORDER BY payment_log_id DESC LIMIT 1");
$bufferoldlog = mysql_fetch_assoc($resultoldlog);

	// UPDATE PAYMENT LOG ****************
// UPDATE SEPT 13TH 2013  ONLY CHANGE THE LOG IF IT IS NOT PENDING, OTHERWISE IT WAS ALREADY PAID OUT!!!!!!!

if ($bufferoldlog['cc_pending'] != 'N') {

mysql_query("UPDATE payment_log SET user_program_id={$bufferlog['user_program_id']}, manual_override='Y', manual_override_date='{$datetime}', old_user_program_id={$bufferoldlog['user_program_id']} 
WHERE payment_log_id={$bufferoldlog['payment_log_id']}");

}

if ($bufferoldlog['collected_by'] != 'admin') {

	// JS UPDATE 10/28/15 TO STOP PAYING THE OLD USER!!
		mysql_query("UPDATE e4_arb SET active='N' WHERE program_id='{$_GET['prog']}' AND id_paying='{$_GET['id']}'") or die(mysql_error());	

}	


// OLD CONDITION -- WHERE payment_plan_id=".intval($_GET['plan']));

//}
	// UPDATE USER PAYMENT PLAN **************
	mysql_query("UPDATE user_payment_plan SET real_sponsorid='".mysql_escape_string($_POST['username'])."', manual_override='Y', manual_override_date='{$datetime}', old_real_sponsorid='{$bufferplan['username']}' WHERE user_payment_plan_id='{$bufferplan['user_payment_plan_id']}'");

	$Error_msg = 'Updated payment plan '.$_GET['plan'].'. This plan now pays <strong>'.$bufferfind['Username'].'</strong>.

<br/><br/>The username who was originally to be paid, but is now gonna lose it, is: <strong>' .$bufferplan['username'] .'</strong>.
<br/><br/>If the money for this initial sale was not already paid out to <strong>'.$bufferplan['username'].'</strong>,
<br/><br/>(i.e. you using "admin collects payments on behalf of members" OR you edited a started plan, where this payment has not yet been made at all),<br/><br/>then it will be paid to <strong>'.$bufferfind['Username'].'</strong>, along with all subsequent payments (if this is a subscription plan).
<br/><br/>If the initial sale was already paid out to <strong>'.$bufferplan['username'].'</strong>, then only subsequent payments will go to <strong>'.$bufferfind['Username'].'</strong> (if this is a subscription plan).
<br/><br/>
<strong>IMPORTANT!</strong> If you are using member to member payments, you should contact the payer <strong>'.$_SESSION['payer_username'].'</strong>,<br/>and alert them they need to login to their payment processor, and cancel their subscription to <strong>' .$bufferplan['username'] .'</strong>,<br/>and next login to '.$Global['webpage_url_ssl'].' to create a new payment to <strong>'.$bufferfind['Username'].'</strong>.<br/>They should do this last step near the time their subscription ends, to avoid paying for the same time twice.
</strong>
';
	}
}
// END EDIT PAYMENT PLAN OPTION
// XXX DELETE MASTER PLAN OPTION
elseif (!empty($_GET['do']) && $_GET['do'] == 'DeleteMaster') {
	//Update Master Payment plan set to history
	mysql_query("UPDATE user_payment_plan SET valid_plan='H' WHERE user_payment_plan_id=".intval($_GET['key']));
	//mysql_query("DELETE FROM payment_plan WHERE user_payment_plan_id=".intval($_GET['key']));

	$Error_msg = 'Deleted master payment plan '.$_GET['key'];
	}
// XXX ACTIVATE MASTER PAY PLAN
elseif (!empty($_GET['do']) && $_GET['do'] == 'ActivateMaster') {
	//Update Master Payment plan set to active=Y
	mysql_query("UPDATE user_payment_plan SET valid_plan='Y' WHERE user_payment_plan_id=".intval($_GET['key']));
	//mysql_query("DELETE FROM payment_plan WHERE user_payment_plan_id=".intval($_GET['key']));

	$Error_msg = 'Activated master payment plan '.$_GET['key'];
	}


if (!empty($Error_msg)) {
echo '<font color="FF0000">'.$Error_msg2.'</font><br /><br />';
echo '<font color="FF0000">'.$Error_msg.'</font><br /><br />';
}

//Find all information about the user and display it...
$result = mysql_query("SELECT * FROM members WHERE ID=".intval($_GET['id']));
$buffer = mysql_fetch_assoc($result);



$user_id = $buffer['ID'];
$_SESSION['payer_username'] = $buffer['Username'];

echo <<<EOD
<table align="center">
<tr>
<td>
<strong>User Information:</strong> <br />
ID: {$buffer['ID']}<br />

Username: <a href="./Finduser.php?username={$buffer['Username']}" target="_blank">{$buffer['Username']}</a> 
<a href="./memberlogin.php?id={$buffer['ID']}" target="_blank">Login As User</a><br />
First Name: {$buffer['First_Name']}<br />
Last Name: {$buffer['Last_Name']}<br />
Email: {$buffer['email']}<br />
<!--
	<form name="form" method="post" action="Loginuser.php" target="_blank">		
<input type="hidden" name="login" value="{$buffer['Username']}">      
<input type="hidden" name="completed" value="yes">
<input type="hidden" name="pass" value="{$buffer['Password']}">      
<input type="submit" value="Login As Member" class="input" name="Submit">
</form>
-->
</td>
</tr>
</table>
EOD;

//JS added $program_id, mysql and login links
$program_id = intval($_GET['prog']); //The id of the program in question

//$resultj = mysql_query("SELECT * FROM members as m JOIN user_program as u JOIN program as p WHERE m.ID=u.ID AND u.program_id=p.program_id AND m.ID='".$user_id."' AND u.program_id=$program_id");

//$bufferj = mysql_fetch_assoc($resultj);

echo '<center>';

//echo '<a href="memberlogin.php?id='.$user_id.'&rd=viewpayment.php?program='.$program_id.'" target="_blank">Member Earned</a> | 
//<a href="memberlogin.php?id='.$user_id.'&rd=viewdirectpayment.php?program='.$program_id.'" target="_blank">Member Received</a> |

echo '<a href="./Finduser.php?username='.$buffer['Username'].'">Return To Find User</a> | 
<a href="./Viewplan.php?id='.$user_id.'&prog='.$_GET['prog'].'" target="_self">Refresh</a><br />

<a href="memberlogin.php?id='.$user_id.'&rd=program.php?program='.$program_id.'&creatingplans=yes" target="_blank">Click here to create pay plans</a> (if you need to process them) and none exist!</center><br /><br />';

//END JS $program_id, mysql and login links

//Select program info
$user_result = mysql_query("SELECT user.*, prog.program_name, prog.program_type FROM user_program as user LEFT JOIN program as prog USING (program_id) WHERE user.ID={$buffer['ID']} && user.program_id=".intval($_GET['prog'])) or die(mysql_error());

$user_buffer = mysql_fetch_assoc($user_result);

if ($user_buffer['date_suspended'] == '0000-00-00 00:00:00')
$user_buffer['date_suspended'] = 'Unknown date (sometime prior to July 29th, 2013)'; 

if ($user_buffer['date_cancelled'] == '0000-00-00 00:00:00')
$user_buffer['date_cancelled'] = 'unknown date (sometime prior to July 29th, 2013)'; 

	if ($user_buffer['end_program'] == 'Y' && $user_buffer['user_status'] == 'Active') { $cancelled = ' (Time Remaining) - <font color="red">Membership Cancelled on '.$user_buffer['date_cancelled'].' </font>';
	} else {
	if ($user_buffer['user_status'] == 'Suspended') { $cancelled = '<font color="red"> on '.$user_buffer['date_suspended'].' </font>';
	} else {
	if ($user_buffer['user_status'] == 'Cancelled') { $cancelled = '<font color="red"> on '.$user_buffer['date_cancelled'].' </font>';

	} else {
	$cancelled = '';
	}
	}
	}

//QQQ update user program - start and end times!!!!!
//started expire start_time end_time
//SET `expire` =  '1433808000' 
	
echo <<<EOD
<table align="center">
<tr>
<td style="padding-top:25px;">
<strong>{$user_buffer['program_name']}</strong><br />
Status: {$user_buffer['user_status']} {$cancelled}<br />
EOD;

if (in_array($user_buffer['user_status'], $Global['good_status']) || $user_buffer['user_status'] == "Suspended") {
	$start_date = date($Global['datetime_format'], $user_buffer['started']);

	if ($user_buffer['user_status'] == $Global['active_status'] || $user_buffer['user_status'] == "Suspended") { 
	$expire_date = date ($Global['datetime_format'], $user_buffer['expire']);
	} 

if ($user_buffer['expire'] == $user_buffer['started'] || $user_buffer['program_type'] == 'N') $expire_date = 'NEVER';

	
	if (!empty($user_buffer['grace_expire'])) $grace = 'In grace period, it expires on '.date($Global['datetime_format'], $user_buffer['grace_expire']).'<br />';
	else $grace = '';
	
$period = 'Payment Period: '.$user_buffer['payment_period'];

if ($user_buffer['expire'] == $user_buffer['started'] || $user_buffer['program_type'] == 'N') $period = '';	

	echo <<<EOD
Start Date: {$start_date}<br />
Expire Date: {$expire_date}<br />{$grace}
{$period}
<br />
EOD;
	}

//Find all payment programs and display them
$result = mysql_query("SELECT master.*, master.grace_enabled as master_grace, plan.* FROM user_payment_plan as master LEFT JOIN payment_plan as plan USING (user_payment_plan_id) WHERE master.user_program_id={$user_buffer['user_program_id']} AND plan.username IS NOT NULL") or die('error1'.mysql_error());

$plan = array();
$master = array();
$active_plan = false;

while ($buffer = mysql_fetch_assoc($result))
	{
	$master[$buffer['user_payment_plan_id']] = array('plan' => $buffer['valid_plan'], 'started' => $buffer['timestamp_started'], 'ended' => $buffer['timestamp_ended'], 'grace' => $buffer['master_grace'], 'ip' => $buffer['signup_ip']);

	$plan[$buffer['user_payment_plan_id']][] = array('id' => $buffer['payment_plan_id'], 'username' => $buffer['username'], 'status' => $buffer['user_status'], 'amount' => $buffer['amount'], 'collected_by' => $buffer['collected_by'], 'type' => $buffer['payment_type'], 'plan_type' => $buffer['plan_type'], 'tier' => $buffer['payment_tier_level'], 'complete' => $buffer['payment_complete'], 'sec_complete' => $buffer['sec_payment_complete'], 'period' => $buffer['payment_period'], 'first' => $buffer['first_paid_date'], 'last' => $buffer['last_paid_date'], 'grace' => $buffer['grace_enabled'], 'grace_amount' => $buffer['grace_amount'], 'grace_reason' => $buffer['grace_reason'], 'pre_reason' => $buffer['grace_pre_reason'], 'grace_start' => $buffer['grace_start_date'], 'grace_end' => $buffer['grace_end_date'], 'manual_override' => $buffer['manual_override'], 'manual_override_date' => $buffer['manual_override_date'], 'old_username' => $buffer['old_username']);

	if ($buffer['valid_plan'] == 'Y') $active_plan = true;
	} // END WHILE LOOP!

$master_history = array();
$master_plan = '<tr><td style="padding-top:20px"><strong>Active Payment Plan</strong></td></tr>';
$history_plan = '<tr><td style="padding-top:20px"><strong>History Payment Plan</strong></td></tr>';
$started_plan = '<tr><td style="padding-top:20px"><strong>Started Payment Plan</strong></td></tr>';
$temp_plan = '<tr><td style="padding-top:20px"><strong>Temp Payment Plan</strong></td></tr>';

if ($user_buffer['program_type'] == 'S') $plan_status = 'Subscription';
else $plan_status = 'One Time Payment';

foreach ($plan as $key => $temp_value)
	{
	foreach ($temp_value as $value) 
		{
$transaction_info = false;
		$amount = number_format($value['amount'], 2);
		$type = program_type($value['type'], $value['tier']);
//print_r($value);
//echo "<br>";

//QQQ
//$collected_by = $log_buffer['collected_by'];
$collected_by = $value['collected_by'];

		if ($value['complete'] == 'Y') {
			
			$log_result = mysql_query("SELECT * FROM payment_log WHERE payment_plan_id={$value['id']} ORDER BY payment_log_id DESC LIMIT 1") or die(mysql_error());
			
			$log_buffer = mysql_fetch_assoc($log_result);
//print_r($log_buffer);
//echo "<br>";			
			$tran_info = false;

			if ($log_buffer['payment_processor'] == 'P') {
				$tran_result = mysql_query("SELECT tnx_id, custom_tnx_id, parent_txn_id FROM paypal_history WHERE payment_log_id={$log_buffer['payment_log_id']} ORDER BY paypal_history_id DESC LIMIT 1") or die(mysql_error());
				
				$tran_buffer = mysql_fetch_assoc($tran_result);
				
				$tran_info = ((!empty($tran_buffer['tnx_id']))?'-Trans ID: '.$tran_buffer['tnx_id'].'<br />':'').((!empty($tran_buffer['parent_txn_id']))?'-Parent ID: '.$tran_buffer['parent_txn_id'].'<br />':'').((!empty($tran_buffer['custom_tnx_id']))?'-Custom ID: '.$tran_buffer['custom_tnx_id'].'<br />':'');
				}
			elseif ($log_buffer['payment_processor'] == 'B') {
				$tran_result = mysql_query("SELECT receiver_address, transaction_hash FROM bitcoin_history WHERE payment_log_id={$log_buffer['payment_log_id']} ORDER BY bitcoin_history_id DESC LIMIT 1") or die(mysql_error());
				
				$tran_buffer = mysql_fetch_assoc($tran_result);
				
				$tran_info = ((!empty($tran_buffer['receiver_address']))?'-Receiver Bitcoin Address: '.$tran_buffer['receiver_address'].'<br />':'').((!empty($tran_buffer['transaction_hash']))?'-Transaction hash: '.$tran_buffer['transaction_hash'].'<br />':'');
				}
			elseif ($log_buffer['payment_processor'] == 'A') {
				$tran_result = mysql_query("SELECT ap_referencenumber, custom_referencenumber FROM alertpay_history WHERE payment_log_id={$log_buffer['payment_log_id']} ORDER BY alertpay_history_id DESC LIMIT 1") or die(mysql_error());
				
				$tran_buffer = mysql_fetch_assoc($tran_result);
				
				$tran_info = ((!empty($tran_buffer['ap_referencenumber']))?'-Trans ID: '.$tran_buffer['ap_referencenumber'].'<br />':'').((!empty($tran_buffer['custom_referencenumber']))?'-Custom ID: '.$tran_buffer['custom_referencenumber'].'<br />':'');
				}
			elseif ($log_buffer['payment_processor'] == 'S') {
				$tran_result = mysql_query("SELECT transaction_id, custom_transaction_id, subscription_id FROM safepay_history WHERE payment_log_id={$log_buffer['payment_log_id']} ORDER BY safepay_history_id DESC LIMIT 1") or die(mysql_error());
				
				$tran_buffer = mysql_fetch_assoc($tran_result);
				
				$tran_info = ((!empty($tran_buffer['transaction_id']))?'-Trans ID: '.$tran_buffer['transaction_id'].'<br />':'').((!empty($tran_buffer['subscription_id']))?'-Sub ID: '.$tran_buffer['subscription_id'].'<br />':'').((!empty($tran_buffer['custom_transaction_id']))?'-Custom ID: '.$tran_buffer['custom_transaction_id'].'<br />':'');
				}
			elseif ($log_buffer['payment_processor'] == 'GC') {
				$tran_result = mysql_query("SELECT order_number, custom_order_number FROM gc_history WHERE payment_log_id={$log_buffer['payment_log_id']} ORDER BY gc_history_id DESC LIMIT 1") or die(mysql_error());
				
				$tran_buffer = mysql_fetch_assoc($tran_result);
				
				$tran_info = ((!empty($tran_buffer['order_number']))?'-Trans ID: '.$tran_buffer['order_number'].'<br />':'').((!empty($tran_buffer['custom_order_number']))?'-Custom ID: '.$tran_buffer['custom_order_number'].'<br />':'');
				}
			elseif ($log_buffer['payment_processor'] == 'AN') {
				$tran_result = mysql_query("SELECT an.transaction_id, an.custom_transaction_id, an.subscription_id FROM cc_history as cc LEFT JOIN authorize_history as an USING (authorize_history_id) WHERE cc.payment_log_id={$log_buffer['payment_log_id']} ORDER BY cc.authorize_history_id DESC LIMIT 1") or die(mysql_error());
				
				$tran_buffer = mysql_fetch_assoc($tran_result);
				
				$tran_info = ((!empty($tran_buffer['transaction_id']))?'-Trans ID: '.$tran_buffer['transaction_id'].'<br />':'').((!empty($tran_buffer['subscription_id']))?'-Sub ID:'.$tran_buffer['subscription_id'].'<br />':'').((!empty($tran_buffer['custom_transaction_id']))?'-Custom ID: '.$tran_buffer['custom_transaction_id'].'<br />':'');
				}
			//new
			elseif ($log_buffer['payment_processor'] == 'LP') {
				$tran_result = mysql_query("SELECT lp.linkpoint_history_id, lp.custom_transaction_id, lp.subscription_id FROM cc_history as cc LEFT JOIN linkpoint_history as lp USING (linkpoint_history_id) WHERE cc.payment_log_id={$log_buffer['payment_log_id']} ORDER BY cc.linkpoint_history_id DESC LIMIT 1") or die(mysql_error());
				
				$tran_buffer = mysql_fetch_assoc($tran_result);
//print_r($tran_buffer);
//echo "<br>";				
				$tran_info = ((!empty($tran_buffer['linkpoint_history_id']))?'-Trans Order ID: '.$Global['cc_prefix']."-".$tran_buffer['linkpoint_history_id'].'<br />':'').((!empty($tran_buffer['custom_transaction_id']))?'-Custom ID: '.$tran_buffer['custom_transaction_id'].'<br />':'').((!empty($tran_buffer['subscription_id']))?'-Sub ID:'.$tran_buffer['subscription_id'].'<br />':'');
				}
			elseif ($log_buffer['payment_processor'] == 'STP') {
				$tran_result = mysql_query("SELECT stp.tr_id, stp.tr_id_custom, stp.subscription_id FROM solidtrustpay_history as stp WHERE stp.payment_log_id={$log_buffer['payment_log_id']} ORDER BY stp.solidtrustpay_history_id DESC LIMIT 1") or die(mysql_error());
				
				$tran_buffer = mysql_fetch_assoc($tran_result);
				
				$tran_info = ((!empty($tran_buffer['tr_id']))?'-Trans ID: '.$tran_buffer['tr_id'].'<br />':'').((!empty($tran_buffer['subscription_id']))?'-Sub ID:'.$tran_buffer['subscription_id'].'<br />':'').((!empty($tran_buffer['tr_id_custom']))?'-Custom ID: '.$tran_buffer['tr_id_custom'].'<br />':'');
				}
		
			elseif ($log_buffer['payment_processor'] == 'PSI') {
				$tran_result = mysql_query("SELECT psi.transaction_id, psi.subscription_id FROM cc_history as cc LEFT JOIN psigate_history as psi USING (psigate_history_id) WHERE cc.payment_log_id={$log_buffer['payment_log_id']} ORDER BY psi.psigate_history_id DESC LIMIT 1") or die(mysql_error());
				
				$tran_buffer = mysql_fetch_assoc($tran_result);
				
				$tran_info = ((!empty($tran_buffer['transaction_id']))?'-Trans ID: '.$tran_buffer['transaction_id'].'<br />':'').((!empty($tran_buffer['subscription_id']))?'-Sub ID:'.$tran_buffer['subscription_id'].'<br />':'');
				}



// CHECK LOG STATUS OF CC_PENDING

if ($log_buffer['cc_pending'] == 'Y') {

$cc_pending_status = 'Pending';

} else if ($log_buffer['cc_pending'] == 'A') { 

$cc_pending_status = 'Awaiting Payment';

} else if ($log_buffer['cc_pending'] == 'N' && $log_buffer['chargeback'] == 'Y') { 

$cc_pending_status = 'Refunded';

} else if ($log_buffer['cc_pending'] == 'N' && $log_buffer['chargeback'] != 'Y') { 

$cc_pending_status = 'Paid Out';

}


			
// temp change for BITCOIN
/*if ($log_buffer['payment_processor_custom'] == "" && $log_buffer['payment_processor'] == "")  $log_buffer['payment_processor_custom'] = "Bitcoin";*/		
			if (!empty($tran_info)) {
				$transaction_info = 'Transaction Info: <br /><div style="padding-left: 10px">-Name: '.(($log_buffer['payment_processor'] == 'CC')?((!empty($log_buffer['payment_processor_custom']))?$log_buffer['payment_processor_custom']:'Custom Processor'):$Global['processor_info'][$log_buffer['payment_processor']]).'<br />-Amount: $'.number_format($log_buffer['amount'], 2).'<br />-Date: '.date($Global['datetime_format'], $log_buffer['timestamp']).'<br />'.$tran_info.'<br />


-<a href="./Payment-Logs.php?username='.$payer_username.'&prog='.$_GET['prog'].'&searchway=username_who_paid&cc_pending=ALL&show_logs_to_admin=yes&show_logs_to_cancelled=yes" target="_blank">Payment Log</a> ID '.$log_buffer['payment_log_id'].'<br />-Payment Log Commission Pay Out Status: '.$cc_pending_status.'</div>';
				}
			elseif (!empty($log_buffer['payment_log_id'])) {
				$transaction_info = 'Transaction Info: <br /><div style="padding-left: 10px">-Name: '.(($log_buffer['payment_processor'] == 'CC' || empty($log_buffer['payment_processor']))?((!empty($log_buffer['payment_processor_custom']))?$log_buffer['payment_processor_custom']:'Custom Processor'):$Global['processor_info'][$log_buffer['payment_processor']]).'<br />-Amount: $'.number_format($log_buffer['amount'], 2).'<br />-Date: '.date($Global['datetime_format'], $log_buffer['timestamp']).'<br />-Payment Log ID '.$log_buffer['payment_log_id'].'<br />-Payment Log Commission Pay Out Status: '.$cc_pending_status.'</div>';
				}
			else {
				$transaction_info = 'Transaction Info: <br /><span style="padding-left: 10px"><font color="red">No Payment Log Was Found.</font></span><br/>

<span style="padding-left: 10px"><font color="red">No Commissions Will Be Rewarded Without A Payment Log.</font></span><br/>

<span style="padding-left: 10px">
<a href="Viewplan.php?id='.$_GET['id'].'&prog='.$_GET['prog'].'&do=CreateLog&plan='.$value['id'].'">Click Here To Create A Payment Log</a> 
<br /><br /></span>';
				}

// JS ADDED IPAYOUT JULY 30 2013
			if ($log_buffer['payment_processor'] == 'IP') {
				$tran_result = mysql_query("SELECT trnx_id FROM ipayout_history WHERE payment_log_id={$log_buffer['payment_log_id']} ORDER BY ipayout_history_id DESC LIMIT 1") or die(mysql_error());
				
				$tran_buffer = mysql_fetch_assoc($tran_result);
				
				$tran_info = ((!empty($tran_buffer['transaction_id']))?'-Trans ID: '.$tran_buffer['trnx_id'].'<br />':'').((!empty($tran_buffer['trnx_id']))?'-Transaction ID:'.$tran_buffer['trnx_id'].'':'');
				

				$transaction_info = 'Transaction Info: <br /><div style="padding-left: 10px">-Name: 
<a href="/ipt/getpayplans.php?u='.$_SESSION['payer_username'].'" target="_blank">Ipayout</a><br />-Amount: $'.number_format($log_buffer['amount'], 2).'<br />-Date: '.date($Global['datetime_format'], $log_buffer['timestamp']).'<br />'.$tran_info.'<br />

-<a href="./Payment-Logs.php?username='.$_SESSION['payer_username'].'&prog='.$_GET['prog'].'&searchway=username_who_paid&cc_pending=ALL&show_logs_to_admin=yes&show_logs_to_cancelled=yes" target="_blank">Payment Log</a> ID 

<a href="./Payment-Logs.php?username='.$_SESSION['payer_username'].'&prog='.$_GET['prog'].'&searchway=username_who_paid&cc_pending=ALL&show_logs_to_admin=yes&show_logs_to_cancelled=yes&log_id='.$log_buffer['payment_log_id'].'" target="_blank">'.$log_buffer['payment_log_id'].'</a><br />-Payment Log Commission Pay Out Status: '.$cc_pending_status.' </div>';

			}
						

// DETERMINED CURRENT PAYMENT COMPLETE IS NOT REQUIRED, AND LEGACY CODE COMMENTS DIRECTLY CONFLICT ON IT'S PROPER USE				
//			$completed = 'Payment Started: Yes<br />Date Started: '.date($Global['datetime_format'], $value['first']).'<br />Last Payment Finished: '.date($Global['datetime_format'], $value['last']).'<br />Current Payment Complete: '.(($value['sec_complete'] == 'Y')?'Yes':'No').'<br />Payment Period: '.$value['period'].'<br />';

//echo $value['first']; exit;

if (is_null($value['first_date'])) $value['first_date'] = $user_buffer['started'];

			$completed = 'Payment Started: Yes<br />Date Started: '.date($Global['datetime_format'], $value['first_date']).'<br />Last Payment Finished: '.date($Global['datetime_format'], $value['last']).'<br />Payment Period: '.$value['period'].'<br />';



			if ($value['grace'] == 'Y') {
				$grace_amount = number_format($value['grace_amount'], 2);
				
				if ($value['grace_reason'] == 'LP') $reason = 'Late Payment';
				elseif ($value['grace_reason'] == 'TM') $reason = 'Replaced Payment Plan';
				elseif ($value['grace_reason'] == 'C') $reason = 'Chargeback';
				else $reason = 'Unknown';

					$completed .= '<span style="color: #F00;"><br />Active Grace Period: Yes<br />Additional Grace Amount: $'.$grace_amount.'<br />Grace Reason: '.$reason.'<br />Grace Start: '.date($Global['datetime_format'], $value['grace_start']).'<br />Grace Expire: '.date($Global['datetime_format'], $value['grace_end']).'<br />';

				}
			else {
				$completed .= 'Active Grace Period: No<br />';
				}
			}
		else {
			$completed = 'Payment Started: No<br />';
			}
		
		if ($value['plan_type'] == 'S') $pay_status = 'Subscription';
		else $pay_status = 'One Time Payment';
			
		if ($value['period'] == 0 || $value['plan_type'] == 'S' || $value['plan_type'] == 'N') {
			$show_links = '<br />Edit: <!--<a href="Viewplan.php?id='.$_GET['id'].'&prog='.$_GET['prog'].'&do=Process&plan='.$value['id'].'">Process Payment</a> |--> <a href="Viewplan.php?id='.$_GET['id'].'&prog='.$_GET['prog'].'&do=Refund&plan='.$value['id'].'&log='.$log_buffer['payment_log_id'].'">Refund This Payment</a>';
 
		if ($value['plan_type'] == 'S') $show_links .= '	| <a href="Viewplan.php?id='.$_GET['id'].'&prog='.$_GET['prog'].'&do=Remove&plan='.$value['id'].'">Remove Period</a>';
			
//| <a href="Viewplan.php?id='.$_GET['id'].'&prog='.$_GET['prog'].'&do=RemoveGrace&plan='.$value['id'].'">Remove Grace Status If Needed</a>';

// REMOVED THE DELETE LINK FROM ABOVE FOR NOW - AS THE DELETE FUNCTION PER PLAN, CURRENTLY LEAVES OLD DATA SHOWING <a href="Viewplan.php?id='.$_GET['id'].'&prog='.$_GET['prog'].'&do=DeletePlan&plan='.$value['id'].'">Delete Plan</a>

// QQQ THEORY IS DELETE PLAN SHOULD ONLY SHOW AS AN OPTION WHEN THEIR ARE MULTIPLE PLANS WITHIN THE USER PAY PLAN. HOWEVER, IT MAY NOT BE POSSIBLE TO SET UP JUST ONE NEW PLAN INSIDE THE USER PAY PLAN, IF ONLY ONE PAY PLAN IS DELETED, SO THIS NEEDS TO BE TESTED. IF ONE CANNOT SET UP NEW PAY PLANS, THEN THE DELETE PLAN OPTION SHOULD NEVER BE RE-INSTATED.

			}
		else {
	$show_links = '<br />Edit: <a href="Viewplan.php?id='.$_GET['id'].'&prog='.$_GET['prog'].'&do=DeletePlan&plan='.$value['id'].'">Delete Plan</a>';
			}

// CHANGE WHO GETS PAID QQQ

if ($value['plan_type'] == 'S') {
$editplan = <<<EOD
<table align="center" bgcolor="#FFFFFF"><tr><td>

	<form enctype="multipart/form-data" method="POST" action="{$_SERVER['PHP_SELF']}?id={$_GET['id']}&prog={$_GET['prog']}&do=Process&plan={$value['id']}&do=EditPlan">
	Paid To Username: <input type="text" name="username" value="{$value['username']}">
	<input type="submit" value="Change Who Gets Paid">
     </form>  

</td></tr></table>
<br/>
EOD;
}


// XXX ADDING DELETE MASTER PLAN FUNCTION
    //	if ($value['valid_plan'] == 'Y') {
			if ($key != "") $delete_master_plan = '<a href="Viewplan.php?id='.$_GET['id'].'&prog='.$_GET['prog'].'&do=DeleteMaster&key='.$key.'">Delete Master Plan</a>';
			else $delete_master_plan = "";
// XXX ADDING ACTiVATE MASTER PLAN FUNCTION
			if ($key != "") $activate_master_plan = '<a href="Viewplan.php?id='.$_GET['id'].'&prog='.$_GET['prog'].'&do=ActivateMaster&key='.$key.'">Activate Master Plan</a>';
			else $activate_master_plan = "";
//}

// QUERIES TO BORROW FROM OR USE
// DO NOT UNCOMMENT THESE!!!!!!!!!!!!!!

 /*
mysql_query("UPDATE user_payment_plan SET valid_plan='H', timestamp_ended=$timestamp WHERE user_payment_plan_id=$user_payment_plan_id") or die(mysql_error());

mysql_query("DELETE FROM user_payment_plan WHERE valid_plan='N' && user_program_id=$user_program_id") or die(mysql_error());

mysql_query("UPDATE user_program SET user_status='{$Global['unpaid_status']}', sign_id=0, user_qualify=0, user_signup=0, started=NULL, expire=NULL, payment_period=0 WHERE ID=$payer_id && program_id=$program_id") or die(mysql_error());
 */

	if ($value['manual_override'] == 'Y') {
		$ManuallyEdited = '<strong>Manually Edited On: '.date($Global['datetime_format'],strtotime($value['manual_override_date'])).'</strong><br/>Old Receiving Username: '.$value['old_username'].'<br/>'; 
	} else {
		$ManuallyEdited = '';
	}

// END DELETE MASTER PLAN LINKS

		switch ($master[$key]['plan']) {
			case 'Y':
				if (!in_array($key, $master_history)) {
					$date = date($Global['datetime_format'], $master[$key]['started']);

					if ($master[$key]['grace'] == 'Y') $master_grace = 'Yes';
					else $master_grace = 'No';

					$master_plan .= <<<EOD
<tr>
<td style="padding-bottom:20px">
Master (User Payment Plan ID): {$key} {$delete_master_plan}<br />
Plan Status: Active<br />
Plan Type: {$plan_status}<br />
Started: {$date}<br />
Active Grace Period: {$master_grace}<br />
User IP: {$master[$key]['ip']}<br />
</td>
</tr>
EOD;
					$master_history[] = $key;
					}

				$master_plan .= <<<EOD
<tr>
<td style="padding-left:20px; padding-bottom:20px">
Payment Plan ID: {$value['id']}<br />
Payment Type: {$type}<br />
Payment Amount: \${$amount}<br />
Payment Is A: {$pay_status}<br />
{$ManuallyEdited} 
Receiving Username: 

<a href="memberlogin.php?username={$value['username']}&rd=viewpayment.php?program={$program_id}" target="_blank">
{$value['username']}</a><br />
Receiving User Status: {$value['status']}<br />{$completed}
<b>Collected by: {$collected_by}</b><br/>
{$transaction_info}
{$show_links} 
{$editplan}
</td>
</tr>
EOD;
				break;
			case 'H':
				if (!in_array($key, $master_history)) {
					$date = date($Global['datetime_format'], $master[$key]['started']);
					$end_date = date($Global['datetime_format'], $master[$key]['ended']);

					if ($master[$key]['grace'] == 'Y') $master_grace = 'Yes';
					else $master_grace = 'No';

					$history_plan .= <<<EOD
<tr>
<td style="padding-bottom:20px">
Master (User Payment Plan ID): {$key} {$activate_master_plan}<br />
Plan Status: History<br />
Plan Type: {$plan_status}<br />
Started: {$date}<br />
Ended: {$end_date}</br>
Active Grace Period: {$master_grace}<br />
User IP: {$master[$key]['ip']}<br />
</td>
</tr>
EOD;
					$master_history[] = $key;
					}

				$history_plan .= <<<EOD
<tr>
<td style="padding-left:20px; padding-bottom:20px">
Payment Plan ID: {$value['id']}<br />
Payment Type: {$type}<br />
Payment Amount: \${$amount}<br />
Payment Is A: {$pay_status}<br />
Receiving Username: {$value['username']}<br />
Receiving User Status: {$value['status']}<br />{$completed}
<b>Collected by: {$collected_by}</b><br/>
{$transaction_info}
</td>
</tr>
EOD;
				break;
			case 'S':
				if (!in_array($key, $master_history)) {
					$date = date($Global['datetime_format'], $master[$key]['started']);

					if ($master[$key]['grace'] == 'Y') $master_grace = 'Yes';
					else $master_grace = 'No';

					$started_plan .= <<<EOD
<tr>
<td style="padding-bottom:20px">
Master (User Payment Plan ID): {$key} {$delete_master_plan} | {$activate_master_plan}<br />
Plan Status: Started<br />
Plan Type: {$plan_status}<br />
Started: {$date}<br />
Active Grace Period: {$master_grace}<br />
User IP: {$master[$key]['ip']}<br />
</td>
</tr>
EOD;
					$master_history[] = $key;
					}
				
				if ($active_plan == false) {
					$edit = $show_links;
					}
				else {
					$edit = '';
					}

				$started_plan .= <<<EOD
<tr>
<td style="padding-left:20px; padding-bottom:20px">
Payment Plan ID: {$value['id']}<br />
Payment Type: {$type}<br />
Payment Amount: \${$amount}<br />
Payment Is A: {$pay_status}<br />
{$ManuallyEdited} 
Receiving Username: {$value['username']}<br />
Receiving User Status: {$value['status']}<br />
<b>Collected by: {$collected_by}</b><br/>
{$completed}
{$transaction_info}
{$show_links} 
{$editplan}

</td>
</tr>
EOD;
				break;
			default:
				if (!in_array($key, $master_history)) {	
					$temp_plan .= <<<EOD
<tr>
<td style="padding-bottom:20px">
Master (User Payment Plan ID): {$key} {$delete_master_plan}<br />
Plan Status: Temp<br />
Plan Type: {$plan_status}<br />
User IP: {$master[$key]['ip']}<br />
</td>
</tr>
EOD;
					$master_history[] = $key;
					}
				
				if ($active_plan == false) {
					$edit = $show_links;
					}
				else {
					$edit = '';
					}

				$temp_plan .= <<<EOD
<tr>
<td style="padding-left:20px; padding-bottom:20px">
Payment Plan ID: {$value['id']}<br />
Payment Type: {$type}<br />
Payment Amount: \${$amount}<br />
Payment Is A: {$pay_status}<br />
Receiving Username: {$value['username']}<br />
Receiving User Status: {$value['status']}<br />{$completed}
<b>Collected by: {$collected_by}</b><br/>
{$edit}
</td>
</tr>
EOD;
				break;
			}
		}
	}

echo $master_plan, $started_plan, $history_plan, $temp_plan.'</table>';

include './../Inc/Footer.inc.php';
?>