<?php
  /**
   * For creating a new Admin User
   * 
   * @author Kailash Badu - Kaizen Web-Productions (http://www.kaizen-web.com)   
   * @copyright Copyright(C), Kaizen Web-Productions, 2004-2008, All Rights Reserved.
   */
$pageName = 'Add Administrator User';
$pageDesc = '';
$pageIcon = '';
$pageAlign = 'center';
$pageClass = '';
   
  require_once('./../../Sub/Config.inc.php');
  require_once('./../Inc/Login.inc.php');
  include_once $Global['path'].''.$Global['admin_dir'].'/Lib/Invoice.inc.php';
  if ($loggedUser->checkPermisson('MANAGE_USERS') === false) {
    $errorMessage = 'You are not allowed to access this page.';
    require_once('./../Inc/error.php');
    exit();   
  }  
  //find available access rights
  $sql = "SELECT permission_id, permission_name FROM permission";
  $result = mysql_query($sql);
  $permissions =  array();
  while($row = mysql_fetch_assoc($result)){
  	$permissions[$row['permission_id']] = $row['permission_name'];
  }
  //set default values for form fields
  $username = $firstname = $lastname = $password = $confirmpassword = $email = '';
  $accessRights = array();
  
  if (isset($_POST['formaction']) && $_POST['formaction'] == 'adduser') {
		$error = array();
		
		$username  = isset($_POST['username']) ? strip_tags(trim($_POST['username'])) : '';
		$firstname = isset($_POST['firstname']) ? strip_tags(trim($_POST['firstname'])) : '';
		$lastname  = isset($_POST['lastname']) ? strip_tags(trim($_POST['lastname'])) : '';
		$password  = isset($_POST['password']) ? strip_tags(trim($_POST['password'])) : '';
		$confirmpassword  = isset($_POST['confirmpassword']) ? strip_tags(trim($_POST['confirmpassword'])) : '';
		$email  = isset($_POST['email']) ? strip_tags(trim($_POST['email'])) : '';
		$accessRights = isset($_POST['accessRights']) ? $_POST['accessRights'] : array();
		//username
		if (strlen($username) == 0) {
			$error[] = 'Please specify the username';
		}
		elseif (strlen($username) > 50) {
			$error[] = 'The username cannot be larger than 50 characters';
		}
		
		//check username is unique
		if (empty($error)) {
			$sql = "SELECT COUNT(*) as total FROM members where username = '%s'";
			$sql = sprintf($sql, mysql_real_escape_string($username));
			$countResult = mysql_query($sql);
			$countRow = mysql_fetch_assoc($countResult);
			if($countRow['total'] > 0) $error[] = 'The username is already taken. Try another';			 
		}
		
		//first name
		if (strlen($firstname) == 0) {
			$error[] = 'Please specify the First Name';
		}
		elseif (strlen($firstname) > 100) {
			$error[] = 'The First Name cannot be larger than 100 characters';
		}
		
		//last name
		if (strlen($lastname) == 0) {
			$error[] = 'Please specify the First Name';
		}
		elseif (strlen($lastname) > 100) {
			$error[] = 'The Last Name cannot be larger than 100 characters';
		}
		
		//password
		if (strlen($password) == 0) {
			$error[] = 'Please specify the password';
		}
		elseif (strlen($password) > 50) {
			$error[] = 'The password cannot be larger than 50 characters';
		}
		elseif ($password != $confirmpassword) {
			$error[] = 'The passwords do not match';
		}
		
		//email
		if(strlen($email) == 0){
			$error[] = 'Please specify the email';
		}
		elseif (!preg_match('/(^[\w\.!#$%"*+\/=?`{}|~^-]+)@(([-\w]+\.)+[A-Za-z]{2,})$/' , $email)) {
  			$error[] = 'Please specify the valid email address';
 		}
		
		//Access Rights
		if (empty($accessRights)) {
			$error[] = "The user must be assigned at least one access right";
		}
		
		if (array_intersect($accessRights, array_keys($permissions)) != $accessRights) {
			$error[] = 'Please select valid access permissions only';
		}
		
		
		//ok, now start inserting the values
		if (empty($error)){
			
			$sql = "INSERT INTO members SET Username ='%s', First_Name = '%s', Last_Name = '%s', password = '%s', email = '%s', Signdate = NOW()";
			$sql = sprintf ($sql,
							mysql_escape_string($username),
							mysql_escape_string($firstname),
							mysql_escape_string($lastname),
							mysql_escape_string($password),
							mysql_escape_string($email)
						);
			mysql_query($sql) || die(mysql_error());
			$insertId = mysql_insert_id();
			$rawsql = "INSERT INTO user_permission SET user_id = %d, permission_id = %d";
			foreach ($accessRights as $value) {
				$sql = sprintf($rawsql, $insertId, $value);
				mysql_query($sql) || die(mysql_error());
			}
			$_SESSION['message']['useradd'] = 'A new User was successfully Added';

			//check if we have to add a store
			if ((int)$_POST['store'] > 0) {

			    copy_store($_POST['store'], $insertId, $username, $username, $email);
			    }
			elseif ((int)$_POST['store'] == 0) {

			    empty_store($insertId, $username, $username, $email);
			    }

			header('Location: userManage.php');
			exit();
		}
  }

//get the store names in order to use them for copy
$sql = 'SELECT store_id, store_name FROM store';
$result = mysql_query($sql);
$stores = array();
while ($buffer = mysql_fetch_assoc($result)) {

	$stores[$buffer['store_id']] = $buffer['store_name'];
	}

  require_once('./../Inc/Header.inc.php');  
?>
   <h2>Add Administrator User</h2>
   <?php if(isset($error) && count($error) > 0): ?>
   		<ul>
			<?php while(list(, $errormsg) = each($error)):?>
				<li><?php print $errormsg ?></li>
			<?php endwhile; ?>
		</ul>
	<?php endif; ?>
   <form method="post" action="<?php print $_SERVER['PHP_SELF'];?>" >
   <center>
   <table style="border-collapse:collapse">
   		<tr>
			<td>Username:</td>
			<td><input type="text" name="username" value="<?php print $username; ?>" /></td>		
		</tr>
		<tr>
			<td>First Name: </td>
			<td><input type="text" name="firstname" value="<?php print $firstname; ?>" /></td>		
		</tr>
		<tr>
			<td>Last name:</td>
			<td><input type="text" name="lastname" value="<?php print $lastname; ?>" /></td>
		</tr>
		<tr>
			<td>Passsword</td>
			<td><input type="password" name="password" value="<?php print $password; ?>" /></td>
		</tr>
		<tr>
			<td>Confirm Password:</td>
			<td><input type="password" name="confirmpassword" value="<?php print $confirmpassword; ?>" /></td>
		</tr>
		<tr>
			<td>Email:</td>
			<td><input type="text" name="email" value="<?php print $email; ?>"></td>
		</tr>
		<tr valign="top">
			<td>Access Rights:</td>
			<td>
				<?php foreach($permissions as $key => $value){ 
           $checked = in_array($key, $accessRights) ? 'checked = "checked"' : '';
           if (strpos($value, "STORE_") !== 0) {
        ?>
					<input type="checkbox" name="accessRights[]" <?php print $checked?> value="<?php print $key; ?>" /> <?php print $value;?> <br /> 
				<?php }} ?>
			</td>
		</tr>
		<tr>
			<td>Store:</td>
			<td>
			    <select name="store">
				<option value="-1" <?php if (isset ($_POST['store']) && $_POST['store'] == -1) echo 'selected="selected"' ?>>No Store</option>
				<option value="0" <?php if (isset ($_POST['store']) && $_POST['store'] == 0) echo 'selected="selected"' ?>>Empty Store</option>
				<?php foreach($stores as $store_id_arr => $store_info) { ?>
				<option value="<?php echo $store_id_arr; ?>" <?php if (isset ($_POST['store']) && $_POST['store'] == $store_id_arr) echo 'selected="selected"' ?>>Copy Store: <?php echo $store_info; ?></option>
				<?php } ?>
			    </select>
			</td>
		</tr>
		<tr>
			<td colspan="2"><center>
				<input type="hidden" name="formaction" value="adduser" />
				<input type="submit" name="submit" value="Add user" />
			</td>
		</tr>
   </table>
   </form>
<?php
  require_once('./../Inc/Footer.inc.php');
?>
