<?php
//-----------------------------------------------------------------
// Software: Automatic Web Software (AWS) built with PHPCPR
// Firm: DirectSalesMLM.com / AutomaticWebSoftware.com / PHPCPR.com
// Author: Jim Symonds Email: jim@directsalesmlm.com
// Copyright 2006 - 2024 Jim Symonds All Rights Reserved.
//-----------------------------------------------------------------
include './../../Sub/Config.inc.php';
include './../../phpcpr.php';
include './../Inc/Login.inc.php';

if ($loggedUser->checkPermisson('ADD_PROGRAM') === false){
  $errorMessage = 'You are not allowed to access this page.';
  require_once('./../Inc/error.php');
  exit();   
}

//error_reporting(-1);
//$_SESSION['debug'] = true;

// COMMENT WHEN TESTING IS DONE!!!
//$_SESSION['dev'] = '';
 /*
if ($_GET['dev'] == '' && $_SESSION['dev'] == '' && $_SESSION['loggedin'] != 'testwalkthru') { // LOCKING PAGE FOR DEVELOPER USE ONLY!!
//include_once './header.php';
echo 'We\'re sorry. This area is temporarily down for maintenance. Please check back soon!';
//include_once './footer.php';
exit;
} else {
$_SESSION['dev'] = true;
}
 */
$datetimenow = date("Y-m-d H:i:s");
	
$pageName = 'Viewing Bank Balances';
$pageDesc = '';
$pageIcon = '';
$pageAlign = 'center';
$pageClass = '';

include './../Inc/Header.inc.php';

$display = ''; // INI VAR

$timestamp = time();
$too_old_date = date("Y-m-d H:i:s",strtotime("-180 day", $timestamp)); 

$selectFields = 'sum(amount) as balance, usrid';
$mainTable = 'transactions_log';
$where = [
    'description' => ['!=', 'CHARGEBACKW']
];
$groupBy = 'usrid';
$result = select($selectFields, $mainTable, [], $where, $groupBy, null, null, 0, 1);

$total_bank_balances = 0;

	foreach ($result as $buffer) {
		$whereMember = [
			'ID' => ['=', $buffer['usrid']]
		];

		$memberDetails = select('ID, Username, Status', 'members', [], $whereMember, null, null, null, 0, 1);
		$bufferm = $memberDetails[0] ?? null;

		// SKIP ANY CANCELLED USERS!!
		if ($bufferm['Status'] == 'Cancelled') continue;

		$whereLog = [
			'ID' => ['=', $buffer['usrid']],
			'log_login_success' => ['=', 1]
		];
		$orderByLog = 'member_log_id DESC';
		$limitLog = 1;

		$lastLoginTime = select('log_time', 'member_log', [], $whereLog, null, null, $orderByLog, $limitLog, 1);
		$bufferlog = $lastLoginTime[0] ?? null;
		
		
		//echo '<br>TOO OLD DATE: '.$too_old_date;
		//echo '<br>Last Login Date: '.$bufferlog['log_time'].'<br>';

		// SKIP ANY USERS WHO HAVEN'T LOGGED IN SINCE X MONTHS AGO!!
		//if ($bufferlog['log_time'] < $too_old_date) continue;		
		
		
		$balance = $buffer['balance'];
		
		if (isset($_GET['show']) && $_GET['show'] == 'negative') {
			// SHOW ONLY NEGATIVE BALANCES!
			$title = 'Showing Only Negative Bank Balances';
			if ($balance >= 0 || $buffer['usrid'] == 1) continue;
			// SHOW ONLY NEGATIVE BALANCES MORE THAN $100
			//if (abs($balance) < 100) continue;

		} else {
		// IF BALANCE LESS THAN OR 0, OR USER IS ADMIN, WE SKIP THEM!
		if ($balance <= 0 || $buffer['usrid'] == 1) continue;
			$title = 'Showing All Current Bank Balances';
		}	
			
		if ($buffer['usrid'] == 1) continue;
		//echo '<h5>User ID: '.$buffer['usrid'].' Bank Balance: $'.$balance;
		
		if (isset($bufferlog['log_time'])) $log_date = substr($bufferlog['log_time'], 0, -9); 
		else $log_date = 'N/A';

		$display .= ' Member ID: '.$bufferm['ID'].' Username: <a href="memberlogin.php?username='.$bufferm['Username'].'&rd=bankledger.php" target="_blank">'.$bufferm['Username'].'</a> Last Login: '.$log_date.' Bank Balance: $'.$balance.'<br/>';
		$display .= '<br/></h5>';
		
		$total_bank_balances = $total_bank_balances + $balance;
		$total_bank_balances = floor($total_bank_balances * 100) / 100;

	}
	
echo '<h2>'.$title.'</h2>';	
	
	echo '<h3>Total Bank Balances: $'.$total_bank_balances.'</h3>';
?>
<!-- HIDE ON MATRIX ONLY SYSTEM
Note: This display does not include <a href="Payment.php" target="_blank">commissions pending</a> the holding period, nor does it include <a href="pay_commissions.php" target="_blank">pending withdrawal requests</a>.
-->
Note: This display does not include <a href="pay_commissions.php" target="_blank">pending withdrawal requests</a>.
<br/><br/>
<a href="bank_balances.php?show=negative">Show only negative balances</a>
<br/><br/>

<?php
echo '<br>'.$display;	

//echo '<br/><br/>Showing only users who have logged in, within the last 6 months.';

include './../Inc/Footer.inc.php';
?>
