<?php
//-----------------------------------------------------------------
// Software: Automatic Web Software (AWS) built with PHPCPR
// Firm: DirectSalesMLM.com / AutomaticWebSoftware.com / PHPCPR.com
// Author: Jim Symonds Email: jim@directsalesmlm.com
// Copyright 2006 - 2024 Jim Symonds All Rights Reserved.
//-----------------------------------------------------------------
include './../../Sub/Config.inc.php';
include './../../phpcpr.php';
include './../Inc/Login.inc.php';

if ($loggedUser->checkPermisson('ADD_PROGRAM') === false){
  $errorMessage = 'You are not allowed to access this page.';
  require_once('./../Inc/error.php');
  exit();   
}

//error_reporting(-1);
//$_SESSION['debug'] = true;

// COMMENT WHEN TESTING IS DONE!!!
//$_SESSION['dev'] = '';
 /*
if ($_GET['dev'] == '' && $_SESSION['dev'] == '' && $_SESSION['loggedin'] != 'testwalkthru') { // LOCKING PAGE FOR DEVELOPER USE ONLY!!
//$_SESSION['UserID'] = 81; // FOR TESTING ONLY!!
//include_once './header.php';
echo 'We\'re sorry. This area is temporarily down for maintenance. Please check back soon!';
//include_once './footer.php';
exit;
} else {
$_SESSION['dev'] = true;
}
 */
$datetimenow = date("Y-m-d H:i:s");
$date = date("Y-m-d");
$payoutdate = $datetimenow;
$card_fee = '19.95';

// CALCULATE AMOUNT OF CC FEES - SET HERE AS 20% !!!!
//$cc_fees = ($pending * .20);

// CACLCULATE PENDING MINUS FEES
//$pending_minus_fees = ($pending - $cc_fees);

	
$pageName = 'Admin Bank Manager';
$pageDesc = 'Debit or Credit Member Bank Accounts';
$pageIcon = 'icon-credit-card';
$pageAlign = 'center';
$pageClass = '';

include './../Inc/Header.inc.php';

// BANK OPENING PAGE!
if ($_REQUEST['type'] == '' && $_GET['reward_user'] == '' && $_GET['amount'] == '') {
	echo '<h1>Credit or Debit Member Account</h1>';	
	echo '<p></p><p></p>';
	echo "<a class=\"links\" href=\"bankpay.php?type=debit\">Debit Member</a> | <a class=\"links\" href=\"bankpay.php?type=credit\">Credit Member</a>";
	include_once './../Inc/Footer.inc.php';
	exit;
}
//if ($_REQUEST['type'] == '') $_REQUEST['type'] == 'debit';

$number1=rand(1,10);
$number2=rand(1,5);

$pay_status = 'PAID';

// TOTAL AMOUNT THAT WILL BE WITHDRAWN
// PREVENT SQL INJECTION!!
$user = $_REQUEST['reward_user'];
$status_explanation = $_POST['explanation'];
$amount = $_REQUEST['amount'];

// WHEN UPDATING PAYOUT OPTIONS HERE, REMEMBER TO ALSO UPDATE pay_commissions.php (FOR MASSPAY PAYOUTS)

$selectFields = 'ID, Username, payout_method, debitcard, paypalaccount, bitcoin';
$mainTable = 'members';
$where = ['Username' => $user]; // Ensure $user is sanitized as per your framework's requirements

// Using the select function from PHPCPR
$result = select($selectFields, $mainTable, [], $where, null, null, null, 0, 1);
$buffer = $result[0];



$usrid = $buffer['ID'];

$payout_method = $buffer['payout_method'];
$payout_info = '';
if ($buffer['payout_method'] == 'card') $payout_info = $buffer['debitcard'];
if ($buffer['payout_method'] == 'paypal') $payout_info = $buffer['paypalaccount'];
if ($buffer['payout_method'] == 'bitcoin') $payout_info = $buffer['bitcoin'];

$user_payout_info = $payout_method.' '.$payout_info;

$amt = $amount;

if ($_REQUEST['type']=='withdrawal') {
// DECIDE HERE WHO GETS PAID, ETC.. 
echo '<h1>Process Withdrawal Request</h1>';

if($_POST['action']!='save') { ?>
				<form method="post" name="myForm" onsubmit="document.getElementById('submit').disabled=true; document.getElementById('submit').value='Submitting, please wait...';">
				<input type="hidden" name="action" value="save">
				<input type="hidden" name="type" value="<?php echo $_REQUEST['type'];?>">
				<input type="hidden" name="delete" value="yes">
				<input class="btn btn-danger" type="submit" value="Delete ALL Withdrawal Requests For <?php echo $buffer['Username']; ?> - Return Funds To Their Bank!" name="submit" id="submit">
				</form>

<?php }
$headline = '';
$submit = 'Process Withdrawal';
$process ='Withrawal';
$processed ='processed (withdrawal marked paid) for '.$user;

$desc = 'ADMIN WITHDRAWAL';
$trans = 'WITHDRAWAL';
$payout_method = $user_payout_info;

$notes_place_holder = 'How you paid this Withdrawal.';

	if ($amt > 0) {
		$amt = -$amount;
	}	

} else if ($_REQUEST['type']=='debit') {

echo '<h1>Debit Member Account</h1>';
$headline = '';
$submit = 'Process Debit';
$process ='Debit';
$processed ='debited from '.$user;

$desc = 'ADMIN DEBIT';
$trans = 'DEBIT';
$payout_method = '';
$notes_place_holder = 'Reason you are Debiting this member.';
$amt = -$amount;

} else if ($_REQUEST['type']=='credit') {
	
echo '<h1>Credit Member Account</h1>';
$notes_place_holder = 'Reason you are Crediting this member.';	

$headline = "<p></p><div style='color:red'>BE SURE TO DEDUCT ANY PROCESSING FEES!</div>";
$submit = 'Process Deposit';
$process = 'Deposit';
$processed ='deposited into the account of '.$user;

$desc = 'ADMIN DEPOSIT';
$trans = 'DEPOSIT';
$payout_method = '';
$notes_place_holder = 'Reason you are Crediting this member.';

} else if ($_REQUEST['type']=='bank_verification') {

echo '<h1>Create Micro Pending Withdrawal</h1>';
$headline = "Enter a low amount, such as .08, .22, .46, 1.03, 1.22, 1.26, etc..<br>These will not show to the user until they have verified the amount themselves.<br>At that point, their bank will show as verified, and whatever amount you paid them here<br>will be applied as a debit to their bank balance.";
$submit = 'Create Pending Withdrawal';
$process = 'Create Micro Pending Withdrawal';
$processed ='created as a micro pending withdrawal for '.$user;

$desc = 'BANK DEPOSIT VERIFICATION';
$trans = 'WITHDRAWAL';
$payout_method = '';

$notes_place_holder = 'Admin Created Micro Withdrawal, For Bank Verification.';

$amt = -$amount;

$pay_status = 'PENDING';
}

if ($_SESSION['dev'] == true && $_SESSION['debug'] == true) {
echo '<p></p><p></p>';	
echo 'user you are transferring funds to is: '.$user.'<br/>';
echo 'usrid is: '.$usrid.'<br/>';
echo 'amount (should be positive for credits, negative for debits) is: '.$amt.'<br/>';
}

if($_POST['action']=='save'){

$totalnum=$_SESSION['number1']+$_SESSION['number2'];

	if ($_POST['delete']!='yes') {

		if ($_POST['security']!=$totalnum && ($_SESSION['dev'] == '' && $_SESSION['debug'] == false)) {
			$error .= 'Please input a valid security code <br />';
		}
		if (is_numeric($amount)) { // DO NOTHING
		} else {	
			$error .= 'Please input a valid amount.<br />';
		}
		if ($amount <= 0 && $_POST['type']!='withdrawal') { // WE ONLY ALLOW NEGATIVE AMOUNTS ON WITHDRAWALS
			$error .= 'Amount must be greater than 0. Debits will be set negative automatically.<br />';
		}
		if ($amount > 0 && $_POST['type']=='withdrawal' && $_POST['delete']!='yes') { // WE ONLY ALLOW NEGATIVE AMOUNTS ON WITHDRAWALS
			$error .= 'Amount must be set negative for a withdrawal.<br />';
		}
		if ($_POST['reward_user'] != '' && $usrid == '') {
			$error .= 'No member with username '.$_POST['reward_user'].' exists! Please double check your information.<br />';
		}
	}	

		if(!$error){

			$selectFields = 'id, amount, description';
			$mainTable = 'transactions_log';
			$where = [
				'usrid' => ['=', $usrid],
				'transtype' => ['=', 'WITHDRAWAL'],
				'pay_status' => ['=', 'PENDING'],
				'amount' => ['=', $amt]
			];
			$orderBy = 'id ASC';
			$limit = 1;

			$result = select($selectFields, $mainTable, [], $where, null, null, $orderBy, $limit, 1);
			$bufferpending = $result[0];
			$rows = is_array($result) ? count($result) : 0;
			
			$id = $bufferpending['id'];	
		//	echo 'rows: '.$rows;
		//	echo 'bufferpending amount: '.$bufferpending['amount']; 	
		//	echo ' amount: '.$amount;
		
			if ($rows > 0 && $_POST['delete'] == 'yes') {
				
				//COUNT PENDING Withdrawals
				$selectFields = 'COUNT(id) AS tot';
				$mainTable = 'transactions_log';
				$where = [
					'usrid' => ['=', $usrid],
					'transtype' => ['=', 'WITHDRAWAL'],
					'pay_status' => ['=', 'PENDING'],
					'description' => ['!=', 'CHARGEBACKW']
				];
				
				$result = select($selectFields, $mainTable, [], $where, null, null, null, 0, 1);
				$buffer = $result[0];
				$delete_limit = $buffer['tot'];

				$table = 'transactions_log';
				$where = [
					'usrid' => ['=', $usrid],
					'transtype' => ['=', 'DEBIT'],
					'description' => ['=', 'Withdrawal Fee']
				];
				$orderBy = 'id DESC';
				delete($table, [], $where, $orderBy, 1, $delete_limit, 1);

				$table = 'transactions_log';
				$where = [
					'usrid' => ['=', $usrid],
					'transtype' => ['=', 'WITHDRAWAL'],
					'pay_status' => ['=', 'PENDING'],
					'description' => ['!=', 'CHARGEBACKW']
				];
				delete($table, [], $where, null, 1, 0, 1);
				
				
				$process = 'All Withdrawals Deleted for '.$user;				
				
			} else if ($rows == 1 && ($_REQUEST['type'] == 'debit' || $_REQUEST['type'] == 'withdrawal') && $bufferpending['amount'] == $amt) {

				$table = 'transactions_log';
				$data = [
					'pay_status' => 'PAID',
					'paiddate' => $datetimenow,
					'payout_method' => $payout_method,
					'status_explanation' => $status_explanation
				];
				$where = [
					'id' => ['=', $id]
				];
				update($table, $data, [], $where, 1, 0, 1);
				
				
				$processed ='processed (withdrawal marked paid) for '.$user;
			
			// UPDATE 12/12/15 TO DEBIT AMOUNT FROM PENDING WITHDRAWAL!			
			} else if ($rows == 1 && ($_REQUEST['type'] == 'debit' || $_REQUEST['type'] == 'withdrawal') && ($pending_amt > $amount)) {
				
				$pending_amt = abs($bufferpending['amount']);
				$adj_amount = -($pending_amt - $amount);
				$status_explanation2 = 'Admin Debited $'.$amount.' Note:'.$status_explanation;
				$table = 'transactions_log';
				$data = [
					'amount' => $adj_amount,
					'status_explanation' => $status_explanation2
				];
				$where = [
					'id' => ['=', $id]
				];

				update($table, $data, [], $where, 1, 0, 1);
							
				$processed ='processed (pending withdrawal reduced by '.$amt.') for '.$user;				
				
			} else if ($rows == 1 && $bufferpending['description'] == 'CHARGEBACKW') {
				
				echo "<h2 style='color:red'>Not Processed!</h2><p></p><p></p>This member has one or more pending chargeback withdrawal request(s) pending.
				<br>These are withdrawal requests in a positive amount (due to a refund or chargeback).<br>This member must be processed with masspay.<br>
				<br><a class=\"links\" href=\"pay_commissions.php\">Return To Masspay</a>.";
				include_once './../Inc/Footer.inc.php';
				exit;			
			} else if ($rows == 1 && ($_REQUEST['type'] == 'debit' || $_REQUEST['type'] == 'withdrawal') && $bufferpending['amount'] != $amt) {
		
				echo "<h2 style='color:red'>Not Processed!</h2><p></p><p></p>This member has one or more pending withdrawal request(s), which you must process first (in order), OR you must delete all their pending withdrawal requests.
				<br><a class=\"links\" href=\"pay_commissions.php?reward_user={$_REQUEST['reward_user']}\">View withdrawal requests</a>. Click on \"Process\" next to each withdrawal request, to mark it paid.";
				?>
				<p>&nbsp;</p>				
				<form method="post" name="myForm" onsubmit="document.getElementById('submit').disabled=true; document.getElementById('submit').value='Submitting, please wait...';">
				<input type="hidden" name="action" value="save">
				<input type="hidden" name="type" value="<?php echo $_REQUEST['type'];?>">
				<input type="hidden" name="delete" value="yes">
				<input class="input" type="submit" value="Delete ALL Withdrawal Requests For <?php echo $buffer['Username']; ?> - Return Funds To Their Bank!" name="submit" id="submit">
				</form>
				<p>&nbsp;</p>
				<h5 style='color:red'>NOTE - IF YOU DELETE ALL WITHDRAWAL REQUESTS, BE SURE TO CREATE A NEW WITHDRAWAL REQUEST LATER (FOR THE ADJUSTED AMOUNT), IF NEEDED!</h5>
				
				<?php
				include_once './../Inc/Footer.inc.php';
				exit;
			} else if ($_REQUEST['type'] == 'withdrawal') {
				$_REQUEST['amount'] = abs($_REQUEST['amount']);
				echo "<h1 style='color:red'>Not Processed!</h1><p></p><p></p>Please choose to debit this member, as there is no withdrawal to process in this amount.
				<br/><br/><a class=\"links\" href=\"bankpay.php?type=debit&reward_user={$_REQUEST['reward_user']}&amount={$_REQUEST['amount']}\">Click here to debit this member, instead.</a>";?>
				<h5 style='color:red'>NOTE: Debits will only be recouped against available bank balance (or if none, future earnings).</h5>
			
				<h1>- OR -</h1>

				<h5 style='color:red'>NOTE: To recoup this debit BEFORE paying out current withdrawal requests, do the following:</h5>
				<div style="text-align:center">
				<b>1)</b> Delete All Withdrawal Requests (using button below).
				<p>&nbsp;</p>
				<b>2)</b> Process desired debit for the member.
				<p>&nbsp;</p>
				<b>3)</b> If needed, created a new withdrawal request for the adjusted amount.
				</div>
				<br/>				
				<form method="post" name="myForm" onsubmit="document.getElementById('submit').disabled=true; document.getElementById('submit').value='Submitting, please wait...';">
				<input type="hidden" name="action" value="save">
				<input type="hidden" name="type" value="<?php echo $_REQUEST['type'];?>">
				<input type="hidden" name="delete" value="yes">
				<input class="input" type="submit" value="Delete ALL Withdrawal Requests For <?php echo $buffer['Username']; ?> - Return Funds To Their Bank!" name="submit" id="submit">
				</form>

				<?php
				include_once './../Inc/Footer.inc.php';
				exit;
				
			} else {				
			// CREATE TRANSACTION LOGS - DEPOSITS OR DEBITS - $amt IS POSITIVE ON A CREDIT, AND NEGATIVE ON A DEBIT
			$table = 'transactions_log';
			$data = [
				'usrid' => $usrid,
				'amount' => $amt,
				'description' => $desc,
				'transtype' => $trans,
				'logdate' => $datetimenow,
				'payout_date' => $payoutdate,
				'paiddate' => $payoutdate,
				'pay_status' => $pay_status,
				'payout_method' => $payout_method,
				'status_explanation' => $status_explanation
			];

			insert($table, $data, 1, 1);
					
				if ($_REQUEST['type'] == 'bank_verification') {
					// DO THEY HAVE A BANK IN THE bank_account TABLE?
					$selectFields = 'idx';
					$mainTable = 'bank_account';
					$where = [
						'ID' => ['=', $usrid]
					];
					$orderBy = 'idx DESC';
					$limit = 1;

					// Attempt to select the most recent bank account entry for the user
					$result = select($selectFields, $mainTable, [], $where, null, null, $orderBy, $limit, 1);
					$buffer = $result[0] ?? null;

					// IF NOT, CREATE IT!
					if (empty($buffer['idx'])) {
						// Fetch bank account and routing number from the members table
						$selectFields = 'bank_account, bank_routing';
						$mainTable = 'members';
						$where = [
							'ID' => ['=', $usrid]
						];

						$buffer = select($selectFields, $mainTable, [], $where, null, null, null, 0, 1);
						$memberDetails = $buffer[0] ?? null;

						if (!empty($memberDetails) && $memberDetails['bank_account'] != '' && $memberDetails['bank_routing'] != '') {
							$bank_account = $memberDetails['bank_account'];
							$bank_routing = $memberDetails['bank_routing'];

							// Insert bank account details into bank_account table
							$data = [
								'ID' => $usrid,
								'username' => $user, // Ensure $user is defined and sanitized
								'amount_sent' => $amt, // Ensure $amt is defined and sanitized
								'date_sent' => $date, // Ensure $date is defined and properly formatted
								'verified' => 'N',
								'bank_account' => $bank_account,
								'bank_routing' => $bank_routing
							];

							insert('bank_account', $data, 1, 1);
						}
					}
					
					// NOW WE DELETE ANY RELATED ALERTS, SO THEY GET ALERTED RIGHT AWAY!
					unset($where);
					$where = [
						'ID' => ['=', $usrid],
						'name' => ['=', 'find_bank_to_verify']
					];
					delete('alert_member', [], $where, null, 1, 1, 1);

					unset($where);
					$where = [
						'ID' => ['=', $usrid],
						'name' => ['=', 'bank_was_verified']
					];
					delete('alert_member', [], $where, null, 1, 1, 1);					
					
					
				} // END BANK VERIFY
			}	

?> 
					<div style="text-align:center">
					<h3> <?php echo $process; ?> Complete!</h3>
					
			<?php if ($_POST['delete']!='yes') echo '<br/><h3>The amount of $'.number_format($_REQUEST['amount'],2).' has been successfully '.$processed.'.</h3>';
				
			echo '<h3>If you like, <a href="memberlogin.php?id='.$usrid.'&rd=bankledger.php" target="_blank">review the bank ledger for '.$user.'</a> ID '.$usrid.'</h3>';
			
			if ($_REQUEST['type']!='bank_verification') {
				echo '<h3>If you need to, <a href="memberlogin.php?id='.$usrid.'&rd=bank.php?bypass=y" target="_blank">make a withdrawal request for '.$user.'</a> ID '.$usrid.'</h3>
					
				<h3>If you need to, <a href="pay_commissions.php?reward_user='.$user.'">process another withdrawal request for '.$user.'</a> ID '.$usrid.'</h3>
					
				<h3><a href="bankpay.php">Return To Admin Bank</a> | <a href="pay_commissions.php">Return To Masspay</a></h3></div>';
			} else {
				echo '<h3><a href="bankpay.php"><a href="pay_commissions.php?m=bank&reset=yes">Return To Masspay</a></h3></div>';
			}				

			// PREVENT REPOST ON REFRESH!!!
			$_POST['amount'] = '';	
			$balance = '';
			unset($_POST);
			$_SESSION['number1']=0;
			$_SESSION['number2']=0;
				include './../Inc/Footer.inc.php'; 
				exit;
			}	// END NO ERROR	


//echo '&nbsp;'; 
if (!empty($error)) { ?>
<div style="color:red;"><h4><?php echo $error; ?> Go Back And Try Again</h4><br />&nbsp;
<?php echo '<a class="links" href="bankpay.php?type='.$_REQUEST['type'].'&reward_user='.$_REQUEST['reward_user'].'&amount='.$_REQUEST['amount'].'">Try Again</a></div>';
include_once './footer.php';
exit;
} // END ERROR			 
} // END SAVE

if($_POST['action']!='save'){		
 
$_SESSION['number1']=$number1 ;
$_SESSION['number2']=$number2 ;
 
echo "<div style=\"text-align:center\"><h3>".$headline."</h3>";
?>

<br/>
<br/>
<br/><br/>

<form method="post" name="myForm" onsubmit="document.getElementById('submit').disabled=true; document.getElementById('submit').value='Submitting, please wait...';">

<input type="hidden" name="action" value="save">
<input type="hidden" name="type" value="<?php echo $_REQUEST['type'];?>">

<table style="width: 380px; margin: auto;" cellpadding="5" cellspacing="10" >

<tr>
	<td style="vertical-align:top; width: 50%; margin: right;">

					Member Username:</td>

					<td style="width: 50%; margin: left;">

				<input class="input" onMouseover="this.focus()" size="25" name="reward_user" value="<?php if(isset($_REQUEST['reward_user'])) : echo $_REQUEST['reward_user']; else : echo ''; endif; ?>" placeholder="username" <?php if(isset($_REQUEST['reward_user'])) : echo 'disabled'; else : echo ''; endif; ?>>
	</td>
</tr>

<tr>
	<td style="vertical-align:top; width: 50%; margin: right;">

					Amount to <?php echo $process; ?>:</td>

					<td style="width: 50%; margin: left;">

				<input class="input" onMouseover="this.focus()" size="25" name="amount" value="<?php if(isset($_REQUEST['amount'])) : echo $_REQUEST['amount']; else : echo ''; endif; ?>" placeholder="amount" value=>
	</td>
</tr>

<tr>
	<td style="vertical-align:top; width: 50%; margin: right;">

					<?php echo $process; ?> Notes (optional):</td>

					<td style="width: 50%; margin: left;">

					<textarea class="input" rows="10" cols="25" name="explanation" onMouseover="this.focus()"  placeholder="<?php echo $notes_place_holder; ?>"><?php if ($_REQUEST['type']=='bank_verification') echo $notes_place_holder; ?></textarea>
	</td>
</tr>

<tr>
	<td style="vertical-align:top; width: 50%; margin: right;">

					Security Add (<?php echo $number1; ?>+<?php echo $number2; ?>):</td>

					<td style="width: 50%; margin: left;">

				<input class="input" onMouseover="this.focus()" size="25" name="security">
	</td>
</tr>	
			
 
<tr>

<td colspan="2">
<div style="text-align:center">

				<input class="input" type="submit" value="<?php echo $submit; ?>" name="submit" id="submit">
				</form>	

</div>
</td>
</tr>
</table>
</div>				
				
		<?php if (false && $_REQUEST['type'] == 'withdrawal') { ?>
				<p>&nbsp;</p>

		<?php } ?>		


<p>&nbsp;</p>





<?php } // END ACTION IS NOT "SAVE"
include './../Inc/Footer.inc.php';
?>
