<?php
  /**
   * For creating a new Admin User
   * 
   * Allows admin to create users and assign different access rights to them
   * 
   * @author Kailash Badu - Kaizen Web-Productions (http://www.kaizen-web.com)   
   * @copyright Copyright(C), Kaizen Web-Productions, 2004-2008, All Rights Reserved.
   */
   
  require_once('./../../Sub/Config.inc.php');
  require_once('./../Inc/Login.inc.php');
  if ($loggedUser->checkPermisson('MANAGE_USERS') === false) {
    $errorMessage = 'You are not allowed to access this page.';
    require_once('./../Inc/error.php');
    exit();   
  }
  
  // you must have a valid user id in order to be able to edit it
  $userId = null;
  $userId = isset($_GET['id']) ? (int) $_GET['id'] : $userId;
  $userId = isset($_POST['id'])? (int) $_POST['id'] : $userId;
  if(is_null($userId)) {
    $errorMessage = 'Invalid Operation';
    require_once('./../Inc/error.php');
    exit();  
  }
  
  //make sure the user actually exists in the database
  $sql = "SELECT ID, Username, First_Name, Last_Name, password, email FROM members WHERE ID = $userId";
  $result = mysql_query($sql);
  if (mysql_num_rows($result) < 1){
    $errorMessage = 'The user does not exist';
    require_once('./../Inc/error.php');
    exit();   
  }
  $row = mysql_fetch_assoc($result);
  $username  = $row['Username'];
  $firstname = $row['First_Name'];
  $lastname  = $row['Last_Name'];
  $password  = $row['password'];
  $confirmpassword = $row['password'];
  $email     = $row['email'];
  
  //find what rights are available to this user
  $accessRights = array();
  $sql = "SELECT permission_id FROM user_permission WHERE user_id = $userId";
  $result = mysql_query($sql);
  while ($row = mysql_fetch_assoc($result)) {
    $accessRights[] = $row['permission_id'];    
  }  
  
  //find available access rights
  $sql = "SELECT permission_id, permission_name FROM permission ORDER BY permission_id ASC";
  $result = mysql_query($sql);
  $permissions =  array();
  while($row = mysql_fetch_assoc($result)){
    $permissions[$row['permission_id']] = $row['permission_name'];
  }
  if (isset($_POST['formaction']) && $_POST['formaction'] = 'edituser') {
    $error = array();
    
    $firstname = isset($_POST['firstname']) ? strip_tags(trim($_POST['firstname'])) : '';
    $lastname  = isset($_POST['lastname']) ? strip_tags(trim($_POST['lastname'])) : '';
    $password  = isset($_POST['password']) ? strip_tags(trim($_POST['password'])) : '';
    $confirmpassword  = isset($_POST['confirmpassword']) ? strip_tags(trim($_POST['confirmpassword'])) : '';
    $email  = isset($_POST['email']) ? strip_tags(trim($_POST['email'])) : '';
    $accessRightsUpdated = isset($_POST['accessRights']) ? $_POST['accessRights'] : array();
        
    //first name
    if (strlen($firstname) == 0) {
      $error[] = 'Please specify the First Name';
    }
    elseif (strlen($firstname) > 100) {
      $error[] = 'The First Name cannot be larger than 100 characters';
    }
    
    //last name
    if (strlen($lastname) == 0) {
      $error[] = 'Please specify the First Name';
    }
    elseif (strlen($lastname) > 100) {
      $error[] = 'The Last Name cannot be larger than 100 characters';
    }
    
    //password
    if (strlen($password) == 0) {
      $error[] = 'Please specify the password';
    }
    elseif (strlen($password) > 50) {
      $error[] = 'The password cannot be larger than 50 characters';
    }
    elseif ($password != $confirmpassword) {
      $error[] = 'The passwords do not match';
    }
    
    //email
    if(strlen($email) == 0){
      $error[] = 'Please specify the email';
    }
    elseif (!preg_match('/(^[\w\.!#$%"*+\/=?`{}|~^-]+)@(([-\w]+\.)+[A-Za-z]{2,})$/' , $email)) {
        $error[] = 'Please specify the valid email address';
     }
    
    //Access Rights
    if (empty($accessRightsUpdated)) {
      $error[] = "The user must be assigned at least one access right";
    }
    
    if (array_intersect($accessRightsUpdated, array_keys($permissions)) != $accessRightsUpdated) {
      $error[] = 'Please select valid access permissions only';
    }
    
    if(empty($error)){
      $sql = "UPDATE members SET First_name = '%s', Last_Name = '%s', password='%s', email = '%s' WHERE ID = %d";      
      $sql = sprintf($sql,
                          mysql_escape_string($firstname),
                          mysql_escape_string($lastname),
                          mysql_escape_string($password),
                          mysql_escape_string($email),
                          $userId
                    );
      mysql_query($sql);
      
      //There are certain rights that need to be removed while other needs to be added
      $accessRightRemove =array_diff($accessRights, $accessRightsUpdated);
      $accessRightAdd = array_diff($accessRightsUpdated, $accessRights);
      
      //delete the removed rights
      if (count($accessRightRemove) > 0){
        $sql = "DELETE FROM user_permission WHERE user_id = $userId  AND permission_id IN (". join(',', $accessRightRemove) .')';  
        mysql_query($sql) or exit($sql);
      }
      
      //add the new rights
      foreach($accessRightAdd as $value){
        $sql = "INSERT INTO user_permission SET user_id = $userId, permission_id = $value";
        mysql_query($sql) or exit($sql);  
      }
      //$_SESSION['message']['useradd'] = "The user $username was updated successfully";
      header('Location: userManage.php');
      exit();
    }
  }
  require_once('./../Inc/Header.inc.php');  
?>
<h2>Edit Administrator User</h2>
<?php if(isset($error) && count($error) > 0): ?>
       <ul>
      <?php while(list(, $errormsg) = each($error)):?>
        <li><?php print $errormsg ?></li>
      <?php endwhile; ?>
    </ul>
<?php endif; ?> 
<form method="post" action="<?php print $_SERVER['PHP_SELF'];?>" >
<center>
   <table style="border-collapse:collapse">
       <tr>
      <td>Username:</td>
      <td><?php print $username;?></td>    
    </tr>
    <tr>
      <td>First Name: </td>
      <td><input type="text" name="firstname" value="<?php print $firstname;?>" /></td>    
    </tr>
    <tr>
      <td>Last name:</td>
      <td><input type="text" name="lastname" value="<?php print $lastname;?>" /></td>
    </tr>
    <tr>
      <td>Passsword</td>
      <td><input type="password" name="password" value="<?php print $password;?>" /></td>
    </tr>
    <tr>
      <td>Confirm Password:</td>
      <td><input type="password" name="confirmpassword" value="<?php print $confirmpassword;?>" /></td>
    </tr>
    <tr>
      <td>Email:</td>
      <td><input type="text" name="email" value="<?php print $email;?>"></td>
    </tr>
    <tr valign="top">
      <td>Access Rights:</td>
      <td>
        <?php foreach($permissions as $key => $value){ 
           $checked = in_array($key, $accessRights) ? 'checked = "checked"' : '';
           if (strpos($value, "STORE_") !== 0) {
        ?>
          <input type="checkbox" <?php print $checked?> name="accessRights[]" value="<?php print $key; ?>" /> <?php print $value;?> <br /> 
        <?php }} ?>
      </td>
    </tr>
    <tr>
      <td colspan="2"><center>
        <input type="hidden" name="id" value="<?php print $userId; ?>" />
        <input type="hidden" name="formaction" value="edituser" />
        <input type="submit" name="submit" value="Update user" />
      </center></td>
    </tr>
   </table>
</form>

<?php
  require_once('./../Inc/Footer.inc.php');
?>