<?php
//-----------------------------------------------------------------
// Software: Automatic Web Software (AWS) built with PHPCPR
// Firm: DirectSalesMLM.com / AutomaticWebSoftware.com / PHPCPR.com
// Author: Jim Symonds Email: jim@directsalesmlm.com
// Copyright 2006 - 2024 Jim Symonds All Rights Reserved.
//-----------------------------------------------------------------
include './../../Sub/Config.inc.php';
include './../../phpcpr.php';
include './../Inc/Login.inc.php';

if ($loggedUser->checkPermisson('ADD_PROGRAM') === false){
  $errorMessage = 'You are not allowed to access this page.';
  require_once('./../Inc/error.php');
  exit();   
}

//error_reporting(-1);
//$_SESSION['debug'] = true;

// COMMENT WHEN TESTING IS DONE!!!
//$_SESSION['dev'] = '';
 /*
if ($_GET['dev'] == '' && $_SESSION['dev'] == '' && $_SESSION['loggedin'] != 'testwalkthru') { // LOCKING PAGE FOR DEVELOPER USE ONLY!!
//include_once './header.php';
echo 'We\'re sorry. This area is temporarily down for maintenance. Please check back soon!';
//include_once './footer.php';
exit;
} else {
$_SESSION['dev'] = true;
}
*/
$now = date("Y-m-d");
	
$pageName = 'Members Tax Forms';
$pageDesc = '';
$pageIcon = '';
$pageAlign = 'center';
$pageClass = '';

include './../Inc/Header.inc.php';

if ($_GET['app']) {
	$idx = $_GET['app'];
	
	$data = [
		'auth_date' => $now,
	];
	$where = [
		'idx' => $idx
	];
	update('pdf_files', $data, [], $where, 1, 1, 1);
	
	$msg = '<h2>User updated!</h2>';
}	

if ($_GET['del']) {
	$idx = $_GET['del'];
	
	$selectFields = 'ID';
	$mainTable = 'pdf_files';
	$where = [
		'idx' => $idx
	];
	
	$result = select($selectFields, $mainTable, [], $where, null, null, null, 0, 1);
	$buffer = isset($result[0]) ? $result[0] : null;	
	$ID = $buffer['ID'];

	// Upload path
	$upload_path = $_SERVER['DOCUMENT_ROOT'] . '/Members/pdf/';	

	// DELETE ALL OLD W8, W9 FILES FOR THIS USER WHEN THEY UPLOAD A NEW ONE!
	foreach (glob($upload_path . 'fw9_'.$ID.'.*') as $file) {
		unlink($file);
	}
	foreach (glob($upload_path . 'fw8ben_'.$ID.'.*') as $file) {
		unlink($file);
	}		
	
	$where = [
		'idx' => $idx
	];
	delete('pdf_files', [], $where, null, 1, 1, 1);
	
	
	$msg = '<h2>Record deleted!</h2>';	
}

if ($msg) echo '<h2>'.$msg.'</h2>';

if ($_GET['show'] == 'approved') {	
	$selectFields = '*';
	$mainTable = 'pdf_files';
	$where = [
		'auth_date' => ['!=', '0000-00-00'],
	];
	$orderBy = 'idx ASC';

	// Executing the select function
	$result = select($selectFields, $mainTable, [], $where, null, null, $orderBy, 0, 1);
	
	$rows = is_array($result) ? count($result) : 0;

	if ($rows == 0) echo '<h2>No authorized tax form results to show</h2>';

	foreach ($result as $buffer) {
		/*echo "<pre>";
		print_r($buffer);
		echo "</pre>";*/
		
		echo '<a href="/Members/pdf/'.$buffer['name'].'" target="_blank" class="btn btn-primary">Review: '.$buffer['username'].' '.$buffer['type'].' Open PDF</a> <a href="members_tax_forms.php?del='.$buffer['idx'].'" class="btn btn-danger">Delete</a><hr>';
	}
} else {

	$selectFields = '*'; // Selecting all fields
	$mainTable = 'pdf_files';
	$where = [
		'auth_date' => ['=', '0000-00-00'],
	];
	$orderBy = 'idx ASC';

	// Executing the select function
	$result = select($selectFields, $mainTable, [], $where, null, null, $orderBy, 0, 1);	

	$rows = is_array($result) ? count($result) : 0;

	if ($rows == 0) echo '<h2>No results to show</h2>';

	foreach ($result as $buffer) {
		/*echo "<pre>";
		print_r($buffer);
		echo "</pre>";*/
		
		//echo '<a href="/Members/pdf/'.$buffer['name'].'" target="_blank" class="btn btn-primary">Review: '.$buffer['username'].' '.$buffer['type'].' Open PDF</a> <a href="members_tax_forms.php?del='.$buffer['idx'].'" class="btn btn-danger" Onclick="return confirm(\'Are You Sure?\');">Delete</a> <a href="members_tax_forms.php?app='.$buffer['idx'].'" class="btn btn-success" Onclick="return confirm(\'Are You Sure?\');">Approve</a><hr>';
		
		echo '<a href="/Members/pdf/'.$buffer['name'].'" target="_blank" class="btn btn-primary">Review: '.$buffer['username'].' '.$buffer['type'].' Open PDF</a> <a href="tax_form_deny.php?uname='.$buffer['username'].'" class="btn btn-danger">Deny</a> <a href="members_tax_forms.php?app='.$buffer['idx'].'" class="btn btn-success" Onclick="return confirm(\'Are You Sure?\');">Approve</a><hr>';
	}
}

if ($_GET['show'] != 'approved') echo '<h2><a href="members_tax_forms.php?show=approved" class="btn btn-danger">Show Only Approved Tax Forms</a></h2>';
if ($_GET['show'] == 'approved') echo '<h2><a href="members_tax_forms.php" class="btn btn-danger">Show Only Unapproved Tax Forms</a></h2>';

if ($_GET['del'] != '') echo '<h2><a href="members_tax_forms.php" class="btn btn-success">Reset Page</a></h2>';

include './../Inc/Footer.inc.php';
?>
