<?php
//-----------------------------------------------------------------
// Software: Automatic Web Software (AWS) built with PHPCPR
// Firm: DirectSalesMLM.com / AutomaticWebSoftware.com / PHPCPR.com
// Author: Jim Symonds Email: jim@directsalesmlm.com
// Copyright 2006 - 2024 Jim Symonds All Rights Reserved.
//-----------------------------------------------------------------
session_start();
//---------------------------------------------------------------
// AutomaticWebSoftware.com 
//---------------------------------------------------------------
include './../../Sub/Config.inc.php';
include './../../phpcpr.php';
include './../Inc/Login.inc.php';

$pageName = 'Extract Active Members By State';
$pageDesc = '';
$pageIcon = '';
$pageAlign = 'center';
$pageClass = '';
include './../Inc/Header.inc.php';

if ($loggedUser->checkPermisson('ADD_PROGRAM') === false){
  $errorMessage = 'You are not allowed to access this page.';
  require_once('./../Inc/error.php');
  exit();   
}

set_time_limit(0); //Make sure it will not expire before its complete

function is_texas_phone($phone) {
	$area_codes = array("210", "214", "254", "281", "325", "346", "361", "409", "430", 
"432", "469", "512", "682", "713", "737", "806", "817", "830", 
"832", "903", "915", "936", "940", "956", "972", "979");
	$phone = preg_replace("/[^0-9]/", "", $phone);
	if (substr($phone,0,1) == "1") $phone = substr($phone,1,strlen($phone)-1);
	if (strlen($phone) != 10) return(false); // not US
	$npa = substr($phone,0,3);
	//echo $phone . " " . $npa ."<br />";
	if (in_array($npa,$area_codes)) return(true);
	else return(false);
}

function get_state($phone) {
	 $npa_to_state = array(
                   403 => "AB",
                   907 => "AK",
                   205 => "AL",
                   256 => "AL",
                   334 => "AL",
                   251 => "AL",
                   870 => "AR",
                   501 => "AR",
                   479 => "AR",
                   480 => "AZ",
                   623 => "AZ",
                   928 => "AZ",
                   602 => "AZ",
                   520 => "AZ",
                   628 => "CA",
                   341 => "CA",
                   764 => "CA",
                   925 => "CA",
                   909 => "CA",
                   562 => "CA",
                   661 => "CA",
                   657 => "CA",
                   510 => "CA",
                   650 => "CA",
                   949 => "CA",
                   760 => "CA",
                   415 => "CA",
                   951 => "CA",
                   752 => "CA",
                   831 => "CA",
                   209 => "CA",
                   669 => "CA",
                   408 => "CA",
                   559 => "CA",
                   626 => "CA",
                   442 => "CA",
                   530 => "CA",
                   916 => "CA",
                   707 => "CA",
                   627 => "CA",
                   714 => "CA",
                   310 => "CA",
                   323 => "CA",
                   213 => "CA",
                   424 => "CA",
                   747 => "CA",
                   818 => "CA",
                   858 => "CA",
                   935 => "CA",
                   619 => "CA",
                   805 => "CA",
                   369 => "CA",
                   720 => "CO",
                   303 => "CO",
                   970 => "CO",
                   719 => "CO",
                   203 => "CT",
                   959 => "CT",
                   475 => "CT",
                   860 => "CT",
                   202 => "DC",
                   302 => "DE",
                   689 => "FL",
                   407 => "FL",
                   239 => "FL",
                   836 => "FL",
                   727 => "FL",
                   321 => "FL",
                   754 => "FL",
                   954 => "FL",
                   352 => "FL",
                   863 => "FL",
                   904 => "FL",
                   386 => "FL",
                   561 => "FL",
                   772 => "FL",
                   786 => "FL",
                   305 => "FL",
                   861 => "FL",
                   941 => "FL",
                   813 => "FL",
                   850 => "FL",
                   478 => "GA",
                   770 => "GA",
                   470 => "GA",
                   404 => "GA",
                   706 => "GA",
                   678 => "GA",
                   912 => "GA",
                   229 => "GA",
                   671 => "GU",
                   808 => "HI",
                   515 => "IA",
                   319 => "IA",
                   563 => "IA",
                   641 => "IA",
                   712 => "IA",
                   208 => "ID",
                   217 => "IL",
                   282 => "IL",
                   872 => "IL",
                   312 => "IL",
                   773 => "IL",
                   464 => "IL",
                   708 => "IL",
                   815 => "IL",
                   224 => "IL",
                   847 => "IL",
                   618 => "IL",
                   309 => "IL",
                   331 => "IL",
                   630 => "IL",
                   765 => "IN",
                   574 => "IN",
                   260 => "IN",
                   219 => "IN",
                   317 => "IN",
                   812 => "IN",
                   913 => "KS",
                   785 => "KS",
                   316 => "KS",
                   620 => "KS",
                   327 => "KY",
                   502 => "KY",
                   859 => "KY",
                   606 => "KY",
                   270 => "KY",
                   504 => "LA",
                   985 => "LA",
                   225 => "LA",
                   318 => "LA",
                   337 => "LA",
                   774 => "MA",
                   508 => "MA",
                   781 => "MA",
                   339 => "MA",
                   857 => "MA",
                   617 => "MA",
                   978 => "MA",
                   351 => "MA",
                   413 => "MA",
                   443 => "MD",
                   410 => "MD",
                   280 => "MD",
                   249 => "MD",
                   969 => "MD",
                   240 => "MD",
                   301 => "MD",
                   207 => "ME",
                   383 => "ME",
                   517 => "MI",
                   546 => "MI",
                   810 => "MI",
                   278 => "MI",
                   313 => "MI",
                   586 => "MI",
                   248 => "MI",
                   734 => "MI",
                   269 => "MI",
                   906 => "MI",
                   989 => "MI",
                   616 => "MI",
                   231 => "MI",
                   679 => "MI",
                   947 => "MI",
                   612 => "MN",
                   320 => "MN",
                   651 => "MN",
                   763 => "MN",
                   952 => "MN",
                   218 => "MN",
                   507 => "MN",
                   636 => "MO",
                   660 => "MO",
                   975 => "MO",
                   816 => "MO",
                   314 => "MO",
                   557 => "MO",
                   573 => "MO",
                   417 => "MO",
                   670 => "MP",
                   601 => "MS",
                   662 => "MS",
                   228 => "MS",
                   406 => "MT",
                   336 => "NC",
                   252 => "NC",
                   984 => "NC",
                   919 => "NC",
                   980 => "NC",
                   910 => "NC",
                   828 => "NC",
                   704 => "NC",
                   701 => "ND",
                   402 => "NE",
                   308 => "NE",
                   603 => "NH",
                   908 => "NJ",
                   848 => "NJ",
                   732 => "NJ",
                   551 => "NJ",
                   201 => "NJ",
                   862 => "NJ",
                   973 => "NJ",
                   609 => "NJ",
                   856 => "NJ",
                   505 => "NM",
                   957 => "NM",
                   702 => "NV",
                   775 => "NV",
                   315 => "NY",
                   518 => "NY",
                   716 => "NY",
                   585 => "NY",
                   646 => "NY",
                   347 => "NY",
                   718 => "NY",
                   212 => "NY",
                   516 => "NY",
                   917 => "NY",
                   845 => "NY",
                   631 => "NY",
                   607 => "NY",
                   914 => "NY",
                   216 => "OH",
                   330 => "OH",
                   234 => "OH",
                   567 => "OH",
                   419 => "OH",
                   380 => "OH",
                   440 => "OH",
                   740 => "OH",
                   614 => "OH",
                   283 => "OH",
                   513 => "OH",
                   937 => "OH",
                   918 => "OK",
                   580 => "OK",
                   405 => "OK",
                   503 => "OR",
                   971 => "OR",
                   541 => "OR",
                   814 => "PA",
                   717 => "PA",
                   570 => "PA",
                   358 => "PA",
                   878 => "PA",
                   835 => "PA",
                   484 => "PA",
                   610 => "PA",
                   445 => "PA",
                   267 => "PA",
                   215 => "PA",
                   724 => "PA",
                   412 => "PA",
                   939 => "PR",
                   787 => "PR",
                   401 => "RI",
                   843 => "SC",
                   864 => "SC",
                   803 => "SC",
                   605 => "SD",
                   423 => "TN",
                   865 => "TN",
                   931 => "TN",
                   615 => "TN",
                   901 => "TN",
                   731 => "TN",
                   254 => "TX",
                   325 => "TX",
                   713 => "TX",
                   940 => "TX",
                   817 => "TX",
                   430 => "TX",
                   903 => "TX",
                   806 => "TX",
                   737 => "TX",
                   512 => "TX",
                   361 => "TX",
                   210 => "TX",
                   936 => "TX",
                   409 => "TX",
                   979 => "TX",
                   972 => "TX",
                   469 => "TX",
                   214 => "TX",
                   682 => "TX",
                   832 => "TX",
                   281 => "TX",
                   830 => "TX",
                   956 => "TX",
                   432 => "TX",
                   915 => "TX",
                   435 => "UT",
                   801 => "UT",
                   385 => "UT",
                   434 => "VA",
                   804 => "VA",
                   757 => "VA",
                   703 => "VA",
                   571 => "VA",
                   540 => "VA",
                   276 => "VA",
                   381 => "VA",
                   236 => "VA",
                   802 => "VT",
                   509 => "WA",
                   360 => "WA",
                   564 => "WA",
                   206 => "WA",
                   425 => "WA",
                   253 => "WA",
                   715 => "WI",
                   920 => "WI",
                   414 => "WI",
                   262 => "WI",
                   608 => "WI",
                   353 => "WI",
                   420 => "WI",
                   304 => "WV",
                   307 => "WY");
	$phone = preg_replace("/[^0-9]/", "", $phone);
	if (substr($phone,0,1) == "1") $phone = substr($phone,1,strlen($phone)-1);
	if (strlen($phone) != 10) return(""); // not US
	$npa = substr($phone,0,3);
	$npa = $npa + 0; // make it an integer
	//echo $phone . " " . $npa ."<br />";
	$state = $npa_to_state[$npa];
	return($state);
}

$selectFields = 'DISTINCT memb.Username, memb.First_Name, memb.Last_Name, memb.email, memb.cellphone, link.phone, link.state';
$mainTable = ['table' => 'members', 'as' => 'memb'];
$joinConditions = [
    [
        'table' => 'member_link',
        'as' => 'link',
        'condition' => 'link.ID = memb.ID'
    ],
    [
        'table' => 'user_program',
        'as' => 'up',
        'condition' => 'up.ID = link.ID'
    ]
];
$where = [
    'up.user_status' => ['NOT IN', ['Unpaid','Cancelled']]
];
$groupBy = null;
$having = null;
$orderBy = null;
$limit = 0;
$show_debug = 1;

// Assuming $phpcpr is your PHPCPR object
$result = select($selectFields, $mainTable, $joinConditions, $where, $groupBy, $having, $orderBy, $limit, $show_debug);

if ($_REQUEST['state'] != "") {
	$target_state = strtoupper($_REQUEST['state']);
} else {
	//$target_state = "TX";
	//echo '<h1>Please choose a state.</h1>';
	?>
	<div class="col-md-4 col-xs-0">
	&nbsp;
	</div>
	
	<div class="col-md-4 col-xs-0">
	<?php
	echo '<form method="post"><select name="state" class="form-control"><option value="">Please select a state</option>';

	$selectFields = '*';
	$mainTable = 'states';
	$joinConditions = []; // No join conditions since we're only querying one table
	$where = ['*']; // No where condition as we're selecting all records
	$groupBy = null;
	$having = null;
	$orderBy = null;
	$limit = 0; // Assuming 0 means no limit
	$show_debug = 1; // Assuming you want to see debug output

	// Fetch all records from the states table
	$states = select($selectFields, $mainTable, $joinConditions, $where, $groupBy, $having, $orderBy, $limit, $show_debug);

	// Assuming $states is an array of associative arrays representing the fetched rows
	foreach ($states as $buffer) {

		if (!empty($_POST['state']) && strtoupper($_POST['state']) == $buffer['abbrev']) $selected = 'selected';
		else $selected = '';
		echo '<option value="'.$buffer['abbrev'].'" '.$selected.'>'.$buffer['name'].'</option>';
	}
	
	echo '</select>&nbsp;<br/><input class="btn btn-info" type="submit" name="submit" value="Show Members Active in Any Program">';
	//echo '&nbsp;<input class="#" type="submit" name="submit2" value="Show Members Active in Admin Program"></form>';
	?>
	</div>
	
	<div class="col-md-4 col-xs-0">
	&nbsp;
	</div>
	<div class="clearfix"></div>
	<?php
	include './../Inc/Footer.inc.php';
	exit;
}
echo '<a href="statelist.php" class="btn btn-info">RESET</a><br/><br/>';

echo "Members in $target_state who are active in at least one Program";

// QQQ REWORK TO A FORM, WHERE YOU ENTER THE PROGRAM ID, OR IT SHOWS IN AN ARRAY, AND THE POST PROG ID IS USED IN THE SQL QUERY

echo ":<br/ ><br />username,firstname,lastname,email,cellphone,phone<br />";

$txctr = 0;
$qc = '"';
foreach ($result as $buffer) {
	$username = $buffer['Username'];
	$email = $buffer['email'];
	$cellphone = $buffer['cellphone'];
	$phone = $buffer['phone'];
	$state = $buffer['state'];
	$firstname = $buffer['First_Name'];
	$lastname = $buffer['Last_Name'];
	if (($state == "" && (get_state($phone) == $target_state || get_state($cellphone) == $target_state)) || $state == $target_state) {
		$txctr ++;
		echo $username . ",". $qc .$firstname . $qc . "," . $qc . $lastname . $qc . "," . $email . "," . $cellphone . "," . $phone . "<br />";
	}
}
//echo $txctr;
include './../Inc/Footer.inc.php';
?>