<?php
//-----------------------------------------------------------------
// Software: Automatic Web Software (AWS) built with PHPCPR
// Firm: DirectSalesMLM.com / AutomaticWebSoftware.com / PHPCPR.com
// Author: Jim Symonds Email: jim@directsalesmlm.com
// Copyright 2006 - 2024 Jim Symonds All Rights Reserved.
//-----------------------------------------------------------------
include './../Sub/Config.inc.php';
include './../phpcpr.php';
include './Inc/Login.inc.php';

if ($_GET['action'] != 'delete' && $_GET['d'] != 'y' && $_SESSION['allow_delete'] != true) {
	echo 'Feature disabled'; exit;
} else {
	$_SESSION['allow_delete'] = true;
}

if ($loggedUser->checkPermisson('ADD_PROGRAM') === false){
  $errorMessage = 'You are not allowed to access this page.';
  require_once('./../Inc/error.php');
  exit();   
}

//$GLOBALS['debug'] = true;
$live = 1;

set_time_limit(0); //Make sure it will not expire before its complete


// GET USER TO DELETE
$user_delete = $_GET['user'];

if ($_GET['action'] == 'delete') $action = "&action=delete";
else $action = "";

echo '<h1>Deleting User '.$user_delete.'!</h1>';

if ($_GET['user'] != '' && $_GET['process'] != 'yes') {
echo "<h2>Are you sure? <a href=\"delete_user.php?user=".$_GET['user']."&process=yes{$action}\">Yes, Delete User ".$user_delete."!</a></h2>";
//include './../Inc/Footer.inc.php';
exit;
} else if ($_GET['user'] != '' && $_GET['process'] == 'yes') {
	// DO NOTHING - LET PASS
} else {
	echo 'No Action Taken!';
	exit;
}	


$user_delete_sanitized = sanitize($user_delete, 'username');

$whereConditions = [
    'ID' => ['>', 3],
    'Username' => $user_delete_sanitized
];

$selectFields = ['ID', 'Username', 'email'];
$mainTable = 'members';
$result = select($selectFields, $mainTable, [], $whereConditions, null, null, null, 0, 1);

foreach ($result as $buffer) {
	
	$ID = $buffer['ID'];
	$user = $buffer['Username'];
	$email = $buffer['email'];	
		
	//echo 'Got inside loop!';	
	echo '<pre>';
	//echo $buffer['Username'];
	echo '</pre>';
			
	// Deleting records from various tables using the PHPCPR delete function
	delete('status_log', [], ['ID' => ['=', $ID]], null, $live, 1, 1);
	// Uncomment the next line to perform deletion on `payment_log` table
	// delete('payment_log', [], ['payer_username' => ['=', $user]], null, $live, 1, 1);
	delete('member_link', [], ['ID' => ['=', $ID]], null, $live, 1, 1);
	delete('member_log', [], ['ID' => ['=', $ID]], null, $live, 1, 1);
	delete('members_change_log', [], ['ID' => ['=', $ID]], null, $live, 1, 1);
	delete('support_tickets', [], ['username' => ['=', $user]], null, $live, 1, 1);
	delete('transactions_log', [], ['usrid' => ['=', $ID]], null, $live, 1, 1);
	delete('leaderboard_earnings', [], ['Username' => ['=', $user]], null, $live, 1, 1);
	delete('leaderboard', [], ['Username' => ['=', $user]], null, $live, 1, 1);
	delete('user_program', [], ['ID' => ['=', $ID]], null, $live, 1, 1);
	delete('e4_arb', [], ['id_paying' => ['=', $ID]], null, $live, 1, 1);
	delete('e4_history', [], ['id_paying' => ['=', $ID]], null, $live, 1, 1);
	delete('e4_log', [], ['id_paying' => ['=', $ID]], null, $live, 1, 1);

	// Selecting records from the `payment_plan` table
	$selectFields = ['user_payment_plan_id', 'payment_plan_id'];
	$mainTable = 'payment_plan';
	$where = ['payer_username' => ['=', $user]];
	$result2 = select($selectFields, $mainTable, [], $where, null, null, null, 0, 1);

	// Assuming $result2 is fetched as an associative array
	foreach ($result2 as $buffer2) {
		$upp = $buffer2['user_payment_plan_id'];
		$pp = $buffer2['payment_plan_id'];
		
		// Deleting records from `payment_plan`, `user_custom_plan`, and `user_payment_plan` tables
		delete('payment_plan', [], ['payment_plan_id' => ['=', $pp]], null, $live, 1, 1);
		delete('user_custom_plan', [], ['payment_plan_id' => ['=', $pp]], null, $live, 1, 1);
		delete('user_payment_plan', [], ['user_payment_plan_id' => ['=', $upp]], null, $live, 1, 1);
	}
			

	// Selecting records from the `ar_member_master` table
	$selectFields = ['ar_member_master_id'];
	$mainTable = 'ar_member_master';
	$where = ['ID' => ['=', $ID]];
	$result2 = select($selectFields, $mainTable, [], $where, null, null, null, 0, 1);

	foreach ($result2 as $buffer2) {
		$ar_member_master_id = $buffer2['ar_member_master_id'];
		
		delete('ar_member_email', [], ['ar_member_master_id' => ['=', $ar_member_master_id]], null, $live, 1, 1);
		delete('ar_member_master', [], ['ar_member_master_id' => ['=', $ar_member_master_id]], null, $live, 1, 1);
	}

	// Deleting records from `ar_leads` and `members` tables
	delete('ar_leads', [], ['ar_leads_email' => ['=', $email]], null, $live, 1, 1);
	delete('members', [], ['ID' => ['=', $ID]], null, $live, 1, 1);

	
} // END MASTER WHILE LOOP!	
?>

<H2>DONE!</H2>
If applicable, the user's email was also deleted from the leads table.
<br>
<a href="<?php echo $Global['webpage_url_ssl']; ?>admin/Sub/Finduser.php?username=<?php echo $user_delete;?>"> Go To Find User Page </a>
