<?php
//-----------------------------------------------------------------
// Software: Automatic Web Software (AWS) built with PHPCPR
// Firm: DirectSalesMLM.com / AutomaticWebSoftware.com / PHPCPR.com
// Author: Jim Symonds Email: jim@directsalesmlm.com
// Copyright 2006 - 2024 Jim Symonds All Rights Reserved.
//-----------------------------------------------------------------
//---------------------------------------------------------------
// Copyright 2017, Jim Symonds, AutomaticWebSoftware.com 
//---------------------------------------------------------------
include '../Members/logincheck.php';
$pageName = 'Campaign Creator'; // THIS IS SHOWN AS A BREADCRUMB UNDER THE MENU, AND IS ALSO USED AS THE PAGE TITLE, IF $pageDesc IS LEFT EMPTY.
$pageDesc = ''; // IF USED, THIS IS SHOWN AS THE TITLE IN THE PAGE (BLUE BAR SECTION, END OF HEADER), REPLACING $pageName.
$pageIcon = 'fa fa-bullhorn'; // THE ICON USED IN THE PAGE
$pageAlign = 'center'; // HOW YOU WANT TO ALIGN THE PAGE CONTENT
$pageClass = ''; // FOR CUSTOM PROGRAMMING USES
$do_not_display_ads = true;
include $Global['path'].'Sub/tpl/header_tpl.php';
$datetime = date("Y-m-d H:i:s");
$error = ''; $error2 = '';
$debug = false;
//$debug = true;

$can_name_custom_link = false;
$can_name_custom_link = true;

if ($Global['webpage_url_ssl'] == 'https://socialpaysme.com/') {
	if ($_SESSION['p2_status'] == 'Active' || $_SESSION['p2_status'] == 'Comped') {
		$pid = 2;
		$pname = 'PRO';
		$can_name_custom_link = true;
		//$embedcode = get_embed_code("{$pid}",1,11); // YOUTUBE USES 11 CHARS, SO A GOOD MODEL TO FOLLOW -- EXPAND TO MORE AS 10,000 CODES BECOMES NEAR
		//$embedcode = get_embed_code(0,1,6); // YOUTUBE USES 11 CHARS, SO A GOOD MODEL TO FOLLOW
	} else if ($_SESSION['p1_status'] == 'Active' || $_SESSION['p1_status'] == 'Comped') {
		$pid = 1;
		$pname = 'STARTER';
		$can_name_custom_link = false;
		//$embedcode = get_embed_code(0,1,4); // SET FOR 11 CHARS TOTAL
	} else { // MEMBER IS UNPAID
		$pid = 0;
		$pname = 'FREE';
		$can_name_custom_link = false;
		//$embedcode = get_embed_code(0,1,5); // SET FOR 11 CHARS TOTAL
	}
}

// QQQ COMMENT!
//error_reporting(E_ALL);

/*
textadcode becomes subject

textadcodedescr becomes body

DELETE ALL THESE!!

banneradcode now subject

banneradurl now url

email_subject now subject

email_message now body
*/

if (isset($_POST['type']) && $_POST['type'] !== '') {
    $type = htmlspecialchars($_POST['type'], ENT_QUOTES, 'UTF-8');
} elseif (isset($_GET['type']) && $_GET['type'] !== '') {
    $type = htmlspecialchars($_GET['type'], ENT_QUOTES, 'UTF-8');
} else {
    $type = ''; // Initialize $type to an empty string if none of the conditions above are met
}


// QQQ MTP KLUDGE - HAD 8 PEEPS SOMEHOW CREATE CAMPAIGNS WITHOUT A TYPE. ONLY TYPE ON MTP IS TRAFFIC!
//$type = 'traffic';

$ID = $_SESSION['UserID'] ?? 0;
$username = $_SESSION['loggedin'] ?? '';

if (isset($_GET['edit'])) $edit = htmlspecialchars($_GET['edit']);
else $edit = '';

$campaign_was_edited = false; // INI VAR
$lock_field = false; // INI VAR
$lock_url = false; // INI VAR
$product_sql = '';
if (isset($_GET['product_id'])) {
	$product_id = $_GET['product_id'];
} else if (isset($_SESSION['product_id'])) {
	$product_id = $_SESSION['product_id'];
} else if (!isset($product_id)) {
	$product_id = 0;
}
if ($product_id > 0 && $edit == '') {
	//$ad_source = 'LAC'; // QQQ SET PER CLIENT!
	$ad_source = 'CO-OP'; // QQQ SET PER CLIENT!
	$lock_field = true;
	$_SESSION['product_id'] = $product_id;
	
	$results = select('*', 'product', [], ['product_id' => $product_id], null, null, null, 0, 1);
	$buffers = isset($results[0]) ? $results[0] : null;

	$product_price = $buffers['product_price'] ?? 0;
	$display_product_price = number_format($buffers['product_price'] ?? 0);
	$units = number_format($buffers['quantity'] ?? 0);
	
	$prod_type = $buffers['product_type'];
	if ($prod_type == 'text') {
		$display_type = 'TEXTS';
		$headline = 'Text Blast';
	} else if ($prod_type == 'ringless') {
		$display_type = 'CALLS';
		$headline = 'Ringless Drop Calls';
		$desc = '';	
	} else if ($prod_type == 'email') {
		$display_type = 'EMAILS';
		$headline = 'Email Marketing';
		$desc = '';	
	} else if ($prod_type == 'solo') {
		$display_type = 'UNIQUE CLICKS';
		$headline = 'Solo Ads';
		$desc = '';	
	} else if ($prod_type == 'phone') {
		$display_type = 'INTERVIEWED';
		$headline = 'Phone Verified Leads';
		$desc = 'These are income qualified real time phone leads.';	
	} else if ($prod_type == 'combo') {
		$display_type = 'CUSTOM CAMPAIGN';
		$headline = '';
		$desc = '';	
	}
	
	// CUSTOM CAMPAIGNS DO NOT GIVE UNITS!
	if ($display_type != 'CUSTOM CAMPAIGN') $display_type = $units.' '.$display_type;

	$_POST['campaign'] = $display_type;
	$_POST['adsource'] = $ad_source;
	$_POST['amount_spent'] = $product_price;
}



$result = select('COUNT(idx) as tot', 'campaigns', [], ['ID' => $ID], null, null, null, 0, 1);
$buffer = isset($result[0]) ? $result[0] : null;


// FOR TRESTING
//$pname = 'PRO';
//$pname = 'STARTER';
//$pname = 'FREE';
//$buffer['tot'] = 25;
//echo $buffer['tot'];
// END TESTING
if ($Global['webpage_url_ssl'] == 'https://socialpaysme.com/') {
	if ($_REQUEST['edit'] == '') { // NOT EDITING CAMP - SO SHOW MAX LIMIT ERRORS WHEN APPROPRIATE
		if ($pname == 'PRO' && $_SESSION['loggedin_status'] == 3 && $buffer['tot'] >= 100) {
			$error = 'You have reached your 100 campaigns limit.<br/>Please <a href="https://socialpaysme.com/apay/pay.php?program=2" class="btn btn-warning btn-lg">Upgrade to Pro Advertiser</a>';
			$error2 = '<br/><br/>Alternately, you may also edit or remove existing campaigns if desired.';
		} else if ($pname == 'STARTER' && $buffer['tot'] >= 25) {
			$error = 'You have reached your 25 campaigns limit.<br/><br/><a href="https://socialpaysme.com/apay/buy.php?upgrade=Y" class="btn btn-warning btn-lg">Please Upgrade</a>';
			$error2 = '<br/><br/>Alternately, you may also edit or remove existing campaigns if desired.';
		} else if ($pname == 'QQQFREE' && $buffer['tot'] >= 10) {
			$error = 'You have reached your 10 free campaigns limit.<br/><br/><a href="https://socialpaysme.com/apay/buy.php?upgrade=Y" class="btn btn-warning btn-lg">Please Upgrade</a>';
			//$error2 = '<br/><br/>Alternately, you may also edit or remove existing campaigns if desired.';
		}
	}
}
if ($error != '') {
	echo '<h2>'.$error.'</h2>';	
	echo '<h4>'.$error2.'</h4>';
	include $Global['path'].'Sub/tpl/footer_tpl.php';	
	exit;
}

if (isset($_REQUEST['edit']) && $_REQUEST['edit'] !== '') { // EDITING CAMP!!
	$edit = $_GET['edit'];
	$selectFields = '*'; // ALL
	$mainTable = 'campaigns'; // IF ONLY ONE TABLE, WITH NO JOIN CONDITION
	$where = [
		'ID' => ['=', $ID],
		'short' => ['=', $edit]
	];
	$limit = 1; // GET SINGLE ROW
	$show_debug = 1;
	$result = select($selectFields, $mainTable, [], $where, null, null, null, $limit, $show_debug);
	$buffer = isset($result[0]) ? $result[0] : null;
	
	if ($buffer['ad_source'] == 'LAC' && $buffer['product_id'] > 0) {
		echo '<h2>You Cannot Edit Done For You Campaigns!</h2><br>'; 
		$lock_field = true;
		$lock_url = true;
		//exit;
	}	
	
	//if ($_POST['subject'] == $buffer['subject'] && $_POST['body'] == $buffer['body'] && $_POST['url'] == $buffer['url']) {
		// NOTHING THE PUBLIC SEES HAS CHANGED - SO NO NEED TO MAKE THE CAMP PENDING AGAIN!
	//}

	$whereCampUpdate = [];
	if ($_SERVER['REQUEST_METHOD'] === 'POST' && (
		(isset($_POST['subject']) && $_POST['subject'] != $buffer['subject']) ||
		(isset($_POST['body']) && $_POST['body'] != $buffer['body']) ||
		(isset($_POST['url']) && $_POST['url'] != $buffer['url']))) {
		// USER HAS UPDATED CONTENT THAT MUST BE APPROVED AGAIN, SO WE RESET CAMPAIGN TO PENDING STATUS
		$campaign_was_edited = true;
		$whereCampUpdate['status'] = ['=', 0];

		// QQQ OVERRIDE -> NOT FORCING REVIEWS OF CONTENT NOW	
		$campaign_was_edited = false;
		$whereCampUpdate = [];
		// END OVERRIDE
	} else {
		$campaign_was_edited = false;		
		$whereCampUpdate = [];
	}
		
	if (!isset($_POST['campaign']) || $_POST['campaign'] === '') $_POST['campaign'] = $buffer['name'];
	if (!isset($_POST['adsource']) || $_POST['adsource'] === '') $_POST['adsource'] = $buffer['ad_source'];
	if (!isset($_POST['amount_spent']) || $_POST['amount_spent'] === '') $_POST['amount_spent'] = $buffer['amount_spent'];
	if (!isset($_POST['subject']) || $_POST['subject'] === '') $_POST['subject'] = $buffer['subject'];
	if (!isset($_POST['body']) || $_POST['body'] === '') $_POST['body'] = $buffer['body'];
	if (!isset($_POST['url']) || $_POST['url'] === '') $_POST['url'] = $buffer['url'];

	$camp_edit = $buffer['short'];
	$type = $buffer['adtype'];
	$idx = $buffer['idx'];
	$idxA = $buffer['idx'];	
	
	if ($buffer['adtype'] == 'abtest' && $_POST['url2'] == '') { // GET THE A/B TEST CAMPAIGN URL NOW (GET THE URL FROM THE "B" CAMPAIGN)
		$selectFields = '*'; // NOTE - THE "B" CAMPAIGN IS TIED IN VIA THE IDX OF THE "A" CAMPAIGN, WHICH IS THE SHORT OF CAMP "B".
		$mainTable = 'campaigns';
		$where = [
			'short' => ['=', $idx]
		];
		$limit = 1; // GET SINGLE ROW
		$resultab = select($selectFields, $mainTable, [], $where, null, null, null, $limit, 1);
		$bufferab = isset($resultab[0]) ? $resultab[0] : '';
		if (!isset($_POST['url2']) || $_POST['url2'] == '') $_POST['url2'] = $bufferab['url']; // THIS IS CORRECT - NOT $bufferab['url2']	- DOES NOT EXIST!	
	}
}

// DO THIS FOR EDITS AND CREATIONS
if ($ID == 1) { // AUTO APPROVE ADMIN CAMPAIGNS
	$campaign_was_edited = false;		
	$whereCampUpdate['status'] = ['=', 1];
}	

if ($edit != '') {
	$heading_type = 'Edit';
	$post_headline = 'Has Been Edited!';
	$submit = 'Save Updates';
} else {
	$heading_type = 'Create';
	$post_headline = 'Has Been Created!';	
	$submit = 'Create Campaign';
}
if (isset($_REQUEST['add']) && $_REQUEST['add'] == 'credits' && $type != 'solo') {
	$heading_type = 'Add Credits To';
	$post_headline = 'Has Been Topped Off!';	
	$add = 'credits';
	$submit = 'Fill \'er up!';
	//echo 'GOT TO LINE 135!';
	//exit;	
} else if (isset($_REQUEST['add']) && $_REQUEST['add'] == 'credits' && $type == 'solo') {
	$heading_type = 'Re-run';
	$post_headline = 'Your Solo Ad is Queued For Sending!';	
	$add = 'credits';
	$submit = 'Run Solo Ad Again!';	
} else {
	$add = '';
}

// GET THE USER'S AVAILABLE CREDITS
$selectFields = 'user_credits';
$mainTable = 'members';
$where = [
    'ID' => ['=', $ID]
];
$limit = 1;
$show_debug = 1;
$result = select($selectFields, $mainTable, [], $where, null, null, null, $limit, $show_debug);
$buffer = isset($result[0]) ? $result[0] : null;


$user_credits = $buffer['user_credits'];

// QQQ SET MINIMUM AD SPEND REQUIRED // PER CAMPAIGN - DOES NOT REFLECT TYPE COSTS
$min_credit_spend = 500;

$url_start = '';
if (!isset($type)) $type = 'banner';
if ($type == 'url') {
	$ccvar = 'url_credit';
	$adtype_display = 'Short URL Tracking Link';
	$adtype = 'url';
	//$url_start = $Global['webpage_url_ssl'].'?id='.$_SESSION['loggedin'];
	// USING SHORT REDIRECT LINK
	$url_start = $Global['webpage_url_ssl'].'lc.php?id='.$_SESSION['loggedin'];	
	
	// ABANDONED THIS IDEA - CHARGING FOR THIS NOW!
	// KLUDGE TO ALLOW FREE MEMBERS TO SET UP SHORT URLS, WITHOUT CREDITS
	//$user_credits = 1;
	//$min_credit_spend = 1;
} else if ($type == 'abtest') {
	$ccvar = 'url_credit';
	$adtype_display = 'A/B Split Test URL Tracking Link';
	$adtype = 'abtest';
	$url_start = $Global['webpage_url_ssl'].'lc.php?id='.$_SESSION['loggedin'];
	$url_start2 = $Global['webpage_url_ssl'].'lc2.php?id='.$_SESSION['loggedin'];
} else if ($type == 'text') {	
	$ccvar = 'text_ad_credit';
	$adtype_display = 'Text Ad';
	$adtype = 'text';
} else if ($type == 'banner') {
	$ccvar = 'banner_ad_credit';
	$adtype_display = 'Banner Ad';
	$adtype = 'banner';
} else if ($type == 'solo') {
	$ccvar = 'solo_ad_credit';
	$adtype_display = 'Solo Ad';
	$adtype = 'solo';
} else if ($type == 'te') {
	$ccvar = 'traffic_credit';
	$adtype_display = 'Traffic Exchange Ad';
	$adtype = 'te';	
} else if ($type == 'login') {
	$ccvar = 'login_page_credit';
	$adtype_display = 'Login Ad';
	$adtype = 'login';
} else if ($type == 'logout') {
	$ccvar = 'logout_page_credit';
	$adtype_display = 'Logout Ad';
	$adtype = 'logout';
} else if ($type == 'sms') {
	$ccvar = 'sms_ad_credit';
	$adtype_display = 'SMS Ad';
	$adtype = 'sms';
} else if ($type == 'share') {
	$ccvar = 'video_credit';
	$adtype_display = 'Video Share';
	$adtype = 'share';
} else if ($type == 'tweet') {
	$ccvar = 'tweet_credit';
	$adtype_display = 'Tweet Share';
	$adtype = 'tweet';
} else if ($type == 'traffic') {
	$ccvar = 'banner_ad_credit'; // QQQ QUICK HACK, AS THESE ARE 1 CREDIT EACH ALSO!
	$adtype_display = 'Traffic';
	$adtype = 'traffic';
}


if ($adtype_display == 'Solo Ad') {
	$heading = 'Subject';
	$title = 'This is your Solo Ad Subject Line. Use 50 characters or less, and make it a catchy phrase.';
	$subj_char_limit = 50;
	$body_char_limit = 500;
} else if ($adtype_display == 'Banner Ad') {
	$heading = 'Title';
	$title = 'This is a call to action which will appear under your banner, as an additional link to your URL. Use 15 characters or less. Make it a catchy phrase.';
	$subj_char_limit = 15;
	$body_char_limit = 50;
} else if ($type == 'url') {
	$heading = 'Headline';
	$title = 'This is your Ad Headline, used here as a reference only (optional). Use 100 characters or less, and make it a catchy phrase.';
	$subj_char_limit = 100;
	$body_char_limit = 500;
} else {
	$heading = 'Headline';
	$title = 'This is your Ad Headline. It will link to your full text ad. Use 50 characters or less, and make it a catchy phrase.';
	$subj_char_limit = 50;
	$body_char_limit = 175;
}	

if (isset($_SESSION['p2_status']) && ($_SESSION['p2_status'] == 'Active' || $_SESSION['p2_status'] == 'Comped')) {
    $prog = 2;
} else if (isset($_SESSION['p1_status']) && ($_SESSION['p1_status'] == 'Active' || $_SESSION['p1_status'] == 'Comped')) {
    $prog = 1;
} else {
	$prog = 1; // FAILSAFE SO WE ALWAYS HAVE A PROGRAM FOR QRY BELOW
}


	
$selectFields = 'ccvalue';
$mainTable = 'creditsystemconfig';
$where = [
    'ccvarname' => ['=', $ccvar],
    'program_id' => ['=', $prog]
];
$limit = 1;
$show_debug = 1;
//echo $ccvar; exit;
$result = select($selectFields, $mainTable, [], $where, null, null, null, $limit, $show_debug);
$buffer = isset($result[0]) ? $result[0] : null;

$ccvalue = $buffer['ccvalue'];

	if ($debug == true) {
		echo 'TYPE IS: '.$type;
		//echo '';
	}
	
if ($type == 'solo' || $type == 'url' || $type == 'abtest') $adcredits = $ccvalue; // ALSO USED BELOW IN SAVE CONDITION, BUT NEEDED HERE ALSO!
	
if (isset($_REQUEST['action']) && $_REQUEST['action'] == 'save') {
	
	if ($debug == true) {
		echo '<pre>';
		print_r($_POST);
		echo '</pre>';
	}

	if (isset($_POST['subject'])) {
		$_POST['subject'] = substr($_POST['subject'], 0, $subj_char_limit);
	} else {
		$_POST['subject'] = ''; // Set a default value or handle it as needed
	}

	if (isset($_POST['body'])) {
		$_POST['body'] = substr($_POST['body'], 0, $body_char_limit);
	} else {
		$_POST['body'] = ''; // Set a default value or handle it as needed
	}

		
	$campaign = $_POST['campaign'];	
	
// CAPITALIZE FIRST WORD IN CAMP NAMES
	preg_match_all('/[A-Za-z]+|[^A-Za-z]+/', $campaign, $data);
	for ($i = 0; $i < count($data[0]); $i++) {
	  $data[0][$i] = ucfirst($data[0][$i]);
	}
	$campaign = implode("", $data[0]);
	
	$url = trim($_POST['url'] ?? '');
	$url2 = trim($_POST['url2'] ?? '');
	
	
	// IF USER LEFT THE MIN CREDIT SPEND EMPTY, LET'S SET IT TO THE MIN CREDIT SPEND FOR THEM, IF THEY HAVE IT!
	if (isset($_POST['adcredits']) && $_POST['adcredits'] == '' && $user_credits >= $min_credit_spend) $_POST['adcredits'] = $min_credit_spend;
	
	$_POST['adcredits'] = $_POST['adcredits'] ?? '';
	
	if (is_numeric($_POST['adcredits']) || $_POST['adcredits'] == '') {
		// do nothing
	} else {
		$error = 'Please input a valid Ad Credits Amount<br/>(numbers only).<br />';
	}	
	
	if (isset($_POST['adcredits']) && !empty($_POST['adcredits'])) $adcredits = trim($_POST['adcredits']);
	else $adcredits = 0;
	
	if ($type == 'solo' || $type == 'url') $adcredits = $ccvalue; // THIS MUST BE SET ABOVE OUTSIDE SAVE CONDITION ALSO!
	
	$adsource = $_POST['adsource'] ?? '';
	
	if (!isset($_POST['amount']) || is_numeric($_POST['amount']) || $_POST['amount'] == '') {
		// do nothing
	} else {
		$error .= 'Please input a valid Amount Spent<br/>(numbers only).<br />';
	}
	
	if (empty($campaign)) {
		$error .= 'Please input a campaign name. <br />';
	}	
	
	if (empty($error)) {
	$amount = $_POST['amount'] ?? '';
	$banners = $_POST['banners'] ?? '';
	$subject = $_POST['subject'] ?? '';
	$body = $_POST['body'] ?? '';
	
	
	$selectFields = '*';
	$mainTable = 'campaigns';
	$where = [
		'ID' => ['=', $ID],
		'name' => ['=', $campaign]
	];
	$orderBy = 'idx ASC';
	$limit = 1;
	$show_debug = 1;

	$result = select($selectFields, $mainTable, [], $where, null, null, $orderBy, $limit, $show_debug);
	$buffer = isset($result[0]) ? $result[0] : null;	
	$idx = $buffer['idx'];
	}

	if (isset($buffer['idx']) && $_REQUEST['edit'] == '') {
		$error .= "That campaign already exists!<br/>Please choose another name. <br />";
	}							
	if (isset($_POST['adcredits']) && $_POST['adcredits'] > $user_credits/* && $_REQUEST['edit'] == ''*/) {
		$error .= "You have ".$user_credits." Ad Credits.<br/>You cannot spend more than that on a campaign. <br />" ;
	}	

	if ($adtype != 'url' && $adtype != 'abtest') { // SHORT URLS ARE FREE, ALL OTHER TYPES THEY PAY FOR	
		if ($adcredits == '' && $adtype != 'url' && $_REQUEST['edit'] == '') {
			$error .= 'Please specify the number of Ad Credits<br/>to spend on this campaign. <br/>';		
		} else if (is_numeric($adcredits) && $edit == '') { // WE HAVE A VALID NUMBER - PROCEED!
			
			if ($edit != '') { // ON EDITS, THEY ARE REFILLING CAMPAIGNS, SO DO NOT ENFORCE MIN CAMP SPEND
				$real_min_credit_spend = $ccvalue; // ONLY REQUEST MIN VALUE PER CAMP TYPE
			} else { // FIRST TIME AROUND, THEY PAY THE MINIMUM CAMP SPEND PRICE!
				$real_min_credit_spend = $min_credit_spend;
			}
			
			if (($add == '' && $adcredits < $real_min_credit_spend) && $type != 'solo' && $type != 'url') {
				$error  .= 'The Minimum Campaign Spend is '.$real_min_credit_spend.' Ad Credits. <br />';
			} else if (($adcredits / $adcredits) != 1) {
				$error  .= 'Your Spend for '.$adtype_display.'s must be '.number_format($ccvalue,0).' Ad Credits, (or a multiple of '.number_format($ccvalue,0).'). <br />';
			} else if ($adcredits < $ccvalue) {
				$error  .= $adtype_display.'s cost '.number_format($ccvalue,0).' Ad Credits. Please increase your Ad Credit Spend to at least this amount.<br />';
			} 
			
		} else if ($edit == '') {
			$error .= 'Please input a valid Ad Credits amount (numbers only).<br />';
		}
	}
	
	if (empty($_POST['subject']) && $type != 'url' && $type != 'share' && $type != 'tweet' && $type != 'sms' && $type != 'abtest' && $type != 'traffic') {
		$error .= 'Please add a Title / Headline / Subject <br />';
	}	
	
	if (empty($_POST['body']) && $edit == '' && $type != 'url' && $type != 'share' && $type != 'tweet' && $type != 'sms' && $type != 'abtest' && $type != 'banner' && $type != 'traffic') {
		$error .= 'Please add a Description / Body <br />';
	}		


	if ($banners == '' && $type == 'banner' && $_REQUEST['edit'] == '') {
		$error  .= 'Please choose a banner. <br />';
	}
	
	if ($url == '' && $edit == '') {
		$error .= 'Please input a Destination URL<br />';
	}	
	
	if ($url != '') {
		//$url=str_replace("http://","",$url);		
		//$url=str_replace("www.","",$url);		
		
	/*	if(preg_match("/\//",$url)){	
			$urlarray=explode("/",$url);
			$url=$urlarray[0];
		} 
	*/	
		$selectFields = '*';
		$mainTable = 'url_list';
		$where = [
			'url' => ['LIKE', "%{$url}%"],
			'status' => ['=', 'bad']
		];
		$limit = 1;
		$show_debug = 1;

		$result = select($selectFields, $mainTable, [], $where, null, null, null, $limit, $show_debug);
		$buffer_url = isset($result[0]) ? $result[0] : null;
		
		if ($debug == true && isset($buffer_url)) print_r($buffer_url);
				
		if (isset($buffer_url) && $buffer_url['status'] == 'bad') {
			//$error .= ' Banned URL Please check our <a href="./banned-programs.php" target="_new">banned programs</a> list, and add another URL<br />';
			$error .= 'Banned URL. Please promote another URL.<br />';
		}
	}

	// QQQ TESTING ERROR MSG HERE!!	
	//$error = '?';
	//if (!empty($error)) {
	//	echo '<h3 style="color:red;">'.$error.'<br />&nbsp;</h3>';
	// } 	
	
	//if ($error == '') { MOVING DOWN BELOW - WAS NOT STOPPING ERRORS CREATED BELOW!
					
		/*
		$descrypt= sha1(time());
		$randst=rand(1,33);
		$goodurlshort=substr($descrypt,$randst,8);
		*/
		
		
		$embedcode = rand(1,11);
		//$goodurlshort = 'C'.$pid.$pname.$embedcode;
		
		$descrypt= sha1(time());
		$randst=rand(1,33);
		$goodurlshort=substr($descrypt,$randst,7);
		
		$goodurlshort = strtoupper($goodurlshort);
		
		if (!empty($_POST['short_url'])) {
			$short = $_POST['short_url'];
			//$short = preg_replace("/[^a-zA-Z0-9]+/", "", $short); // MAKE URL ALPHANUMERIC ONLY!!
			$short = preg_replace("/[^0-9a-zA-Z-]/", '', $short); // MAKE URL ALPHANUMERIC ONLY - LEAVE HYPHEN!!
			$short = strtoupper($short);

			// NOW CHECK TO MAKE SURE THIS SHORT URL IS NOT SOMEONE ELSE'S USERNAME!
			$selectFields = 'ID';
			$mainTable = 'members';
			$where = [
				'Username' => ['=', $short]
			];
			$orderBy = 'ID DESC';
			$limit = 1; // To get only the latest entry
			$show_debug = 1;

			$result = select($selectFields, $mainTable, [], $where, null, null, $orderBy, $limit, $show_debug);
			$buffermem = isset($result[0]) ? $result[0] : null;
			
			if ($buffermem['ID'] != '' && ($buffermem['Username'] != $_SESSION['loggedin'])) { // SHORT IS ANOTHER'S USERNAME!
				$error = 'We\'re sorry, but your chosen short URL belongs to another member.<br/>Please choose a new short URL code.';
			} else {
				$goodurlshort = $short;
			}
			
			// NOW CHECK TO MAKE SURE THIS SHORT URL IS NOT ALREADY IN USE!
			$qryshort = "SELECT idx FROM campaigns WHERE short = '{$short}' LIMIT 1";
			$selectFields = 'idx';
			$mainTable = 'campaigns';
			$where = [
				'short' => ['=', $short]
			];
			$limit = 1; // To fetch only one record
			$show_debug = 1;

			$result = select($selectFields, $mainTable, [], $where, null, null, null, $limit, $show_debug);
			$buffershort = isset($result[0]) ? $result[0] : null;

			if ($buffershort['idx'] != '') { // SHORT IS ALREADY IN USE!
				$error = 'We\'re sorry, but your chosen short URL is already in use.<br/>Please choose a new short URL code.';
			}

			// NOW CHECK TO MAKE SURE THIS SHORT URL IS NOT ALREADY IN USE AS AB TEST!
			// MUST BE DONE TO PROTECT 
			$where = [
				'idx' => ['=', $short]
			];
			$result = select($selectFields, $mainTable, [], $where, null, null, null, $limit, $show_debug);
			$buffershort = isset($result[0]) ? $result[0] : null;		
			
			if ($buffershort['idx'] != '' && $buffershort['ID'] != '{$ID}' && $buffershort['adtype'] != 'abtest') { // SHORT IS ALREADY IN USE - AND IS NOT THIS LOGGEDIN USER'S ABTEST MATCH!
				$error = 'We\'re sorry, but your chosen short URL is already in use.<br/>Please choose a new short URL code.';
			}			
			
			
		} // END POST SHORT URL NOT EMPTY
			
		//	if($_POST['banners'])$banners_join=join(":",$_POST['banners']);
		//	if($_POST['banners'])$banners_array=$_POST['banners'];
		
		

	if ($error == '') {	
	
		$campaign = isset($campaign) ? $campaign : '';
		$url = isset($url) ? $url : '';
		$url2 = isset($url2) ? $url2 : '';		
		$adsource = isset($adsource) ? $adsource : '';
		$subject = isset($subject) ? $subject : '';
		$body = isset($body) ? $body : '';
		$amount = isset($amount) ? $amount : '';
		$banners = isset($banners) ? $banners : '';
		$camp_edit = isset($camp_edit) ? $camp_edit : '';	
	
		if ($edit != '' && $add == 'credits') {
			//echo 'UPDATE!<br>';
			$data = [
				'stcredits' => ['expression' => 'stcredits'.'+'.$adcredits],
				'adcredits' => ['expression' => 'adcredits'.'+'.$adcredits]
			];
			update('campaigns', $data, [], ['ID' => $ID, 'short' => $camp_edit], 1, 1, 1);
		} else if ($edit != '' && $add != 'credits') {			
			//echo 'UPDATE!<br>';
			$table = 'campaigns';
			$data = [
				'name' => $campaign,
				'url' => $url,
				'ad_source' => $adsource,
				'subject' => $subject,
				'body' => $body,
				'amount_spent' => $amount,
				'banners' => $banners
			];
			$whereCampUpdate['ID'] = ['=', $ID];
			$whereCampUpdate['short'] = ['=', $camp_edit];
			$live = 1;
			$limit = 1;
			$show_debug = 1;
			update($table, $data, [], $whereCampUpdate, $live, $limit, $show_debug);

			if ($type == 'abtest') {
				$data = [
					'name' => $campaign,
					'url' => $url2,
					'ad_source' => $adsource,
					'subject' => $subject,
					'body' => $body,
					'amount_spent' => $amount,
					'banners' => $banners
				];
				$whereCampUpdate['short'] = ['=', $idxA];				
				update($table, $data, [], $whereCampUpdate, $live, $limit, $show_debug);			
			}	
		} else {
			//echo 'INSERT!<br>';
			// Ensure all variables are set to an empty string if not defined
			$variables = ['campaign', 'url', 'goodurlshort', 'adtype', 'adsource', 'subject', 'body', 'amount', 'adcredits', 'banners', 'ID'];
			foreach ($variables as $var) {
				if (!isset($$var)) $$var = '';
			}

			// Define data for insertion using the PHPCPR framework
			$table = 'campaigns';
			$data = [
				'name' => $campaign,
				'url' => $url,
				'short' => $goodurlshort,
				'adtype' => $adtype,
				'ad_source' => $adsource,
				'subject' => $subject,
				'body' => $body,
				'amount_spent' => $amount,
				'stcredits' => $adcredits,
				'adcredits' => $adcredits,
				'banners' => $banners,
				'ID' => $ID
			];
			$live = 1;
			$show_debug = 1;
			
			if ($ID == 1) { // AUTO APPROVE ADMIN CAMPAIGNS
				$data['status'] = ['=', 1];
			}

			// Perform the insert operation
			$res = insert($table, $data, $live, $show_debug);
			$idx = $res['last_insert_id'];

			if ($type == 'abtest') {
				// GET CAMP ID OF JUST CREATED CAMPAIGN
				$selectFields = 'idx';
				$mainTable = 'campaigns';
				$where = [
					'short' => ['=', $goodurlshort],
					'ID' => ['=', $ID]
				];
				$limit = 1; // To fetch only one record
				$show_debug = 1;

				$result = select($selectFields, $mainTable, [], $where, null, null, null, $limit, $show_debug);
				$buffer_idx = isset($result[0]) ? $result[0] : null;				
								
				$idx = $buffer_idx['idx'];
				$data['url'] = ['=', $url2];
				$data['short'] = ['=', $idx];

				// Perform the insert operation
				insert($table, $data, $live, $show_debug);				
			}
		}
		
		// IF BANNERS ARE NOT WORKING TRY ALSO banners='".$banners_join IN ABOVE QRY.";

		// INSERT URL WITH APPROPRIATE STATUS
		if ($_POST['url'] != $url_start && (!isset($buffer_url) || $buffer_url['id'] == '' && $buffer_url['url'] == '')) {
			if ($debug == true) echo 'DOING URL INSERT';
			insert('url_list', ['url' => $url, 'status' => 'pending', 'member_id' => $ID], 1, 1);
		} else if (($_POST['url'] == $url_start || $buffer_url['status'] == 'good') && ($adtype == 'bannerQQQ' || $adtype == 'url')) { // URL ALREADY EXISTS, AND IS GOOD, AND NO TEXT IS USED -- SO PREAPPROVE THIS CAMPAIGN!!
			if ($debug == true) echo 'DOING URL STATUS UPDATE!';
			if ($_SESSION['product_id'] != '') $this_status = 0; // BUYING A CAMPAIGN - MAKE IT PENDING!
			else $this_status = $prog;

			// Initialize variables to an empty string if they are not set
			$this_status = isset($this_status) ? $this_status : '';
			$goodurlshort = isset($goodurlshort) ? $goodurlshort : '';

			$table = 'campaigns';
			$data = [
				'status' => $this_status
			];
			$where = [
				'ID' => ['=', $ID],
				'short' => ['=', $goodurlshort]
			];
			$show_debug = 1;
			$live = 1; // To execute the query
			$limit = 1; // Assuming you want to update only one record that matches the condition

			$res = update($table, $data, [], $where, $live, $limit, $show_debug);
			$idx = $res['last_insert_id'];
		}
		
		// DEDUCT USER CREDITS FROM MEMBERS TABLE		
		if (isset($_POST['adcredits']) && $_POST['adcredits'] != '' && ($edit == '' || $add != '')) {
			$credit_bal = ($user_credits - $adcredits);
			// WE DON'T GO NEGATIVE!
			if ($credit_bal >= 0) update('members', ['user_credits' => $credit_bal], [], ['ID' => $ID], 1, 1, 1);			

			// CREATE CREDIT LOG ---> TO LOG THE AD CREDIT SPEND!			
			$qry_log_data = [
				'campid' => $idx, 'credits_spent' => $adcredits, 
				'type' => $type, 'ID' => $ID, 
				'program' => $prog, 'date' => $datetime
			];
			insert('credit_log', $qry_log_data, 1, 1);
		}
		?>

		<h2>Your Campaign <?php echo $post_headline; ?></h2>
 
		<?php if ($add == '' && $campaign_was_edited == true) { ?>
		<h3><span style="color:red">NOTE:</span> All ads are approved manually before going live. This may take up to 24 hours.</h3>
		<h4>Short Redirect Tracking URLs <!--and Banner URLs-->will be approved immediately, if they have been pre-approved.</h4>
		<?php
		}
		echo '<p>&nbsp;</p>';
		if ($edit != '') { 	// JUST EDITED
		
		if ($_SESSION['loggedin'] != 'QQQdemo') {
			echo '<p>&nbsp;</p><div class="alert alert-warning" role="alert"><h1>STOP and double check your link!</h1>';	
			echo '<a href="'.$Global['webpage_url_ssl'].$camp_edit.'" class="btn btn-warning" target="_blank">My Campaign Link</a><br> (opens in new window)</div>';
			
			echo '<p>&nbsp;</p><div class="alert alert-warning" role="alert"><h1>Is the above link wrong?</h1>';	
			echo '<a href="'.$Global['webpage_url_ssl'].'ads/campaign-creator.php?type=traffic&edit='.$camp_edit.'" class="btn btn-warning" target="_blank">Click Here To Make Changes</a></div>';
			echo '<p>&nbsp;</p>';
		}
		
		
		?>
			<p><a href="campaign-stats.php?c=<?php echo $camp_edit; ?>" class="btn btn-success">Click Here To See Your Campaign</a></p>
		<?php	
		} else { // JUST MADE
		
		if ($_SESSION['loggedin'] != 'QQQdemo') {
			echo '<p>&nbsp;</p><div class="alert alert-warning" role="alert"><h1>STOP and double check your link!</h1>';	
			echo '<a href="'.$Global['webpage_url_ssl'].$goodurlshort.'" class="btn btn-warning" target="_blank">My Campaign Link</a><br> (opens in new window)</div>';
			
			echo '<p>&nbsp;</p><div class="alert alert-warning" role="alert"><h1>Is the above link wrong?</h1>';	
			echo '<a href="'.$Global['webpage_url_ssl'].'ads/campaign-creator.php?type=traffic&edit='.$goodurlshort.'" class="btn btn-warning" target="_blank">Click Here To Make Changes</a></div>';
			echo '<p>&nbsp;</p>';
		}		
			
			echo '<p><a href="campaign-stats.php" class="btn btn-success">Click Here To See Your Campaigns</a></p>';
		}
		if ($edit == '') { // JUST MADE
		?>	

		<span style="color:red">NOTE:</span> there will be no stats until after your campaign has been approved, and you get traffic to your campaign URL.

		<?php
		} // END JUST MADE
		if ($adtype_display == 'Banner Ad') {
				// TEXTAREA URLS USES .HTACCESS REWRITE CONDITIONS
				$selectFields = 'bannername';
				$mainTable = 'banners';
				// Adapting the OR structure for numerical comparison might not directly fit, 
				// but conceptually, if we could, it would resemble something like this:
				$where = [
					'OR' => [
						'member_id' => ['<', 2],
						'member_id' => ['=', $ID]
					]
				];
				$show_debug = 1;
				$result = select($selectFields, $mainTable, [], $where, null, null, null, 0, $show_debug);
				$buffer = isset($result[0]) ? $result[0] : null;

				
				/*echo '<p><img src="'.$Global['webpage_url_ssl'].'images/banners/'.$buffer['bannername'].'"><br>
				<textarea cols="50" rows="3" wrap="on">
				<a href="'.$Global['webpage_url_ssl'].'banner_clicks/'.$banners.'/'.$goodurlshort.'">
				<img src="'.$Global['webpage_url_ssl'].'images/banner_imps/'.$banners.'/'.$goodurlshort.'/"></a>
				</textarea></p>';*/
		}
		include $Global['path'].'Sub/tpl/footer_tpl.php';
		exit;
		} // END NO ERROR!!
} // END SAVING NEW CAMPAIGN!!		
?>

<div class="row">
    <div class="center">
        <div class="col-xs-12 col-md-6 col-md-offset-3">

<div style="text-align: center;">

<?php if ($type != 'urlQQQ') { ?>
	<h2><?php echo $heading_type.' '.$adtype_display; if (strlen($adtype_display) > 10) echo '<br/>'; ?> Campaign</h2>

	<?php if ($ccvalue > 0) { ?>
	
	<?php 
	$ad_credit_desc = 'Ad Credits';
	if ($ccvalue == 1) $ad_credit_desc = 'Ad Credit';
	if ($type == 'url') {
		$end_headline = 'one time';
	} else if ($type == 'solo') {
		$end_headline = 'per send';
	} else if ($type == 'banner') {
		$end_headline = 'per impression';
	} else {
		//$end_headline = 'per click';
		$end_headline = 'per impression';
	} ?>
	<?php } ?>

	<?php if ((($edit == '' && $ccvalue > 0) || ($edit != '' && $add != '' ))) { 
	
		if ($type != 'QQQurl') $ad_title = 'Ads';
		else $ad_title = 'Campaigns';
		$ad_title = 'Campaigns';
	?>
	<h4 style="color:"><?php echo $adtype_display.' '.$ad_title.' are '.$ccvalue.' '.$ad_credit_desc.' '.$end_headline; ?></h4>
	<?php } ?>
	
<?php } else if ($type == 'url' && $edit == '') { 
	echo 'Create '.$adtype_display.'</h2>';
	echo 'This tool will allow you to create short URL tracking links, to track your promotions.';
	echo '<br/><br/>We recommend you create a unique short URL for each External Ad Campaign you run.';
	echo '<br/><br/><i class="fa fa-thumbs-up" style="color:#00b3fe" aria-hidden="true"></i> <u>This service is FREE for all Starter and Pro members</u><br/><br/>';
}

if (($ccvalue > 0 && $edit == '') || ($edit != '' && $add != '')) { ?>
	<h4 style="color:green">You Have <?php echo $user_credits; ?> Available Ad Credits.</h4>	
<?php
}

if ($edit == '' && $ccvalue > 0 && $type != 'solo' && $type != 'url') { ?>
	<h4 style="color:"><?php echo 'The minimum Ad Campaign spend is '.$min_credit_spend.' Ad Credits.'; ?></h4>
<?php }
if (!empty($error)) { ?>
<hr>
	<h3 style="color:red;"><?php echo $error; ?><br />&nbsp;</h3>
<?php } ?>
<hr>

<form method="post" name="myForm" onsubmit="document.getElementById('submit').disabled=true; document.getElementById('submit').value='Submitting, please wait...';">
<input type="hidden" name="action" value="save">					
<input type="hidden" name="type" value="<?php echo $type; ?>">
<input type="hidden" name="add" value="<?php echo $add; ?>">


<?php if ($add != '') { 

	if ($type == 'solo') $_POST['adcredits'] = $adcredits; 
	//echo 'ADCREDITS: '.$adcredits;

	if ($type != 'solo') { ?>
		Add Credits <a style="text-decoration:none" data-toggle="tooltip" data-placement="top" title="Define how many Ad Credits you wish to Add to this Campaign."><i class="fa icon-question"></i></a>
	<?php } else { ?>
		Run This Solo Ad Again? <a style="text-decoration:none" data-toggle="tooltip" data-placement="top" title="Submit this form to queue this Solo Ad for another mailing"><i class="fa icon-question"></i></a>
	<?php } ?>	
		<input class="form-control" onMouseover="this.focus()" name="adcredits" maxlength="10" value="<?php if (isset($_POST['adcredits'])) : echo $_POST['adcredits']; else : echo ''; endif; ?>" id="inputSuccess" placeholder="Number of Credits" <?php if ($type == 'solo') echo 'readonly';?>>
		<p></p>

<?php } else { ?>
		Campaign Name (For your reference only): <a style="text-decoration:none" data-toggle="tooltip" data-placement="top" title="Define a name for this Campaign."><i class="fa icon-question"></i></a>		
				<input class="form-control" onMouseover="this.focus()" name="campaign" maxlength="25" value="<?php if(isset($_POST['campaign'])) : echo $_POST['campaign']; else : echo ''; endif; ?>" id="inputSuccess" placeholder="My Campaign Name">
		<p></p>
		
<?php if ($ccvalue > 0 && $type != 'solo' && $type != 'url' && $edit == '') { // IF THIS AD TYPE IS NOT FREE AND NOT A SOLO AD, THIS SHOW FIELD 
?>		
		Ad Credit Spend <a style="text-decoration:none" data-toggle="tooltip" data-placement="top" title="Define how many Ad Credits you wish to spend on this Campaign."><i class="fa icon-question"></i></a>
				<input class="form-control" onMouseover="this.focus()" name="adcredits" maxlength="10" value="<?php if(isset($_POST['adcredits'])) : echo $_POST['adcredits']; else : echo ''; endif; ?>" id="inputSuccess" placeholder="Ad Credits to Spend on this Campaign">
		<p></p>
<?php } 
if ($type == 'share' || $type == 'tweet' || $type == 'url' || $type == 'abtest') {
?>		
		Advertising Source (optional) <a style="text-decoration:none" data-toggle="tooltip" data-placement="top" title="Where you will Advertise this Campaign (optional)."><i class="fa icon-question"></i></a>
				<input class="form-control" onMouseover="this.focus()" name="adsource" maxlength="25" value="<?php if(isset($_POST['adsource'])) : echo $_POST['adsource']; else : echo ''; endif; ?>" id="inputSuccess" placeholder="Where I will Advertise this Campaign">
		
<?php }
if ($type == 'share' || $type == 'tweet' || $type == 'url' || $type == 'abtest') { ?>
		<p></p>
		Amount Spent (optional) <a style="text-decoration:none" data-toggle="tooltip" data-placement="top" title="Define how much you will spend for this Campaign (optional)."><i class="fa icon-question"></i></a>
				<input class="form-control" onMouseover="this.focus()" name="amount" maxlength="10" value="<?php if(isset($_POST['amount_spent'])) : echo $_POST['amount_spent']; else : echo ''; endif; ?>" id="inputSuccess" placeholder="Amount Spent on this Ad Campaign">
		<?php } ?>		

		<?php if ($type != 'tweet' && $type != 'share' && $type != 'url' && $type != 'abtest' && $type != 'traffic') { // DO NOT SHOW ON SHARES OR URLS! ?>		
		<p></p>				
		<?php echo $adtype_display; ?> <?php echo $heading; ?> <a style="text-decoration:none" data-toggle="tooltip" data-placement="top" title="<?php echo $title; ?>"><i class="fa icon-question"></i></a>
		
		<textarea class="form-control" rows="3" cols="25" size="25" name="subject" maxlength="<?php echo $subj_char_limit; ?>" onkeydown="return keyhandler(this,event,<?php echo $subj_char_limit; ?>)"><?php if (isset($_POST['subject'])) echo htmlspecialchars($_POST['subject'], ENT_QUOTES, 'UTF-8'); ?>
</textarea>
		<!--<small> <?php echo $subj_char_limit; ?> Chars Limit</small>-->
		<small> <span id="counter" style=""></span></small>
	
		<p></p>	
		<?php 
		if ($type != 'banner' && $type != 'traffic') {
		$body_desc = 'Description';
		if ($type == 'solo') $body_desc = 'Body';
		
		echo $adtype_display; ?> <?php echo $body_desc; ?>: <a style="text-decoration:none" data-toggle="tooltip" data-placement="top" title="This is your <?php echo $adtype_display; ?> Message. 
		<?php if ($type == 'url') echo '(Optional)'; ?> Use <?php echo $body_char_limit; ?> characters or less. Make it compelling."><i class="fa icon-question"></i></a>

		<textarea class="form-control" rows="3" cols="25" size="25" name="body" maxlength="<?php echo $body_char_limit; ?>" onkeydown="return keyhandle(this,event,<?php echo $body_char_limit; ?>)"><?php if (isset($_POST['body'])) echo htmlspecialchars($_POST['body'], ENT_QUOTES, 'UTF-8'); ?>
</textarea>
		<!--<small> <?php echo $body_char_limit; ?> Chars Limit</small>-->
		<small> <span id="counter2"></span></small>
		<?php 
		} // TYPE IS NOT BANNER
		} // END IS NOT A SHARE / IS NOT URL / IS NOT ABTEST ?>
		
		<?php if ($type != 'abtest') { ?> 
		<p></p>		
		Destination URL: <a style="text-decoration:none" data-toggle="tooltip" data-placement="top" title="Add the URL that you want people to go to when they click on your <?php echo $adtype_display; ?>."><i class="fa icon-question"></i></a>	
	 
		<input class="form-control" onMouseover="this.focus()" name="url" value="<?php if (isset($_POST['url'])) : echo $_POST['url']; else : echo $url_start; endif; ?>" id="inputSuccess" placeholder="Website to send your traffic to - start with http:// or https://">
		<?php } // END IS NOT AB TEST ?>		

		<?php if ($type == 'abtest') { ?> 
		<p></p>		
		A/B Test URL 1: <a style="text-decoration:none" data-toggle="tooltip" data-placement="top" title="Add the first URL that you want people to go to when they click on your <?php echo $adtype_display; ?> Ad."><i class="fa icon-question"></i></a>	
				
		<input class="form-control" onMouseover="this.focus()" name="url" value="<?php if (isset($_POST['url'])) : echo $_POST['url']; else : echo $url_start; endif; ?>" id="inputSuccess" placeholder="Website to send your traffic to">		
		
		A/B Test URL 2: <a style="text-decoration:none" data-toggle="tooltip" data-placement="top" title="Add the second URL that you want people to go to when they click on your <?php echo $adtype_display; ?> Ad."><i class="fa icon-question"></i></a>	
				
		<input class="form-control" onMouseover="this.focus()" name="url2" value="<?php if (isset($_POST['url2'])) : echo $_POST['url2']; else : echo $url_start2; endif; ?>" id="inputSuccess" placeholder="Website to send your traffic to">
		<?php } // END IS AB TEST ?>		
		
		<?php
		if ($can_name_custom_link == true && isset($_REQUEST['edit'])) { // USE IS PRO, AND WE'RE NOT EDITING CAMPAIGN 
		?>		
		<p></p>
		
		<?php if ($Global['webpage_url_ssl'] == 'https://socialpaysme.com/') { ?>
		As A Pro Member, you may name your own Short URL link.
		<?php } else { ?>
		You may name your own Short URL link. 
		<?php } ?>
		
		Create your link name below, or leave blank, for a random Short URL.
		<input class="form-control" type="input" onMouseover="this.focus()" name="short_url" value="<?php if(isset($_POST['short_url'])) : echo $_POST['short_url']; else : echo ''; endif; ?>" id="inputSuccess" placeholder="My Short URL" maxlength="30"
				<?php //if ($_REQUEST['QQQs'] != '') echo 'readonly';?>>

				 <?php echo '<small>Alphanumeric characters only (letters and numbers)</small>'; ?>
		<?php } // END MEMBER IS PRO ?>
<p>&nbsp;</p>
	<?php } // END NOT ADDING CREDITS ?>

<?php if ($type == 'banner') { ?>

<h2>Please Select 1 Banner You Would Like To Use.</h2>
<br>

<div class="table-responsive">
	<table class="table">
		<?php
		//SELECT BANNERS UPLOADED BY ADMIN OR BY THE LOGGEDIN USER
			$selectFields = '*'; // Select all fields
			$mainTable = 'banners';
			$where = [
				'member_id' => ['IN', [0, 1, $ID]] // This assumes your framework can handle 'IN' conditions similarly.
			];
			$show_debug = 1;
			$result = select($selectFields, $mainTable, [], $where, null, null, null, 0, $show_debug);
			foreach ($result as $row) {	
				
				echo '<tr><td><input type="radio" name="banners" value="'.$row['bannerid'].'"><p>&nbsp;</p></td>
				<td><img src="'.$Global['webpage_url_ssl'].'/images/banners/'.$row['bannername'].'" class="img-responsive"><p>&nbsp;</p></td></tr>';
			}
		?>
	</table>
</div>	
<p>&nbsp;</p>
<?php } ?>

<!-- CLOSE FORM TO DISABLE FOR DEMO ONLY
</form>
<form>
<input class="input" type="submit" value="Create Campaign" name="submit" onclick="alert('Disabled in demo!');">
-->

<input type="submit" value="<?php echo $submit; ?>" name="submit" id="submit" class="btn btn-info btn-default">
</form>
</div>	

 </div>

    </div>
</div>
<script>
 
function keyhandler(obj,e,max){
    e = e || event;
    max = max || 50;
    var keycode = e.keyCode
      , len     = 0
      , This    = keyhandler
      , currlen = obj.value.length;
     
    if (!('countfld' in This)){
        This.countfld = document.getElementById('counter');
    }
    
    if (keycode === 13) {
        return document.forms[0].submit();
    }
    if ((keycode == 32 || keycode>46) 
         && currlen >= max) {
        This.countfld.innerHTML = '<span style="color:red">Maximum <?php echo $subj_char_limit; ?> Characters Reached</span>';
        return false;
    }
    len = (keycode==8 || (keycode===46)
           && obj.value.length<=max && currlen > 0) 
            ? currlen-1
            : keycode <= 46 
               ? currlen
               : currlen+1;
    This.countfld.innerHTML = (currlen <1 ? max : max-len) + ' Characters Left';
    return true;
}

function keyhandle(obj,e,max){
    e = e || event;
    max = max || 50;
    var keycode = e.keyCode
      , len     = 0
      , This    = keyhandle
      , currlen = obj.value.length;
     
    if (!('countfld' in This)){
        This.countfld = document.getElementById('counter2');
    }
    
    if (keycode === 13) {
        return document.forms[0].submit();
    }
    if ((keycode == 32 || keycode>46) 
         && currlen >= max) {
        This.countfld.innerHTML = '<span style="color:red">Maximum <?php echo $body_char_limit; ?> Characters Reached</span>';
        return false;
    }
    len = (keycode==8 || (keycode===46)
           && obj.value.length<=max && currlen > 0) 
            ? currlen-1
            : keycode <= 46 
               ? currlen
               : currlen+1;
    This.countfld.innerHTML = (currlen <1 ? max : max-len) + ' Characters Left';
    return true;
}
</script>
<?php
include $Global['path'].'Sub/tpl/footer_tpl.php';
?>