<?php
//-----------------------------------------------------------------
// Software: Automatic Web Software (AWS) built with PHPCPR
// Firm: DirectSalesMLM.com / AutomaticWebSoftware.com / PHPCPR.com
// Author: Jim Symonds Email: jim@directsalesmlm.com
// Copyright 2006 - 2024 Jim Symonds All Rights Reserved.
//-----------------------------------------------------------------
include '../Members/logincheck.php';
$pageName = 'Campaign Stats'; // THIS IS SHOWN AS A BREADCRUMB UNDER THE MENU, AND IS ALSO USED AS THE PAGE TITLE, IF $pageDesc IS LEFT EMPTY.
$pageDesc = ''; // IF USED, THIS IS SHOWN AS THE TITLE IN THE PAGE (BLUE BAR SECTION, END OF HEADER), REPLACING $pageName.
$pageIcon = ''; // THE ICON USED IN THE PAGE
$pageAlign = 'center'; // HOW YOU WANT TO ALIGN THE PAGE CONTENT
$pageClass = 'full'; // FOR CUSTOM PROGRAMMING USES
$do_not_display_ads = true;
include $Global['path'].'Sub/tpl/header_tpl.php';
include $Global['path'].$Global['admin_dir'].'/Lib/Pagination.function.php';
//$debug = false;
//if ($_SESSION['loggedin'] == 'demo') $debug = true;
?>
<script type="text/javascript">
     <!--
        function ShowCode(t)
        {
            if(document.getElementById(t).style.display == 'none') {
                document.getElementById(t).style.display = '';
		
            } else {
                document.getElementById(t).style.display = 'none';
			
			
            }
        }
     -->
</script>
<?php
$ID = $_SESSION['UserID'];
$error = '';

function autolink($str, $attributes=array()) {
    $attrs = '';
    foreach ($attributes as $attribute => $value) {
        $attrs .= " {$attribute}=\"{$value}\"";
    }
    $str = ' ' . $str;
    $str = preg_replace('`([^"=\'>])((http|https|ftp)://[^\s<]+[^\s<\.)])`i','$1<a href="$2"'.$attrs.'>$2</a>',$str);
	$str = substr($str, 1);
	return $str;
}

$where = [
    'ID' => ['=', $ID] // WHERE condition
];

if (isset($_GET['type'])) {
	$type = $_GET['type'];
	$type = htmlspecialchars($type, ENT_QUOTES, 'UTF-8');
	if ($type == 'video') $type = 'share';
	$where['adtype'] = ['=', $type];
	$display_type = $type;
	if ($type == 'te') $display_type = 'Traffic Exchange';
	if ($type == 'url') $display_type = 'Tracking Link';
	if ($type == 'abtest') $display_type = 'A/B Test';	
} else {
	$type = '';
	$display_type = '';	
}	

$show_details = false;

if (isset($_GET['c']) && $_GET['c'] != '') {
	$camp = htmlspecialchars($_GET['c'], ENT_QUOTES, 'UTF-8');
	$where['short'] = ['=', $camp];
}
//echo $camp;

if ($type == 'abtest') $orderby = 'idx ASC';
else  $orderby = 'idx DESC';

$selectFields = '*, campstamp as campcrdate';
$mainTable = 'campaigns';
$limit = 0; 
$show_debug = 1;

// Executing the select function
$result = select($selectFields, $mainTable, [], $where, null, null, $orderby, $limit, $show_debug);

// Counting the number of rows returned
$rows = is_array($result) ? count($result) : 0;


if ($rows > 0) {
	// SHOW CAMP DETAILS, MENU BAR LINKS
	$bufferc = isset($result[0]) ? $result[0] : '';	
	//print_r($bufferc);
	//exit;
	$type = $bufferc['adtype'];
}	
if ($debug == true) echo '<br>TYPE IS: '.$type;
	
//if ($camp != '' && $_GET['showlink'] != '' && ($bufferc['status'] > 0) && $type != 'shareQQQ' && $type != 'tweetQQQ' && $type != 'solo') {
if (isset($camp, $_GET['showlink'], $bufferc['status'], $type) && $camp != '' && $_GET['showlink'] != '' && $bufferc['status'] > 0 && $type != 'text' && $type != 'banner') {
    $show_details = true;
}

if (isset($_REQUEST['delete'])) {
	
	$delete = htmlspecialchars($_REQUEST['delete'], ENT_QUOTES, 'UTF-8');
	$short = $delete;
	
	if ($delete == $_SESSION['loggedin']) {
		echo '<h2>You cannot delete your username campaign!</h2><br><br><br>'; 
		exit;
	}	
	
	unset($where['adtype']);
	$where['short'] = ['=', $short];
	$result = select($selectFields, $mainTable, [], $where, null, null, $orderby, $limit, $show_debug);
	
	$rows = is_array($result) ? count($result) : 0;
	
	if ($rows < 1) {
		$error = "<div style='color:red;'><h2>Invalid Request</h2><br />&nbsp;</div>";
		exit;
	} else {
		$bufferd = isset($result[0]) ? $result[0] : null;	
		//print_r($bufferd);
		//exit;
		$type = $bufferd['adtype'];	
		$camp_id = $bufferd['idx'];	
		$recoup_credits = $bufferd['adcredits'];
		if ($bufferd['type'] == 'LAC' || $bufferd['type'] == 'traffic') {
			echo '<h2>You Cannot Delete Done For You Traffic Campaigns!</h2><br><br><br>'; 
			exit;
		}			
	}
	
	if ($error == '' && isset($_GET['confirm'])) { // SAFETY CHECK - ARE YOU SURE? // THIS WILL DELETE YOUR SHARES AS WELL!

		if ($error == '') $error = "<h2 style='color:red;'>Are you sure you wish to delete this Campaign \"".$short."\"?</h2>";
		
		if ($type != 'share' && $type != 'tweet' && $type != 'url')
		//$error .= '<h3 style="color:red;"><span style="color:red; font-weight:normal"><i class="fa fa-exclamation-triangle" aria-hidden="true"></i> Any unused Ad Credits assigned to this Campaign will be deleted!</h3>';
		
		if ($type == 'share') 
		$error .= "<h3 style='color:red;'>Your video listing using this campaign will also be deleted.</h3>";
	
		if ($type == 'tweet') 
		$error .= "<h3 style='color:red;'>Your tweet listing using this campaign will also be deleted.</h3>";	
		
		$error .= "<br />&nbsp;
		<a class='btn btn-danger' href='campaign-stats.php?delete=$short&confirm=yes'>Yes, delete it!</a>&nbsp;&nbsp;";
		
		$error .= "<a class='btn btn-info' href='campaign-creator.php?edit=$short'>No, I will edit it, instead.</a>";
		
		$error .= "<br/><br/><a class='btn btn-success' href='campaign-stats.php'>Return to View Stats</a>";
	
	} else if ($error == '' && $_GET['confirm'] == 'yes') { // CONFIRMED DELETE
		
		// SHOULD ADD CREDIT LOG ALSO HERE - FUTURE UPDATE IDEA - NOT VITAL!
		$table = 'members';
		$data = [
			'user_credits' => ['expression' => 'user_credits'.'+'.$recoup_credits]
		];
		$where = [
			'ID' => ['=', $ID]
		];
		$live = 1;
		$show_debug = 1;
		update($table, $data, [], $where, $live, 0, $show_debug);
		
		$table = 'campaigns';
		$where = [
			'ID' => ['=', $ID],
			'short' => ['=', $short]
		];
		$live = 1;
		$show_debug = 1;
		delete($table, [], $where, null, $live, 1, $show_debug);
				
		$table = 'shares';
		$where = [
			'ID' => ['=', $ID],
			'share' => ['=', $short]
		];
		$live = 1;
		$show_debug = 1;
		delete($table, [], $where, null, $live, 1, $show_debug);
				
		$table = 'campaign_ip_check';
		$where = [
			'campaign_id' => ['=', $camp_id]
		];
		$live = 1;
		$show_debug = 1;
		delete($table, [], $where, null, $live, 1, $show_debug);
		
		$error = "<div style='color:red;'><h2>Campaign Deleted Successfully!</h2><br />&nbsp;</div>";	
		$error .= '<a href="campaign-stats.php">Return to Campaign Stats</a><br><br><br>';	
	} // END CONFIRMED DELETE	
} // END DELETE SECTION
?>
<style>
table, th, td {
    border: 1px solid #dddddd;
	background-color: #fff;
    vertical-align: middle;
	padding: 5px; 
	text-align: center;
}

.table > tbody > tr > td {
	vertical-align: middle;
}
.table {
	float: none;
	margin: 0 auto;	
	width: 96%;
}
</style>

<div style="text-align:center; background-color:#F2F3F4">

<?php
if ($error != '') {
	echo $error;
	include './../Sub/tpl/footer_tpl.php';
	exit;
}
?>
<!--
<p>&nbsp;</p><p>&nbsp;</p>
-->

<?php if ($display_type != '') { ?>
	<h2>My <?php echo ucfirst($display_type);?> Campaign Stats</h2>
<?php } else {
	echo '<h2>My Campaign Stats</h2>';	
} ?>

<a href="dashboard.php" class="btn btn-sm btn-info" style="background-color:;"><i class="fa fa-bullhorn" aria-hidden="true"></i>&nbsp; Promotion Dashboard</a>
<!--&nbsp;<a href="../Members/leads.php" class="btn btn-sm btn-info" style="background-color:;"><i class="fa fa-sitemap" aria-hidden="true"></i>&nbsp; View Leads</a>-->

 <?php 
// /*
 if (isset($_SESSION['adman']) && $_SESSION['adman'] == true) { ?>
    &nbsp;<a class="btn btn-info btn-sm" href="admin/index.php" style="text-decoration:none" title="Approve campaigns.">
 <i class="fa fa-binoculars" aria-hidden="true"></i>&nbsp; Admin Dashboard</a>
<?php } 
//*/
?>

<br/><br/>

<?php
if (true) {
?>
<!--
	Filter: &nbsp;<a href="?type=share">Videos</a> &nbsp;&nbsp;<a href="?type=tweet">Tweets</a>&nbsp;&nbsp;

	<a href="?type=url">Tracking Links</a> &nbsp;&nbsp;

	<a href="?type=text">Text Ads</a> &nbsp;&nbsp;<a href="?type=banner">Banner Ads</a>&nbsp;&nbsp;
 
	<a href="?type=solo">Solo Ads</a> &nbsp;&nbsp;<a href="?type=te">TE Ads</a>&nbsp;&nbsp;
  
	<a href="?type=login">Login Ads</a> &nbsp;&nbsp;<a href="?type=logout">Logout Ads</a>&nbsp;&nbsp;
 
	<a href="campaign-stats.php">All</a><br /><br />
-->  
  
	<?php 
	if ($bufferc['status'] == -1 && $camp!= '') {
	echo '<div class="row"><div class="col-md-6 col-md-offset-3" style="text-align:left; background-color:white">';
	
	$selectFields = '*';
	$mainTable = 'support_tickets';
	$where = [
		'ticket_id' => ['=', $camp]
	];
	$orderBy = 'idx ASC';
	$limit = 1;
	$show_debug = 1;

	$resultt = select($selectFields, $mainTable, [], $where, null, null, $orderBy, $limit, $show_debug);
	$buffert = isset($resultt[0]) ? $resultt[0] : '';
	
	echo '<h4 style="color:red; text-decoration:underline">'.$buffert['subject'].'</h4>';
	echo '<br/><br/>';
	
	$message = autolink($buffert['message'], array("target"=>"_blank","rel"=>"nofollow"));
	echo nl2br($message); // <a href="http://example.com/" target="_blank" rel="nofollow">http://example.com/</a>
	?>
	<br/>
   <a href="<?php echo $Global['webpage_url_ssl']; ?>ticket-thread.php" target="_blank" class="btn btn-danger">
   Click to see and respond to this ticket thread</span>
    </a>
	
	<?php
	echo '</div></div><br/><br/>';
	}
		
	if ($bufferc['adtype'] == 'tweet') {
		$url_root = "https://ShareMyTweet.com/";
	} else if ($bufferc['adtype'] == 'share') {
		$url_root = "https://ShareThisAgain.com/";
	} else { // TYPE IS URL
		$url_root = $Global['webpage_url_ssl'];
	}	
	$url = $url_root.$bufferc['short'];
	
	if ($show_details == true) {		
	?>	
	
	<h2>Your <?php echo $bufferc['name'];?> Campaign Link to Copy</h2>
<h3 style="text-align:center;">Copy this link to share or advertise.</h3>

	
<div class="table-responsive col-xs-12 col-md-6 col-md-offset-3">
  <table class="table" style="text-align:left; background-color:#fff">
<tr>
<td>

<table cellpadding="0" class="table">
<tr>
<td style="width:30%; height:50%;"><a href="<?php echo $url; ?>" target="_blank">Campaign Link</a>:
<i class="fa fa-arrow-circle-right fa-lg" style="color:#3598dc"></i>
</td>
<td style="position:relative;right:0;">
<form>
<input class="form-control" onmouseover="this.focus(); this.select();" size="100%" name="url" value="<?php echo $url; ?>">
</form>
</td>
</tr>
</table>

</td>
</tr>

<tr>
<td>

<?php
// BANNER SECTION - ONLY SHOWN IF A BANNER AD!!!!
if ($bufferc['banners'] != '') {
	
	if ($camp != '' && $type == '') $type = 'banner';
	
	$banners = '';
	$banners = $bufferc['banners'];
	
	$selectFields = '*';
	$mainTable = 'banners';
	$where = [
		'bannerid' => ['=', $banners]
	];
	$limit = 0;
	$show_debug = 1;

	$resultb = select($selectFields, $mainTable, [], $where, null, null, null, $limit, $show_debug);
	$bufferb = isset($resultb[0]) ? $resultb[0] : '';

	echo '<a href="'.$Global['webpage_url'].'banner_clicks/'.$bufferb['bannerid'].'/'.$camp.'">
	<img src="'.$Global['webpage_url'].'images/banners/'.$bufferb['bannername'].'"></a>';
	?>

	<hr>
	<a href="#" OnClick="ShowCode('bn_<?php echo $bufferb['bannerid']; ?>');return false;" class="btn btn-warning btn-lg">Show Banner HTML Code</a>
	<hr>

	<table class="table" id="<?php echo 'bn_'.$bufferb['bannerid']; ?>" style="display: none";>
	<tr>
	<td style="width:30%; height:50%;">
	<!--
	<a href="<?php echo $Global['webpage_url_ssl']; ?>lc.php?id=<?php echo $_SESSION['loggedin']; ?>" target="_blank">Banner HTML</a>:
	-->
	Banner HTML: <i class="fa fa-arrow-circle-right fa-lg" style="color:#3598dc"></i>
	Copy this code if you wish to display this banner on other websites.
	<span style="color:red;">(Optional)</span>


	</td>
	<td style="min-width: 100%">
	<form>

	<textarea class="form-control" cols="50" rows="7" id="bannercode" style="min-width: 100%" onmouseover="this.focus(); this.select();">
	<?php
	echo '<a href="'.$Global['webpage_url'].'banner_clicks/'.$bufferb['bannerid'].'/'.$camp.'"><img src="'.$Global['webpage_url'].'images/banners/'.$bufferb['bannername'].'"></a>';
	?>
	</textarea>


	</form>
	</td>
	</tr>
	</table>
<?php } ?>

<h5 style="text-align:center; color:red">Reminder - Please do not make unsubstantiated claims, and do not spam.</h5>									
<h5 style="text-align:center; color:red">Practice only these advertising principles:</h5>
<hr>
Be truthful, do not mislead or make claims, and do not spam. 
If you write a review, you must disclose your affiliate relationship. Do not engage in negative campaigns. Failure to adhere to these principles may result in your account termination.
<?php if ($type == 'share' || $type == 'tweet' || $type == 'url' || $type == 'abtest') { // NOT PROMOTING 3RD PARTY LINK, SO SHOW SPM ADS
?>
<hr>
<a href="./../Members/text-ads.php?c=<?php echo $bufferc['short']; ?>" target="_blank" class="btn btn-info btn-lg">Show Me Text Ads To Use!</a>
<a href="./../Members/banners.php?c=<?php echo $bufferc['short']; ?>" target="_blank" class="btn btn-info btn-lg">Show Me Banner Ads To Use!</a>
<?php } ?>
</td>
</tr>

</table>
</div>	  		
		
<div class="clearfix"></div>		
<hr>
<br/>		
<?php		
	} // END SHOW DETAILS IS TRUE
if (isset($_GET['c']) && $type == 'abtest') {
// DO NOTHING
// WE DO NOT SHOW STATS ON ABTESTS HERE, SINCE IT ONLY SHOWS THE ONE CAMP RECORD!!
// THIS WOULD BE CONFUSING TO END USERS!
} else {	
?>
  
	<div class="table-responsive">  
	<table class="table">
	<tr>
	<th>Campaign Name</th>
	<th>Type</th>
	<th>Action</th>

	<th>Ad Credits</th> 
	<th>Ad Source </th>

	<?php if (true || $type == 'banner') { ?>
	<th>Ipms</th>
	<?php } ?>

	<th>Clicks</th>
	<th>Leads</th>
	<th>Sign Ups</th>

	<th>Sales </th>
	<th>Cost Per Sale </th>
	<th>Conv Rate </th>

	<th>Commissions </th>
	<th>Created</th> 
	</tr>

	<?php
	$last_type = ''; // INI VAR
	$last_short = ''; // INI VAR
	$use_last_displayed_camp_name = false; // INI VAR
	//$count = 0;
	foreach ($result as $buffer) {
		//$count++;
		$display_camp_name = $buffer['name']; // SUPPORTING ALL OTHER TYPES OF CAMPS!
		$show_camp_links = true;		
		///* // BELOW SECTION MIGHT WORK IF WE ORDER BY ASC - IS NOT GOOD FOR DESC RESULTS!
		// ABORTING THIS IDEA FOR NOW
		if ($buffer['adtype'] == 'abtest' && $last_type != 'abtest' && $_GET['c'] == '' && $orderby == 'DESC') { // THIS CODE CANNOT EXECUTE THE FIRST TIME AN ABTEST CAMP LOADS!
			// THIS COND IS THE "A" TEST
			// THIS CODE IS THE "B" TEST. WE WANT TO OBSCURE THE CAMP NAME
			// FOR DISPLAY PURPOSES ONLY, THE CAMP NAME WILL SHOW AS BELOW...
			// THIS IS REQUIRED, SINCE WE NEED TO HAVE UNIQUE NAMES FOR EACH CAMP, IN ORDER TO SEE VISITOR STATS!			
			//$display_camp_name = 'A/B TEST - B URL';
			//echo 'zzzzz'; exit;
			$display_camp_name = $buffer['name'];
			$show_camp_links = false;
			$last_type = $buffer['adtype'];
			if ($last_short != $buffer['idx'] && $_GET['c'] == '') {
				//echo 'qqqqzzzzz'; exit;
				continue; // IF NOT LOOKING AT CAMP OR ABTESTS, SKIP SHOWING THE "B" TEST CAMP OF THE ABTESTS, WHICH WILL COME FIRST, WHEN ORDER BY DESC, WHICH IS DONE IN MASS CAMP VIEWS.
			}	
		} else {
			$display_camp_name = $buffer['name'];
			$show_camp_links = true;
		}
		
		if ($buffer['adtype'] == 'abtest' && $last_short == $buffer['idx'] && $_GET['c'] == '' && $orderby == 'DESC') { //THIS IS THE "B" CAMP URL! (WHEN SHOWN IN DESC ORDER)
			$showing_campaign_A = false;
			$show_camp_links = false;
		} else {
			$showing_campaign_A = true;
			$show_camp_links = true;
		}	
		
		if ($buffer['adtype'] == 'abtest' && $last_type == 'abtest' && $_GET['c'] == '' && $orderby == 'ASC') { //THIS IS THE "B" CAMP URL! (WHEN SHOWN IN ASC ORDER)
			$showing_campaign_A = false;
			$show_camp_links = false;
		}
		
		if ($showing_campaign_A == true) $abtest_title = 'A';
		else $abtest_title = 'B';

		if ($debug == true) echo 'adtype: '.$buffer['adtype'].' last short: '.$last_short.' idx: '.$buffer['idx']; //exit;	
		
		// NOW WE LOG AT THE ABTEST AS THE LAST TYPE LOADED
		$last_type = $buffer['adtype'];
		$last_short = $buffer['short'];
		
		$idx = $buffer['idx'];
		$display_idx = rand(1000,9999) . $idx; // ADDING 4 RANDOM DIGITS TO TOP OF IDX, SO WE CAN USE THIS TO LINK TO VISITOR STATS NOW, WITHOUT GIVING AWAY ANY REAL NUMBER OF RECORDS (WE STRIP OUT THOSE 4 OVER THERE)
		$cmpurls='';
		$cmpbanners='';
		$banners = '';
		$banners = $buffer['banners'];
		//print_r($buffer);

		//$bnrsids="('".str_replace(":","','",$buffer['banners'])."')";
		//$cmpbrs=mysql_query("SELECT * FROM banners WHERE bannerid in ".$bnrsids."");

		//while ($cmpbrow=mysql_fetch_array($cmpbrs)) {
			//$cmpbanners.="<img src='/images/banners/".$cmpbrow['bannername']."'  ><br>";
		//} // END INNDER WHILE LOOP

		$selectFields = '*';
		$mainTable = 'banners';
		$where = [
			'bannerid' => ['=', $banners]
		];
		$limit = 0;
		$show_debug = 1;

		$resultb = select($selectFields, $mainTable, [], $where, null, null, null, $limit, $show_debug);
		$bufferb = isset($resultb[0]) ? $resultb[0] : '';
		
		// CAMP MODAL INFO!
		//include 'campaign-info-modal.php';	
		
		$short = $buffer['short']; // CAMPAIGN SHORT URL LINK
		$net_comm = '$'.number_format($buffer['commission']);
		

		if ($buffer['status'] > 0) $status = '<span style="color:green"><b>Approved</b></span>';
		if ($buffer['status'] == "-1") $status = '<span style="color:red"><b>Rejected</b></span>';
		
		/* // ABANDONED IDEA 
		// 8/15/21 JUST NOTATING, unique_clicks IN CAMPAIGNS TABLE, WAS UNSHOWN TO USERS, IN FAVOR OF VISITS TABLE STATS
		// REASON BEING IS TO BE ABLE TO CROSS REF AFF SITE TRAFFIC WITH CAMPAIGNS, WITHOUT DESCREPANCIES
		// I.E. CAMP TABLE STATS VS VISITS TABLE STATS	- IF A SINGLE PAGE MISSES A LINKAGE, IT LOOKS BROKEN
		// SO EASIER TO TO USE ONLY ONE SOURCE.
		// GETTING THE VISITS TABLE TO POPULATE RELIABLY WAS PROVING TOO DIFFICULT. GOING BACK TO STATS EXCLUSIVELY FROM CAMPAIGN TABLE NOW!		
		
		$bufferr['rawvisits'] = '';
		$qryr = "SELECT COUNT(idx) as rawvisits FROM `visits` WHERE `campaign_id` = '{$idx}'";
		if ($debug == true) $debug_text .= '<br><br><b>RAW QRY </b>'.$qryr.'<br/><br>';
		$resultr = mysql_query($qryr) or die($qryr.' '.mysql_error());
		$bufferr = mysql_fetch_assoc($resultr);
		$rawvisits = $bufferr['rawvisits'];

		$bufferu['uniquevisits'] = '';
		$qryu = "SELECT idx FROM `visits` WHERE `campaign_id` = '{$idx}' GROUP BY ip";
		$debug_text .= '<br><br><b>UNIQUE QRY </b>'.$qryu.'<br/><br>';
		$resultu = mysql_query($qryu) or die($qryu.' '.mysql_error());
		$bufferu = mysql_fetch_assoc($resultu);
		$uniquevisits = mysql_num_rows($resultu);
		*/
		$rawvisits = $buffer['total_clicks'];
		$uniquevisits = $buffer['unique_clicks'];
		if ($debug == true) echo $debug_text;		

		$costperclick = 0; // Initialize as 0 to handle case where division can't be performed
		if (isset($buffer['unique_clicks']) && $buffer['unique_clicks'] > 0) {
			$costperclick = number_format($buffer['amount_spent'] / $buffer['unique_clicks'], 2);
		}

		$costperlead = 0; // Initialize as 0
		if (isset($buffer['leads']) && $buffer['leads'] > 0) {
			$costperlead = number_format($buffer['amount_spent'] / $buffer['leads'], 2);
		}

		$costpersale = 0; // Initialize as 0
		if (isset($buffer['sales']) && $buffer['sales'] > 0) {
			$costpersale = number_format($buffer['amount_spent'] / $buffer['sales'], 2);
		}
		
		
		//echo 'sales: '.$buffer['sales']; 
		//echo 'unqiue visits: '.$uniquevisits; exit;

		//$convrate=$buffer['sales']/$buffer['unique_clicks']; // REQUIRED - OR URL REDIRECTS OFFSITE DO NOT GET COUNTED!

		$convrate = 0; // Initialize as 0 to handle case where division can't be performed
		if (isset($uniquevisits) && $uniquevisits > 0) { 
			$convrate = $buffer['sales'] / $uniquevisits; // USING VISITS TABLE STATS INSTEAD - TO MATCH VISITS NETWORK WIDE
		}
		
		//echo $convrate; exit;
		if ($convrate >= 1) $convrate = $convrate.'00';
		//else $convrate = number_format($convrate, 2);
		if ($convrate == '') $convrate = 0;
		
		//$convrate = 1;
		
		if ($convrate >= 1) $convrate = number_format($convrate, 2);
		if ($convrate < .009 && $convrate > .0001) $convrate = number_format($convrate, 4);		
		
		
		//echo $convrate; exit;

		if ($buffer['status'] == 0) { 
			$color = 'warning';
			$status = 'Pending Approval';
		} else if ($buffer['status'] < 0) {
			$color = 'danger';
			$status = 'Campaign Rejected';
		} else if ($buffer['status'] > 0 || $buffer['short'] == $_SESSION['loggedin']) {
			$color = 'success';
			$status = 'Campaign Approved';
		}	
		
		if ($buffer['adtype'] == 'abtest' && $showing_campaign_A != true) $status = $status.' This is your B test URL';

		if ($buffer['adtype'] == 'tweet') {
			$url_root = "https://sharemytweet.com/";
		} else if ($buffer['adtype'] == 'share') {
			$url_root = "https://sharethisagain.com/";
		} else { // TYPE IS URL
			$url_root = $Global['webpage_url_ssl'];
		}	

		$type = $buffer['adtype'];
		$hide_camp_name_url = false;
		
		if ($type == 'abtest' && $_GET['type'] == 'abtest') {
			$hide_camp_name_url = true;
		} else if ($type == 'abtest') {
			//$url = $_SERVER['PHP_SELF'].'?c='.$buffer['short'].'&showlink=yes';
			$url = $_SERVER['PHP_SELF'].'?type=abtest';
			$target = '';
		} else {
		$url = $url_root.$buffer['short'];
			$target = 'target="_blank"';
		}
		$is_ad_type = false;
		if ($type == 'text' || $type == 'banner' || $type == 'solo' || $type == 'te' || $type == 'login' || $type == 'logout') {
			$is_ad_type = true;
			//echo 'IS AD TYPE!!';
		}
		if ($is_ad_type == true) $url = $url_root.'ads/index.php?type='.$type.'&c='.$buffer['short'];
		
		$unique_imps = $buffer['unique_imps'];
		$total_imps = $buffer['total_imps'];
		$adcredits = $buffer['adcredits'];
		if ($adcredits < 0) $adcredits = 0; // FORCE 0 IF NEGATIVE - FIXING BUG!
		//echo 'TYPE IS '.$type;
		
		// WE ONLY SHOW RED BUTTON, IF THIS IS NOT THEIR AFF LINK CAMPAIGN!
		if ($buffer['status'] > 0 && $adcredits < 1 && $buffer['short'] != $_SESSION['loggedin']) {
			$color = 'danger';
			$status = 'Credits Depleted';
		}		
		?>

		<tr>
		
		<td>
		<?php //echo stripslashes($buffer['idx']); 
		?>
		<?php if ($show_camp_links == true && $hide_camp_name_url == false) { ?>
		<a href="<?php echo $url;?>" <?php echo $target; ?> class="btn btn-sm btn-<?php echo $color;?>" style="min-width:100%" title="<?php echo $status;?>"><?php echo stripslashes($display_camp_name); ?></a>
		<?php } else { ?>
		<div class="btn btn-sm btn-<?php echo $color;?>" style="min-width:100%" title="<?php echo $status;?>"><?php echo stripslashes($display_camp_name); ?></div>
		<?php } ?>
		
		<?php if ($debug == true) echo 'idx: '.$buffer['idx'].'<br>short: '.$buffer['short'].'<br>'; ?>
		<?php if ($type == 'abtest') echo '<small>'.$abtest_title.' Test URL:</small><br><small><small>'.$buffer['url'].'</small></small>'; ?>		
		
		</td>	

		<td>
		<?php if ($buffer['adtype'] != $type) echo '<a href="campaign-stats.php?type='.$buffer['adtype'].'">'; ?>
		<span class="btn btn-sm btn-default" style="min-width:100%; background-color:#F0F0F0"><?php echo stripslashes($buffer['adtype']); ?></span>
		<?php if ($buffer['adtype'] != $type) echo '</a>';	?>	
		</td>
		
		<?php if ($show_camp_links == true) { ?>
		
		<td>
		<a href="<?php echo $_SERVER['PHP_SELF'].'?c='.$buffer['short']; ?>&showlink=yes" class=""><li class="fa fa-binoculars text-success" aria-hidden="true" title="View Only This Campaign"></li></a>	
		
		<a href="campaign-stats.php?delete=<?php echo $buffer['short']; ?>" class=""><li class="fa fa-trash-o" style="color:red" aria-hidden="true" title="Delete Campaign"></li></a>	
		
		<a href="campaign-creator.php?edit=<?php echo $buffer['short']; ?>" class=""><li class="fa fa-pencil-square-o" style="color:#00b3fe" aria-hidden="true" title="Edit Campaign"></li></a>
		</td>
		
		<?php } else { ?>
		<li class="fa fa-ban" style="color:red" aria-hidden="true" title="No Edit Available. Edit Master A/B Campaign Instead."></li>
		<?php } ?>
		
		<td>
		<small>
		<?php if ($buffer['stcredits'] > 0 && $type != 'share' && $type != 'tweet' && $type != 'url') { ?>	
			
			Credit Spend <?php echo stripslashes($buffer['stcredits']); ?> 
			<br/>
			Credits Left <?php echo $adcredits; ?><!--
			<a href="campaign-creator.php?edit=<?php echo $buffer['short']; ?>&add=credits" class="">
			<li class="fa fa-plus" style="color:#00b3fe" aria-hidden="true" title="Add Credits"></li></a>	-->			
		<?php } else {
			echo 'N / A';
		}?>
		</small>
		</td>
		
		
		
		<td><small> <?php echo stripslashes($buffer['ad_source']).'</small>'; 
		if ($buffer['ad_source'] == '') echo '<small>N / A</small>';
			?><br/>
			<?php if ($buffer['amount_spent'] != 0) { ?>	
			<small>Ad Spend<br/>$<?php echo stripslashes($buffer['amount_spent']); ?></small>
			<?php } ?>
		</td>

		<?php if (true || $type == 'banner') { ?>
			<td>
			<small>
<!--			
			<a href="../Members/visits-public.php?campname=<?php echo stripslashes($buffer['name']); ?>&idx=<?php echo $display_idx; ?>" target="_blank">Raw <?php echo stripslashes($total_imps); ?></a><br/>

			<a href="../Members/visits-public.php?campname=<?php echo stripslashes($buffer['name']); ?>&idx=<?php echo $display_idx; ?>&unique=1" target="_blank">Unique <?php echo stripslashes($unique_imps); ?></a><br/>
-->
			Raw <?php echo stripslashes($total_imps); ?><br/>

			Unique <?php echo stripslashes($unique_imps); ?><br/>

			<small>
			CPC <?php echo '$'.$costperclick; ?>
			</small>
			</small>
			</td>
		<?php } ?>

		<td>
		<small>
		Raw <?php echo stripslashes($buffer['total_clicks']); ?><br/>
<!--		
		<a href="../Members/visits-public.php?campname=<?php echo stripslashes($buffer['name']); ?>&idx=<?php echo $display_idx; ?>" target="_blank">Raw <?php //echo stripslashes($buffer['total_clicks']); 
		echo stripslashes($rawvisits);
		?></a><br/>
	-->	
<!--
		<a href="../Members/visits-public.php?campname=<?php echo stripslashes($buffer['name']); ?>&idx=<?php echo $display_idx; ?>&unique=1" target="_blank">Unique <?php 
		// FAKE FOR TESTING
		//$uniquevisits = 8;
		//echo stripslashes($buffer['unique_clicks']); 
		echo stripslashes($uniquevisits);
		?></a><br/>
-->		
		Unique <?php echo stripslashes($uniquevisits); ?><br/>
		<small>
		CPC <?php echo '$'.$costperclick; ?>
		</small>
		</small>
		</td>

		<td>
		<small>
		<?php echo stripslashes($buffer['leads']); ?><br/>

		CPL <?php echo '$'.$costperlead; ?>
		</small>
		</td>
		
		<td><?php echo stripslashes($buffer['signups']); ?> </td>
		<td><?php echo stripslashes($buffer['sales']); ?> </td>
		<td><?php echo $costpersale; ?> </td>
		<td><?php echo $convrate.'%'; ?></td>
		<td><?php echo $net_comm; ?></td>
		
<?php
$campcrdate = stripslashes($buffer['campcrdate']);
$campcrdate = date('Y-m-d', strtotime($campcrdate));
?>		
		
		
		<td><small><?php echo $campcrdate; ?></small></td>
		</tr>

	<?php
	} // END WHILE LOOP
	?>

	</table>
	</div>
	<br/><br/>
<?php } ?>	
<!--	<span style="color:red"><b>NOTE:</b></span> You will never be charged ad credits to click on your own ads while logged in.
	This is so your ad credit spend is only consumed by other visitors.-->

<?php
} else { // END RESULTS > 0

	if ($_GET['type'] != '') {
		echo '<h2>No '.ucfirst($display_type).' Campaigns Available</h2>';
		echo '<br/><a href="campaign-stats.php" class="btn btn-sm btn-info" style="background-color:;">Show All Campaign Stats</a>';
	} else {
		echo '<h2>No Campaigns Available</h2>';	
	}
	echo '<p>&nbsp;</p><p>&nbsp;</p><p>&nbsp;</p>';
}
echo '</div>';
include $Global['path'].'Sub/tpl/footer_tpl.php';
?>