<?php
//-----------------------------------------------------------------
// Software: Automatic Web Software (AWS) built with PHPCPR
// Firm: DirectSalesMLM.com / AutomaticWebSoftware.com / PHPCPR.com
// Author: Jim Symonds Email: jim@directsalesmlm.com
// Copyright 2006 - 2024 Jim Symonds All Rights Reserved.
//-----------------------------------------------------------------
if (IPN_PROCESS !== true) {
	exit;
}
$use_sendgrid = $Global['use_sendgrid']; // SET THIS TO FALSE TO SEND CONFIRMATION EMAIL NORMALLY, TRUE TO USE SENDGRID	
if ($use_sendgrid == true) include './../sendgrid.inc.php'; // load sendgrid functions if using them
/*

Received from /Sub/Config.inc.php:
	$Global = An array containing preset config values.

Received from /Ipn/*.ipn.php: 
	$payer_id = ID of the person paying
	$payer_status = If the user is active, unpaid etc
	$payer_grace_status = If the person paying has a active grace period
	$payer_signup_ip = The logged ip on this program
	$payer_expire = The time the sub expire
	
	$user_payment_plan_id = The id of the main payment plan system
	
	$program_id = The id of the program in question
	$program_name = The name of the program in question
	$program_type = If its a subscription or a normal payment
	$program_sub_period = The period the subscription last, days
	$program_powerline = The number of powerlines in the program
		
	$plan_info = An array containing all the payment_plans in this user_payment_plan.

Received from /Ipn/Logging.inc.php:
	$payer_firstname = The firstname of the person making the payment 
	$payer_lastname = The lastname of the person making the payment
	$payer_email = The email of the person making the payment
	$payer_username = The username of the person making the payment
	$payer_password = The password of the person making the payment
	
Received if its run from admin panel i.e. /admin/Sub/Viewplan.php
	$admin_processing = true i.e. it allows us to use a different path on the giveaway file	
*/

$timestamp = time();

$starting_payer_user_status = $payer_status;

$sent_sponsor_email = false;

	// INSERT status_log entry
	$slog_qry = "INSERT INTO `status_log`(`ID`, `program_id`, `new_status`, `event_time`, `changed_by`, `reason`, `new_sign_id`, `new_sponsorid`, `new_powerline_sponsorid`) SELECT ID,program_id,user_status,'".date('Y-m-d H:i:a')."','Finalize','Enter Finalize status={$starting_payer_user_status} type={$program_type} amt={$expected_amount}', sign_id, sponsorid, powerline_sponsor FROM user_program WHERE program_id='{$program_id}' AND ID='{$payer_id}'"; 
	if ($_SESSION['debug']) echo "<br />: ".$slog_qry."<br />";
	mysql_query($slog_qry);
/*
if (in_array($starting_payer_user_status,array('Active','Comped','TempComp','Suspended'))) {
	// Set flag that this is NOT a new signup, and so should not get welcome emails and NOT reset the start time of the user program
	$already_in_program = true;
} else {
	$already_in_program = false;
}
*/

if ($_SESSION['debug']) {
	echo "<br />Finalize: Starting Status = $payer_status<br/>";
	echo "receiver=$receiver_username $$expected_amount payment_plan_id=$payment_plan_id user_payment_plan=$user_payment_plan_id<br>plan_info:<br>";
	print_r($plan_info);
	echo "<br>----<br>";
}
//Query added to check if the giveaway function is enabled. The reason the query is added here instead of the ipn is due to we dont want the ipns to become outdated. I.e. that they all need to be updated.
$result = mysql_query("SELECT program_name, program_forced, upgrade_program, program_up_order, giveaway_file, giveaway_enabled, program_link, program_year_period, program_type, program_setup_type FROM program WHERE program_id=$program_id");

$buffer = mysql_fetch_assoc($result);

$Global['year_period'] = $buffer['program_year_period'];
$Global['powerline_order'] = explode(',', $buffer['program_up_order']);
$Global['upgrade_program'] = $buffer['upgrade_program'];
$Global['forced_passup'] = $buffer['program_forced'];
$program_name = $buffer['program_name'];
$program_type = $buffer['program_type'];

if ($buffer['giveaway_enabled'] == 'Y' && $payer_username != 'demo') {
	$giveaway_enabled = true;
	$giveaway_file = $Global['path'].'Ipn/Give/'.$buffer['giveaway_file'];
} else {
	$giveaway_enabled = false;
}

//Check if its a master program
if (!empty($buffer['program_link'])) {
	$master_program = true;
	$master_link = array();
	
	$master_link = explode(' ', $buffer['program_link']);
} else {
	$master_program = false;
}

//Find out what program type it is.
// QQQ UPDATE THIS TO ALWAYS EMAIL ON NEW ORDERS - NOT ON CRONS
if (($buffer['program_setup_type'] == 'S' && !in_array($payer_status,array('Unpaid')) && !in_array($payer_status,array('Suspended')) && !in_array($payer_status,array('Cancelled'))) || ($_SESSION['sendemail'] == 'n')) $Global['program_not_send_email'] = true;
else $Global['program_not_send_email'] = false;

		
//Check what payment type the user has selected. 
$result = mysql_query("SELECT payment_program FROM user_payment_plan WHERE user_payment_plan_id='{$user_payment_plan_id}' LIMIT 1");

$buffer = mysql_fetch_assoc($result);

if ($buffer['payment_program'] == 'L') {
	$program_type = 'N'; //Set to make sure the lifetime purchase is not setup as a subscription
	$program_selected = 'L';
	
	$new_user_status = $Global['comped_status'];
	$new_user_status_additional = ", program_life='Y'";
} else if ($buffer['payment_program'] == 'Y') {
	$program_sub_period = $Global['year_period'];
	$program_selected = 'Y';
	
	$new_user_status = $Global['active_status'];
	$new_user_status_additional = '';	
} else {
	$program_selected = 'N';
	
	$new_user_status = $Global['active_status'];
	$new_user_status_additional = '';
}

// FREE TRIAL UPDATE
	if ($freetrial == true) {
	$new_user_status = 'FreeTrial';
	}  

	$renewal = false;
// mark as recurring renewal if current payer status not Unpaid (payer is Active or Suspended or Cancelled)
if ($program_type == 'S' && !in_array($payer_status,array('Unpaid')) && $payer_status != $Global['tempcomp_status']) { //Reccuring subscription payment, we just update the expire time and reset the payment system
	//NOTE: if we add that first sub can pay for a membership, then we need to make sure that the user does have a active one!

	// JS ADDED RENEWAL VARIABLE 7/26/13 SO RENEWALS DO NOT GET THEIR SIGN IDS CHANGED! VARIABLE GETS USED WHERE SIGN ID IS DETERMINED, BELOW.
	$renewal = true;

	$result = mysql_query("SELECT * FROM payment_plan WHERE plan_type='S' && user_payment_plan_id=$user_payment_plan_id") or die('1432'.mysql_error());
		
	$period = array();
	$period_nr = 0;

	while ($buffer = mysql_fetch_assoc($result))
		{
		$period[] = array('id' => $buffer['payment_plan_id'], 'period' => $buffer['payment_period']);	

		if ($period_nr == 0 || $period_nr > $buffer['payment_period']) $period_nr = $buffer['payment_period'];
		}

	$result = mysql_query("SELECT * FROM user_program WHERE ID=$payer_id && program_id=$program_id") or die('143r'.mysql_error());

	$buffer = mysql_fetch_assoc($result);

	if ($period_nr > ($buffer['payment_period'] + 1)) $real_period = $period_nr - $buffer['payment_period'];
	else $real_period = 1;
		
	// FIXING EXPIRE TIME 1/28/19 
	//- IN PROGRAM OF 365 DAYS AS THE SUB PERIOD (SPM PRO), WE WERE GETTING AN EXPIRE TIME SET TO ONE DAY LATER!
	if ($real_period < 1) $real_period = 1;
		
	$period_info = $real_period + $buffer['payment_period'];
	
	if ($payment_processor == 'VC') $real_period = $months;

	if ($payer_expire > $timestamp) $expire_timestamp = ($program_sub_period * $real_period) * 86400;
	else $expire_timestamp = (($program_sub_period * $real_period) + 1) * 86400;

	// FREE TRIAL UPDATE
	if ($freetrial == true) {
		$expire_timestamp = ($freetrial_days * 86400);
	}  
	// END FREE TRIAL UPDATE
	// if not Active or Comped, set status to $new_user_status (Active or Comped)
	if (!in_array($starting_payer_user_status,array("Comped","Active"))) {
		mysql_query("UPDATE user_program SET user_status='{$new_user_status}' WHERE ID=$payer_id && program_id=$program_id") or die('13 Suspend to Active '.mysql_error());
		// INSERT status_log entry
		$slog_qry = "INSERT INTO `status_log`(`ID`, `program_id`, `new_status`, `event_time`, `changed_by`, `reason`, `new_sign_id`, `new_sponsorid`, `new_powerline_sponsorid`) SELECT ID,program_id,user_status,'".date('Y-m-d H:i:a')."','Finalize','Subscription: Change Status from {$starting_payer_user_status} to {$new_user_status}', sign_id, sponsorid, powerline_sponsor FROM user_program WHERE program_id='{$program_id}' AND ID='{$payer_id}'"; 
		if ($_SESSION['debug']) echo "<br />: ".$slog_qry."<br />";
		mysql_query($slog_qry);
	}
	//Update the expire time + set grace_expire to NULL to remove Grace
	//JS UPDATE 8/3/15 TO NOT SET EXPIRE TIMES IN A ONE TIME FEE PROGRAM
	if ($program_type == 'S') {
		// UPDATE 9/29/2015 if expired more than 16 days ago, set new expire time based on current time, otherwise add time to existing expire time.
		if ($payer_expire < ($timestamp - (16 *86400))) {
			$newexpiretime = $timestamp + $expire_timestamp;
			mysql_query("UPDATE user_program SET expire=$newexpiretime, payment_period=payment_period+{$real_period}, grace_start=NULL, grace_expire=NULL, grace_checked=NULL, end_program='N' WHERE ID=$payer_id && program_id=$program_id") or die('14'.mysql_error());
		} else {
			mysql_query("UPDATE user_program SET expire=expire+$expire_timestamp, payment_period=payment_period+{$real_period}, grace_start=NULL, grace_expire=NULL, grace_checked=NULL, end_program='N' WHERE ID=$payer_id && program_id=$program_id") or die('14'.mysql_error());
		}
		
	}

	//Check if the user is in a grace period, which is no longer used, and clear the setting
	if ($payer_grace_status == 'Y') {
			//Update user payment plan, reset grace settings
		mysql_query("UPDATE user_payment_plan SET grace_enabled='N' WHERE user_payment_plan_id=$user_payment_plan_id") or die('15'.mysql_error());	
	}
} else { //First subscription payment or a normal payment, we update the information and send out emails	
	//Check if the member is already active in a linked lower price program
	$extend_subscription = 0;
	
	$nr = 1;
	
	//Find the sponsor who the user who paid will be put under.
	$result_sponsor = mysql_query("SELECT real_sponsorid FROM user_payment_plan WHERE user_payment_plan_id='{$user_payment_plan_id}'") or die('n15'.mysql_error());	
	
	$buffer_sponsor = mysql_fetch_assoc($result_sponsor);
	
	//First try the new and accurate sponsor system
	if (!empty($buffer_sponsor['real_sponsorid'])) { 
		$receive_refer_username = $buffer_sponsor['real_sponsorid'];
		
		// JS ADDED FAILSAFE HERE 11/10/17
		if ($receive_refer_username == '') $receive_refer_username = 'admin';
		// WHY THIS GOT ADDED - WE STARTED SEEING SOME STRANGE CASES, WHERE real_sponsorid WAS NOT POPULATED, AND THIS HAD THE ILL EFFECT OF CAUSING THE PAYMENT PROCESS TO LOOP AND OVER CHARGE THE USERS. WHILE THIS VALUE IS BEING SET HERE (AFTER) THE PAYMENT, IT SEEMED TO BE CAUSING THE ISSUE ON (FUTURE) PAYMENTS!
		
		$result_unpaid = mysql_query("SELECT sponsorid FROM user_program WHERE ID=$payer_id && program_id=$program_id") or die('n16'.mysql_error());	
		
		$buffer_unpaid = mysql_fetch_assoc($result_unpaid);
		
		$real_refer_username = $buffer_unpaid['sponsorid'];
		
		$result = mysql_query("SELECT prog.*, memb.email, memb.First_Name, memb.Last_Name FROM members as memb LEFT JOIN user_program as prog USING (ID) WHERE memb.Username='{$receive_refer_username}' && prog.program_id=$program_id") or die('real_spon'.mysql_error());
				
		$buffer = mysql_fetch_assoc($result);
				
		$receive_refer_user_program = $buffer['user_program_id'];
		$receive_refer_qualify = $buffer['user_qualify'];
		$receive_refer_signup = $buffer['user_signup'];
		$receive_refer_status = $buffer['user_status'];

		$receive_refer_email = $buffer['email'];
		$receive_refer_firstname = $buffer['First_Name'];
		$receive_refer_lastname = $buffer['Last_Name'];

		//If its a different refer than the first in the list, make sure the unpaid_ref is set.
		if ($receive_refer_username != $real_refer_username && $receive_refer_username != 'admin') {
			$unpaid_username = $real_refer_username;
			$unpaid_ref = " unpaid_ref='$real_refer_username', ";
		} else {
			$unpaid_username = '';
			$unpaid_ref = '';
			}
	} else { 
		die("ERROR Finalize - UPP".$user_payment_plan_id);
	}
			

	
	//new signid code


	$result = mysql_query("SELECT user.sign_id FROM user_payment_plan as plan LEFT JOIN user_program as user USING (user_program_id) WHERE plan.user_payment_plan_id=$user_payment_plan_id") or die(mysql_error());

	$buffer = mysql_fetch_assoc($result);
	
	if ($_SESSION['debug'] == true) {
	echo "<br />FINALIZE: Preliminary Sign ID: ".$buffer['sign_id']."<br />";
	}
	
	if ($buffer['sign_id'] == 0 && $program_powerline > 0) { 
		die("Finalize: Sign ID not assigned UPP: $user_payment_plan_id");
	} else { // keep sign ID the same if there already is one
		$new_signup_id = $buffer['sign_id'];
		$qualify_info = '';
		$qualify_info_real = true;
	}
		
		// JS ADDED 7/26/13 SO RENEWALS DO NOT GET THEIR SIGN IDS CHANGED!
		if ($renewal === true && $buffer['sign_id'] !=0) {
			$qualify_info = '';
			$new_signup_id = $buffer['sign_id'];
			$qualify_info_real = false;
		}
		// END JS UPDATE
		if ($_SESSION['debug'] == true) {
			echo "<br />FINALIZE: New Sign ID: $new_signup_id<br />";
		}
	
	//end new signid code


	//Make sure the correct powerline receives the payment, it is run only when there is powerline payments!	
	if ($program_type == 'S' && $program_powerline > 0 && $program_selected != 'L') {
		
		$prog_result = mysql_query("SELECT * FROM program WHERE program_id=$program_id");
		
		$prog_buffer = mysql_fetch_assoc($prog_result);
		
		if ($prog_buffer['program_up_type'] == 'S') {
			
			if ($program_selected == 'L') $powerline_payment = $prog_buffer['program_up_life'];
			elseif ($program_selected == 'Y') $powerline_payment = $prog_buffer['program_up_year'];
			else $powerline_payment = $prog_buffer['program_up_pay'];
		
			$powerline_result = mysql_query("SELECT * FROM payment_plan WHERE user_payment_plan_id=$user_payment_plan_id ORDER BY payment_plan_id ASC");
			  			
			while ($powerline_buffer = mysql_fetch_assoc($powerline_result))
				{
				if ($powerline_buffer['payment_type'] == 'P') {		
					$receiving_powerline = $powerline_buffer['username'];
					$receiving_id = $powerline_buffer['payment_plan_id'];
					$receiving_type = 'P';
					$receiving_tier = 0;
					$receiving_amount = $powerline_payment;
					
					$detuct_amount = false;
					break;
					}
				elseif ($powerline_buffer['payment_type'] == 'PT') {				
					$receiving_powerline = $powerline_buffer['username'];
					$receiving_id = $powerline_buffer['payment_plan_id'];
					$receiving_type = 'P';
					$receiving_tier = 0;
					$receiving_amount = $powerline_payment;
					
					$change_type = 'T';
					$detuct_amount = true;
					break;
					}
				elseif ($powerline_buffer['payment_type'] == 'A' && empty($receiving_powerline)) {	
					$receiving_powerline = $powerline_buffer['username'];
					$receiving_id = $powerline_buffer['payment_plan_id'];
					$receiving_type = 'P';
					$receiving_tier = 0;
					$receiving_amount = $powerline_payment;
					
					$change_type = 'A';
					$detuct_amount = true;
					}
				}

			if ((empty($qualify_info) && $qualify_info_real == false) && $receiving_powerline != $receive_refer_username) {
					//check if the user already have a payment plan...
				$check_result = mysql_query("SELECT * FROM payment_plan WHERE user_payment_plan_id=$user_payment_plan_id");
				
				$user_exists = false;
	
				while ($check_buffer = mysql_fetch_assoc($check_result))
					{
					if ($check_buffer['username'] == $receive_refer_username && $check_buffer['plan_type'] == 'S') {
						$user_exists = true;
						$user_id = $check_buffer['payment_plan_id'];
						$user_type = $check_buffer['payment_type'];
						}
					}
				
				//Update the powerline and set it to the sponsor
				if ($user_exists === true) {
						if ($user_type == 'T') $real_type = 'PT';
						elseif ($user_type == 'P') $real_type = 'P';
						elseif ($user_type == 'PT') $real_type = 'PT';
						elseif ($user_type == 'A') $real_type = 'A';
						
						$query = "UPDATE payment_plan SET payment_type='$real_type', grace_pre_reason='Y' WHERE payment_plan_id={$user_id}";
						
						mysql_query($query) or die('1-'.$query.'<br>'.mysql_error());
						
						if ($detuct_amount === true) {
							mysql_query("UPDATE payment_plan SET amount=amount-$receiving_amount, payment_type='$change_type' WHERE payment_plan_id=$receiving_id") or die('4'.mysql_error());
							}
						else {
							mysql_query("DELETE FROM payment_plan WHERE payment_plan_id=$receiving_id") or die('4'.mysql_error());
							}
						}
					else {
						if ($detuct_amount === true) {
							$check_result = mysql_query("SELECT * FROM payment_plan WHERE payment_plan_id=$receiving_id");
							
							$check_buffer = mysql_fetch_assoc($check_result);
														
							mysql_query("INSERT INTO payment_plan SET user_payment_plan_id=$user_payment_plan_id, username='".mysql_real_escape_string($receive_refer_username)."', user_status='{$Global['active_status']}', amount=$receiving_amount, plan_type='S', payment_type='$receiving_type', payment_tier_level=0, payment_complete='Y', sec_payment_complete='Y', payment_period={$check_buffer['payment_period']}, first_paid_date={$check_buffer['first_paid_date']}, last_paid_date={$check_buffer['last_paid_date']}, grace_pre_reason='Y'") or die('n22'.mysql_error());
							
								$result = mysql_query("SELECT memb.Username, prog.* FROM members as memb LEFT JOIN user_program as prog USING (ID) WHERE memb.Username='{$buffer['sponsorid']}' && prog.program_id=$program_id");

				
							mysql_query("UPDATE payment_plan SET amount=amount-$receiving_amount, payment_type='$change_type' WHERE payment_plan_id=$receiving_id") or die('4'.mysql_error());
						} else {
							mysql_query("UPDATE payment_plan SET username='".mysql_real_escape_string($receive_refer_username)."', grace_pre_reason='Y' WHERE payment_plan_id=$receiving_id") or die('2-'.mysql_error());
						}
						}
				
				if ($Global['program_not_send_email'] === false) {
					//Custom Tags subject: [program_name] [firstname] [lastname]
					$subject_replace = array('[program_name]', '[firstname]', '[lastname]');	
					$subject_replace_with = array($program_name, $payer_firstname, $payer_lastname);
																		
					//Custom Tags message: [program_name] [firstname] [lastname] [amount] [old_powerline] [new_powerline] [type_payment]
					$message_replace = array('[program_name]', '[firstname]', '[lastname]', '[amount]', '[old_powerline]', '[new_powerline]', '[type_payment]');
					$message_replace_with = array($program_name, $payer_firstname, $payer_lastname, number_format($receiving_amount, 2), $receiving_powerline, $receive_refer_username, program_type($receiving_type, $receiving_tier));
		
					$subject = str_replace($subject_replace, $subject_replace_with, $Global['email_change_powerline_subject']);
					$message = str_replace($message_replace, $message_replace_with, $Global['email_change_powerline_message']);
		
					if ($_SESSION['sendemail'] != 'n') {
						if ($use_sendgrid == true) sendgrid_email($payer_email, $subject, $message);		
						else mail($payer_email, $subject, $message, "From: {$Global['admin_email_heading']} <{$Global['admin_email']}>\r\n");
					}
				}
			}
		}
	}

	//Update the refer number of signups and qualifiers if required
	mysql_query("UPDATE user_program SET user_signup=user_signup+1{$qualify_info} WHERE user_program_id='$receive_refer_user_program'") or die('Finalize.inc.php update sign ups'.mysql_error());
		
	//update the user who paid, different if its a normal or sub payment
	if ($program_type == 'N') { //Normal payment (or Lifetime subscription)
		mysql_query("UPDATE user_program SET payment_period=payment_period+1, user_status='{$new_user_status}', sponsorid='{$receive_refer_username}', {$unpaid_ref} program_linked='N', program_downgrade='N', program_downgrade_time=NULL, grace_start=NULL, grace_expire=NULL, grace_checked=NULL, end_program='N' {$new_user_status_additional} WHERE ID=$payer_id AND program_id=$program_id") or die('6'.mysql_error());
		mysql_query("UPDATE user_program SET started=$timestamp WHERE ID=$payer_id && program_id=$program_id AND started IS NULL") or die('6'.mysql_error());
		$slog_qry = "INSERT INTO `status_log`(`ID`, `program_id`, `new_status`, `event_time`, `changed_by`, `reason`, `new_sign_id`, `new_sponsorid`, `new_powerline_sponsorid`) SELECT ID,program_id,user_status,'".date('Y-m-d H:i:a')."','Finalize','Normal: Change Status from {$starting_payer_user_status} to {$new_user_status}', sign_id, sponsorid, powerline_sponsor FROM user_program WHERE program_id='{$program_id}' AND ID='{$payer_id}'";
		if ($_SESSION['debug']) echo "<br />: ".$slog_qry."<br />";
		mysql_query($slog_qry);
	} else { //New subscription payment
		if ($_SESSION['debug'] == true) {
			echo "Finalize: Thinks this is a NEW subscription payment<br>";
		}
		//The subscription date is set to one day longer to combat payment processor issues, i.e. if they have isses sending over IPN info at the same time 	etc. The time left is added when next payment is completed etc.
		
		if ($payment_processor != 'VC') { 
		
		$expire_timestamp = $timestamp + (($program_sub_period + 1) * 86400) + $extend_subscription;
			
		} else {
		
			$expire_timestamp = $timestamp + ((($program_sub_period * $months) + 1) * 86400) + $extend_subscription;
			
		}
		$started_timestamp = $timestamp;

		$freetrial_start = date('Y-m-d H:i:s');
		$freetrial_end = date('Y-m-d H:i:s',$expire_timestamp);		

		// FREE TRIAL UPDATE
		if ($freetrial == true) {
			$expire_timestamp = $timestamp + ($freetrial_days * 86400);
			$prog_status = 'FreeTrial';
			$freetrial_status = 'started';
			$query= "UPDATE user_program SET payment_period=payment_period+1, user_status='".$prog_status."', sponsorid='{$receive_refer_username}', {$unpaid_ref} freetrial_status='$freetrial_status', freetrial_start='$freetrial_start', start_time='$freetrial_start', end_time='$freetrial_end', expire=$expire_timestamp, program_linked='N', program_downgrade='N', program_downgrade_time=NULL, grace_start=NULL, grace_expire=NULL, grace_checked=NULL, end_program='N' WHERE ID=$payer_id AND program_id=$program_id";
		} else { // NOT A FREE TRIAL
			$prog_status = $Global['active_status'];

			$query= "UPDATE user_program SET payment_period=payment_period+1, user_status='{$new_user_status}', sponsorid='{$receive_refer_username}', {$unpaid_ref} start_time='$freetrial_start', end_time='$freetrial_end', expire=$expire_timestamp, program_linked='N', program_downgrade='N', program_downgrade_time=NULL, grace_start=NULL, grace_expire=NULL, grace_checked=NULL, end_program='N' WHERE ID=$payer_id AND program_id=$program_id";	
		}	
		// END FREE TRIAL UPDATE
		mysql_query($query) or die('7'.$query.'<br>'.mysql_error());
		mysql_query("UPDATE user_program SET started=$timestamp WHERE ID=$payer_id && program_id=$program_id AND started IS NULL") or die('7'.mysql_error());
		$slog_qry = "INSERT INTO `status_log`(`ID`, `program_id`, `new_status`, `event_time`, `changed_by`, `reason`, `new_sign_id`, `new_sponsorid`, `new_powerline_sponsorid`) SELECT ID,program_id,user_status,'".date('Y-m-d H:i:a')."','Finalize','New Subscription Payment', sign_id, sponsorid, powerline_sponsor FROM user_program WHERE program_id='{$program_id}' AND ID='{$payer_id}'";
		if ($_SESSION['debug']) echo "<br />: ".$slog_qry."<br />";
		mysql_query($slog_qry);
	}	
	
	//If this is a master program, comp the user in the child programs as well
	if ($master_program === true) {
		//Note that child programs does not count as a qualifier, or signup for the sponsor!
		
		$parent_sign_id = $new_signup_id;
		
		foreach ($master_link as $key) 
			{
			if (ctype_digit($key)) {			
				$result_2 = mysql_query("SELECT program_up, program_up_order FROM program WHERE program_id=$key") or die(mysql_error());
						
				$buffer_2 = mysql_fetch_assoc($result_2);
				
				//select the latest sign_id
				$result = mysql_query("SELECT max(sign_id) as total FROM user_program WHERE sponsorid='{$receive_refer_username}' AND program_id=$key") or die('20'.mysql_error());
					
				$buffer = mysql_fetch_assoc($result);
					
				if ($buffer['total'] >= $buffer_2['program_up']) {
					$new_signup_id = $buffer['total'] + 1;
				} else {
					$child_powerlines = explode(',', $buffer_2['program_up_order']);	
					
					$result = mysql_query("SELECT sign_id FROM user_program WHERE sponsorid='{$receive_refer_username}' && sign_id!=0 AND program_id=$key ORDER BY sign_id ASC LIMIT ".$child_powerlines[(count($child_powerlines) - 1)]) or die('20'.mysql_error());
		
					$nr = 1;
					
					while ($buffer = mysql_fetch_assoc($result)) {
						if ($buffer['sign_id'] != $nr && !in_array($nr, $child_powerlines)) break;
						++$nr;
					}
				
					$new_signup_id = $nr;
				}
					
				$result_unpaidref = mysql_query("SELECT sponsorid, unpaid_ref FROM user_program WHERE ID=$payer_id && program_id=$key");
				
				$buffer_unpaidref = mysql_fetch_assoc($result_unpaidref);
				
				if ($buffer_unpaidref['sponsorid'] != $receive_refer_username && empty($buffer_unpaidref['unpaid_ref'])) {
					$unpaid_ref = " unpaid_ref='{$buffer_unpaidref['sponsorid']}', ";
					}
				else {
					$unpaid_ref = '';
					}
					
				mysql_query("UPDATE user_program SET user_status='Comped', sponsorid='{$receive_refer_username}', {$unpaid_ref} program_linked='Y', program_linked_to='{$program_id}', grace_start=NULL, grace_expire=NULL, grace_checked=NULL, end_program='N' WHERE user_status!='Active' AND ID='{$payer_id}' AND program_id='{$key}'") or die('Finalize.inc.php comping'.mysql_error());
				
				// DO NOT UPDATE SIGN ID WHERE IT ALREADY EXISTS!!
				mysql_query("UPDATE user_program SET sign_id='{$new_signup_id}' WHERE user_status!='Active' AND ID='{$payer_id}' AND program_id='{$key}' AND sign_id=0") or die('Finalize.inc.php comping 2'.mysql_error());
				
				mysql_query("UPDATE user_program SET started=$timestamp WHERE ID=$payer_id && program_id=$program_id AND started IS NULL") or die('Finalize.inc.php comping 3'.mysql_error());
				$slog_qry = "INSERT INTO `status_log`(`ID`, `program_id`, `new_status`, `event_time`, `changed_by`, `reason`, `new_sign_id`, `new_sponsorid`, `new_powerline_sponsorid`) SELECT ID,program_id,user_status,'".date('Y-m-d H:i:a')."','Finalize','Comped Program linked to {$program_id}', sign_id, sponsorid, powerline_sponsor FROM user_program WHERE program_id='{$key}' AND ID='{$payer_id}'";
				if ($_SESSION['debug']) echo "<br />: ".$slog_qry."<br />";
				mysql_query($slog_qry);
				}
			}
		
		
		
		}
	

//Add the program to the active_in list!
$result = mysql_query("SELECT active_in FROM user_program WHERE ID=$payer_id && program_id=$program_id") or die('1'.mysql_error());		

$buffer = mysql_fetch_assoc($result);

$progs_real = array();

if (!empty($buffer['active_in'])) {
  //verify that the program is not already there
  $progs = explode(',', $buffer['active_in']);
  
  foreach ($progs as $value) {
    if ($value != $program_id) {
      //Verify that it has not turned into a child program, only active programs should be in the list!
      $child_result = mysql_query("SELECT program_id FROM user_program WHERE ID=$payer_id && program_id=$value && program_linked='N'") or die('3'.mysql_error());
      
      $child_buffer = mysql_fetch_assoc($child_result);
      
      if (!empty($child_buffer['program_id'])) $progs_real[] = $value;
      }
    }
  }

$progs_real[] = $program_id;

mysql_query("UPDATE user_program SET active_in='".implode(',', $progs_real)."' WHERE ID=$payer_id") or die('2'.mysql_error());
$slog_qry = "INSERT INTO `status_log`(`ID`, `program_id`, `new_status`, `event_time`, `changed_by`, `reason`, `new_sign_id`, `new_sponsorid`, `new_powerline_sponsorid`) SELECT ID,program_id,user_status,'".date('Y-m-d H:i:a')."','Finalize','Update active_in: ".implode(',', $progs_real)."', sign_id, sponsorid, powerline_sponsor FROM user_program WHERE program_id='{$program_id}' AND ID='{$payer_id}'"; 
if ($_SESSION['debug']) echo "<br />: ".$slog_qry."<br />";
mysql_query($slog_qry);

//Handle forced passup functionality
if ($Global['forced_passup'] > 0) {
	$result = mysql_query("SELECT
													master.forced_ref
													, master.sponsor_ref
													, memb.ID as forced_id
													, spons_memb.ID as sponsor_id
												 FROM
													user_payment_plan as master
													LEFT JOIN members as memb
														ON (master.forced_ref=memb.Username)
													LEFT JOIN members as spons_memb
														ON (master.sponsor_ref=spons_memb.Username)
												 WHERE
													master.user_payment_plan_id=$user_payment_plan_id
												") or die('forced'.mysql_error());

	$buffer = mysql_fetch_assoc($result);

	if (!empty($buffer['forced_ref'])) {
		//Select the row with information from the forced passup table
		$result_temp = mysql_query("SELECT
																 ID
																 , passup_total
																FROM
																	forced_passup
																WHERE
																	ID={$buffer['forced_id']}
																	AND sponsor={$buffer['sponsor_id']}
																	AND program_id={$program_id}
															 ") or die(mysql_error());

		$buffer_temp = mysql_fetch_assoc($result_temp);

		if (!empty($buffer_temp['ID']) && $buffer_temp['passup_total'] > 1) {
			//more than one passup required, remove one from the query
			mysql_query("UPDATE
										forced_passup
									 SET
										passup_total=passup_total-1
									 WHERE
										ID={$buffer['forced_id']}
										AND sponsor={$buffer['sponsor_id']}
										AND program_id={$program_id}
									") or die(mysql_error());
			}
		elseif (!empty($buffer_temp['ID'])) {
			mysql_query("DELETE FROM
										forced_passup
									 WHERE
										ID={$buffer['forced_id']}
										AND sponsor={$buffer['sponsor_id']}
										AND program_id={$program_id}
									") or die(mysql_error());
			}
		else {
			//There were no record of the passup, possibly already passed up...
			//Additional protection can be added here to move the user back to who he came from, tho that is a massive job
			}

		//Update the user_program and set the forced_ref
		mysql_query("UPDATE
									user_program
								 SET
									unpaid_ref=NULL
									, forced_ref='".mysql_real_escape_string($buffer['forced_ref'])."'
								 WHERE
									ID=$payer_id
									AND program_id=$program_id
								") or die(mysql_query());

		}
	else {
		//Check and make certain noone else is passing up sales to you, if they are remove that sale since you made it yourself.
		$result_temp = mysql_query("SELECT
																	memb.ID
																FROM
																	user_program as prog
																	LEFT JOIN members as memb
																		ON (prog.sponsorid=memb.Username)
																WHERE
																	prog.ID=$payer_id
																	AND prog.program_id=$program_id
															 ") or die(mysql_error());

		$buffer_temp = mysql_fetch_assoc($result_temp);

		$temp_sponsor_id = $buffer_temp['ID'];

		$result_temp = mysql_query("SELECT
														ID
														, passup_total
													 FROM
														forced_passup
													 WHERE
														sponsor=$temp_sponsor_id
														AND program_id=$program_id
													") or die('forced2'.mysql_error());

		$buffer_temp = mysql_fetch_assoc($result_temp);

		//If your doing your own sales, remove forces sales
		if (!empty($buffer_temp['ID']) && $buffer_temp['passup_total'] > 1) {
			//more than one passup required, remove one from the query
			mysql_query("UPDATE
										forced_passup
									 SET
										passup_total=passup_total-1
									 WHERE
										ID={$buffer_temp['ID']}
										AND sponsor={$temp_sponsor_id}
										AND program_id={$program_id}
									") or die(mysql_error());
			}
		elseif (!empty($buffer_temp['ID'])) {
			mysql_query("DELETE FROM
										forced_passup
									 WHERE
										ID={$buffer_temp['ID']}
										AND sponsor={$temp_sponsor_id}
										AND program_id={$program_id}
									") or die(mysql_error());
			}
		}

	//Add this member into the forced passup system so they receive their passups!

	//First find out who should be giving them the passup, i.e. either the powerline if its a powerline system or the tier1
	if ($program_powerline > 0) {
		function user_unpaid($username, $status, $bad_status, $program) {
			$buffer['sponsorid'] = $username;
			$buffer['user_status'] = $status;

			while (in_array($buffer['user_status'], $bad_status))
				{
				$result = mysql_query("SELECT memb.Username, prog.* FROM members as memb LEFT JOIN user_program as prog USING (ID) WHERE memb.Username='{$buffer['sponsorid']}' && prog.program_id=$program");

				$buffer = mysql_fetch_assoc($result);
				}

			return $buffer;
			}

		$result_temp = mysql_query("SELECT
																	*
																FROM
																	user_program
																WHERE
																	ID=$payer_id
																	AND program_id=$program_id
															 ") or die(mysql_error());

		$buffer_temp = mysql_fetch_assoc($result_temp);

		$previous_sign_id = $buffer_temp['sign_id'];

		while (in_array($previous_sign_id, $Global['powerline_order']) || (in_array($buffer_temp['user_status'], $Global['bad_status'])) || ($buffer_temp['user_status'] == $Global['tempcomp_status'] && $buffer_temp['user_signup'] >= $program_powerline && empty($buffer_temp['grace_expire'])))
			{
			$previous_sign_id = $buffer_temp['sign_id'];

			if (in_array($buffer_temp['user_status'], $Global['bad_status'])) {
				$buffer_temp = user_unpaid($buffer_temp['sponsorid'], $buffer_temp['user_status'], $Global['bad_status'], $program_id);
				$buffer_temp['sponsorid'] = $buffer_temp['Username'];
				}

			$result_temp = mysql_query("SELECT memb.Username, prog.* FROM members as memb LEFT JOIN user_program as prog USING (ID) WHERE memb.Username='{$buffer_temp['sponsorid']}' && prog.program_id=$program_id") or die(mysql_error());

			$buffer_temp = mysql_fetch_assoc($result_temp);
			}

		if ($buffer_temp['ID'] == $payer_id) {
			$buffer_temp['Username'] = $buffer_temp['sponsorid'];
			}

		$result_temp = mysql_query("SELECT
																	ID
																FROM
																	members
																WHERE
																	Username='".mysql_real_escape_string($buffer_temp['Username'])."'
															 ") or die(mysql_error());

		$buffer_temp = mysql_fetch_assoc($result_temp);

		$forced_to_giveaway = $buffer_temp['ID'];
		}
	else {
		$result_temp = mysql_query("SELECT
																	memb.ID
																FROM
																	user_program as prog
																	LEFT JOIN members as memb
																		ON (prog.sponsorid=memb.Username)
																WHERE
																	prog.ID=$payer_id
																	AND prog.program_id=$program_id
															 ") or die(mysql_error());

		$buffer_temp = mysql_fetch_assoc($result_temp);

		$forced_to_giveaway = $buffer_temp['ID'];
		}

	mysql_query("INSERT INTO
								forced_passup
							 SET
								ID=$forced_to_giveaway
								, sponsor=$payer_id
								, program_id=$program_id
								, passup_total={$Global['forced_passup']}
								, passup_tried=0
						  ") or die(mysql_error());

	} // end forced passup

//if ($Global['program_not_send_email'] === false && $program_id!=3 && $program_id!=4)	
if ($Global['program_not_send_email'] === false) {		
	//Pull out the email templates
	$result = mysql_query("SELECT * FROM program_email WHERE program_id=$program_id") or die('9'.mysql_error());

	while ($buffer = mysql_fetch_assoc($result))
		{
		switch ($buffer['email_type']) {
			case 'nm': //New Member Email
				$new_member_subject = $buffer['email_subject'];
				$new_member_message = $buffer['email_message'];
				break;
			case 's':	//Sponsor Email
				$sponsor_subject = $buffer['email_subject'];
				$sponsor_message = $buffer['email_message'];
				break;
			case 'sq': //Sponsor Qualifier Email
				$sponsor_q_subject = $buffer['email_subject'];
				$sponsor_q_message = $buffer['email_message'];
				break;
			case 'p': //Powerline Email
				$powerline_subject = $buffer['email_subject'];
				$powerline_message = $buffer['email_message'];
				break;
			case 'u': //Unpaid Email	
				$unpaid_subject = $buffer['email_subject'];
				$unpaid_message = $buffer['email_message'];	
				break;
			} // END SWITCH CASE 
		} // END WHILE LOOP	
		
	// GET PROGRAM NAME, AND DEFINE SITENAME AND URL FOR PROGRAM EMAILS
		$user_mem_info=mysql_fetch_array(mysql_query("SELECT	memb.*		FROM	user_program as prog	LEFT JOIN members as memb	ON (prog.sponsorid=memb.Username)	WHERE	prog.ID=$payer_id AND prog.program_id=$program_id"));
		$sitename=$Global['webpage_name'];
		$siteurl=$Global['webpage_url'];

	// END GET PROGRAM NAME, AND DEFINE SITENAME AND URL FOR PROGRAM EMAILS

	//New member email
	//Custom Tags subject: [program_name] [firstname] [lastname]  [program_name]  [sitename] [URL]	
	$subject_replace = array('[firstname]', '[lastname]', '[program_name]',  '[sitename]', '[URL]');	
	$subject_replace_with = array($payer_firstname, $payer_lastname,$program_name,$sitename,$siteurl);
				  						
	//Custom Tags message: [firstname] [lastname] [username] [password] [sponsorid] [sponsorstatus] [ip] [program_name]  [sitename] [URL]	
	$message_replace = array('[firstname]', '[lastname]', '[username]', '[password]', '[sponsorid]', '[sponsorstatus]', '[ip]', '[program_name]',  '[sitename]', '[url]');
	$message_replace_with = array($payer_firstname, $payer_lastname, $payer_username, $payer_password, $receive_refer_username, $receive_refer_status, $payer_signup_ip,$program_name,$sitename,$siteurl);
				  							
	$subject = str_replace($subject_replace, $subject_replace_with, $new_member_subject);
	$message = str_replace($message_replace, $message_replace_with, $new_member_message);				  					

	if ($_SESSION['sendemail'] != 'n') {
		if ($use_sendgrid == true) sendgrid_email($payer_email, $subject, $message);		
		else mail($payer_email, $subject, $message, "From: {$Global['admin_email_heading']} <{$Global['admin_email']}>\r\n");
	}	
		
		if ($program_id != 100) { // QQQ KLUDGE -- DO NOT SEND SPONSOR EMAILS ON LISTED PROGRAM HERE (SET TO 100 WHEN NOT IN USE)
	if (empty($qualify_info) && $qualify_info_real == false) {
		//Sponsor email
		//Custom Tags subject: [firstname] [lastname]	[program_name]  [sitename] [URL]	
		$subject_replace = array('[firstname]', '[lastname]', '[program_name]',  '[sitename]', '[URL]');	
		$subject_replace_with = array($receive_refer_firstname, $receive_refer_lastname,$program_name,$sitename,$siteurl);
					  						
		//Custom Tags message: [firstname] [lastname] [newmemberemail] [newmemberfirstname] [newmemberlastname] [program_name]  [sitename] [URL]	
		$message_replace = array('[firstname]', '[lastname]', '[newmemberemail]', '[newmemberfirstname]', '[newmemberlastname]', '[program_name]',  '[sitename]', '[URL]');
		$message_replace_with = array($receive_refer_firstname, $receive_refer_lastname, $payer_email, $payer_firstname, $payer_lastname,$program_name,$sitename,$siteurl);
					  							
		$subject = str_replace($subject_replace, $subject_replace_with, $sponsor_subject);
		$message = str_replace($message_replace, $message_replace_with, $sponsor_message);				
		
		if ($_SESSION['sendemail'] != 'n') {
			// NOTE: TO DISABLE SENDING DIRECT SPONSOR EMAILS FOR ALL PROGRAMS, COMMENT NEXT LINE
			if ($use_sendgrid == true) sendgrid_email($receive_refer_email, $subject, $message);		
			else mail($receive_refer_email, $subject, $message, "From: {$Global['admin_email_heading']} <{$Global['admin_email']}>\r\n");
			$sent_sponsor_email = true;
		}	
				// SEND SMS ALERT
				if(eregi("sales",$user_mem_info['sms_alert']) && $user_mem_info['cellphone'] && $user_mem_info['cellphone_carrier']){

							// To send HTML mail, the Content-type header must be set
							//$headers  = 'MIME-Version: 1.0' . "\r\n";
							//$headers .= 'Content-type: text/html; charset=iso-8859-1' . "\r\n";
							$headers = 'From: '.$Global['admin_email_heading'].' <'.$Global['admin_email'].'>'."\r\n";

		if ($_SESSION['sendemail'] != 'n') {
			mail(str_replace('<CELLPHONE>',eregi_replace('[^0-9]','',$user_mem_info['cellphone']),$Global['smscarrier'][$user_mem_info['cellphone_carrier']]),$subject, $message."\n", $headers);
		}
		} // END SEND SMS ALERT

			} else { 
		//Find powerline information
		$result = mysql_query("SELECT * FROM payment_plan WHERE user_payment_plan_id=$user_payment_plan_id ORDER BY payment_plan_id ASC") or die(mysql_error());

		while ($buffer = mysql_fetch_assoc($result))
			{
			if ($buffer['payment_type'] == 'P' || $buffer['payment_type'] == 'PT') {
				$powerline_username = $buffer['username'];
				}
			}
		
		if (empty($powerline_username)) $powerline_username = $Global['administrator'];
		
		//++$receive_refer_qualify; should show the correct qualifier number now.
		
		//Gather powerline information
		$result = mysql_query("SELECT email, First_Name, Last_Name,cellphone,sms_alert,cellphone_carrier FROM members WHERE Username='$powerline_username'") or die('10'.mysql_error());
		
		$buffer = mysql_fetch_assoc($result);
		
		//Sponsor qualify email
		//Custom Tags subject: [firstname] [lastname]	[program_name]  [sitename] [URL]	
		$subject_replace = array('[firstname]', '[lastname]', '[program_name]',  '[sitename]', '[URL]');	
		$subject_replace_with = array($receive_refer_firstname, $receive_refer_lastname,$program_name,$sitename,$siteurl);
					  						
		//Custom Tags message: [firstname] [lastname]	[newmemberemail] [newmemberfirstname] [newmemberlastname] [powerlinefirstname] [powerlinelastname] [powerlineemail] [qualifynumber] [qualifyrequired] [program_name]  [sitename] [URL]	
		$message_replace = array('[firstname]', '[lastname]', '[newmemberemail]', '[newmemberfirstname]', '[newmemberlastname]', '[powerlinefirstname]', '[powerlinelastname]', '[powerlineemail]', '[qualifynumber]', '[qualifyrequired]', '[program_name]',  '[sitename]', '[URL]');
		$message_replace_with = array($receive_refer_firstname, $receive_refer_lastname, $payer_email, $payer_firstname, $payer_lastname, $buffer['First_Name'], $buffer['Last_Name'], $buffer['email'], $receive_refer_qualify, $program_powerline,$program_name,$sitename,$siteurl);
					  							
		$subject = str_replace($subject_replace, $subject_replace_with, $sponsor_q_subject);
		$message = str_replace($message_replace, $message_replace_with, $sponsor_q_message);				  					
		if ($_SESSION['sendemail'] != 'n' && $sent_sponsor_email != true) {
			if ($program_powerline > 0 && $use_sendgrid == true) sendgrid_email($receive_refer_email, $subject, $message);	
			else if ($program_powerline > 0) mail($receive_refer_email, $subject, $message, "From: {$Global['admin_email_heading']} <{$Global['admin_email']}>\r\n");
		}	
				// send SMS for user
		if ($program_powerline > 0 && eregi("sales",$buffer['sms_alert']) && $buffer['cellphone'] && $buffer['cellphone_carrier']){
			// To send HTML mail, the Content-type header must be set
			//$headers  = 'MIME-Version: 1.0' . "\r\n";
			//$headers .= 'Content-type: text/html; charset=iso-8859-1' . "\r\n";
			$headers = 'From: '.$Global['admin_email_heading'].' <'.$Global['admin_email'].'>'."\r\n";
		
			if ($_SESSION['sendemail'] != 'n') {
				mail(str_replace('<CELLPHONE>',eregi_replace('[^0-9]','',$buffer['cellphone']),$Global['smscarrier'][$buffer['cellphone_carrier']]),$subject, $message."\n", $headers);
			}	
		}
		//Powerline email
		//Custom Tags subject: [firstname] [lastname]	
		$subject_replace = array('[firstname]', '[lastname]', '[program_name]',  '[sitename]', '[URL]');	
		$subject_replace_with = array($buffer['First_Name'], $buffer['Last_Name'],$program_name,$sitename,$siteurl);
					  						
		//Custom Tags message: [firstname] [lastname] [newmemberemail] [newmemberfirstname] [newmemberlastname] [sponsoremail] [sponsorfirstname] [sponsorlastname] [program_name]  [sitename] [URL]	
		$message_replace = array('[firstname]', '[lastname]', '[newmemberemail]', '[newmemberfirstname]', '[newmemberlastname]', '[sponsoremail]', '[sponsorfirstname]', '[sponsorlastname]', '[program_name]',  '[sitename]', '[URL]');
		$message_replace_with = array($buffer['First_Name'], $buffer['Last_Name'], $payer_email, $payer_firstname, $payer_lastname, $receive_refer_email, $receive_refer_firstname, $receive_refer_lastname,$program_name,$sitename,$siteurl);
					  							
		$subject = str_replace($subject_replace, $subject_replace_with, $powerline_subject);
		$message = str_replace($message_replace, $message_replace_with, $powerline_message);				  					
		if ($_SESSION['sendemail'] != 'n') {
			if ($program_powerline > 0 && $use_sendgrid == true) sendgrid_email($buffer['email'], $subject, $message);		
			else if ($program_powerline > 0) mail($buffer['email'], $subject, $message, "From: {$Global['admin_email_heading']} <{$Global['admin_email']}>\r\n");
		}
										// send SMS for user
				if ($program_powerline > 0 && eregi("sales",$buffer['sms_alert']) && $buffer['cellphone'] && $buffer['cellphone_carrier']){
					// To send HTML mail, the Content-type header must be set
					//$headers  = 'MIME-Version: 1.0' . "\r\n";
					//$headers .= 'Content-type: text/html; charset=iso-8859-1' . "\r\n";
					$headers = 'From: '.$Global['admin_email_heading'].' <'.$Global['admin_email'].'>'."\r\n";
					
					if ($_SESSION['sendemail'] != 'n') {
						mail(str_replace('<CELLPHONE>',eregi_replace('[^0-9]','',$buffer['cellphone']),$Global['smscarrier'][$buffer['cellphone_carrier']]),$subject, $message."\n", $headers);
					}	
				}
		}
	
		
	if (!empty($unpaid_username)) {
		//Gather unpaid information
		$result = mysql_query("SELECT email, First_Name, Last_Name,cellphone,sms_alert,cellphone_carrier FROM members WHERE Username='$unpaid_username'") or die('11'.mysql_error());
		
		$buffer = mysql_fetch_assoc($result);
		
		//Unpaid email
		//Custom Tags subject: [firstname] [lastname]	[program_name]  [sitename] [URL]	
		$subject_replace = array('[firstname]', '[lastname]', '[program_name]',  '[sitename]', '[URL]');	
		$subject_replace_with = array($buffer['First_Name'], $buffer['Last_Name'],$program_name,$sitename,$siteurl);
					  						
		//Custom Tags message: [firstname] [lastname] [newmemberemail] [newmemberfirstname] [newmemberlastname] [sponsoremail] [sponsorfirstname] [sponsorlastname] [program_name]  [sitename] [URL]	
		$message_replace = array('[firstname]', '[lastname]', '[newmemberemail]', '[newmemberfirstname]', '[newmemberlastname]', '[sponsoremail]', '[sponsorfirstname]', '[sponsorlastname]', '[program_name]',  '[sitename]', '[URL]');
		$message_replace_with = array($buffer['First_Name'], $buffer['Last_Name'], $payer_email, $payer_firstname, $payer_lastname, $receive_refer_email, $receive_refer_firstname, $receive_refer_lastname,$program_name,$sitename,$siteurl);
					  						
/* // ONLY FOR POWERLINE PROGRAMS!
// SATS YOU ARE UNPAID - FOR SOME REASON GOING OUT TO PAID MEMBERS IN MATRIX!							
		$subject = str_replace($subject_replace, $subject_replace_with, $unpaid_subject);
		$message = str_replace($message_replace, $message_replace_with, $unpaid_message);				  					
	
		if ($_SESSION['sendemail'] != 'n') {
			if ($use_sendgrid == true) sendgrid_email($buffer['email'], $subject, $message);		
			else mail($buffer['email'], $subject, $message, "From: {$Global['admin_email_heading']} <{$Global['admin_email']}>\r\n");
		}	
*/		
										// send SMS for user
		if(eregi("sales",$buffer['sms_alert']) && $buffer['cellphone'] && $buffer['cellphone_carrier']){
				//$headers  = 'MIME-Version: 1.0' . "\r\n";
				//$headers .= 'Content-type: text/html; charset=iso-8859-1' . "\r\n";
				$headers = 'From: '.$Global['admin_email_heading'].' <'.$Global['admin_email'].'>'."\r\n";

					if ($_SESSION['sendemail'] != 'n') {
						mail(str_replace('<CELLPHONE>',eregi_replace('[^0-9]','',$user_mem_info['cellphone']),$Global['smscarrier'][$user_mem_info['cellphone_carrier']]),$subject, $message."\n", $headers);
					}
		}
	} // END UNPAID USERNAME NOT EMPTY
		} // end if program id is not listed above for exclusion KLUDGE
	} // end if $Global['program_not_send_email'] === false
} // end NOT First subscription payment or a normal payment

// **********************************************************************************************************************************
// ******************* THE CODE FOLLOWING (FROM THIS POINT TO THE END OF THE FILE) IS UNCONDITIONALLY EXECUTED **********************

//Update user payment plan, set it to active and set start date	
mysql_query("UPDATE user_payment_plan SET valid_plan='Y' WHERE user_payment_plan_id=$user_payment_plan_id") or die('set upp valid'.mysql_error());
mysql_query("UPDATE user_payment_plan SET timestamp_started=$timestamp WHERE user_payment_plan_id=$user_payment_plan_id AND timestamp_started IS NULL") or die('8'.mysql_error()); // only update upp started timestamp if it is not already set
$slog_qry = "INSERT INTO `status_log`(`ID`, `program_id`, `new_status`, `event_time`, `changed_by`, `reason`, `new_sign_id`, `new_sponsorid`, `new_powerline_sponsorid`) SELECT ID,program_id,user_status,'".date('Y-m-d H:i:a')."','Finalize','upp={$user_payment_plan_id} SET valid_plan=Y', sign_id, sponsorid, powerline_sponsor FROM user_program WHERE program_id='{$program_id}' AND ID='{$payer_id}'";
	if ($_SESSION['debug']) echo "<br />: ".$slog_qry."<br />";
	mysql_query($slog_qry);
	
//Also set all other started plans to history.

mysql_query("UPDATE user_payment_plan SET valid_plan='H' WHERE user_program_id='{$user_program_id}' && user_payment_plan_id!='{$user_payment_plan_id}'") or die('Finalize.inc.php set ll other upps to H'.mysql_error()); // set all other plans to History
//Update the payment plan table (user payment plan is the master table), making it ready for next months subscription (only matter if its subscription based, has no effect on one time payment programs)

				// CLEAN UP - FLUSH ALL PRIOR TEMP UPPs, WITH ASSOCIATED PPs NEVER PAID
				// DOES NOT TOUCH HISTORY UPPs, STARTED PLANS OR ANY PAID PAYMENT PLANS!!
				mysql_query("DELETE pp.*, upp.* FROM 
				payment_plan as pp LEFT JOIN user_payment_plan as upp 
				ON pp.user_payment_plan_id=upp.user_payment_plan_id
				WHERE upp.user_program_id='{$user_program_id}' AND upp.valid_plan='N' AND upp.user_payment_plan_id!='{$user_payment_plan_id}' AND pp.payment_complete='N'") or die('finalize delete upp error'.mysql_error());

//Update the payment plan table (user payment plan is the master table), making it ready for next months subscription (only matter if its subscription based, has no effect on one time payment programs)
mysql_query("UPDATE payment_plan SET payer_username='{$payer_username}', sec_payment_complete='N' WHERE user_payment_plan_id=$user_payment_plan_id") or die('12'.mysql_error());

//Update the payment table, set it to paid as the user has paid for the next period already
if (!empty($period) && is_array($period)) {
	foreach ($period as $key) {
		if ($period_info < $key['period']) {
			//Update the paymen table, set it to paid as the user has paid for the next period already
			mysql_query("UPDATE payment_plan SET sec_payment_complete='Y' WHERE payment_plan_id='{$key['id']}'") or die('13'.mysql_error());
		}
	}
}

if(isset($_SESSION['a'.$_SESSION['UserID']]['status_check'])) unset($_SESSION['a'.$_SESSION['UserID']]['status_check']);
if(isset($_SESSION['status_check'])) unset($_SESSION['status_check']);
if(isset($_SESSION['E4CTR'])) unset($_SESSION['E4CTR']);
if(isset($_SESSION['ordernr_e4'])) unset($_SESSION['ordernr_e4']);	

// if not active or Comped, Activate it

if (true) { // always make sure to set status to Activated (or Comped)
	if ($new_user_status != "Active" && $new_user_status != "FreeTrial") $new_user_status = "Active";
	mysql_query("UPDATE user_program SET user_status='{$new_user_status}' WHERE ID=$payer_id && program_id=$program_id") or die('13 Suspend to Active '.mysql_error());
	$slog_qry = "INSERT INTO `status_log`(`ID`, `program_id`, `new_status`, `event_time`, `changed_by`, `reason`, `new_sign_id`, `new_sponsorid`, `new_powerline_sponsorid`) SELECT ID,program_id,user_status,'".date('Y-m-d H:i:a')."','Finalize','Failsafe: Status is now {$new_user_status}', sign_id, sponsorid, powerline_sponsor FROM user_program WHERE program_id='{$program_id}' AND ID='{$payer_id}'";
	if ($_SESSION['debug']) echo "<br />: ".$slog_qry."<br />";
	mysql_query($slog_qry);
}

mysql_query("UPDATE members SET Status='paid' WHERE ID=$payer_id") or die(mysql_error());
	
/* // QQQ AMOUNT KLUDGE - EDIT PAY PLAN AMOUNT TO BE LESS FOR RECURRING AMOUNT NEXT YEAR		

if ($program_id == 2) {	
	mysql_query("UPDATE payment_plan SET amount='99.00' WHERE user_payment_plan_id='{$user_payment_plan_id}' AND payer_username='{$payer_username}' AND username='admin' AND amount='199.00'") or die('amt kludge 1'.mysql_error());
				
	mysql_query("UPDATE payment_plan SET amount='399.00' WHERE user_payment_plan_id='{$user_payment_plan_id}' AND payer_username='{$payer_username}' AND username='admin' AND amount='499.00'") or die('amt kludge 2'.mysql_error());			
}	
if ($program_id == 3) {		
	mysql_query("UPDATE payment_plan SET amount='199.00' WHERE user_payment_plan_id='{$user_payment_plan_id}' AND payer_username='{$payer_username}' AND username='admin' AND amount='299.00'") or die('amt kludge 3'.mysql_error());				
			
	mysql_query("UPDATE payment_plan SET amount='1199.00' WHERE user_payment_plan_id='{$user_payment_plan_id}' AND payer_username='{$payer_username}' AND username='admin' AND amount='1299.00'") or die('amt kludge 4'.mysql_error());
	// END AMOUNT KLUDGE
}
*/

//Finally process the giveaway file if the function is enabled
//The reason its included last, is due to the possiblity that the file could contain programming issues!
//Remember that if there is syntax errors the entire finalize script will fail! but if its only logic errors in the code, at least the finalize script will run.
if ($giveaway_enabled === true && file_exists($giveaway_file)) {
	include $giveaway_file;
}

/* // THIS SECTION Added for COMMISSION BY RANK - NSC - placed AFTER Giveaway file so all child programs could be set up first for accurate accounting
$cbr_program_id_array = array(9,10);

if (in_array($program_id,$cbr_program_id_array)) { // QQQ NSC Commission
	include './commission_by_rank.inc.php'; // this awards commission_by_rank commissions and puts them in the transactions_log_cbr
	cbr_process_sale($payer_id, $expected_amount, $program_id, $cbr_program_id_array ); // Update rank of seller and pay commissions to seller and all eligible uplines
}
*/
if ($_SESSION['debug']) echo "<br />FINISHED FINALIZE FILE!<br />";
?>