<?php
if (IPN_PROCESS !== true) {
	echo '
	//----------------------------------------------------------------------<br />
	//Made by: Sven Arild Helleland 																				<br />
	//Firm: Kaizen Web-Productions (http://www.kaizen-web.com)							<br />
	//Date: 27th September 2007																							<br />
	//Last Modified: 28th September 2007																		<br />
	//Copyright(C), Kaizen Web-Productions, 2004-2007, All Rights Reserved.	<br />
	//----------------------------------------------------------------------<br />
	';
	exit;
	}
	

/**
 * Authorize.net ARB Library
 *  
 * @author Sven Arild Helleland - Kaizen Web-Productions (http://www.kaizen-web.com)
 * @version 0.1
 * @copyright Copyright(C), Kaizen Web-Productions, 2004-2007, All Rights Reserved.
 * @package Authorize.net
 */	

class authorize_arb {
	
	var $merchant_id;
	var $merchant_key;
	var $server_url;
	var $schema_url = 'https://api.authorize.net/xml/v1/schema/AnetApiSchema.xsd';
	var $request;
	var $error = array();
	
	
	/**
	 * Constructor
	 *
	 * @param string $merchant_id		Merchant ID
	 * @param string $merchant_key	Merchant Key
	 * @param bool $test						If this is a test transaction, default false 
	 * @return authorize_arb
	 */
	
	function authorize_arb($merchant_id, $merchant_key, $test=false) {
		
		if ($test === true) $this->server_url = 'https://apitest.authorize.net/xml/v1/request.api';
		else $this->server_url = 'https://api.authorize.net/xml/v1/request.api';
		
		$this->merchant_id = $merchant_id;
		$this->merchant_key = $merchant_key;
		}
	
		
	/**
	 * Process the subscription request
	 *
	 * @param string $reference				Custom reference for the request
	 * @param int $period							How long the subscription periods last, max 365 on days and 12 on months
	 * @param string $start_date			The subscription start date, YYYY-MM-DD
	 * @param float $amount						Amount
	 * @param float $trial_amount			Trial amount
	 * @param string $card_number			Credit card number
	 * @param string $card_expire			Credit card expire date, YYYY-MM
	 * @param array $order_info				Order information, should contain header, id and description
	 * @param array $customer_info		Customer info, should contain firstname, lastname, address, city, state, zip and country
	 * @param string $period_type			How long one subscription period last, days or months
	 * @param int $trial_times				How many times the trial amount should be billed
	 * @param int $subscription_times	How many times the subscription should be billed, 9999 is forever
	 * @return string									The XML answer
	 */
		
	function process_subscription($reference, $period, $start_date, $amount, $trial_amount, $card_number, $card_expire, $order_info, $customer_info, $period_type='days', $trial_times=0, $subscription_times=9999) {
		if (isset($order_info['header']{21})) $order_info['header'] = substr($order_info['header'], 0, 20);
		
		$form = '<?xml version="1.0" encoding="utf-8"?><ARBCreateSubscriptionRequest xmlns="AnetApi/xml/v1/schema/AnetApiSchema.xsd">'.$this->create_authentication().'<refId>'.$reference.'</refId><subscription><name>'.$order_info['header'].'</name><paymentSchedule><interval><length>'.$period.'</length><unit>'.$period_type.'</unit></interval><startDate>'.$start_date.'</startDate><totalOccurrences>'.$subscription_times.'</totalOccurrences>'.(($trial_amount > 0)?'<trialOccurrences>'.$trial_times.'</trialOccurrences>':'').'</paymentSchedule><amount>'.$amount.'</amount>'.(($trial_amount > 0)?'<trialAmount>'.$trial_amount.'</trialAmount>':'').'<payment><creditCard><cardNumber>'.trim($card_number).'</cardNumber><expirationDate>'.$card_expire.'</expirationDate></creditCard></payment><order><invoiceNumber>'.$order_info['id'].'</invoiceNumber><description>'.$order_info['description'].'</description></order><customer><email>'.$customer_info['email'].'</email><phoneNumber>'.$customer_info['phone'].'</phoneNumber></customer><billTo><firstName>'.$customer_info['firstname'].'</firstName><lastName>'.$customer_info['lastname'].'</lastName><address>'.$customer_info['address'].'</address><city>'.$customer_info['city'].'</city>'.((!empty($customer_info['state']))?'<state>'.$customer_info['state'].'</state>':'').'<zip>'.$customer_info['zip'].'</zip><country>'.$customer_info['country'].'</country></billTo></subscription></ARBCreateSubscriptionRequest>';
		
		$this->request = 'ARBCreateSubscriptionResponse';
		
		return $this->transfer_request($this->server_url, $this->create_headers(), $form);
		}
	
		
	/**
	 * Process the subscription cancel request
	 *
	 * @param string $subscription_id	The subscription ID
	 * @param string $reference				The custom reference for the request
	 * @return string									The XML answer
	 */
		
	function create_cancel($subscription_id, $reference) {
		$form = '<?xml version="1.0" encoding="utf-8"?><ARBCancelSubscriptionRequest xmlns="AnetApi/xml/v1/schema/AnetApiSchema.xsd">'.$this->create_authentication().'<refId>'.$reference.'</refId><subscriptionId>'.$subscription_id.'</subscriptionId></ARBCancelSubscriptionRequest>';
		
		$this->request = 'ARBCancelSubscriptionResponse';
		
		return $this->transfer_request($this->server_url, $this->create_headers(), $form);
		}	
		
		
	/**
	 * Create the authentication part of the XML schema
	 *
	 * @return string	XML code
	 */
		
	function create_authentication() {
		$authentication = '<merchantAuthentication><name>'.$this->merchant_id.'</name><transactionKey>'.$this->merchant_key.'</transactionKey></merchantAuthentication>';
		
		return $authentication;
		}
	

	/**
	 * Transfer request
	 * 
	 * Performs the transfer to Authorize.net and validates the response.
	 *
	 * @param string 	$url		The url
	 * @param array 	$header	The headers
	 * @param string 	$data		The xml data
	 * @return bool						Returns the data received
	 */
		
	function transfer_request($url, $header, $data) {
		$handle = curl_init($url);
		
		curl_setopt($handle, CURLOPT_POST, true);
    curl_setopt($handle, CURLOPT_HTTPHEADER, $header);
    curl_setopt($handle, CURLOPT_POSTFIELDS, $data);
    curl_setopt($handle, CURLOPT_HEADER, false);
    curl_setopt($handle, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($handle, CURLOPT_SSL_VERIFYPEER, false);
 
		$response = curl_exec($handle);
		
		if (curl_errno($handle)) $this->error[] = curl_errno($handle).': '.curl_error($handle);
		
		curl_close($handle);

		return $response;
		}	
	
		
	/**
	 * Prepare the request answer
	 *
	 * @param string $data 	The XML reply
	 * @return array 				Returns array with these keys: result_code, message_code, message_text, reference, subscription_id
	 */
		
	function interpret_answer($data) {
		
		$processed = $this->parse_xml($data);
		
		if ($processed !== false && is_array($processed)) {		
			$message_code = array();
			$message_text = array();
			
			if (isset($processed[$this->request]['messages']['message'][0])) {
				$reference = $processed[$this->request]['refId']['value'];
				
				if (!empty($processed[$this->request]['subscriptionId']['value'])) $subscription_id = $processed[$this->request]['subscriptionId']['value'];
				else $subscription_id = false;
				
				$result_code = $processed[$this->request]['messages']['resultCode']['value'];
			
				foreach ($processed[$this->request]['messages']['message'] as $key => $value) {
					$message_code[] = $value['code']['value'];
					$message_text[] = $processed[$this->request]['messages']['message'][$key]['text']['value'];
					}
				}
			elseif (isset($processed[$this->request]['messages']['message'])) { 
				$reference = $processed[$this->request]['refId']['value'];
				
				if (!empty($processed[$this->request]['subscriptionId']['value'])) $subscription_id = $processed[$this->request]['subscriptionId']['value'];
				else $subscription_id = false;
				
				$result_code = $processed[$this->request]['messages']['resultCode']['value'];
				
				$message_code[] = $processed[$this->request]['messages']['message']['code']['value'];
				$message_text[] = $processed[$this->request]['messages']['message']['text']['value'];
				}
			else {
				$reference = null;
				$subscription_id = null;
				$result_code = $processed['ErrorResponse']['messages']['resultCode']['value'];
				
				$message_code[] = $processed['ErrorResponse']['messages']['message']['code']['value'];
				$message_text[] = $processed['ErrorResponse']['messages']['message']['text']['value'];
				}

			return array('result_code' => $result_code, 'message_code' => $message_code, 'message_text' => $message_text, 'reference' => $reference, 'subscription_id' => $subscription_id);
			}
		else {
			return false;
			}
		}	
		
		
	/**
	 * Create HTTP Header's
	 *
	 * @return array Returns the http headers
	 */
		
	function create_headers() {
		$header = array();
		
		$header[] = "Content-Type: application/xml;charset=UTF-8";
		$header[] = "Accept: application/xml;charset=UTF-8";
		$header[] = "User-Agent: Kaizen-Web; Authorize.net ARB Processing (0.1)";
		
		return $header;
		}		
		
		
	/**
	 * Parse XML
	 * 
	 * Uses SAX for best backward compability
	 *
	 * @param string $data	The XML data
	 * @return array|bool		Returns parsed data on success, false on failure
	 */
	
	function parse_xml($data) {
		$handle = xml_parser_create();
		
		xml_parser_set_option($handle, XML_OPTION_CASE_FOLDING, 0);
		
		xml_parse_into_struct($handle, $data, $return, $index);
			
		xml_parser_free($handle);
		
		if (!empty($return)) {
			return $this->parse_xml2array($return);
			}
		else {
			$this->error[] = 'Parse XML Error: No data';
			return false;
			}
		}	
		
		
	/**
	 * Parse the complete XML array into an simpler array
	 *
	 * @param array $data	The complete XML array
	 * @return array			Returns the simpler array
	 */
		
	function parse_xml2array($data) {
		$return_data = array();

		foreach ($data as $value) {
   		$tag = $value['tag'];
   		
      if ($value['type'] == 'open' || $value['type'] == 'complete') {
      	if (!empty($return_data[$tag])) {
        	if (isset($return_data[$tag][0])){
          	$return_data[$tag][] = array(); 
            }
          else {
          	$return_data[$tag] = array($return_data[$tag], array());
            } 
            
          $temp = &$return_data[$tag][(count($return_data[$tag]) - 1)];
          }
        else {
          $temp = &$return_data[$tag];
          }
				
        if ($value['type'] == 'open') $temp = array();

        if (isset($value['attributes'])) { 
        	foreach ($value['attributes'] as $key => $val) {
          	$temp[$key] = $val;
            }
          }
                
       	if ($value['type'] == 'open') {
       	 	$temp['_p'] = &$return_data;
        	$return_data = &$temp;
       		}
       	else {
       		$temp['value'] = (isset($value['value'])?$value['value']:null);
       		}
        } 
    	elseif ($value['type'] == 'close') {
     		$return_data = &$return_data['_p'];
      	}
    	}    
		
    $this->recursive_xml2array_delete($return_data);	
    	
		return $return_data;
		}	

		
	/**
	 * Recursive cleaning the simpler XML array
	 *
	 * @param array $data The simpler XML array
	 */
		
	function recursive_xml2array_delete(&$data) {
		foreach ($data as $key => $value) {
    	if ($key === '_p') {
      	unset($data[$key]);
        }
      else if(is_array($data[$key])) {
      	$this->recursive_xml2array_delete($data[$key]);
        }
      }
		}	
	}
