<?php
include 'logincheck.php';
$pageName = 'Confirm Payment Was Sent';
$pageDesc = '';
$pageIcon = 'icon-money';
$pageAlign = 'center';
$pageClass = '';
$paychain = true;

//$GLOBALS['debug'] = true;

$program_id = $_GET['program'];
$upid = $_SESSION['p'.$program_id.'_upid'];	
//echo $upid; //exit;

//Check if the payment can be marked as paid and if it belong to the member...
// Sanitize the $_GET['uid'] to prevent SQL injection
$uid = isset($_GET['uid']) ? (int) $_GET['uid'] : 0;

$pp_id = $uid;
//$uid = 55; // TESTING

// Define the selection fields
$selectFields = 'plan.username AS receiver, plan.noted_as_paid, memb.Username, memb.First_Name, memb.Last_Name, memb.email';

// Define the main table for the query
//$mainTable = 'payment_plan as plan';
$mainTable = ['table' => 'payment_plan', 'as' => 'plan'];

// Define join conditions
$joinConditions = [
    ['table' => 'user_payment_plan', 'as' => 'master', 'condition' => 'plan.user_payment_plan_id = master.user_payment_plan_id'],
    ['table' => 'user_program', 'as' => 'user', 'condition' => 'master.user_program_id = user.user_program_id'],
    ['table' => 'members', 'as' => 'memb', 'condition' => 'user.ID = memb.ID']
];


// Define where conditions, including the dynamic condition based on $_GET['uid']
$where = [
    'plan.payment_plan_id' => ['=', $uid]
];

// Since your original query does not have groupBy, having, orderBy, and limit explicitly set, we'll keep those parameters null or 0 as placeholders
$result = select($selectFields, $mainTable, $joinConditions, $where, null, null, null, 0, 1);

$buffer = $result ? reset($result) : null;	
//print_r($buffer); exit;
	
if ($buffer['noted_as_paid'] != 'N' || $buffer['Username'] != $_SESSION['loggedin']) {
	header("Location: pay.php");
	exit;	
}
	
$Error_msg = array();	
$Success_msg = false;


	
if (!empty($_POST['submit'])) {
	// USING BITCOIN - NO COURIER NEEDED!
	if (empty($_POST['courier'])) $_POST['courier'] = 'N/A';
	if (empty($_POST['date'])) $Error_msg[] = 'Please fill out the date.';
	if (empty($_POST['courier'])) $Error_msg[] = 'Please fill out the courier/processor information.';
	if (empty($_POST['tracking'])) $Error_msg[] = 'Please fil out the tracking information.';
	
	if (empty($Error_msg)) {

		// Sanitize input values using the PHPCPR sanitize function if not already done automatically
		$uid = isset($_GET['uid']) ? (int) $_GET['uid'] : 0;
		$date = isset($_POST['date']) ? $_POST['date'] : '';
		$courier = isset($_POST['courier']) ? $_POST['courier'] : '';
		$tracking = isset($_POST['tracking']) ? $_POST['tracking'] : '';
		$comments = isset($_POST['comment']) ? $_POST['comment'] : '';
		$timestamp = time();

		// Prepare data for insertion
		$data = [
			'payment_plan_id' => $uid,
			'paid_date' => $date,
			'courier' => $courier,
			'tracking' => $tracking,
			'comments' => $comments,
			'timestamp' => $timestamp
		];

		// Perform insert operation
		insert('mark_payment', $data, 1, 1);

		$data = [
			'noted_as_paid' => 'Y'
		];
		$where = [
			'payment_plan_id' => ['=', $pp_id]
		];

		// Perform update operation
		update('payment_plan', $data, [], $where, 1, 1, 1);

		
		// ADDED UPDATE SET VALID PLAN 'S' - TO STOP PLANS FROM LATER BEING WIPED OUT, WHEN LINKED PROGRAMS (USES OTOs) 8/19/19
		// TIED DIRECTLY TO THE PAY PLAN ALSO NOW, TO BE 100% CERTAIN WE GET THE CORRECT UPP CONVERTED TO A STARTED PLAN! 3/9/20
		// TESTED WORKS GREAT!
		$data = [
			'valid_plan' => 'S'
		];
		$mainTable = ['table' => 'user_payment_plan', 'as' => 'upp'];
		$joinConditions = [
			[
			'table' => 'payment_plan', 
			'as' => 'pp', 
			'condition' => 'upp.user_payment_plan_id = pp.user_payment_plan_id'
			]
		];
		$where = [
			'pp.payment_plan_id' => ['=', $pp_id],
			'upp.user_program_id' => ['=', $upid],
			'upp.valid_plan' => ['=', 'N']
		];
		update($mainTable, $data, $joinConditions, $where, 1, 1, 1);

		// Define the selection fields
		$selectFields = 'email, First_Name, Last_Name';

		// Define the main table for the query
		$mainTable = 'members';

		// Define where conditions
		$where = [
			'Username' => ['=', $buffer['receiver']]
		];

		// Perform select operation
		$result2 = select($selectFields, $mainTable, [], $where, null, null, null, 0, 1);

		$buffer2 = $result2[0] ?? null;


		// Define the selection fields
		$selectFields = 'program_name';

		// Define the main table for the query
		$mainTable = 'program';

		// Define where conditions
		$where = [
			'program_id' => ['=', $_SESSION['program']]
		];

		// Perform select operation
		$result3 = select($selectFields, $mainTable, [], $where, null, null, null, 0, 1);

		$buffer3 = $result3[0] ?? null;
		
		
		$subject_replace = array('[program_name]', '[firstname]', '[lastname]');	

		$subject_replace_with = array($buffer3['program_name'], $buffer2['First_Name'], $buffer2['Last_Name']);
		
		$message_replace = array('[program_name]', '[dearfirstname]', '[firstname]', '[lastname]', '[paid_from_username]', '[email]', '[paid_date]', '[paid_courier]', '[paid_tracking]', '[paid_comment]');

		$message_replace_with = array($buffer3['program_name'], $buffer2['First_Name'], $buffer['First_Name'], $buffer['Last_Name'], $buffer['Username'],  $buffer['email'], $_POST['date'], $_POST['courier'], $_POST['tracking'], $_POST['comment']);

		$subject = str_replace($subject_replace, $subject_replace_with, $Global['email_mark_payment_subject']);

		$message = str_replace($message_replace, $message_replace_with, $Global['email_mark_payment_message']);	
		
		//echo $buffer2['email'] . $subject . $message . $Global['admin_email_heading'] . $Global['admin_email']; exit;

		mail($buffer2['email'], $subject, $message, "From: {$Global['admin_email_heading']} <{$Global['admin_email']}>\r\n");
		
		/*if ($Global['admin_receive_mark_payment'] === true) {
			mail($Global['admin_email_mark_payment'] , $subject, $message, "From: {$Global['admin_email_heading']} <{$Global['admin_email']}>\r\n");
			}*/
			
		$Success_msg = true;
		
		//$to  = '2073218774@txt.att.net';
		$to = '5743495401@vtext.com'; // JEREMY DUNCAN // VERIZON
		$subject = 'Money Alert!';
		$message = $_POST['tracking'].' '.$_POST['comment'].' user: '.$_SESSION['loggedin'];
		$header = "From: site ".$Global['webpage_name']."\r\n";
		$header .= "MIME-VERSION: 1.0\r\n";
		$header .= 'Content-type: text/html; charset=iso-8859-1' . "\r\n";
		$phpversion = phpversion();
		$header .= "X-Mailer: PHP v$phpversion\r\n";
		// SEND SMS TEXT ALERT TO ADMIN - THIS IS FOR WHEN ADMIN COLLECTS ALL
		//mail($to, $subject, $message, "From: {$Global['admin_email_heading']} <{$Global['admin_email']}>\r\n");

		// SEND SMS TEXT ALERT TO ADMIN - ONLY IF THE ALERT IS DESIGNATED FOR ADMIN
		/*if ($buffer2['email'] == $Global['admin_email'])
		mail($to, $subject, $message, "From: {$Global['admin_email_heading']} <{$Global['admin_email']}>\r\n");	*/
		
		unset($_POST);		
		}
	}
	
include './../Sub/tpl/header_tpl.php';

if ($Success_msg === true) {
	$_SESSION['Returning'] = true;
	echo '<h2><span style="color:#F00;">The payment has successfully been marked as sent. Thank you!</h2></span><br />
	<a href="../Members/index.php">Click here to access your back office</a><br /><br /> <br /><br /><br /><br /><br />';
	include './../Sub/tpl/footer_tpl.php';	
	exit;
}
?>
         <div class="col-md-6" style="float: none; margin: 0 auto;">
<form method="post" action="markpayment.php?uid=<?php echo htmlspecialchars($_GET['uid']); ?>&program=<?php echo htmlspecialchars($program_id); ?>">

            <div class="text-center mb-4">
                <h2>Mark Your Payment Sent</h2>
                <?php if (!empty($Error_msg)): ?>
                    <div class="alert alert-danger" role="alert">
                        <?php foreach ($Error_msg as $key => $value): ?>
                            Error <?php echo $key + 1; ?>: <?php echo htmlspecialchars($value); ?><br />
                        <?php endforeach; ?>
                    </div>
                <?php endif; ?>
            </div>
            <div class="form-group">
                <label for="date">Date:</label>
                <input type="text" class="form-control" id="date" name="date" value="<?php echo (!empty($_POST['date'])) ? htmlspecialchars($_POST['date'], ENT_QUOTES, 'UTF-8') : ''; ?>" placeholder="The date the payment was sent" required>
            </div>
            <!-- Example of commented out section for Courier
            <div class="form-group">
                <label for="courier">Courier:</label>
                <input type="text" class="form-control" id="courier" name="courier" value="<?php // echo (!empty($_POST['courier'])) ? htmlspecialchars($_POST['courier'], ENT_QUOTES, 'UTF-8') : ''; ?>" placeholder="Name of the courier or payment processor used." required>
            </div>
            -->
            <div class="form-group">
                <label for="tracking">Tracking:</label>
                <input type="text" class="form-control" id="tracking" name="tracking" value="<?php echo (!empty($_POST['tracking'])) ? htmlspecialchars($_POST['tracking'], ENT_QUOTES, 'UTF-8') : ''; ?>" placeholder="Transaction ID, If Applicable" required>
            </div>
            <div class="form-group">
                <label for="comment">Comment:</label>
                <textarea class="form-control" id="comment" name="comment" rows="7" placeholder="List the payment method you used, e.g. CashApp Cashtag, Bitcoin, ADA, etc." required><?php echo (!empty($_POST['comment'])) ? htmlspecialchars($_POST['comment'], ENT_QUOTES, 'UTF-8') : ''; ?></textarea>
            </div>
            <div class="form-group text-center">
                <input type="submit" class="btn btn-success" name="submit" value="Submit">
            </div>

</form>
        </div>
<?php	
include './../Sub/tpl/footer_tpl.php';	
?>