<?php
//---------------------------------------------------------------
//Made by: Sven Arild Helleland 
//Firm: Kaizen Web-Productions (http://www.kaizen-web.com)
//Date: 5th July 2006
//Last Modified: 14th January 2007
//----------------------------------------------------------------
function admin_collects($plan, $receiver=1) {
  global $Global;
  
  $new_plan = array();
  
  $plan_id = null;
  $sub_plan_id = null;
  $amount = 0;
  $sub_amount = 0;
  
  $last_paid = null;
  $sub_last_paid = null;
  $processor = null;
  $sub_processor = null;
  $grace_id = null;
  $sub_grace_id = null;
  $grace_status = null;
  $sub_grace_status = null;
  $grace_reason = null;
  $sub_grace_reason = null;
  $grace_pre_reason = null;
  $sub_grace_pre_reason = null;
  $grace_end = null;
  $sub_grace_end = null; 
  
  foreach ($plan as $value) {
    if ($value['plan_type'] == 'S') {
      $sub_plan_id = $value['id'];
    
      $sub_amount += $value['amount'];
      
      if (!empty($value['last_paid_date']) && (empty($sub_last_paid) || $sub_last_paid < $value['last_paid_date'])) {
        $sub_last_paid = $value['last_paid_date'];
        $sub_processor = (!empty($value['paid_processor']))?$value['paid_processor']:null;
        }
        
      if (!empty($value['grace_status']) && $value['grace_status'] == 'Y') {
        $sub_grace_id = $value['id'];
          
        $sub_grace_status = $value['grace_status'];
        $sub_grace_reason = $value['grace_reason_'];
        $sub_grace_pre_reason = $value['grace_pre_reason'];
        $sub_grace_end = $value['grace_end'];
        }
      }
    elseif ($value['plan_type'] == 'N') {
      $plan_id = $value['id'];
    
      $amount += $value['amount'];
      
      if (!empty($value['last_paid_date']) && (empty($last_paid) || $last_paid < $value['last_paid_date'])) {
        $last_paid = $value['last_paid_date'];
        $processor = (!empty($value['paid_processor']))?$value['paid_processor']:null;
        }
        
      if (!empty($value['grace_status']) && $value['grace_status'] == 'Y') {
        $grace_id = $value['id'];
          
        $grace_status = $value['grace_status'];
        $grace_reason = $value['grace_reason_'];
        $grace_pre_reason = $value['grace_pre_reason'];
        $grace_end = $value['grace_end'];
        }
      }
    }
  
  //Find the user info
	// Prepare select fields and conditions
	$selectFields = ['Username'];
	$mainTable = ['members'];
	$where = [
		'ID' => ['=', $receiver]
	];

	// Use PHPCPR's select function
	$result = select($selectFields, $mainTable, [], $where, null, null, null, 0, 1);

	// Fetching the result
	$buffer = isset($result[0]) ? $result[0] : null;
  
  if (!empty($plan_id)) {
    $new_plan[] = array('id' => $plan_id, 'username' => $buffer['Username'], 'status' => $Global['comped_status'], 'amount' => $amount,
               'type' => 'A', 'plan_type' => 'N', 'tier' => 0, 'last_paid_date' => $last_paid, 'paid_processor' => $processor,
               'plan_divided' => 'N', 'grace_status' => $grace_status, 'grace_reason_' => $grace_reason, 'grace_pre_reason' => $grace_pre_reason, 
 							 'grace_end' => $grace_end, 'collected_by' => 'admin');
    }
  
  if (!empty($sub_plan_id)) {
    $new_plan[] = array('id' => $sub_plan_id, 'username' => $buffer['Username'], 'status' => $Global['comped_status'], 'amount' => $sub_amount,
               'type' => 'A', 'plan_type' => 'S', 'tier' => 0, 'last_paid_date' => $sub_last_paid, 'paid_processor' => $sub_processor,
               'plan_divided' => 'N', 'grace_status' => $sub_grace_status, 'grace_reason_' => $sub_grace_reason, 
               'grace_pre_reason' => $sub_grace_pre_reason, 'grace_end' => $sub_grace_end, 'collected_by' => 'admin');
    }
  return $new_plan;
  }
function admin_collects_tiers($plan, $receiver=1) {
  global $Global;
  
  $new_plan = array();
  
  $plan_id = null;
  $sub_plan_id = null;
  $amount = 0;
  $sub_amount = 0;
  
  $last_paid = null;
  $sub_last_paid = null;
  $processor = null;
  $sub_processor = null;
  $grace_id = null;
  $sub_grace_id = null;
  $grace_status = null;
  $sub_grace_status = null;
  $grace_reason = null;
  $sub_grace_reason = null;
  $grace_pre_reason = null;
  $sub_grace_pre_reason = null;
  $grace_end = null;
  $sub_grace_end = null; 
  
  foreach ($plan as $value) {
   if (substr($value['type'],0,1) == 'T' || strtolower($value['username']) == "admin") {
    if ($value['plan_type'] == 'S') {
      $sub_plan_id = $value['id'];
    
      $sub_amount += $value['amount'];
      
      if (!empty($value['last_paid_date']) && (empty($sub_last_paid) || $sub_last_paid < $value['last_paid_date'])) {
        $sub_last_paid = $value['last_paid_date'];
        $sub_processor = (!empty($value['paid_processor']))?$value['paid_processor']:null;
        }
        
      if (!empty($value['grace_status']) && $value['grace_status'] == 'Y') {
        $sub_grace_id = $value['id'];
          
        $sub_grace_status = $value['grace_status'];
        $sub_grace_reason = $value['grace_reason_'];
        $sub_grace_pre_reason = $value['grace_pre_reason'];
        $sub_grace_end = $value['grace_end'];
        }
      }
    elseif ($value['plan_type'] == 'N') {
      $plan_id = $value['id'];
    
      $amount += $value['amount'];
      
      if (!empty($value['last_paid_date']) && (empty($last_paid) || $last_paid < $value['last_paid_date'])) {
        $last_paid = $value['last_paid_date'];
        $processor = (!empty($value['paid_processor']))?$value['paid_processor']:null;
        }
        
      if (!empty($value['grace_status']) && $value['grace_status'] == 'Y') {
        $grace_id = $value['id'];
          
        $grace_status = $value['grace_status'];
        $grace_reason = $value['grace_reason_'];
        $grace_pre_reason = $value['grace_pre_reason'];
        $grace_end = $value['grace_end'];
        }
      } 
	  
     } else { // else if not Tier payment, do not change
	 	$new_plan_unchanged[] = array('id' => $value['id'], 'username' => $value['username'], 'status' => $Global['comped_status'], 'amount' => $value['amount'], 'type' => $value['type'], 'plan_type' =>  $value['plan_type'], 'tier' => 0, 'last_paid_date' => $value['last_paid_date'], 'paid_processor' => $value['paid_processor'], 'plan_divided' => $value['plan_divided'], 'grace_status' => $value['grace_status'], 'grace_reason_' => $value['grace_reason'], 'grace_pre_reason' => $value['grace_pre_reason'], 'grace_end' => $value['grace_end']);
    }
    } // end of for loop
  
  //Find the user info
  // Prepare select fields and conditions
	$selectFields = ['Username'];
	$mainTable = ['members'];
	$where = [
		'ID' => ['=', $receiver]
	];

	// Use PHPCPR's select function
	$result = select($selectFields, $mainTable, [], $where, null, null, null, 0, 1);

	// Fetching the result
	$buffer = isset($result[0]) ? $result[0] : null;
  
  
  if (!empty($plan_id)) {
    $new_plan[] = array('id' => $plan_id, 'username' => $buffer['Username'], 'status' => $Global['comped_status'], 'amount' => $amount,
               'type' => 'A', 'plan_type' => 'N', 'tier' => 0, 'last_paid_date' => $last_paid, 'paid_processor' => $processor,
               'plan_divided' => 'N', 'grace_status' => $grace_status, 'grace_reason_' => $grace_reason, 'grace_pre_reason' => $grace_pre_reason, 
 							 'grace_end' => $grace_end);
    }
  
  if (!empty($sub_plan_id)) {
    $new_plan[] = array('id' => $sub_plan_id, 'username' => $buffer['Username'], 'status' => $Global['comped_status'], 'amount' => $sub_amount,
               'type' => 'A', 'plan_type' => 'S', 'tier' => 0, 'last_paid_date' => $sub_last_paid, 'paid_processor' => $sub_processor,
               'plan_divided' => 'N', 'grace_status' => $sub_grace_status, 'grace_reason_' => $sub_grace_reason, 
               'grace_pre_reason' => $sub_grace_pre_reason, 'grace_end' => $sub_grace_end);
    }
	if (!empty($new_plan_unchanged)) {
		for ($i=0; $i<count($new_plan_unchanged); $i++) {
			$new_plan[] = $new_plan_unchanged[$i];
		}
	}
  return $new_plan;
  }
function admin_collects_single($payment_plan, $receiver=1) {
  global $Global;
  
  //First collect all of the plans
	// Prepare select fields and conditions for the first query
	$selectFields = ['user_payment_plan_id', 'plan_type'];
	$mainTable = ['payment_plan'];
	$where = [
		'payment_plan_id' => ['=', $payment_plan]
	];

	// Use PHPCPR's select function for the first query
	$result = select($selectFields, $mainTable, [], $where, null, null, null, 0, 1);
	// Fetching the result for the first query
	$buffer = isset($result[0]) ? $result[0] : null;

	// Prepare for the second query if the first query was successful
	$plan = array();
	if ($buffer) {
		// Prepare select fields and conditions for the second query
		$selectFields = '*'; // Select all fields
		$where = [
			'user_payment_plan_id' => ['=', $buffer['user_payment_plan_id']],
			'plan_type' => ['=', $buffer['plan_type']]
			// Uncomment the following line if needed based on your logic
			// 'payment_complete' => ['!=', 'Y']
		];
		$orderBy = ['payment_plan_id' => 'ASC'];

		// Use PHPCPR's select function for the second query
		$result = select($selectFields, $mainTable, [], $where, null, null, $orderBy, 0, 1);

		// Fetching the results for the second query
		foreach ($result as $buffer) {
			$plan[] = $buffer;
		
			// ADDED TRUE OR, AS IT WAS NOT RECOGNIZING PAID PLANS, FOR CREATING SUBSEQUENT NEW PAYMENTS, AS NEEDED
		if (true || $buffer['plan_type'] == 'S' || $buffer['payment_complete'] == 'N') {
  		$payment_type = program_type($buffer['payment_type'], $buffer['payment_tier_level'], $Global['admin_amount'][$Global['payment_duration']], true);
		
		// Prepare select fields and conditions for the query
		$selectFields = ['payment_processor'];
		$mainTable = ['payment_log'];
		$where = [
			'payment_plan_id' => ['=', $buffer['payment_plan_id']]
		];
		$orderBy = 'payment_log_id DESC';
		$limit = 1;

		// Use PHPCPR's select function
		$result_history = select($selectFields, $mainTable, [], $where, null, null, $orderBy, $limit, 1);

		// Fetching the result
		$buffer_history = isset($result_history[0]) ? $result_history[0] : null;		
  				
  		$plan[] = array('id' => $buffer['payment_plan_id'], 'username' => $buffer['username'], 'status' => $buffer['user_status'], 'tier' => $buffer['payment_tier_level'], 'amount' => $buffer['amount'], 'last_paid_date' => $buffer['last_paid_date'], 'paid_processor' => $buffer_history['payment_processor'], 'type' => $payment_type, 'plan_type' => $buffer['plan_type'], 'grace_status' => $buffer['grace_enabled'], 'grace_reason_' => $buffer['grace_reason'], 'grace_pre_reason' => $buffer['grace_pre_reason'], 'grace_end' => $buffer['grace_end_date'], 'plan_divided' => $buffer['plan_divided']);
		}
		}
	}
	//Then process them
	$new_plan = admin_collects($plan, $receiver);
	
  return array('amount' => $new_plan[0]['amount'], 'last_paid_date' => $new_plan[0]['last_paid_date'], 'grace_status' => $new_plan[0]['grace_status'], 
  						 'grace_pre_reason' => $new_plan[0]['grace_pre_reason'], 'grace_end' => $new_plan[0]['grace_end'], 'payment_type' => 'A',
               'payment_tier_level' => 0, 'plan_type' => $new_plan[0]['plan_type']);
}
function admin_collects_single_tiers($payment_plan, $receiver=1) {
  global $Global;
  
  //First collect all of the plans
	// Prepare select fields and conditions for the first query
	$selectFields = ['user_payment_plan_id', 'plan_type'];
	$mainTable = ['payment_plan'];
	$where = [
		'payment_plan_id' => ['=', $payment_plan]
	];

	// Use PHPCPR's select function for the first query
	$result = select($selectFields, $mainTable, [], $where, null, null, null, 0, 1);
	// Fetching the result for the first query
	$buffer = isset($result[0]) ? $result[0] : null;

	// Prepare for the second query if the first query was successful
	$plan = array();
	if ($buffer) {
		// Prepare select fields and conditions for the second query
		$selectFields = '*'; // Select all fields
		$where = [
			'user_payment_plan_id' => ['=', $buffer['user_payment_plan_id']],
			'plan_type' => ['=', $buffer['plan_type']]
			// Uncomment the following line if needed based on your logic
			// 'payment_complete' => ['!=', 'Y']
		];
		$orderBy = 'payment_plan_id ASC';

		// Use PHPCPR's select function for the second query
		$result = select($selectFields, $mainTable, [], $where, null, null, $orderBy, 0, 1);

		// Fetching the results for the second query
		foreach ($result as $buffer) {  

		if ($buffer['plan_type'] == 'S' || $buffer['payment_complete'] == 'N') {
  		$payment_type = program_type($buffer['payment_type'], $buffer['payment_tier_level'], $Global['admin_amount'][$Global['payment_duration']], true);
  			
		// Prepare select fields and conditions for the query
		$selectFields = ['payment_processor'];
		$mainTable = ['payment_log'];
		$where = [
			'payment_plan_id' => ['=', $buffer['payment_plan_id']]
		];
		$orderBy = 'payment_log_id DESC';
		$limit = 1;

		// Use PHPCPR's select function
		$result_history = select($selectFields, $mainTable, [], $where, null, null, $orderBy, $limit, 1);

		// Fetching the result
		$buffer_history = isset($result_history[0]) ? $result_history[0] : null;		
  				
  		$plan[] = array('id' => $buffer['payment_plan_id'], 'username' => $buffer['username'], 'status' => $buffer['user_status'], 'tier' => $buffer['payment_tier_level'], 'amount' => $buffer['amount'], 'last_paid_date' => $buffer['last_paid_date'], 'paid_processor' => $buffer_history['payment_processor'], 'type' => $payment_type, 'plan_type' => $buffer['plan_type'], 'grace_status' => $buffer['grace_enabled'], 'grace_reason_' => $buffer['grace_reason'], 'grace_pre_reason' => $buffer['grace_pre_reason'], 'grace_end' => $buffer['grace_end_date'], 'plan_divided' => $buffer['plan_divided']);
		  }
		}
  
	//Then process them
	$new_plan = admin_collects_tiers($plan, $receiver);
	
  return array('amount' => $new_plan[0]['amount'], 'last_paid_date' => $new_plan[0]['last_paid_date'], 'grace_status' => $new_plan[0]['grace_status'], 
  						 'grace_pre_reason' => $new_plan[0]['grace_pre_reason'], 'grace_end' => $new_plan[0]['grace_end'], 'payment_type' => 'A',
               'payment_tier_level' => 0, 'plan_type' => $new_plan[0]['plan_type']);
  }
}  
?>