<?php
//-----------------------------------------------------------------
// Software: Automatic Web Software (AWS) built with PHPCPR
// Firm: DirectSalesMLM.com / AutomaticWebSoftware.com / PHPCPR.com
// Author: Jim Symonds Email: jim@directsalesmlm.com
// Copyright 2006 - 2024 Jim Symonds All Rights Reserved.
//-----------------------------------------------------------------
// CREATED FROM index.php
// FOR REBILLING VIA CRON ONLY!

set_time_limit(0); // Make sure it will not expire before it's complete
//$GLOBALS['use_sandbox'] = true; // ONLY FOR TESTING IN AUTHNET SANDBOX, WITH OR WITHOUT DEBUGGING TURNED ON - TO TEST END USER EXPERIENCE!
$GLOBALS['use_sandbox'] = false; // THIS WILL MAKE PAYMENTS LIVE!
?>
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
<?php
//$GLOBALS['debug'] = true;
//$GLOBALS['debug'] = false;

if ($payer_username == 'demo') {
	$GLOBALS['use_sandbox'] = true;
	$GLOBALS['debug'] = true;
}

// MAKE SURE NO ONE CAN ACCESS THIS PAGE DIRECTLY!
if (!isset($cron) || $cron != 'CRON') exit;
if (!isset($handshake) || $handshake != 'T') exit;

/*include './../../../Sub/Config.inc.php';
$GLOBALS['debug'] = true;
include $Global['path'].'phpcpr.php';
*/
if ($GLOBALS['debug'] == true) {
	ini_set('display_errors', 1);
	ini_set('display_startup_errors', 1);
	error_reporting(E_ALL);
}
//echo $GLOBALS['path'];


$ID = $payer_id;

echo debug_stmt('up top', 1);
	
require_once ''.$Global['path'].'apay/pm/AuthorizeNet/autoload.php';


use net\authorize\api\contract\v1 as AnetAPI;
use net\authorize\api\controller as AnetController;

function decrypt($input) {
    // Check if the input is null or an empty string
    if ($input === null || $input === '') {
        return $input;
    }

    global $GLOBALS;
    $key = $GLOBALS['member_taxid_algorythm_key'];    
    $method = 'AES-256-CBC';
    $data = base64_decode($input);
    $ivLength = openssl_cipher_iv_length($method);
    $iv = substr($data, 0, $ivLength);
    $encryptedData = substr($data, $ivLength);
    return openssl_decrypt($encryptedData, $method, $key, OPENSSL_RAW_DATA, $iv);
}

if ($GLOBALS['use_sandbox'] == true) { // USE JIM'S AUTHNET TEST KEYS IN SANDBOX

	// TEST KEYS FOR USE IN SANDBOX
	define("MERCHANT_LOGIN_ID", "63YPu6bW");
	define("MERCHANT_TRANSACTION_KEY", "963yjqV3cP8Xc2MM");

} else { // GET ADMIN'S AUTHNET KEYS!

    // PHPCPR 'select' function
    $selectFields = ['*'];
    $mainTable = 'members';
    $where = ['Username' => [['=', 'admin']]];

    $result = select($selectFields, $mainTable, [], $where);
	
	$row = $result[0]; // Assign the first row array to $row
	//print_r($row);

	$authorize_id = $row['paymentprocessor3'];
	$authorize_key = decrypt($row['paymentprocessor4']);
	
	//SET MERCHANT KEYS HERE!
	define("MERCHANT_LOGIN_ID", $authorize_id);
	define("MERCHANT_TRANSACTION_KEY", $authorize_key);
}


use net\authorize\api\contract\v1\OrderType;
use net\authorize\api\contract\v1\ExtendedAmountType;
use net\authorize\api\contract\v1\LineItemType;
use net\authorize\api\contract\v1\TransactionRequestType;

function chargeAWSCustomerProfile($customerProfileId, $customerPaymentProfileId, $amount, $refId = null, $shippingAddress = null, $description = null, $invoiceNumber = null, $tax = null, $freight = null, $duty = null)
{
    $merchantAuthentication = new AnetAPI\MerchantAuthenticationType();
    $merchantAuthentication->setName(MERCHANT_LOGIN_ID);
    $merchantAuthentication->setTransactionKey(MERCHANT_TRANSACTION_KEY);

    // Determine the environment
	if ($GLOBALS['use_sandbox'] == true) {
		$environment = \net\authorize\api\constants\ANetEnvironment::SANDBOX;
	} else {
		$environment = \net\authorize\api\constants\ANetEnvironment::PRODUCTION;
	}


    $profileToCharge = new AnetAPI\CustomerProfilePaymentType();
    $profileToCharge->setCustomerProfileId($customerProfileId);
    $paymentProfile = new AnetAPI\PaymentProfileType();
    $paymentProfile->setPaymentProfileId($customerPaymentProfileId);
    $profileToCharge->setPaymentProfile($paymentProfile);

    $transactionRequestType = new AnetAPI\TransactionRequestType();
    $transactionRequestType->setTransactionType("authCaptureTransaction");
    $transactionRequestType->setAmount($amount);
    $transactionRequestType->setProfile($profileToCharge);

    // Set the order description
    $order = new OrderType();
    $order->setDescription($description);
    $order->setInvoiceNumber($invoiceNumber);
    $transactionRequestType->setOrder($order);

    // Set the shipping address
    if ($shippingAddress !== null) {
        $shipTo = new AnetAPI\CustomerAddressType();
        $shipTo->setFirstName($shippingAddress['firstName']);
        $shipTo->setLastName($shippingAddress['lastName']);
        $shipTo->setCompany($shippingAddress['company']);
        $shipTo->setAddress($shippingAddress['address']);
        $shipTo->setCity($shippingAddress['city']);
        $shipTo->setState($shippingAddress['state']);
        $shipTo->setZip($shippingAddress['zip']);
        $shipTo->setCountry($shippingAddress['country']);
        $transactionRequestType->setShipTo($shipTo);
    }

    // Set tax
    /* // THIS IS A MESS AND CAUSING NOTHING BUT TROUBLE
	$tax = new AnetAPI\ExtendedAmountType();
    $tax->setAmount($tax);
    $tax->setName("tax");

    // Set freight
    $freight = new AnetAPI\ExtendedAmountType();
    $freight->setAmount($freight);
    $freight->setName("freight");

    // Set duty
    $duty = new AnetAPI\ExtendedAmountType();
    $duty->setAmount($duty);
    $duty->setName("duty");

    $transactionRequestType->setTax($tax);
    //$transactionRequestType->setFreight($freight);
    $transactionRequestType->setDuty($duty);*/
	

    $request = new AnetAPI\CreateTransactionRequest();
    $request->setMerchantAuthentication($merchantAuthentication);
    $request->setRefId($refId);
    $request->setTransactionRequest($transactionRequestType);

    $controller = new AnetController\CreateTransactionController($request);
    $response = $controller->executeWithApiResponse($environment);

	if ($response != null) {
		$resultCode = $response->getMessages()->getResultCode();
		
		// For debugging purposes, if you want to see the entire response
		/*if ($GLOBALS['debug'] == true) {
			echo '<pre>';
			print_r($response);
			echo '</pre>';	
		}*/

		if ($resultCode == "Ok") {
			$transactionId = $response->getTransactionResponse()->getTransId();
			echo debug_stmt("Charge Customer Profile SUCCESSFUL CALL ONLY: " . $transactionId, 1);

		} else {
			echo debug_stmt("Charge Customer Profile ERROR: Invalid response", 0);

			$errorMessages = $response->getMessages()->getMessage();
			foreach ($errorMessages as $msg) {
				$errorMsg = "Response: " . $msg->getCode() . "  " . $msg->getText() . "\n";

				// Display and log error messages
				if ($GLOBALS['debug'] == true) echo debug_stmt($errorMsg, 0);
				error_log($errorMsg, 3, __DIR__ . "/error.log"); // log errors
			}

	if (method_exists($response, 'getTransactionResponse')) {
		$transactionErrors = $response->getTransactionResponse();
		if (is_array($transactionErrors) || is_object($transactionErrors)) {
			foreach ($transactionErrors as $error) {
				if (method_exists($error, 'getErrorCode') && method_exists($error, 'getErrorText')) {
					$errorMsg = "Transaction Error: " . $error->getErrorCode() . "  " . $error->getErrorText() . "\n";

					// Display and log error messages
					if ($GLOBALS['debug'] == true) echo debug_stmt($errorMsg, 0);
					else echo $errorMsg;
					error_log($errorMsg, 3, __DIR__ . "/error.log"); // log errors
				}
			}
		}
	}

		}
	} else {
        echo debug_stmt("Charge Customer Profile ERROR: Null response", 0);
    }

	return $response;

} // END chargeAWSCustomerProfile FUNCTION

if ($GLOBALS['debug'] == true) echo "Customer Profile ID: " . $customerProfileId . "<br>";
if ($GLOBALS['debug'] == true) echo "Customer Payment Profile ID: " . $customerPaymentProfileId . "<br>";

$shippingAddress = null;
//$description = null;
$invoiceNumber = null; 
$tax = null;
$freight = null; 
$duty = null;

// For processing a rebill transaction in Authorize.Net, it's generally recommended to use the server IP rather than the user's IP address that was used in the original payment. This is because the rebill or recurring billing transaction is typically initiated by your server as part of an automated process, not directly by the user. Using the server IP aligns with the nature of the transaction being server-initiated.

$Global_userip = $_SERVER['REMOTE_ADDR'];

if ($charge_customer == true) {
	
	echo debug_stmt("Attempting charge to customer profile", 1);
	$response = chargeAWSCustomerProfile($customerProfileId, $customerPaymentProfileId, $amount, $refId, $shippingAddress, $description, $invoiceNumber, $tax, $freight, $duty);
}	

if ($charge_customer == true && $response != null) {
    $resultCode = $response->getMessages()->getResultCode();
	
	$transactionResponse = $response->getTransactionResponse();
/*	A responseCode of "1" indicates a successful transaction.
	A responseCode of "2" indicates a declined transaction.
	A responseCode of "3" indicates an error with the transaction.	*/
	
	$insertData = [
        'user_payment_plan_id' => $user_paymentplan_id,
        'amount' => $amount,
        'email' => $email,
        'firstname' => $firstName,
        'lastname' => $lastName,
        'address' => $address1,
        'address2' => '',  // if applicable, not using in cc form
        'city' => $city,
        'zip' => $zip,
        'state' => $state,
        'country' => $country,
        'phone' => $phone,
        'timestamp' => time(),
        'ip' => $Global_userip,
		'transaction_id' => ($resultCode == "Ok") ? $response->getTransactionResponse()->getTransId() : '',
		'error_code' => ($resultCode != "Ok") ? $response->getMessages()->getMessage()[0]->getCode() : '',
        'error_text' => ($resultCode != "Ok") ? $response->getMessages()->getMessage()[0]->getText() : '',
		'success' => ($resultCode == "Ok" && $transactionResponse->getResponseCode() == "1") ? 'Y' : 'N'
    ];
	

	echo debug_stmt("Inserting Authnet History - return data from gateway", 1);
    $iresult = insert('authorize_history', $insertData, 1, 1);
	if ($iresult) {
		echo debug_stmt("Successfully inserted authnet history.", 1); 
	} else {
		echo debug_stmt("Failed to insert authnet history.", 0); 
	}

	//!!! 11/23/23 Check if the transaction was actually approved. It turns out $resultCode == "Ok" DOES NOT MEAN APPROVED!
	// 11/29/23 HAD TO REMOVE $resultCode == "Ok" FROM THIS COND, AS IT DID NOT SHOW ERRORS TO USER ON DECLINES!
	// SINCE DECLINE IS OK.
    if ($transactionResponse && $transactionResponse->getResponseCode() == "1") {
		// TRANSACTION WAS SUCCESSFUL!
		echo debug_stmt("Successfully charged authnet!", 1); 
		$rebill_successful = true;
		$_SESSION['ordrenr'] = $response->getTransactionResponse()->getTransId();
		$transactionId = $response->getTransactionResponse()->getTransId();
		//echo "Charge Customer Profile SUCCESS: " . $transactionId . "\n";

		define('IPN_PROCESS', true);
		$cron = 'CRON';
		include $GLOBALS['path'].'apay/process_success.php';

		// SEND A TEXT ALERT SMS TO ADMIN OR TECH 
		$to = '5743495401@vtext.com'; // JEREMY DUNCAN // VERIZON
		$subject = 'Payment Alert!';
		$message = $firstName.' '.$lastName.' phone: '.$phone.' user: '.$payer_username.' just paid '.$amount.' for '.$description;		
		$to  = '2073218774@txt.att.net'; // JIM
		//mail($to, $subject, $message, "From: {$GLOBALS['admin_email_heading']} <{$GLOBALS['admin_email']}>\r\n");
    } else { // failed transaction
		echo debug_stmt("Charged Failed!", 0);
        $errorMessages = $response->getMessages()->getMessage();
        $errorCode = $errorMessages[0]->getCode();
        $errorText = $errorMessages[0]->getText();

        echo "Charge ERROR: " . $errorCode . " - " . $errorText . "\n";

		// SEND A TEXT ALERT SMS TO ADMIN OR TECH 
		$to = '5743495401@vtext.com'; // JEREMY DUNCAN // VERIZON
		$subject = 'Payment Failed.';
		$message = $firstName.' '.$lastName.' phone: '.$phone.' user: '.$payer_username.' just tried to pay '.$amount.' for '.$description;		
		$to  = '2073218774@txt.att.net'; // JIM
		//mail($to, $subject, $message, "From: {$GLOBALS['admin_email_heading']} <{$GLOBALS['admin_email']}>\r\n");
    }
} else {
    // Place your code for a null response here
	echo 'Charge ERROR: Null response.<br>';
}
?>
