<?php
// COPYRIGHT JIM SYMONDS 2023, AUTOMATIC WEB SOFTWARE / DIRECTSALESMLM.COM
/*
session_start();
session_destroy();
session_start();
print_r($_SESSION);
*/
if (session_status() == PHP_SESSION_NONE) {
    session_start();
}
//phpinfo(); exit;
//error_reporting(E_ALL);
//ini_set('display_errors', 1);

$GLOBALS['webpage_url'] = 'https://mytrafficpowerline.com/';
$GLOBALS['program_name'] = 'My Traffic Powerline';
$GLOBALS['path'] = '/home/mytraffic/public_html/'; //The server path to the files, has to include ending forward slash

$GLOBALS['db_mode'] = 'mysqli';
//$GLOBALS['db_mode'] = 'pdo';

$db_host = "localhost";
$db_user = "mytraffic_aws";
$db_password = "EEemNot^%@FJd";
$db_name = "mytraffic_aws";
$charset = 'utf8mb4';


//if ($_SESSION['UserID'] < 4) $GLOBALS['debug'] = true;
$GLOBALS['debug'] = false;

mysqli_report(MYSQLI_REPORT_ERROR | MYSQLI_REPORT_STRICT);
$GLOBALS['db_conn'] = mysqli_connect($db_host, $db_user, $db_password, $db_name);

/*
$host = 'localhost';
$db   = 'test_db';
$user = 'test_user';
$pass = 'test_pass';
$charset = 'utf8mb4';

$dsn = "mysql:host=$host;dbname=$db;charset=$charset";
$opt = [
    PDO::ATTR_ERRMODE            => PDO::ERRMODE_EXCEPTION,
    PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC,
    PDO::ATTR_EMULATE_PREPARES   => false,
];
$pdo = new PDO($dsn, $user, $pass, $opt);

$stmt = $pdo->query('SELECT * FROM users');
while ($row = $stmt->fetch()) {
    echo $row['name'] . "\n";
}
*/




//HTML Entities: When outputting data that was input by the user, you should use functions like htmlspecialchars() or htmlentities(). This will convert special characters to their HTML entities, which prevents cross-site scripting (XSS) attacks by ensuring that user input is displayed as data, not code.


// Force PHP to report all errors
error_reporting(E_ALL); // Leave alone - will log all errors to error.log!
if ($GLOBALS['debug'] === true) ini_set('display_errors', 1); // 1 means "on"
else ini_set('display_errors', 0); // 0 means "off"

// Custom error handling function
function customError($errno, $errstr, $errfile, $errline) {
	$logFile = fopen(__DIR__ . "/error.log", "a");
	$error_message = "[" . date("Y-m-d H:i:s") . "] Error: [$errno] $errstr - $errfile:$errline" . PHP_EOL;
	fwrite($logFile, $error_message);
	fclose($logFile);
}

// Set the error handler
set_error_handler("customError");

// Register shutdown function to catch fatal errors
register_shutdown_function(function() {
	$last_error = error_get_last();
	if ($last_error && $last_error['type'] === E_ERROR) {
		// fatal error has occurred
		customError($last_error['type'], $last_error['message'], $last_error['file'], $last_error['line']);
	}
});

//echo 10 / 0;  // This will generate a warning

// Helper Functions
//include_once 'helper_functions.php';


function create_vars($input) {
    if (is_array($input)) {
        // Input is an array: create multiple variables
        foreach ($input as $key => $value) {
            $GLOBALS[$key] = $value;
        }
        return array_keys($input);  // Return the names of the variables created
    } else if (is_string($input)) {
        // Input is a string: create a single variable
        $GLOBALS[$input] = $input;  // Create a global variable with the name passed
        return $input; // Return the name of the variable created		
    }
}

function show_array($array) {
	if ($GLOBALS['debug'] !== true) return null;
    foreach ($array as $key => $value) {
        echo "<br><b>{$key}</b>: ";
        if (is_array($value)) {
            echo implode(', ', $value);
        } else {
            echo $value;
        }
        //echo "<br>";
        echo "&nbsp;";		
    }
}

function show_vars($vars) {
    if ($GLOBALS['debug'] !== true) return null;
    if (is_array($vars)) {
        // It's an array, iterate over it
        foreach ($vars as $var_name) {
            if (isset($GLOBALS[$var_name])) {
                // Put a line break before printing the first variable of each row
                if ($var_name === reset($vars)) echo "<br>";
                echo "&nbsp;{$var_name}: ";
                if (is_array($GLOBALS[$var_name])) {
                    echo implode(', ', $GLOBALS[$var_name]);
                } else {
                    echo $GLOBALS[$var_name];
                }
            }
        }
    } else if (is_string($vars)) {
        // It's a string, just print it directly
        echo "<br>{$vars}: " . $GLOBALS[$vars];
    }
}

function debug_stmt($debug_statement) {
	if ($GLOBALS['debug'] !== true) return null;
	$display = $debug_statement;
	return $display;	
}

/*function debugQuery($query, $values) {
	if ($GLOBALS['debug'] !== true) return null;
    $debugQuery = $query;
    foreach ($values as $value) {
        // This will replace the first occurrence of '?'
        $debugQuery = preg_replace('/\?/', "'" . $value . "'", $debugQuery, 1);
    }
    return $debugQuery;
}*/

function debugQuery($query, $values) {
    $debugQuery = $query;
    foreach ($values as $value) {
        // This will replace the first occurrence of '?'
        $debugQuery = preg_replace('/\?/', "'" . $value . "'", $debugQuery, 1);
    }
    return $debugQuery;
}



// Function to sanitize the input values
function sanitize($data) { // Only use this for user input!
    if (is_array($data)) {
        // Recursive sanitization if the input is an array
        return array_map('sanitize', $data);
    } else {
        // Sanitizing the data with htmlspecialchars
        $sanitizedValue = htmlspecialchars($data, ENT_QUOTES, 'UTF-8');

        // Return the sanitized value
        return $sanitizedValue;
    }
}


function validate_table_name($table) {
	//  checks if the table name only contains alphanumeric characters and underscores, the only characters allowed in MySQL table names.
    return preg_match('/^[a-zA-Z0-9_]+$/', $table);
}

function get_placeholder_type($value) {
    switch (gettype($value)) {
        case 'string': return 's';
        case 'integer': return 'i';
        case 'double': return 'd';
        default: return 'b';
    }
}


function select($table, $selectFields, $where = [], $limit = 1, $debug = 0) {
	
	if ($GLOBALS['debug'] === true && $debug == 1) $show_debug = 1;
	else $show_debug = 0;

    if (!validate_table_name($table)) {
		if ($show_debug == 1) echo debug_stmt('Failed table validation!');
        return false;
    }

    $fields = '*';
    if (is_array($selectFields)) {
        $fields = implode(',', $selectFields);
    }

    $whereClauses = [];
    $whereTypes = '';
    $whereValues = [];

    foreach ($where as $condition) {
        $field = $condition[0];
        $operator = $condition[1];
        $value = $condition[2];

        $whereClauses[] = "{$field} {$operator} ?";
        //$whereValues[] = &$value;
        $whereValues[] = $value;
        $show_whereValues[] = &$value;		
        $whereTypes .= get_placeholder_type($value);
    }

    $whereClause = implode(' AND ', $whereClauses);
    $query = "SELECT {$fields} FROM {$table} WHERE {$whereClause} LIMIT {$limit}";

    // Print SQL query for debugging
    if ($show_debug == 1) { 
		$debug_qry = "<br>DEBUG QRY: " . debugQuery($query, $show_whereValues) . "<br><br>";
		echo debug_stmt($debug_qry);
    }
	
    $stmt = mysqli_prepare($GLOBALS['db_conn'], $query);
    if ($stmt === false && $show_debug == 1) {
		die('Error preparing statement: ' . mysqli_error($GLOBALS['db_conn']));
    } else if ($stmt === false) {
		die;
	}	

    //call_user_func_array('mysqli_stmt_bind_param', array_merge([$stmt, $whereTypes], $whereValues));
    if (!mysqli_stmt_bind_param($stmt, $whereTypes, ...$whereValues)) {
        if ($show_debug == 1) die('Error binding parameters: ' . mysqli_error($GLOBALS['db_conn']));
        else die;
    }	
	

	$execute = mysqli_stmt_execute($stmt);
	
    if ($execute === false && $show_debug == 1) {
		die('Error executing statement: ' . mysqli_error($GLOBALS['db_conn']));
	} else if ($execute === false) {
		die;		
    } else if ($show_debug == 1) { 
        echo debug_stmt('Select table success!');
    }
	
    $result = mysqli_stmt_get_result($stmt);

    // Check if only one row is expected
    if ($limit == 1) {
        $row = mysqli_fetch_assoc($result);
        $vars_array = [];
        if ($row !== null) {
            foreach ($selectFields as $field) {
                if (array_key_exists($field, $row)) {
                    $vars_array[$field] = $row[$field];
                }
            }
        }
    } else {
        $vars_array = [];
        while ($row = mysqli_fetch_assoc($result)) {
            $temp_array = [];
            foreach ($selectFields as $field) {
                if (array_key_exists($field, $row)) {
                    $temp_array[$field] = $row[$field];
                }
            }
            $vars_array[] = $temp_array;
        }
    }

    mysqli_free_result($result);
    mysqli_stmt_close($stmt);

    return $vars_array;
}




function update($table, $data, $where, $debug = 0) {
	
	if ($GLOBALS['debug'] === true && $debug == 1) $show_debug = 1;
	else $show_debug = 0;

	if (!validate_table_name($table)) {
		if ($show_debug == 1) echo debug_stmt('Failed table validation!');
		return false;
	}	
	
    $fields = array_keys($data);
    $values = array_values($data);

    $setClauses = [];
    $setTypes = '';
    $setValues = [];

    foreach ($data as $field => $value) {
        $setClauses[] = "{$field} = ?";
        $setValues[] = $value;
		$setTypes .= get_placeholder_type($value);
    }

    $whereClauses = [];
    $whereTypes = '';
    $whereValues = [];

    foreach ($where as $field => $value) {
        $whereClauses[] = "{$field} = ?";
        $whereValues[] = $value;
		$setTypes .= get_placeholder_type($value);
    }

    $setQuery = implode(', ', $setClauses);
    $whereQuery = implode(' AND ', $whereClauses);

    $query = "UPDATE {$table} SET {$setQuery} WHERE {$whereQuery}";

    // Print SQL query for debugging
    if ($show_debug == 1) {
		$debug_qry = "<br>DEBUG QRY: " . debugQuery($query, array_merge($setValues, $whereValues)) . "<br><br>";
		echo debug_stmt($debug_qry);
	}	

    $stmt = mysqli_prepare($GLOBALS['db_conn'], $query);
    if ($stmt === false && $show_debug == 1) {
		die('Error preparing statement: ' . mysqli_error($GLOBALS['db_conn']));
    } else if ($stmt === false) {
		die;
    }    

    mysqli_stmt_bind_param($stmt, $setTypes . $whereTypes, ...array_merge($setValues, $whereValues));
    
    $execute = mysqli_stmt_execute($stmt);
    
    if ($execute === false && $show_debug == 1) {
		die('Error executing statement: ' . mysqli_error($GLOBALS['db_conn']));
	} else if ($execute === false) {
		die;		
    } else if ($show_debug == 1) { 
        echo debug_stmt('Update table success!');
    }	
    
    mysqli_stmt_close($stmt);
    return $execute;
}


function insert($table, $data, $debug = 0) {

	if ($GLOBALS['debug'] === true && $debug == 1) $show_debug = 1;
	else $show_debug = 0;

	if (!validate_table_name($table)) {
		if ($show_debug == 1) echo debug_stmt('Failed table validation!');
		return false;
	}
	
    $fields = array_keys($data);
    $values = array_values($data);
    $placeholders = str_repeat('?,', count($fields) - 1) . '?';
	
	$types = '';
	foreach ($values as $value) {
		$types .= get_placeholder_type($value);
	}
	
    $query = "INSERT INTO {$table} (" . implode(',', $fields) . ") VALUES ({$placeholders})";

    // Print SQL query for debugging
    if ($show_debug == 1) echo "<br>DEBUG QRY: " . debugQuery($query, $values) . "<br><br>";    

	// undefined!
	//echo debug_stmt($debug_qry);

    $stmt = mysqli_prepare($GLOBALS['db_conn'], $query);
    if ($stmt === false && $show_debug == 1) {
		die('Error preparing statement: ' . mysqli_error($GLOBALS['db_conn']));
    } else if ($stmt === false) {
		die;
    }    

    mysqli_stmt_bind_param($stmt, $types, ...$values);
    
    $execute = mysqli_stmt_execute($stmt);
    
    if ($execute === false && $show_debug == 1) {
		die('Error executing statement: ' . mysqli_error($GLOBALS['db_conn']));
		$id = false;
	} else if ($execute === false) {
		die;
		$id = false;	
    } else {
		if ($show_debug == 1) echo debug_stmt('Insert success!');
		$id = mysqli_insert_id($GLOBALS['db_conn']);
    }
    
    mysqli_stmt_close($stmt);
    
    return $id;
}
?>
