<?php
//-----------------------------------------------------------------
// Software: Automatic Web Software (AWS) built with PHPCPR
// Firm: DirectSalesMLM.com / AutomaticWebSoftware.com / PHPCPR.com
// Author: Jim Symonds Email: jim@directsalesmlm.com
// Copyright 2006 - 2024 Jim Symonds All Rights Reserved.
//-----------------------------------------------------------------
//require_once 'payment_setup.inc.php';
//require_once 'vars.php';

require_once ''.$_SERVER['DOCUMENT_ROOT'].'/apay/pm/stripe/payment_setup.inc.php';
require_once ''.$_SERVER['DOCUMENT_ROOT'].'/apay/pm/stripe/vars.php';

function handleStripeException($e) {
    // Log the error message
    error_log('Message is:' . $e->getError()->message);
    return false;
}

function processPayment($row) {
    global $stripe, $currency, $return_url;

    try {
        $paymentIntent = $stripe->paymentIntents->create([
            'customer'=> $row['customer_id'],
            'description' => $GLOBALS['program_name'],
            'payment_method' => $row['$stripe_payment_method'],
            'confirm' => 'true',
            'amount' => $row['product_price'],
            'currency' => $currency,
            'automatic_payment_methods' => [
                'enabled' => true,
            ],
            'return_url' => $return_url,
            'metadata' => $row['metadata'],
        ]);

        if($paymentIntent->status === 'succeeded') {
            return true;
        } else {
            error_log("Payment intent failed with status: ".$paymentIntent->status);
            return false;
        }

    } catch(\Stripe\Exception\CardException $e) {
        return handleStripeException($e);
    } catch (\Stripe\Exception\ApiErrorException $e) {
        return handleStripeException($e);
    } catch (Exception $e) {
        // Log the error message
        error_log('Message is:' . $e->getMessage());
        return false;
    }
}

// Mocked data
$row = [
    'cus' => 'cus_123',
    'product_name' => 'Test product',
    'pm' => 'pm_card_visa',
    'product_price' => 1000,
    'metadata' => ['order_id' => '123']
];

// Call the function
$result = processPayment($row);

if($result) {
    echo "Payment succeeded.";
} else {
    echo "Payment failed.";
}
?>
