<!-- All Stripe responses arrive on this page -->
<?php 
//-----------------------------------------------------------------
// Software: Automatic Web Software (AWS) built with PHPCPR
// Firm: DirectSalesMLM.com / AutomaticWebSoftware.com / PHPCPR.com
// Author: Jim Symonds Email: jim@directsalesmlm.com
// Copyright 2006 - 2024 Jim Symonds All Rights Reserved.
//-----------------------------------------------------------------
// COPYRIGHT JIM SYMONDS 2023, AUTOMATIC WEB SOFTWARE / DIRECTSALESMLM.COM
//require_once 'dbconn.php';
$GLOBALS['debug'] = true;

include_once ''.$_SERVER['DOCUMENT_ROOT'].'/Sub/Config.inc.php';
include_once ''.$_SERVER['DOCUMENT_ROOT'].'/phpcpr.php';
$server_timezone = date_default_timezone_get();
//echo $server_timezone; exit;
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>Return</title>
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <link rel="stylesheet" href="https://stackpath.bootstrapcdn.com/bootstrap/4.3.1/css/bootstrap.min.css">
    <style>
        body {
            background-color: #3b5998; 
            color: #fff; /* Facebook blue for text */
        }

        .jumbotron {
            background-color: #3b5998; /* Facebook blue for the jumbotron */
            color: white;
        }

        .btn-primary {
            background-color: #29487d; /* Darker blue for the call to action button */
            border-color: #29487d;
        }

        .btn-primary:hover {
            background-color: #3b5998; /* Facebook blue for hover effect */
            border-color: #3b5998;
        }
    </style>
</head>
<body>
<?php
require_once 'vars.php';
?>

<div class="container">
    <div class="row">
        <div class="col-lg-8 mx-auto text-center text-break">
		
<p>&nbsp;</p><p>&nbsp;</p>
		
<?php
if (isset($_GET['canceled'])) {
   	echo '<div class="alert alert-danger text-center" role="alert">
			 <h1>Payment canceled.</h1>
			 </div><div class="text-center">
			<p>&nbsp;</p><p>&nbsp;</p>
			<a href="checkout.php" class="btn btn-success btn-lg img-responsive">Return To Checkout</a>			 
			</div>';
	exit;
}  

$paymentOrSessionId = '';
if (isset($_GET["payment_intent"])) {
	$paymentOrSessionId = $_GET["payment_intent"];
} else if (isset($_GET["session_id"])) {
	$paymentOrSessionId = $_GET["session_id"];
}


// REPURPOSING $balance_transaction FIELD - IT NEVER WORKED BEFORE, BUT NOT NEEDED// AND WE NEED TO STORE $paymentOrSessionId
$balance_transaction = $paymentOrSessionId;

try {
	// KEEPING SIMPLE FOR NOW - AS ISSUES WITH THE FUNC DOING MULTIPLE WHERE CONDS RIGHT NOW!
	$row = select('balance_transaction', 'stripe_history', [], ['balance_transaction' => $balance_transaction], null, null, null, 1, 1);
	if ($row === false) {
		die("Error: Unable to execute SELECT statement");
	}
} catch (Exception $e) {
	die("Error: " . $e->getMessage());
}

if ($balance_transaction != '' && $row['balance_transaction'] != '' && $row['balance_transaction'] == $balance_transaction) {
?>
	<div class="alert alert-success text-center" role="alert">
	<h1>Already processed!</h1>
	</div><div class="text-center">
	<p>&nbsp;</p><p>&nbsp;</p>
	<a href="<?php echo $paid_access_url; ?>" class="btn btn-success btn-lg img-responsive">Go To Paid Area</a>
	</div>
	<?php
	exit;
}	

if (!empty($paymentOrSessionId)) {
    try {
		if (strpos($paymentOrSessionId, 'pi_') === 0) {
			// It's a Payment Intent
			$paymentIntent = $stripe->paymentIntents->retrieve($paymentOrSessionId, []);
		} else if (strpos($paymentOrSessionId, 'cs_') === 0) {
			// It's a Checkout Session
			$session = $stripe->checkout->sessions->retrieve($paymentOrSessionId, []);
			$paymentIntent = $stripe->paymentIntents->retrieve($session->payment_intent, []);
		} 

 

		// Get the metadata
		$metadata = $paymentIntent->metadata;
		
		//print_r($metadata); exit;

		$payer_id = $metadata['payer_id'];
		
		//echo $payer_id; exit;


        if ($paymentIntent->status === 'succeeded') {
			
			$program_id = isset($metadata->program_id) ? $metadata->program_id : 1;
			$_SESSION['p'.$program_id.'_status'] = 'Active';
           ?>
			
          	<div class="alert alert-success text-center" role="alert">
			<h1>Payment was successful!</h1>
			</div><div class="text-center">
			<p>&nbsp;</p><p>&nbsp;</p>
			<a href="<?php echo $paid_access_url; ?>" class="btn btn-success btn-lg img-responsive">Go To Paid Area</a>
			</div>

<?php
			// Get the customer id and payment method id
			$stripeCustomerId = $paymentIntent->customer;
			$stripePaymentMethodId = $paymentIntent->payment_method;

            if (!empty($stripeCustomerId) && !empty($stripePaymentMethodId) && !empty($payer_id)) {
                $data = [
                    'stripe_customer_id' => $stripeCustomerId,
                    'stripe_payment_method' => $stripePaymentMethodId
                ];
                
				try {
					update('members', $data, [], ['ID' => $payer_id], 1, 1, 1);
				} catch (Exception $e) {
					die("Error: " . $e->getMessage());
				}
				
			    $charge_id = $paymentIntent->id; // The charge id from the payment intent
				//$balance_transaction = $paymentIntent->balance_transaction; // The balance transaction from the payment intent
            }
        } else {
            ?>
			<div class="alert alert-danger text-center" role="alert">
			 <h1>Payment failed.</h1>
			 </div><div class="text-center">
			<p>&nbsp;</p><p>&nbsp;</p>
			<a href="checkout.php" class="btn btn-success btn-lg img-responsive">Return To Checkout</a>			 
			</div>
<?php
		    $charge_id = '';
			//$balance_transaction = '';
        }
		
		if (is_null($charge_id)) $charge_id = '';
		if (is_null($balance_transaction)) $balance_transaction = '';
		
        echo "<pre>";
        //print_r($paymentIntent);
        echo "</pre>";
			
		// SUCCESS OR FAILURE - WE LOG THE RESULTS!
		if ($paymentIntent->status === 'succeeded') {
			$success = 'Y';
		} else {
			$success = 'N';
		}
		$datetimenow = date("Y-m-d H:i:s"); 
		$aws_error_msg = '';
			
		/*$real_amount_received = ($metadata['amount'] / 100);
		$payer_username = $metadata['payer_username'];
		$pp = $metadata['payment_plan_id'];
		*/
		$real_amount_received = isset($metadata->amount) ? ($metadata->amount / 100) : 0;
		//$payer_username = isset($metadata->payer_username) ? $metadata->payer_username : '';
		//$pp = isset($metadata->payment_plan_id) ? $metadata->payment_plan_id : '';
		//$program_id = isset($metadata->program_id) ? $metadata->program_id : '';
		$program_name = isset($metadata->program_name) ? $metadata->program_name : '';	

		$payer_username = $_SESSION['loggedin'];
		$program_id = $_SESSION['program_id'];
		$pp = $_SESSION['pp'];

		// QQQ FAKE DATA TO TEST!
		//$payer_username = 'test';
		//$pp = 520;
		// END FAKE DATA
		//echo $payer_username.' '.$pp;

		// CALL UP PAYMENT PLAN DATA
		//$table, $selectFields, $where, $limit, $debug
		if (isset($payer_username) && isset($pp)) {
			
			try {
				// KEEPING SIMPLE FOR NOW - AS ISSUES WITH THE FUNC DOING MULTIPLE WHERE CONDS RIGHT NOW!
				$result = select(['username, amount, user_payment_plan_id'], 'payment_plan', [], ['payment_plan_id' => $pp], null, null, null, 1, 1);
				if ($row === false) {
					die("Error: Unable to execute SELECT statement");
				}
				$row = $result ? reset($result) : null;
			} catch (Exception $e) {
				die("Error: " . $e->getMessage());
			}
			

			/*$paid_to_username = $row['username'];
			if (empty($paid_to_username)) $paid_to_username = '';
			$amount = $row['amount'];
			$uid = $row['user_payment_plan_id'];
			*/
			$paid_to_username = isset($row['username']) ? $row['username'] : '';
			$amount = isset($row->amount) ? $row->amount : 0;
			//$uid = isset($row->user_payment_plan_id) ? $row->user_payment_plan_id : null;
			$uid = $row['user_payment_plan_id'];
			
			//echo '<br>user_payment_plan_id: '.$uid;
			//echo '<br>';

			// Cast the values to floats for a proper comparison
			$check_amount = round(floatval($row['amount']), 2);
			$check_real_amount_received = round(floatval($real_amount_received), 2);

			// SECURITY CHECK - MAKE SURE AMOUNT POSTED MATCHES PAY PLAN!
			if ($check_amount != $check_real_amount_received) {
				//$success = 'N';
				//$aws_error_msg = 'Amount received ' . $real_amount_received . ' does not match pay plan amount of ' . $row['amount'] . '! ';
			}

		} else {
			//$success = 'N';	
			//$aws_error_msg .= 'Post back has no valid pay plan! ';			
		}

		// SUCCESS OR FAILURE - WE LOG THE RESULTS!		
		
		
		$payment_log_id = 0; // GETS SET LATER! LEAVE THIS HERE!!
		
		// IF ANY VAR IS MISSING, WE SET IT HERE TO EMPTY STRING!
		// Access individual fields
		$program_id = isset($metadata['program_id']) ? $metadata['program_id'] : '1';
		$program_name = isset($metadata['program_name']) ? $metadata['program_name'] : '';
		$plan_type = isset($metadata['plantype']) ? $metadata['plantype'] : ''; // Assuming that plantype is in metadata
		$payment_plan_id = isset($metadata['payment_plan_id']) ? $metadata['payment_plan_id'] : '';
		$payer_username = isset($metadata['payer_username']) ? $metadata['payer_username'] : '';
		$amount = isset($metadata['amount']) ? $metadata['amount'] / 100 : ''; // Assuming the amount is in cents	
		$postback = json_encode($metadata);

		
		/* // TESTING VARS - INSERT WORKS PERFECTLY!
		$program_id = 123;
		$program_name = 'Sample Program';
		$payment_plan_id = 456;
		$payment_log_id = 789;
		$paid_to_username = 'receiveruser';
		$payer_username = 'payeruser';
		$real_amount_received = 100.50;
		$success = 'Y';
		$aws_error_msg = '';  // let's assume no error for this instance
		$postback = 'postbackdata';

		// Mocking a payment intent object
		$paymentIntent = new stdClass();
		$paymentIntent->id = 'ch_1Hh1V4Kur5Q5swC3tze2Kl5q';
		$paymentIntent->balance_transaction = 'txn_1Gy5uhKur5Q5swC3XJa7l7q8';*/
		

		// Prepare the data for insertion
		$data = [
			'program_id' => $program_id,
			'program_name' => $program_name,
			'plan_type' => 'N',
			'payment_plan_id' => $payment_plan_id,
			'payment_log_id' => $payment_log_id,
			'receiver_username' => $paid_to_username,	
			'payer_username' => $payer_username,
			'amount' => $real_amount_received,
			'success' => $success,
			'error' => $aws_error_msg,
			'datetime' => $datetimenow,
			'postback' => $postback,	
			'charge_id' => $charge_id, // The charge id from the payment intent
			'balance_transaction' => $balance_transaction, // The balance transaction from the payment intent
			'currency' => 'USD'  // Your currency
		];
		
		// Call the insert function and catch any potential errors
		try {
			insert('stripe_history', $data, 1, 1); // QQQ CHANGE 1 TO 0, WHEN DONE DEBUGGING!
		} catch (Exception $e) {
			die("Error: " . $e->getMessage());
		}		

		//echo "<p>Transaction logged.</p>";
		
		} catch (\Stripe\Exception\RateLimitException $e) {
			handleStripeExceptions($e);
		} catch (\Stripe\Exception\InvalidRequestException $e) {
			handleStripeExceptions($e);
		} catch (\Stripe\Exception\AuthenticationException $e) {
			handleStripeExceptions($e);
		} catch (\Stripe\Exception\ApiConnectionException $e) {
			handleStripeExceptions($e);
		} catch (\Stripe\Exception\ApiErrorException $e) {
			handleStripeExceptions($e);
		} catch (Exception $e) {
			echo 'Message is:' . $e->getMessage() . '<br>';
		}		
		
		
		if ($success == 'Y') {
			define('IPN_PROCESS', true);
			// VARS REQUIRED BY LOGGING 
			// QQQ DOES NOT SUPPORT ADMIN COLLECTS AT THIS TIME - IF ADDING, WILL NEED TO GET MORE CODE FROM AWS PAYPAL IPN
			$admin_collects = false;
			$admin_collects_tiers = false;
			$freetrial = false;
			$payer = 'STRIPE'; //The payment processor id that the person paid with (if IPN payment)
			$payment_processor = 'STRIPE'; //The payment processor used QQQ CHECK DB FOR ENUM - CHANGE IF NEEDED!!!!!!!
			$payment_processor_name = 'STRIPE'; // The full name for the payment processor used	

			//$payer_username = $json["username"];
			//$_SESSION['loggedin'] = $json["username"];
			$receiver_username = $paid_to_username;

			$payment_amount = $real_amount_received;
			$expected_amount = $amount;
			$payment_plan_id = $pp;
			//$program_id = 1;
			//$program_name = $json["itemname"];
			//if ($program_id == 1) $program_type = 'S'; // QQQ S, SUBSCRIPTION
			//else $program_type = 'N';
			//$user_payment_plan_id = $json["userplan"];
			$user_payment_plan_id = $uid;
			$this_user_payment_plan_id = $uid;
			require_once ''.$_SERVER['DOCUMENT_ROOT'].'/apay/process_success.php';
			
		} // END SUCCESS IPN UPDATE!!!

} else {
	echo '<a href="checkout.php" class="btn btn-success btn-lg">Return To Checkout</a>';
}

?>			
        </div>
    </div>			
</div>	
</body>
</html>
