<?php
//-----------------------------------------------------------------
// Software: Automatic Web Software (AWS) built with PHPCPR
// Firm: DirectSalesMLM.com / AutomaticWebSoftware.com / PHPCPR.com
// Author: Jim Symonds Email: jim@directsalesmlm.com
// Copyright 2006 - 2024 Jim Symonds All Rights Reserved.
//-----------------------------------------------------------------
/* This is a configuration file for the variables and functions that are repeated throughout the project. */
$currency='usd';
$return_url= $GLOBALS['webpage_url_ssl'].'apay/pm/stripe/return.php';
$success_url= $GLOBALS['webpage_url_ssl'].'apay/pm/stripe/return.php?session_id={CHECKOUT_SESSION_ID}';
$cancel_url= $GLOBALS['webpage_url_ssl'].'apay/pm/stripe/return.php?canceled=Y';
$pay_with_saved_card_url= $GLOBALS['webpage_url_ssl'].'apay/pm/stripe/pay_with_saved_card.php';
//$paid_access_url = $GLOBALS['webpage_url_ssl'].'apay/pay.php';
//$paid_access_url = $GLOBALS['webpage_url_ssl'].'Members/advanced_viewer.php';
$paid_access_url = $GLOBALS['webpage_url_ssl'].'ads/dashboard.php';

require_once ''.$_SERVER['DOCUMENT_ROOT'].'/apay/pm/stripe/stripe-php/init.php';
//require_once 'stripe-php/init.php';
//You must put the secret key of your Stripe account. A test or production mode secret key.
// JEREMY'S TEST KEY
//$stripe = new \Stripe\StripeClient('sk_test_51NDYfsB6H5WcUOf8wKrLfHlI8nRJGzMYX3EevtZtorgOkvoI3M1hpMkKniokRc8FPx7OoPGa5P43GssPQT0HHsFv002ellrc65');

// FIND STRIPE KEYS FOR WHO GETS PAID
$paid_to_username = 'admin';
//$table, $selectFields, $where, $limit, $debug
//function select($selectFields, $mainTable, $joinConditions = [], $where = [], $groupBy = null, $having = null, $orderBy = null, $limit = 0, $show_debug = 0)
$row = select('stripekey, stripesecretkey', 'members', [], [['Username' => $paid_to_username]], null, null, null, 1, 1);
//print_r($row);
$stripekey = $row[0]['stripekey'];
$stripesecretkey = $row[0]['stripesecretkey'];

//echo 'Attempting to connect to Stripe with '.$stripekey;
//exit;
$stripe = new \Stripe\StripeClient($stripesecretkey);

if (!isset($stripe)) {
	echo 'Could not connect to Stripe!';
	exit;
}

function handleStripeExceptions($e) {
    if ($GLOBALS['debug'] === true) echo 'Message is:' . $e->getError()->message . '<br>';
}

function handleStripeException($e) {
    if ($GLOBALS['debug'] === true) echo 'Message is:' . $e->getError()->message . '<br>';
}

function PayCardbtn($amount, $stripe_customer_id, $product_name, $payment_metadata, $btn_text, $checkout_session_url) {
    //global $checkout_session_url;
	$pcb = '';
    $pcb = '<form id="st_checkout_form" action="'.$checkout_session_url.'" method="POST">
                    <input type="hidden" name="amount" value="'.$amount.'">
                    <input type="hidden" name="customer_id" value="'.$stripe_customer_id.'">
                    <input type="hidden" name="product_name" value="'.$product_name.'">';

    foreach ($payment_metadata as $key => $value) {
        $pcb.='<input type="hidden" name="metadata['.$key.']" value="'.$value.'">';
    }

    $pcb.='         <button type="submit" class="btn btn-warning btn-lg">'.$btn_text.'</button>
            </form>';

    // If last value is 'pay' then add a script to auto-submit form on load
    //	/*
	if (strtolower($btn_text) == 'make payment') {
        $pcb.= '
            <script type="text/javascript">
                window.onload = function() {
                    document.getElementById("st_checkout_form").submit();
                }
            </script>
        ';
    }
	//	*/

    return $pcb;
}


function PaySaveCardbtn($amount, $stripe_customer_id, $stripe_paymentMethod, $paymentMethod, $product_name, $payment_metadata, $btn_text) {
	global $pay_with_saved_card_url;
	$pscb = '';
	$pscb.= '<form id="saved_card_form" action="'.$pay_with_saved_card_url.'" method="POST">
					<h2>Would you like to use your<br>card on file ending in '.$paymentMethod->card->last4.' ?</h2><br><br>
					<input type="hidden" name="amount" value="'.$amount.'">
					<input type="hidden" name="pm" value="'.$stripe_paymentMethod.'">
					<input type="hidden" name="customer_id" value="'.$stripe_customer_id.'">
					<input type="hidden" name="product_name" value="'.$product_name.'">';

					foreach ($payment_metadata as $key => $value) {
					   $pscb.='<input type="hidden" name="metadata['.$key.']" value="'.$value.'">';
					}
					
/* // TRYING OUT, MAYBE NOT WHAT I WAS THINKING
	$pscb.= '<script type="text/javascript">
                window.onload = function() {
                    document.getElementById("saved_card_form").submit();
                }
            </script>';
*/
	$pscb.='	   <button type="submit" class="btn btn-success btn-lg">'.$btn_text.'</button>
			</form><p>&nbsp;</p>';

	return $pscb;
}


function CreateCheckoutSession($customer_id, $product_name, $amount, $payment_metadata) {
    global $stripe;
    global $success_url;
    global $cancel_url;
    global $currency;

    try {
        $session_data = [
        /*    'payment_method_types' => ['card', 'afterpay_clearpay'], // Added this line	to support afterpay. needs testing!	*/
            'payment_intent_data' => [
                'setup_future_usage' => 'off_session',
				'description' => $product_name,
                'metadata' => $payment_metadata, // Moved here
            ],
            'line_items' => [[
                'price_data' => [
                    'currency' => $currency,
                    'product_data' => [
                        'name' => $product_name,
                    ],
                    'unit_amount' => $amount,
                ],
                'quantity' => 1,
            ]],
            'mode' => 'payment',
            'success_url' => $success_url,
            'cancel_url' => $cancel_url,
        ];

        if ($customer_id) {
            $session_data['customer'] = $customer_id;
        }

        $session = $stripe->checkout->sessions->create($session_data);
		
		if (!isset($session->url)) {
			echo 'Cannot connect';
			exit;
		}
        header("HTTP/1.1 303 See Other");
        header("Location: " . $session->url);

    } catch(\Stripe\Exception\CardException $e) {
		error_log('Message is:' . $e->getMessage());
        return handleStripeExceptions($e);
    } catch (\Stripe\Exception\ApiErrorException $e) {
		error_log('Message is:' . $e->getMessage());
        return handleStripeExceptions($e);
    } catch (Exception $e) {
        // Log the error message
        error_log('Message is:' . $e->getMessage());
        return false;
    }
}
//if ($_SESSION['UserID'] < 4) echo 'Bottom line';
?>