<?php
//-----------------------------------------------------------------
// Software: Automatic Web Software (AWS) built with PHPCPR
// Firm: DirectSalesMLM.com / AutomaticWebSoftware.com / PHPCPR.com
// Author: Jim Symonds Email: jim@directsalesmlm.com
// Copyright 2006 - 2024 Jim Symonds All Rights Reserved.
//-----------------------------------------------------------------
include './cookie.php';
include './maintenance.inc.php'; // THIS FILE WILL LOCK THIS PAGE, WHEN SITE IS PLACED IN MAINTENANCE MODE (FROM ADMIN PANEL)

//$debug = true;

// FOR TESTING ONLY!
//$_SESSION['page_email'] = 'jim@directsalesmlm.com';

// '0' WHEN POWERLINE FEAR OF LOSS SYSTEM IS NOT BEING USED, REDIRECT NOW!
if (($GLOBALS['powerline_program_id'] > 0 || (isset($_SESSION['page_email']) && isset($_SESSION['page_name'])) || isset($_GET['lead'])) && (!isset($_GET['fill_form'])) && (!isset($_GET['t']))) { 
	if (isset($_GET['lead'])) {
		$getLead = "&lead=".$_GET['lead'];
	} else {
		$getLead = "";
	}
		
	header("Location: {$GLOBALS['webpage_url_ssl']}login-check-enrollee.php?id={$SponsorID}{$getLead}");
	exit;
}	

$current_page_name = basename($_SERVER['PHP_SELF']);
$current_page_name = str_replace(".php", "", $current_page_name);
$pageName = htmlspecialchars($current_page_name, ENT_QUOTES, 'UTF-8'); // 'lc', 'lc2', etc.. this new method now does not need updating for each new file.
$_SESSION['pageName'] = $pageName;
$pageClass = 'join';
$page_id = 1; // SET UNIQUE PAGE ID FOR EACH LEAD CAP PAGE, NUMBERS ONLY!
//$survey_name = 'survey1';
$ar_list = 1;

$joinuser = true; // MAKE LEAD A MEMBER

$error_msg = ''; // INI VAR

// CREATE SIMPLE RANDOM CAPTCHA NUMBERS
if (!isset($_SESSION['captcha'])) {
	$_SESSION['captcha'] = rand(111,999);
	if ($_SESSION['captcha'] == 665 + 1) $_SESSION['captcha'] = 777;
	$captcha_password = $_SESSION['captcha'];
} else {
	$captcha_password = $_SESSION['captcha'];
}
$error_captcha = false; // INI VAR

if (isset($_REQUEST['t']) && $_REQUEST['t'] == 'y' && isset($_SESSION['admin_login']) && $_SESSION['admin_login'] === true) {
    
    $selectFields = 'ID, Username';
    $mainTable = 'members';
    $where = [
        'Username' => ['LIKE', 'test%']
    ];
    $orderBy = 'ID DESC';
    $limit = 1;
    $show_debug = 1;

    $result = select($selectFields, $mainTable, [], $where, null, null, $orderBy, $limit, $show_debug);
    $buffer = isset($result[0]) ? $result[0] : null;

    if (!isset($buffer['Username'])) {
        $test_username = 'test';
    } else {
        $test_username_nr = (int) substr($buffer['Username'], 4);
        $test_username = 'test' . ($test_username_nr < 1 ? 2 : $test_username_nr + 1);
    }
    
    $email_domain = strtolower($Global['webpage_name'] ?? 'defaultdomain.com');
    $test_email = $test_username.'@'.$email_domain;
    
    if (!isset($_POST['firstname'])) $_POST['firstname'] = $test_username.'fname';
    if (!isset($_POST['lastname'])) $_POST['lastname'] = $test_username.'lname';
    if (!isset($_POST['username'])) $_POST['username'] = $test_username;
    if (!isset($_POST['password2'])) $_POST['password2'] = $captcha_password . $captcha_password;
    if (!isset($_POST['email'])) $_POST['email'] = $test_email;
    if (!isset($_POST['phone'])) $_POST['phone'] = '123';
    if (!isset($_POST['cellphone'])) $_POST['cellphone'] = '123';

    // Address fields
    if (!isset($_POST['address'])) $_POST['address'] = 'some street';
    if (!isset($_POST['city'])) $_POST['city'] = 'my city';
    if (!isset($_POST['state'])) $_POST['state'] = 'AL';
    if (!isset($_POST['zip'])) $_POST['zip'] = '123456';
    if (!isset($_POST['country'])) $_POST['country'] = 'US';
	
	$_POST['captcha'] = $captcha_password;

} else {
    if (!isset($_POST['firstname'])) $_POST['firstname'] = $_SESSION['page_name'] ?? '';
    if (!isset($_POST['email'])) $_POST['email'] = $_SESSION['page_email'] ?? '';
    if (!isset($_POST['phone'])) $_POST['phone'] = $_SESSION['page_phone'] ?? '';
    if (isset($_POST['username']) && strstr($_POST['username'], 'test')) {
        $error_msg = 'Your username cannot contain the word "test"';
    }
} // END TEST SIGN UP FROM ADMIN LOGIN

if (isset($_SESSION['admin_login']) && $_SESSION['admin_login'] === true) $_POST['captcha'] = $captcha_password;

if (!isset($_POST['firstname'])) {
    $_POST['firstname'] = '';
}

if (!isset($_POST['lastname'])) {
    $_POST['lastname'] = '';
}

// THIS ACCOMODATES ADMIN SIGN UPS, AND LEAD SIGN UPS
if (!isset($_POST['username']) || $_POST['username'] == '') {
    $_POST['username'] = $_POST['email'];
}

if (!isset($_POST['email'])) {
    $_POST['email'] = '';
}

if (!isset($_POST['phone'])) {
    $_POST['phone'] = '';
}


if (isset($_GET['dev']) && $_GET['dev'] == '' && $_SESSION['dev'] == '') { // LOCKING PAGE FOR DEVELOPER USE ONLY!!
	/*
	include_once './header.php';
	echo 'We\'re sorry. This area is temporarily down for maintenance. Please check back soon!';
	include_once './footer.php';
	exit;
	*/
} else {
	//$debug = true;
}
//$debug = false;
//if ($SponsorID == 'test') $debug = true;

if (true || isset($_GET['fill_form']) && $_GET['fill_form'] == 'Y') {
/* // FOR TESTING ONLY!!
	$_SESSION['page_name'] = 'Tom';
	$_SESSION['page_lastname'] = 'Hill';	
	$_SESSION['page_email'] = 'thill@gmail.com';
	$_SESSION['page_phone'] = '555-555-1212';
*/
	if (!isset($_POST['firstname']) || $_POST['firstname'] == '') {
		$_POST['firstname'] = isset($_SESSION['page_name']) ? $_SESSION['page_name'] : '';
	}

	if (!isset($_POST['lastname']) || $_POST['lastname'] == '') {
		$_POST['lastname'] = isset($_SESSION['page_lastname']) ? $_SESSION['page_lastname'] : '';
	}
	
	if (!isset($_POST['email']) || $_POST['email'] == '') {
		$_POST['email'] = isset($_SESSION['page_email']) ? $_SESSION['page_email'] : '';
	}

	if (!isset($_POST['phone']) || $_POST['phone'] == '') {
		$_POST['phone'] = isset($_SESSION['page_phone']) ? $_SESSION['page_phone'] : '';
	}
}


if (isset($_POST["custom_username"]) && $_POST["custom_username"] != '') $SponsorID = $_POST["custom_username"];

if ($_SERVER['REQUEST_METHOD'] == 'POST' && !empty($debug) && $debug === true) {
    echo '<p>&nbsp;</p><p>&nbsp;</p>';
	echo 'DEBUG SESSION ACTIVE<br/>';
    echo 'r= ' . (isset($_GET['r']) ? $_GET['r'] : 'not set') . '<br/>';  
	
    echo 'firstname=' . (isset($_POST['firstname']) ? $_POST['firstname'] : 'not set') . '<br/>';
    echo 'email=' . (isset($_POST['email']) ? $_POST['email'] : 'not set') . '<br/>';
    echo 'page_id=' . (isset($_POST['page_id']) ? $_POST['page_id'] : 'not set') . '<br/>';
    echo 'redirect=' . (isset($_POST['redirect']) ? $_POST['redirect'] : 'not set') . '<br/>';
	
    echo 'ref_username=' . (isset($_POST['ref_username']) ? $_POST['ref_username'] : 'not set') . '<br/>';
    echo 'custom_username=' . (isset($_POST['custom_username']) ? $_POST['custom_username'] : 'not set') . '<br/>';  
	
    echo 'username=' . (isset($SponsorID) ? $SponsorID : 'not set') . '<br/>';  
	echo 'POST: ';
	print_r($_POST);
	exit;
}
$use_logo = false;
$brand = $GLOBALS['webpage_name'];

if ($_SERVER['REQUEST_METHOD'] == 'POST' && isset($_SESSION['ar_post']) && $_SESSION['ar_post'] != '' && $_SESSION['ar_post'] >= 1 && isset($_SESSION['page_email']) && $_SESSION['page_email'] == $_POST['email']) {
	// DO NOTHING
	if ($_POST['redirect'] != '') { // WORKS FINE, BUT SHOWS REDIRECT LINK IN THE SOURCE CODE. BETTER TO HIDE IT.
		//$url = htmlspecialchars($_POST['redirect'], ENT_QUOTES, 'UTF-8');
		//echo '<meta http-equiv="refresh" content="0; url='.$url.'">';
	}
} else {
	//include 'subscribe.setup.inc.php'; 
}

if ($_SERVER['REQUEST_METHOD'] == 'POST') {
	
	$check_email = $_POST['email'];
	
	//$check_email = 'jim@directsalesmlm.com';

	// SECURE LOGIN FROM XSS ATTACKS!
	if (!isset($_POST['csrf_token']) || !isset($_SESSION['csrf_token']) || (isset($_POST['csrf_token']) && $_POST['csrf_token'] !== $_SESSION['csrf_token'])) {
		// Token not set in either POST or SESSION, or Token mismatch, 
		// redirect to the same page within the same domain with proper sanitization to prevent XSS
		$currentPage = htmlentities($_SERVER['PHP_SELF'], ENT_QUOTES, 'UTF-8');
		$queryString = !empty($_SERVER['QUERY_STRING']) ? '?' . http_build_query($_GET) : '';
		
		// Ensure the redirect is to a path on the current domain
		$redirectUrl = '/' . ltrim($currentPage, '/') . $queryString;
		
		header('Location: ' . $redirectUrl);
		exit;
	}
	
	if (isset($buffer)) unset($buffer);
	/* // THIS WAS MOVED TO subscribe.inc.php
	// CHECK IF EMAIL EXISTS - IF YES, SKIP IT AND REDIRECT!
	$where = [
		'OR' => [
			['Username' => $check_email],
			['email' => $check_email],
			['bounced_email' => $check_email]
		]
	];
	
    $result = select(['email'], 'members', [], $where, null, null, null, 1, 1);	
	$buffer = isset($result[0]) ? $result[0] : null;
	
	//echo 'see 3 way email called!<br>';
	//print_r($buffer);
	//exit;

	if ($buffer['email'] != '') {
		// THEY ARE IN ALREADY A MEMBER - SKIP THEM!
		$url = 'index.php';
		echo '<meta http-equiv="refresh" content="0; url='.$url.'">';
		exit;
	}*/
	
	if ($_POST['email'] != '' && (trim($_POST['captcha']) != $captcha_password)) {
		$error_captcha = true;
     	$error_msg = 'Please enter the Captcha number: '.$captcha_password.' to pass the human test.';
		$error_msg_headline = '<h2 style="color:red">ERROR! Please scroll down and enter the Captcha number: '.$captcha_password.' and re-submit the form.</h2>';
	} else {	
		include 'subscribe.setup.inc.php';
	}	
}	


include 'header.php'; 
	
include 'header.inc.php';

 /*
CLASSES
class="wow fadeIn quick"
class="wow fadeInRight quick"
class="wow fadeInLeft quick"
class="wow fadeIn one"
*/?>



<div class="container" style="position:relative; z-index: 900; ">
    <div class="row">
<!--	
	<div class="col-xs-12" style="float:left;">
			<p>&nbsp;</p>
	      
	<?php if ($use_logo == true) { ?>		
			<h4 style="text-align:left; color:#fff"><b>
			<a href="/?id=<?php echo $SponsorID ?>" style="color:#eeeeee"><?php echo $brand;?></a>
			</b></h4>
	<?php } ?>
	</div>
-->	
<!--
<p>&nbsp;</p><p>&nbsp;</p><p>&nbsp;</p>	
-->

<!--
<div id="video" class="col-md-8 col-xs-12 collapse" style="background-color: #; margin-top:0px; float:left; min-height:20px">
	
	<h2 class="wow fadeInLeft" style="background-color: #d31927; text-align:center; color:#fff">
    HEADLINE
</h2>

	<div class="embed-responsive embed-responsive-16by9">
<iframe width="560" height="315" src="https://player.vimeo.com/video/?autoplay=0" title="Leads Are Cash" frameborder="0" allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture" allowfullscreen></iframe>	  
	  
	  </div>

</div>
-->
<!-- NEW FORMAT - BELOW WAS HIIDEN WITH collapse IN END OF CLASS -->
    	<div id="signup" class="col-md-4 col-xs-12" style="background-color: #; margin-top:0px; float:none; margin: auto; filter:alpha(opacity=50); opacity:.9;">

<!--	<h4 class="wow fadeInLeft" style="text-align:center; color:#fff">
    &nbsp;
</h4>
	-->	
    		<div class="panel panel-default transparent" style="background-color: rgba(0,0,0,0);"> 		
			  	<div class="panel-heading" style="background-color:#bbb;">
					
		    	  <h3 class="panel-title" style="line-height:30px; color:#FFFFF;">
				  <div  class="wow fadeInLeft" style="text-align:center;  padding-top:10px;  padding-bottom:5px; font-size:21px; color:#FCB442;  font-family: Arial">
				  <div style="display:inline-block; color:#FFFFFF;"><div style="text-align:justify; word-spacing:5px; color:#fff">
				  JOIN NOW
				</div></div>
				</div>
		    	  <!--<div  style="line-height:30px; color:#FFFFFF; font-family: Graphik-Light;"></strong>Fill out the form below:</div>-->
				  </h3>
			 	</div>
			  	<div class="panel-body" style="background-color: #ffffff;">
				
				<?php if (!empty($error)) { ?>
				<div style="text-align:center; color:red;"><?php echo $error; ?><br />&nbsp;</div>
				<?php } ?>
				<!--				
				<form method="post" action="<?php echo htmlspecialchars($_SERVER['PHP_SELF']); ?>?r=<?php echo $ar_list; ?>&id=<?php echo $SponsorID;?>" id="mainForm" target="_parent">
				-->
				<form method="post" action="<?php echo htmlspecialchars($_SERVER['PHP_SELF']) . '?r=' . $ar_list . '&id=' . $SponsorID . (isset($_SESSION['admin_login']) ? '&t=y' : ''); ?>" id="mainForm" target="_parent">
				
				<input type="hidden" name="csrf_token" value="<?php if (isset($_SESSION['csrf_token'])) echo htmlspecialchars($_SESSION['csrf_token'], ENT_QUOTES, 'UTF-8'); ?>">				
                
                    <fieldset>
			    	  	<div class="wow fadeInRight one form-group">
							<div class="left-inner-icon ">
    						<i class="fa fa-user"></i>
    						<input type="text" class="form-control" name="firstname" value="<?php echo (!empty($_POST['firstname']) ? $_POST['firstname']:''); ?>" placeholder="Enter Your FIRST NAME*" onblur="this.value = this.value.substr(0, 1).toUpperCase() + this.value.substr(1);" maxlength="50" required>
							</div>
						</div>	
						<div class="wow fadeInLeft two form-group">
							<div class="left-inner-icon ">
    						<i class="fa fa-user"></i>
    						<input type="text"  class="form-control" name="lastname" value="<?php echo (!empty($_POST['lastname']) ? $_POST['lastname']:''); ?>" placeholder="Enter Your LAST NAME*" onblur="this.value = this.value.substr(0, 1).toUpperCase() + this.value.substr(1);" maxlength="50" required>
							</div>							
			    		</div>
			
						<?php if (isset($_REQUEST['t']) && $_REQUEST['t'] == 'y' && isset($_SESSION['admin_login']) && $_SESSION['admin_login'] === true) { ?>
						<div class="wow fadeInRight one form-group">
							<div class="left-inner-icon ">
    						<i class="fa fa-user"></i>
    						<input type="input" class="form-control transparent" name="username" value="<?php echo (!empty($_POST['username']) ? $_POST['username']:''); ?>" placeholder="Choose Your USERNAME*" maxlength="150" required>
							</div>
			    		</div>
						
		<div class="wow fadeInRight one form-group">
							<div class="left-inner-icon ">
    						<i class="fa fa-star"></i>
    						<input type="input" class="form-control transparent" name="password2" value="<?php echo (!empty($_POST['password2']) ? $_POST['password2']:''); ?>" placeholder="Choose Your PASSWORD*" maxlength="150" required>
							</div>
			    		</div>						
						<?php } ?>
			
						<div class="wow fadeInRight one form-group">
							<div class="left-inner-icon ">
    						<i class="fa fa-envelope"></i>
    						<input type="email" class="form-control transparent" name="email" value="<?php echo (!empty($_POST['email']) ? $_POST['email']:''); ?>" placeholder="Enter Your EMAIL*" maxlength="150" required>
							</div>
			    		</div>
                        <div class="wow fadeInLeft two form-group">
							<div class="left-inner-icon ">
    						<i class="fa fa-phone"></i>
    						<input type="phone" class="form-control" name="phone" value="<?php echo (!empty($_POST['phone']) ? $_POST['phone']:''); ?>" placeholder="Enter Your MOBILE PHONE*" maxlength="20" required>
							</div>
			    		</div>
						
                        <div class="wow fadeInLeft two form-group">
<span id="error_captcha" style="color:red; background-color:yellow; font-weight:bold">

<?php if ($error_captcha == true) echo $error_msg; ?>

</span>							
							<div class="left-inner-icon ">
    						<i class="fa fa-lock"></i>
							<input type="text" name="captcha" id="captcha" class="form-control" placeholder="Enter Captcha Code: <?php echo $captcha_password; ?>" value="<?php if (!empty($_POST['captcha'])) echo htmlspecialchars($_POST['captcha'], ENT_QUOTES, 'UTF-8'); ?>" maxlength="10" required>							
							
							
							</div>
			    		</div>	

						<div style="text-align:center">
							
							<input type="checkbox" name="terms" value="yes" required <?php if (isset($_SESSION['admin_login']) && $_SESSION['admin_login'] === true) echo 'checked'; ?>>
							I agree to the 
							<a href="#" data-toggle="modal" data-target="#terms" style="color:#000; text-decoration: underline;">terms and conditions</a>.
						</div>
						
			    		</div>
<br>
			    		</div>
			    		<!--<input class="btn btn-lg btn-success btn-block" type="submit" value="Show Me the System">-->
                      <div class="panel-body" style="background-color: #ffffff;">
					  <div class="wow fadeInRight three" style="text-align:center" style="background-color: #ffffff;">
					  <!--<div class="btn btn-lg btn-warning" style="background-color: #;">
					 <sub><sub> <i class="fa fa-youtube-play" style="font-size:40px;color:white"></i></sub></sub>
					  <input class="btn btn-lg btn-warning" style="background-color:red" type="submit" value="Yes, Show Me Now!" onMouseDown="sendForm()">
					  </div>-->
					  
					  <button type="submit" class="btn btn-info btn-lg" style="font-size:20px;color:white; background-color:#;">
					  <i class="fa fa-youtube-play" style="font-size:40px;color:white;"></i><sup>&nbsp;
					  Yes, <span style="font-size:20px;color:white; text-decoration: underline; text-decoration-color:#;">I Want In</span></sup>
					  </button>
					  <!--
					  <input type="image" name="image" src="images/QQQ.png" class="img-responsive"  alt="" onMouseDown="sendForm()"/></div>
                    -->
					
					<input type="hidden" name="redirect" value="setup">
					
					</fieldset>
					
			      	</form>
                    <br>
					<small><i class="fa fa-lock"></i> Your info is safe and will never be shared with anyone.</small>
                    
		      </div>
						</div>
			</div>
		</div>
			</div>
	</div>
	
<?php
include 'footer.php'; ?>