<?php
//-----------------------------------------------------------------
// Software: Automatic Web Software (AWS) built with PHPCPR
// Firm: DirectSalesMLM.com / AutomaticWebSoftware.com / PHPCPR.com
// Author: Jim Symonds Email: jim@directsalesmlm.com
// Copyright 2006 - 2024 Jim Symonds All Rights Reserved.
//-----------------------------------------------------------------
include './cookie.php';
include './maintenance.inc.php'; // THIS FILE WILL LOCK THIS PAGE, WHEN SITE IS PLACED IN MAINTENANCE MODE (FROM ADMIN PANEL)
$pageName = 'login-check-enrollee';
//$GLOBALS['debug'] = true;

if (!empty($_GET['lead'])) {
	// !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
	// header.php WILL TAKE THIS INFO AND FORCE THIS PAGE TO POST ON PAGE LOAD, TO FWD TO USERNAME SETUP!
    // Sanitize the input
    $leadInput = $_GET['lead'];

    // Define the fields you want to select
    $selectFields = ['ar_leads_email'];

    // Specify the main table
    $mainTable = 'ar_leads';

    // Define the where condition
    $where = ['ar_leads_md5' => ['=', $leadInput]]; // Assuming the select function handles the escaping

    // Execute the select query using PHPCPR's select function
    $result = select($selectFields, $mainTable, [], $where, null, null, null, 1, 1);

    // Fetch the result
    if ($result && count($result) > 0) {
        $lead = $result[0]; // Assuming the select function returns an array of results
        $_SESSION['page_email'] = $lead['ar_leads_email'];
    } else {
        // Handle the case when no lead is found or an error occurred
    }
}

if (isset($_GET['login']) && !empty($_GET['login'])) { // $_GET['login'] IS ONLY USED FROM ADMIN MAILINGS TO MEMBERS AT THIS TIME!
    $login = $_GET['login'];

    // Sanitize the input
    if (is_email($login)) {
        $login = filter_input(INPUT_GET, 'login', FILTER_SANITIZE_EMAIL);
    } else {
        $login = filter_input(INPUT_GET, 'login', FILTER_SANITIZE_STRING);
    }
    
    // Update the $_GET['login'] with the sanitized value
    $_GET['login'] = $login;
	
    // Define the fields to select
    $selectFields = ['ID'];

    // Specify the main table
    $mainTable = 'members';

    // Define the where condition using OR logic
    $where = [
        'OR' => [
            'Username' => $login,
            'email' => $login,
            'bounced_email' => $login
        ]
    ];

    // Execute the select query using PHPCPR's select function
    $result = select($selectFields, $mainTable, [], $where, null, null, null, 0, 1);

    // Fetch the result
    if ($result && count($result) > 0) {
        $buffer = $result[0]; // Assuming the select function returns an array of results

        if (!empty($buffer['ID'])) { // WE HAVE A MATCH! SET LOGIN COOKIE!
			// Set the cookie with the login value (will be email or username) and expiration time for 10 years
			//$cookie_expiration_time = time() + (10 * 365 * 24 * 60 * 60); // 10 years in seconds
			//setcookie('login', $login, $cookie_expiration_time, '/');
        } else {
            // NO MEMBER MATCH - WIPE THIS SO IT IS NOT USED AS EMAIL - IN LC.PHP!!
            $_GET['login'] = '';
        }
    } else {
        // No results found or an error occurred
        $_GET['login'] = '';
    }
}
	


if (isset($_POST['login']) && !empty($_POST['login'])) {
    $prefilled_email = $_POST['login'];
} elseif (isset($_GET['login']) && $_GET['login'] != '') {
	$prefilled_email = $_GET['login'];	
} elseif (isset($_SESSION['page_email'])) {
    $prefilled_email = $_SESSION['page_email'];
} elseif (isset($_COOKIE['login'])) {
    $prefilled_email = $_COOKIE['login'];
} else {
    $prefilled_email = ''; // Default empty value
}

//if (isset($prefilled_email)) $prefilled_email = sanitize($prefilled_email); // Sanitize the input
$login = $prefilled_email; 


$ERROR = '';

if ($_SERVER['REQUEST_METHOD'] == 'POST' && !empty($_POST['login'])) {
	
    // Sanitize the input
    if (is_email($_POST['login'])) {
        $login = filter_input(INPUT_POST, 'login', FILTER_SANITIZE_EMAIL);
		$_SESSION['page_email'] = $login;
    } else {
        $login = sanitize($_POST['login']);
    }
	
    // Define the fields you want to select
    $selectFields = ['*']; // Select all fields, adjust as necessary

    // Specify the main table
    $mainTable = 'members';

    // Define the where condition using OR logic
    $where = [
        'OR' => [
            'Username' => $login,
            'email' => $login,
            'bounced_email' => $login
        ]
    ];

    // Execute the select query using PHPCPR's select function
    $result = select($selectFields, $mainTable, [], $where, null, null, null, 0, 1);

    // Fetch the result
    if ($result && count($result) > 0) {
        $buffer = $result[0]; // Assuming the select function returns an array of results
        // Continue processing with $buffer
    } else {
        // Handle the case when no user is found or an error occurred
    }
	
	/*if ($_SESSION['admin_login'] == true) {
		print_r($buffer);
		exit;
	}*/	
    
	if (!$buffer) $ERROR='<h3 style="color:red">Invalid Username or Email</h3>';
	
	if (isset($_SESSION['loggedin'])) unset($_SESSION['loggedin']);
	
	if ((is_email($_POST['login']) && !empty($buffer['ID']) && (!empty($buffer['Username']) && is_email($buffer['Username']))) || (!empty($buffer['ID']) && $buffer['Status'] == 'unpaid')) { // USERNAME IS STILL AN EMAIL, OR THEY ARE UNPAID!
	
		// $EMAIL IS A VALID EMAIL ADDRESS // USER IS MEMBER!
		
		if ($GLOBALS['powerline_program_id'] > 0) { // 0 WHEN POWERLINE FEAR OF LOSS SYSTEM IS BEING USED, REDIRECT TO VIEW POWERLINE NOW!
		
			$urlnext = $GLOBALS['webpage_url_ssl']."viewmypowerline.php?uid=".$buffer['unsubscribe_id'];
		
		} else {
		
			// REDIRECT TO SET UP USERNAME / PW NOW!
			// THIS URL WILL LOG THEM OUT, IF THEIR UNAME IS NOT AN EMAIL!
			$urlnext = $GLOBALS['webpage_url_ssl']."Members/username-setup.php";
		}	
								
		$_SESSION['loggedin'] = $buffer['Username'];
		$_SESSION['Firstname_loggedin'] = $buffer['First_Name'];
		$_SESSION['Lastname_loggedin'] = $buffer['Last_Name'];
		$_SESSION['UserID'] =  $buffer['ID'];
		$_SESSION['Email_loggedin'] =  $buffer['email'];

		$_SESSION['ulogin']=1;
		log_login($_POST['login'], true, $buffer);
		
		//echo 'IN'; exit;
		
	} else if (!empty($buffer['ID'])) {	
		// USER IS MEMBER!
		$urlnext = $GLOBALS['webpage_url_ssl']."login.php?id=".$SponsorID."&login=".$_POST['login'];
				
	} else if (is_email($_POST['login']) && empty($buffer['ID'])) {
		// $EMAIL IS A VALID EMAIL ADDRESS // NOT A MEMBER! - GO TO LC TO SIGN UP AS LEAD / MEMBER!
		// DO NOT FWD THEM TO join.php, SINCE THAT FWDS HERE!
		$urlnext = $GLOBALS['webpage_url_ssl']."lc.php?fill_form=Y&id=".$SponsorID;

	} else {
		// FAILSAFE!
		// DO NOT FWD THEM TO join.php, SINCE THAT FWDS HERE!
		//$urlnext = $GLOBALS['webpage_url_ssl']."lc.php?fill_form=Y&id=".$SponsorID;
		$urlnext = $GLOBALS['webpage_url_ssl']."login.php?id=".$SponsorID."&login=".$_POST['login'];
	}	
		
	
	// SET SPECIAL CONDS FOR TESTING
	/*if ($_POST['login'] == 'demo@mytrafficpowerline.com' || $_POST['login'] == 'demo' || $_SESSION['admin_login'] == true) {
		$urlnext = $GLOBALS['webpage_url_ssl']."viewmypowerline.php";
	}*/	
	
	//if ($_SESSION['admin_login'] == true) echo $urlnext; exit;

	header("Location: {$urlnext}");
	exit;

} // END POST!

include './header.php'; 
?>

<br/>


  <div class="row">
  <div class="col-xs-0 col-sm-0 col-md-2">
  &nbsp;
  </div>

  <div class="col-xs-12 col-sm-12 col-md-8" style="text-align:center">
	
	<h2>New or Returning? Enter email or username to get started!</h2>
	<br>
	 <h3 class="panel-title">Come on in!</h3>

<?php
if (!empty($ERROR)) { 
	echo '<span style="font-weight:bold; color:red">'.$ERROR.'</span>';
}	
?>
<form id="login_check" name="form" method="POST" action="login-check-enrollee.php">
<input type="hidden" name="completed" value="yes">

         <div class="form-group input-group">
		 <div class="input-group-prepend">
            <span class="input-group-text"><i class="fa fa-user input-icon"></i></span>
			</div>
            <input class="form-control fa fa-user" type="text" placeholder="Username or Email" name="login"
			value="<?php echo htmlentities($login, ENT_QUOTES, 'UTF-8');
 ?>" onMouseover="this.focus()" required maxlength="50"/>
          </div>

     <div class="form-group">
<br>
<input type="submit" value="Submit" class="btn button btn-primary" style="margin-top:5px; background-color:#2fbad0;" name="Submit">
	  
<p>&nbsp;</p>

<h2>This site is powered by AI.</h2>

<?php
$domainName = $_SERVER['HTTP_HOST'];
$currentScript = basename($_SERVER['PHP_SELF']); // Extracts the filename from the current script's path

if ($domainName == 'QQQ.com') { 
	$pageIcon = 'fa fa-car fa-lg';
} else {
	$pageIcon = 'fa fa-money fa-lg';
}	
$iconColor = '#fabf01'; 
?>

<br><i class="<?php echo $pageIcon; ?>" style="color:<?php echo $iconColor; ?>"></i>&nbsp;This form will take you to the appropriate place for you to be, <u>every time you use it</u>.
<p>&nbsp;</p>

<i class="<?php echo $pageIcon; ?>" style="color:<?php echo $iconColor; ?>"></i>&nbsp;If your email is not already in our system, this form will take you to the sign up page.
<p>&nbsp;</p>

<?php if ($GLOBALS['powerline_program_id'] > 0) { ?>
<i class="<?php echo $pageIcon; ?>" style="color:<?php echo $iconColor; ?>"></i>&nbsp;As a pre-enrollee, this form will take you to see your powerline team.<br>
<p>&nbsp;</p>
<?php } ?>

<i class="<?php echo $pageIcon; ?>" style="color:<?php echo $iconColor; ?>"></i>&nbsp;As a pre-enrollee, this form will take you to an area to set up your username / password.
<p>&nbsp;</p>

<i class="<?php echo $pageIcon; ?>" style="color:<?php echo $iconColor; ?>"></i>&nbsp;Once you have upgraded, this form will take you to the login page, to access your back office.

</form>		  
		</div>

     </div>
   
  <div class="col-xs-0 col-sm-12 col-md-2">
  &nbsp;
  </div>

</div>
   

<!--
<p>&nbsp;</p><p>&nbsp;</p><p>&nbsp;</p>
-->
<?php
include './footer.php'; 
?>