<?php
//-----------------------------------------------------------------
// Software: Automatic Web Software (AWS) built with PHPCPR
// Firm: DirectSalesMLM.com / AutomaticWebSoftware.com / PHPCPR.com
// Author: Jim Symonds Email: jim@directsalesmlm.com
// Copyright 2006 - 2024 Jim Symonds All Rights Reserved.
//-----------------------------------------------------------------
include './cookie.php';
$pageName = 'password';

$sender_email = $GLOBALS['admin_email'];
$use_sendgrid = $GLOBALS['use_sendgrid']; 
if ($use_sendgrid == true) include './sendgrid.inc.php'; // load sendgrid functions if using them

//You should change the below email messages so they look like you want them
$affiliate_link = $GLOBALS['webpage_url'].'?id=[USERNAME]';
$login_link = $GLOBALS['webpage_url'].'login.php?id=[USERNAME]';
$email_subject = "Your {$GLOBALS['webpage_name']} Membership Details";
$email_message = "
Hello [FIRSTNAME],

Your Username is: [USERNAME]
Your Password is: [PASSWORD]

Login Here: $login_link

Your Affiliate Link To Promote is: $affiliate_link

Thank you,
Admin";

$email_subject = "{$GLOBALS['webpage_name']} Password Reset";
$email_message = "
Hello [FIRSTNAME],

A request has been made to reset your password.

If this did not come from you, you may simply ignore this email.

Your account is fine.

If you did request this, please click below, to create a new password:
[PASSWORD_RESET_URL]

This link will expire in 60 minutes.

Thank you,
Admin";

//If they have submitted the form we execute the below code
if (!empty($_POST['retrieve']) && $_POST['retrieve'] == 'yes') {
	$email = $_POST['email']; // Get the email from the POST request
	
	$selectFields = ['ID', 'Username', 'First_Name', 'Password', 'email'];	
	$mainTable = 'members';
	$where = ['email' => ['=', $email]];
		
	$limit = 1;
	$show_debug = 1;	
	$result = select($selectFields, $mainTable, [], $where, null, null, null, $limit, $show_debug);	
	$buffer = isset($result[0]) ? $result[0] : null;
	
	//print_r($buffer);	
	//exit;

	if (!empty($buffer['Username'])) {
		
		$oneHourLater = date('Y-m-d H:i:s', strtotime('+1 hour'));
		
		if (version_compare(PHP_VERSION, '7.0.0') >= 0) {
			// PHP version is 7.0.0 or higher
			$secureRandom = bin2hex(random_bytes(16)); // Generates a 32-character hexadecimal number
		} else {
			// PHP version is less than 7.0.0
			$secureRandom = bin2hex(openssl_random_pseudo_bytes(16));
		}

		
		$pw_reset_url = $GLOBALS['webpage_url'].'password-reset.php?token='.$secureRandom;
		
		$table = 'members';	
		$data = ['password_reset_expire' => $oneHourLater, 'password_token' => $secureRandom];
		$joinConditions = [];
		$where = ['ID' => ['=', $buffer['ID']]]; // Assuming 'id' is the identifier column
		$live = 1;
		$limit = 1;
		$show_debug = 1;

		update($table, $data, $joinConditions, $where, $live, $limit, $show_debug);		
		
		//We put in the users information into the email
		$email_subject = str_replace('[USERNAME]',$buffer['Username'],$email_subject);
		$email_subject = str_replace('[FIRSTNAME]',$buffer['First_Name'],$email_subject);

		$email_message = str_replace('[USERNAME]',$buffer['Username'],$email_message);
		$email_message = str_replace('[PASSWORD]',$buffer['Password'],$email_message);
		$email_message = str_replace('[PASSWORD_RESET_URL]',$pw_reset_url,$email_message);		
		$email_message = str_replace('[FIRSTNAME]',$buffer['First_Name'],$email_message);
		
		
		//We send the email
		if ($use_sendgrid == true) { // USING SENDGRID
			sendgrid_email($buffer['email'],$email_subject,$email_message);
		} else { // NO SENDGRID CREDENTIALS - - - USING PHP MAIL	
			mail($buffer['email'],$email_subject,$email_message,"From: $sender_email");
		}
		
		$success_msg = true;
		
	} else {
		//The email didn't exist in the database
		$error_msg = true;
	}
}

include 'header.php'; ?>
<br/>

<div class="row center-block col-md-12 col-xs-12" style="float:none; margin-top:20px; text-align:center">	
<?php 
if (isset($success_msg) && $success_msg == true) {
	//echo '<h4>Success! Your affiliate membership information has been emailed to you at '.$buffer['email'].'</h4>';
	echo '<h4>Success! Your password reset link has been emailed to you at '.$buffer['email'].'</h4></div>';
} else {
	if (isset($error_msg) && $error_msg == true) echo '<h4 style="color:red">Sorry, that email address does not exist in our database.</h4>';
?>
</div>
	<form class="form-signin" name="form" method="post" action="password.php">
	<input type="hidden" name="retrieve" value="yes">
		  <div class="row">
		  
	<div class="col-md-4">
	&nbsp;
	</div> 	  
		  <div class="col-md-4 well well-login">
			 <h3 class="panel-title" style="text-align:center">Lost Password</h3>
			 
			  <div class="form-group input-group">
			<label for="login" class="sr-only">Email</label>
			<div class="input-group-prepend">
			  <span class="input-group-text"><i class="fa fa-envelope"></i></span>
		</div>
	<input type="text" placeholder="Enter Your Email Here" name="email" required="required" class="form-control input-login" onMouseover="this.focus()" value="<?php echo isset($_REQUEST['email']) ? htmlspecialchars($_REQUEST['email']) : ''; ?>">

			<div style="height:10px;"></div>
	</div>		
			<button class="btn btn-info btn-block button-login" type="submit">&#10140; Submit</button>
			<div style="height:10px;"></div>		
	
	</div>

	<div class="col-md-4">
	&nbsp;
	</div> 
		  </div>

	</form>

<br/><br/>
	
<?php 
} // END NOT SUCCESS MSG!
include 'footer.php'; ?>

