<?php
//-----------------------------------------------------------------
// Software: Automatic Web Software (AWS) built with PHPCPR
// Firm: DirectSalesMLM.com / AutomaticWebSoftware.com / PHPCPR.com
// Author: Jim Symonds Email: jim@directsalesmlm.com
// Copyright 2006 - 2024 Jim Symonds All Rights Reserved.
//-----------------------------------------------------------------
?>
<!--
<link rel="stylesheet" href="flagscss/css/flag-icon.min.css">
-->
<style>
		@import "https://fonts.googleapis.com/css?family=Roboto+Condensed:Roboto:400,600,800";
		#proof-popup {
			border: none;
			background: transparent;
			z-index: 999;
			position: fixed;
			left: 0px; 
			bottom: 20px;
			margin: 0px 20px;
		}
		#proof-popup.hide-proof {
			visibility: hidden;
			opacity: 0;
			transition: visibility 0s 0.5s, opacity 0.4s linear
		}
		#proof-popup.show-proof {
			opacity: 1;
			-webkit-animation: shootUp 1100ms linear both;
			animation: shootUp 1100ms linear both
		}
		@keyframes shootUp{
			0%{
				-webkit-transform:matrix3d(1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1, 0, 0, 300, 0, 1);
				transform:matrix3d(1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1, 0, 0, 300, 0, 1)
			}
			4.1%{
				-webkit-transform:matrix3d(1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1, 0, 0, 125.912, 0, 1);
				transform:matrix3d(1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1, 0, 0, 125.912, 0, 1)
			}
			8.11%{
				-webkit-transform:matrix3d(1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1, 0, 0, 31.647, 0, 1);
				transform:matrix3d(1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1, 0, 0, 31.647, 0, 1)
			}
			12.11%{
				-webkit-transform:matrix3d(1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1, 0, 0, -5.53, 0, 1);
				transform:matrix3d(1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1, 0, 0, -5.53, 0, 1)
			}
			16.12%{
				-webkit-transform:matrix3d(1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1, 0, 0, -13.007, 0, 1);
				transform:matrix3d(1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1, 0, 0, -13.007, 0, 1)
			}
			27.23%{
				-webkit-transform:matrix3d(1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1, 0, 0, -2.352, 0, 1);
				transform:matrix3d(1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1, 0, 0, -2.352, 0, 1)~
			}
			38.34%{
				-webkit-transform:matrix3d(1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1, 0, 0, 0.311, 0, 1);
				transform:matrix3d(1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1, 0, 0, 0.311, 0, 1)
			}
			60.56%{
				-webkit-transform:matrix3d(1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1, 0, 0, -0.007, 0, 1);
				transform:matrix3d(1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1, 0, 0, -0.007, 0, 1)
			}
			82.78%{
				-webkit-transform:matrix3d(1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1);
				transform:matrix3d(1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1)
			}
			100%{
				-webkit-transform:matrix3d(1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1);
				transform:matrix3d(1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1)
			}
		}
		.bubble {
		    margin: 0 auto;
			/* margin-left: 160px; */
			margin-left: 0px;
			/* width: 320px; FOR NO PIC */
		    /* width: 370px; FOR PIC */
			width: 300px; 
		    height: 65px;
		    overflow: hidden;
		    position: relative;
			line-height: 1.25;
			border-radius: 40px;
		    background-color: #FFF;
		    box-shadow: 0 0 1px rgba(0,0,0,0.2), 0 1px 2px rgba(0,0,0,0.05), 0 8px 50px rgba(0,0,0,0.05);
		}
		.bubble .content {
			margin-left: 70px;
			/*margin-right: 30px;*/
			padding: 5px 0px 5px 0px;
			/*overflow: hidden;*/
			text-overflow: ellipsis;
			height: 65px;
		}
		@media only screen and (max-width: 767px) {
		  #proof-popup {
			bottom: calc(23px + 3.9 * 16px); /* Adjust this value as needed */
		  }
		}		
		.who {
			font-weight: bold;
			white-space: nowrap;
			font-family: "Roboto", helvetica, arial, sans-serif;
			font-feature-settings: "kern", "liga", "pnum";
			font-size: 14px;
			color: #000;
			width: 100%;
			line-height: 20px;
			text-overflow: ellipsis;
		}
		.what {
			font-family: "Roboto", helvetica, arial, sans-serif;
			font-feature-settings: "kern", "liga", "pnum";
			font-size: 12px;
			color: #333;
			width: 100%;
			line-height: 18px;
		}
		.when {
			color: #999;
			font-family: "Roboto", helvetica, arial, sans-serif;
			font-feature-settings: "kern", "liga", "pnum";
			font-size: 11px;
			width: 100%;
			line-height: 17px;
		}
		.bubble .image {
			display: block;
			position: absolute;
			top: 3px;
			left: 3px;
			height: 59px;
			width: 59px;
		}
		
		.bubble .image2 {
			position: absolute;
			top: 3px;
			left: 238px;
			height: 60px;
			width: 60px;			
			border-radius: 30px;
			-webkit-border-radius: 30px;
			-moz-border-radius: 30px;
			/*
			box-shadow: 0 0 8px rgba(0, 0, 0, .8);
			-webkit-box-shadow: 0 0 8px rgba(0, 0, 0, .8);
			-moz-box-shadow: 0 0 8px rgba(0, 0, 0, .8);
			*/	
		}
		
		.bubble .image img {
			border-radius: 50%;
			height: 60px;
			width: 60px;
		}
		
		.bubble .image2 img {
			border-radius: 50%;
			height: 60px;
			width: 60px;
		}		
		</style>
		
		<div id="proof-popup" class="hide-proof">
		<div class="bubble">
		<!-- FLAG SHOWN HERE -->
		<div class="image">
				<img id="country" src="">
			</div>		

			<div class="content" style="text-align:left">
				<div class="who" id="who"></div>
				<div class="what" id="what"></div>
				<div class="when" id="when"></div>
			</div>
			
			<!-- PIC SHOWN HERE -->
			<div class="image2">
			<img id="pic" src="">
			</div>
			
		</div>
	</div>
<?php

if (!isset($_SESSION['popup_status_time']) || strtotime(date("Y-m-d H:i:s")) > strtotime($_SESSION['popup_status_time']) + 300) {
  // Code to execute if the current time is 5 minutes greater than when the code last ran

	//$join_limit = date("Y-m-d H:i:s",strtotime("-1 days"));
	$join_limit = date("Y-m-d H:i:s", strtotime("-1 hours"));
	
	$selectFields = 'COUNT(ID) AS cnt';
	$mainTable = 'members';
	$where = [
		'Signdate' => ['>=', $join_limit],
		'Status' => ['=', 'paid']
	];

	$resultj = select($selectFields, $mainTable, [], $where);
	$members_joined = isset($resultj[0]['cnt']) ? number_format($resultj[0]['cnt']) : 0;
	//echo $members_joined. ' Leads Joined us in the last 7 days';
	
	$_SESSION['who'] = "";
	$_SESSION['what'] = "";
	$_SESSION['flag'] = "";
	$_SESSION['date'] = "";	
	$_SESSION['pic'] = "";
		
	// Fetch member details
	$selectFields = 'ID, First_Name, Last_Name, Signdate, Status';
	$mainTable = 'members';
	$where = [
		'Signdate' => ['>=', $join_limit],
		'Status' => ['=', 'paid']
	];
	$order = 'Signdate DESC';

	$result_mem = select($selectFields, $mainTable, [], $where, null, null, $order, 0, 1);
	
	$loop_count = 0;
	foreach ($result_mem as $buffer) {
	
		$loop_count = $loop_count + 1;
		$location = '';	
		if ($buffer['city'] != '') $location = $buffer['city'].", ";
		if ($buffer['state'] != '') $location .= $buffer['state']." ";
		//if ($buffer['country'] == '') $buffer['country'] = 'US';	
		//if ($buffer['country'] != '' && $buffer['city'] == '') $location .= $buffer['country'];

		if ($_SESSION['who'] != "") $_SESSION['who'] .= ",";
		// TOO LONG WHEN CITY STATE SHOWING
		//$_SESSION['who'] .= '"'.$buffer['First_Name'].' '.$buffer['Last_Name'].' from '.$location.'"';
		//$_SESSION['who'] .= '"'.$buffer['First_Name'].' '.$buffer['Last_Name'].' from '.$buffer['country'].'"';
		$_SESSION['who'] .= '"'.$buffer['First_Name'].' '.$buffer['Last_Name'].'"';
		
		$msg = '';
		if ($buffer['ID'] != '' && $buffer['Status'] == 'unpaid') $msg = '"Recent Pre Enrollee...'. $location.'"';	// ADDED LOCATION HERE FOR MORE ROOM (SMALLER FONT)
		else if ($buffer['Status'] == 'paid')  $msg = '"Recent Paid Member...'. $location.'"';	
		
		if ($_SESSION['what'] != "") $_SESSION['what'] .= ",";
		$_SESSION['what'] .= $msg;
		$no = '';
		
		if ($_SESSION['flag'] != "") $_SESSION['flag'] .= ",";
		// QQQ BELOW LINE WORKS FINE IN TEST DISPLAY, NOT IN JS POP UP
		//$_SESSION['flag'] .= '"'.$no.'<span class="flag-icon flag-icon-'.strtolower($buffer['country']).'"></span>"';
		
		$_SESSION['flag'] .= '"images/user.png"';

		// IN LEAD BUBBLE, FLAG IS USER ICON
		//$_SESSION['flag'] = '"<i class=\'fa fa-bell\'></i>"'.",".$_SESSION['flag'];
		//$_SESSION['flag'] = '"images/favicon.ico"'.",".$_SESSION['flag'];
			
		$ret = '';
		$timeline = (time()-strtotime($buffer['Signdate']));
		//$periods = array('day' => 86400, 'hour' => 3600, 'minute' => 60);
		$periods = array('hour' => 3600, 'minute' => 60);
		foreach($periods AS $name => $seconds){
			$num = floor($timeline / $seconds);
			$timeline -= ($num * $seconds);
			if ($ret != '') $ret .= ", ";
			
			$time_display = $num.' '.$name.(($num > 1) ? 's' : '');
			$begin_display = substr($time_display, 0, 6);
			if ($begin_display == "0 hour") { // CUT OFF '0 hour,' FROM SHOWING IN DISPLAY!
				$final_display = substr($time_display, 7, 50);
			} else if ($begin_display == "-1 hou") { // "r" MISSING HERE ON PURPOSE!! CUT OFF '-1 hour,' FROM SHOWING IN DISPLAY!
				$final_display = substr($time_display, 8, 50);			
			} else {
				$final_display = $time_display;
			}	

			$begin_display2 = substr($final_display, 0, 8);
			if ($begin_display2 == "0 minute") { // CUT OFF '0 minutes' FROM SHOWING IN DISPLAY!
				$final_display2 = 'Less than a minute';
			} else {
				$final_display2 = $final_display;
			}		
			
			$ret .= $final_display2;
		}

		//echo trim($ret).' ago<br><br>';
		
		if ($_SESSION['date'] != "") $_SESSION['date'] .= ",";
		$_SESSION['date'] .= '"'.trim($ret).' ago"';

		$image_path = '';
		$image_url = '';
		$image_path = $GLOBALS['path'].'images/Users/'.floor(($buffer['ID'] / 1000)).'/'.$buffer['ID'].'.jpg';
		
		//echo $image_path.'<br><br>';
		
		if (file_exists($image_path)) {
			$image_url = $GLOBALS['webpage_url_ssl'].'images/Users/'.floor(($buffer['ID'] / 1000)).'/'.$buffer['ID'].'.jpg';
		}
		//echo $image_url.'<br><br>';
		//SET AVATAR AS DEFAULT, WHEN NO IMAGE EXISTS
		//if ($image_url == '') $image_url = $GLOBALS['webpage_url_ssl'].'images/avatar.png';
		
		//SET CHECKMARK IMAGE AS DEFAULT, WHEN NO IMAGE EXISTS
		// MARCUS DOESN'T WANT CHECKMARK
		//if ($image_url == '' || $loop_count > 1) $image_url = $GLOBALS['webpage_url_ssl'].'images/CheckMark.png';
		if ($image_url == '' && $loop_count > 0) $image_url = $GLOBALS['webpage_url_ssl'].'images/check-circle2.png';	
		//if ($image_url == '') $image_url = $GLOBALS['webpage_url_ssl'].'images/Users/366/366607.jpg'	
		//$image_url = $GLOBALS['webpage_url_ssl'].'images/whitebg-aws.gif';
		
		if ($_SESSION['pic'] != "") $_SESSION['pic'] .= ",";
		$_SESSION['pic'] .= '"'.$image_url.'"';
		
		// TEST
		//$_SESSION['pic'] = '"/images/Users/366/366607.jpg", "/images/Users/366/366607.jpg"';
		
		$_SESSION['popup_status_time'] = date("Y-m-d H:i:s"); // TIME QUERIES LAST RUN FOR STATS
	 
	} // END MASTER FOR EACH LOOP


	// PIC OF ADMIN
	//$image_url = $GLOBALS['webpage_url_ssl'].'images/Users/'.floor((1 / 1000)).'/1.jpg';

	// SHOW USER ICON
	$image_url = $GLOBALS['webpage_url_ssl'].'images/user.png';

	$_SESSION['who'] = '"'.$members_joined.' New Paid Enrollees"'.",".$_SESSION['who'];
	$_SESSION['what'] = '"Showing ONLY last hour"'.",".$_SESSION['what'];
	//$_SESSION['flag'] = '"images/logobo.png"'.",".$_SESSION['flag'];
	$_SESSION['date'] = '"We are pleased to have you!"'.",".$_SESSION['date'];
	$_SESSION['date'] = '"Welcome New Users!"'.",".$_SESSION['date'];
	$_SESSION['pic'] = '"'.$image_url.'"'.",".$_SESSION['pic'];
	$_SESSION['flag'] = '"images/pleasewait.gif"'.",".$_SESSION['flag'];

} // END CODE ONLY RUNS EVERY 5 MINUTES

// IF WE ONLY HAVE 3 OR LESS MEMBERS, DO NOT SHOW BUBBLE!
if ($members_joined <= 3) {
   $_SESSION['who'] = "";
   $_SESSION['what'] = "";
   $_SESSION['flag'] = "";
   $_SESSION['date'] = "";	
   $_SESSION['pic'] = "";
}
?>
<!--
                        <?php echo $_SESSION['who']; ?>&nbsp;<p></p>
						<?php echo $_SESSION['what']; ?>&nbsp;<p></p>
						<?php echo $_SESSION['flag']; ?>&nbsp;<p></p>
                        <?php echo $_SESSION['date'];?>&nbsp;<p></p>
						
						<?php echo $_SESSION['pic']; 
						//exit;
						?>
						<br/>
-->						
<?php
//print_r($_SESSION);
?>	
<script>	
	var who_array = [<?php echo $_SESSION['who']; ?>];
	var what_array = [<?php echo $_SESSION['what']; ?>];
	var when_array = [<?php echo $_SESSION['date'];?>];
	var map_url_array = [<?php echo $_SESSION['flag']; ?>];
	var pic_url_array = [<?php echo $_SESSION['pic']; ?>];
			
	var index_array = Array.apply(null, {length: who_array.length}).map(Number.call, Number);
	var delay = 1000;
	var milisecs_hiding = 3 * 1000 - delay;
	var milisecs_to_start = 3 * 1000 - delay;
	
	/*var delay = 10000; // Delay set to 10 seconds (10000 milliseconds)
	var milisecs_hiding = 10 * 1000 - delay;
	var milisecs_to_start = 10 * 1000 - delay;
	// idea for future use - has issue currently as first lead info comes on/off too quick - delay does not account for next bubble yet!
	// so axing for now!
	*/


	function refresh_bubble(step) {
		document.getElementById('who').innerHTML = who_array[index_array[step]];
		document.getElementById('what').innerHTML = what_array[index_array[step]];
		document.getElementById('when').innerHTML = when_array[index_array[step]];
		document.getElementById('country').src = map_url_array[index_array[step]];
		document.getElementById('pic').src = pic_url_array[index_array[step]];
		
		setTimeout(function() {
			document.getElementById('proof-popup').className = 'show-proof';

			setTimeout(function() {
				popdown_bubble(step);
			}, 7000);
		}, delay);
	}
	
	function popdown_bubble(step) {
		document.getElementById('proof-popup').className = 'hide-proof';
		
		setTimeout(function() {
			if (step < (who_array.length - 1)) {
				refresh_bubble(step + 1);
			} else {
				refresh_bubble(0);
			}
		}, milisecs_hiding);
	}
	
	/*setTimeout(function() {
		refresh_bubble(0);
	}, milisecs_to_start);*/

/*only show bubble if more than or equal to the number below!!*/
	
if (who_array.length >= 3) {
   setTimeout(function() {
      refresh_bubble(0);
   }, milisecs_to_start);
}
	
	</script>	