<?php
//-----------------------------------------------------------------
// Software: Automatic Web Software (AWS) built with PHPCPR
// Firm: DirectSalesMLM.com / AutomaticWebSoftware.com / PHPCPR.com
// Author: Jim Symonds Email: jim@directsalesmlm.com
// Copyright 2006 - 2024 Jim Symonds All Rights Reserved.
//-----------------------------------------------------------------
include './cookie.php'; 
include ''.$Global['admin_dir'].'/Lib/Pagination.function.php';

$pageName = 'View My Powerline';
$pageDesc = '';
$pageIcon = 'fa fa-group';
$pageAlign = 'center';
$pageClass = 'leads';
$thisPage = 'viewmypowerline.php';

//SHOW ALL ERRORS
//error_reporting(-1);
//error_reporting = E_ALL;
//$debug = false;
//$debug = true;
///*
if ((isset($_GET['dev']) && !empty($_GET['dev'])) || (isset($_SESSION['dev']) && !empty($_SESSION['dev']))) {
	$_SESSION['dev'] = true;
	//$loggedin_user_is_closer = false;
	$debug = true;
} else {
	//$debug = false;
	//echo 'Locked for dev use';
	//exit;
}
//*/
//$debug = true; // QQQ COMMENT UNCOMENT FOR TESTING // LIVE USE
//$_SESSION['dev'] = false; // QQQ COMMENT UNCOMENT FOR TESTING

// KILL DEV DESSION
if (isset($_GET['dev']) && $_GET['dev'] == '0') {
	$debug = false;
	$_SESSION['dev'] = false;
}
unset($buffer);

// GET LAST WEDNESDAY MIDNIGHT
date_default_timezone_set('America/Chicago');

// Get the current day of the week (0 = Sunday, 1 = Monday, ..., 6 = Saturday)
$currentDayOfWeek = date('w');

$cutoff_day = $GLOBALS['cutoff_day']; // CUTOFF DAY
$cutoff_dayOfWeek = $GLOBALS['cutoff_dayOfWeek']; // CUTOFF DAY NUMBER
$cutoff_dayOfWeek = $cutoff_dayOfWeek + 1; // SET REAL CUTOFF DAY NUMBER - IS NEXT DAY FOR MIDNIGHT OF SAME DAY!!

// Calculate the number of days to subtract to get to the last Wednesday (3 = Wednesday)
// BUT WE SET TO 4, WE WANT END OF DAY FIRST SECOND OF THURSDAY!
$daysToSubtract = ($currentDayOfWeek + 7 - $cutoff_dayOfWeek) % 7;

// Get the current date and time in the specified timezone
$currentDateTime = new DateTime();

// Subtract the days to get to the last cutoff day
$currentDateTime->sub(new DateInterval('P' . $daysToSubtract . 'D'));

// Set the time to 12:00 AM (midnight)
$currentDateTime->setTime(0, 0, 0);

//echo $currentDateTime->format('Y-m-d H:i:s');

$last_cutoff = $currentDateTime->format('Y-m-d H:i:s');

// Add 7 days to the last cutoff, to get next cutoff
$next_cutoff_datetime = new DateTime($last_cutoff);
$next_cutoff_datetime->add(new DateInterval('P7D'));

// Set the timezone for the next cutoff to Chicago
$next_cutoff_datetime->setTimezone(new DateTimeZone('America/Chicago'));

$next_cutoff = $next_cutoff_datetime->format('Y-m-d H:i:s');

// Convert $next_cutoff to a UTC timestamp in milliseconds
$next_cutoff_utc = strtotime($next_cutoff) * 1000;


// WORKS GREAT!
if ($debug == true) echo '<br>last cutoff: '.$last_cutoff;
if ($debug == true) echo '<br>next cutoff: '.$next_cutoff;

// Step 1: Retrieve the uid from the query string
if (isset($_GET['uid']) && $_GET['uid'] != '') {
    // Assign and sanitize $uid from $_GET
	$uid = isset($_GET['uid']) ? htmlspecialchars(strip_tags(filter_input(INPUT_GET, 'uid')), ENT_QUOTES, 'UTF-8') : null;
	// Sanitize the input
	//$uid = filter_var($uid, FILTER_SANITIZE_STRING);
} else {
    // Handle the case where 'uid' is not provided
    //echo "No uid provided.";
    //exit();
	header("Location: /login.php");
	exit;
}


// GET user info & Signdate!
if (isset($buffer)) unset($buffer);

// Define the fields to select
$selectFields = ['Username', 'First_Name', 'email', 'Signdate'];

// Specify the main table
$mainTable = 'members';

// Define the where condition
$where = ['unsubscribe_id' => ['=', $uid], 'Status' => ['=', 'unpaid']];

// Execute the select query using PHPCPR's select function
$result = select($selectFields, $mainTable, [], $where, null, null, null, 1, 1);

// Fetch the result
if ($result && count($result) > 0) {
	$buffer = $result[0]; // Assuming the select function returns an array of results
	$signdate = $buffer['Signdate'];
	$fname = $buffer['First_Name'];
	//print_r($buffer); 

	if (empty($buffer['Username'])) {
		header("Location: /login.php");
		exit;
	}
}


//if (is_email($buffer['email'])) {
if (is_email($buffer['Username'])) { // CHANGED ON 9/6/23	
	$action_link = '/Members/username-setup.php';
} else {
	//$action_link = '/apay/pay.php';
	//$action_link = '/Members/sponsor-check.php';
	$action_link = 'login.php';
}

if ($GLOBALS['powerline_program_id'] == 0) { // 0 WHEN NOT IN USE!
	// POWERLINE FEAR OF LOSS SYSTEM IS NOT BEING USED, SO REDIRECT NOW!
	header("Location: {$action_link}");
	exit;
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<title>View My Powerline</title>
<!--<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">-->

  <script src="https://ajax.googleapis.com/ajax/libs/jquery/2.1.1/jquery.min.js"></script>
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/flipclock/0.7.8/flipclock.css" />
  <script src="https://cdnjs.cloudflare.com/ajax/libs/flipclock/0.7.8/flipclock.min.js"></script>

			<script src="//netdna.bootstrapcdn.com/bootstrap/3.0.0/js/bootstrap.min.js"></script>
			<link rel="stylesheet" href="//maxcdn.bootstrapcdn.com/bootstrap/3.3.7/css/bootstrap.min.css">

        <link href="//maxcdn.bootstrapcdn.com/font-awesome/4.7.0/css/font-awesome.min.css" rel="stylesheet" type="text/css" />
		
	<!-- NEXT 2 INCLUDES ARE FOR ANIMATED WOW EFFECTS -->
    <link href="https://cdnjs.cloudflare.com/ajax/libs/animate.css/3.7.0/animate.min.css" rel="stylesheet">
	<script src="https://cdnjs.cloudflare.com/ajax/libs/wow/1.1.2/wow.min.js"></script>			
		
    <style>
        body {
            margin: 30px;
        }
		
/* Styles for screens that are 768px wide or less */
@media (max-width: 768px) {
  body {
    margin: 10px;
  }
}		
h1 {color:#000;}
h2 {color:#05e6f2;
 text-shadow: 1px 1px 2px rgba(0, 0, 0, 0.5);
}
h3 {color:#516872;}
h4 {color:#516872;
font-size: 43px;
}
h5 {color:#516872;
font-size: 18px;
}
</style>
<style>
.clock {
  margin: 0 auto;
  width: 700px;
}
</style>

	
<?php
//include_once './header.php';
?>
<script>
new WOW().init(); 
$(document).ready(function() {
    $('a[href*="#"]:not([href="#"])').click(function() {
      if (location.pathname.replace(/^\//,'') == this.pathname.replace(/^\//,'') && location.hostname == this.hostname) {
        var target = $(this.hash);
        target = target.length ? target : $('[name=' + this.hash.slice(1) +']');
        if (target.length) {
          $('html, body').animate({
            scrollTop: target.offset().top
          }, 1000);
          return false;
        }
      }
    });
  });
</script>
</head>
<body>
<div style="text-align:center">
<!--
	  <img src="/images/logo9.png" class="img-responsive wow fadeInRight" style="width:250px; background-color:#;">
	  -->
	  
<h4 class="wow fadeInLeft">Congratulations <?php echo $fname; ?>!</h4>
<h2 class="wow fadeInRight">Your FREE TEMPORARY PRE-ENROLLEE
Position is in!</h2><br>
<a href="<?php echo $action_link; ?>" class="btn btn-lg btn-danger wow fadeInLeft"><?php echo strtoupper($cutoff_day); ?> is the CUTOFF</a>

<br><br><br>
<div class="class="wow fadeInRight" style="text-align:center; background-color:#eee">
<!-- COUNTDOWN TIMER -->
<!-- FlipClock Countdown Timer -->
  <div class="clock wow fadeInRight" style="margin: 0 auto; max-width:80%"></div>
</div>


  <script>
    // Set the target date to next Wednesday midnight
    var targetDate = new Date(<?php echo $next_cutoff_utc; ?>);
    var currentDate = new Date();
    var timeDifference = targetDate - currentDate;

    if (timeDifference <= 0) {
      document.querySelector('.clock').innerHTML = "Time's up!";
    } else {
      var clock = $('.clock').FlipClock(timeDifference / 1000, {
        clockFace: 'DailyCounter',
        countdown: true
      });
    }
  </script>



<br><br><br>
<a href="<?php echo $action_link; ?>" class="btn btn-lg btn-info wow fadeIn One">LOCK IN YOUR POSITION</a>	  
	  
</div>
<?php
//the styling of the results table
$nr = 1;
$color[0] = 'FFFFFF';
$color[1] = 'F0F0F0';
$color[2] = '#abf5bc'; // PAID

// GET UNPAID COUNT
// Define the fields to select and the conditions
$selectFields = ['COUNT(ID) AS count'];
$whereUnpaid = ['Status' => ['=', 'unpaid'], 'Signdate' => ['>', $signdate]];

// Execute the select query for unpaid count
$resultUnpaid = select($selectFields, 'members', [], $whereUnpaid, null, null, null, 1, 1);
$unpaid = ($resultUnpaid && count($resultUnpaid) > 0) ? $resultUnpaid[0]['count'] : 0;

// GET PAID COUNT
$wherePaid = ['Status' => ['=', 'paid'], 'Signdate' => ['>', $signdate]];

// Execute the select query for paid count
$resultPaid = select($selectFields, 'members', [], $wherePaid, null, null, null, 1, 1);
$paid = ($resultPaid && count($resultPaid) > 0) ? $resultPaid[0]['count'] : 0;

if ($debug == true) echo "Value of \$signdate: " . $signdate . "<br>";
if ($debug == true) echo "Value of \$last_cutoff: " . $last_cutoff . "<br>";

// Determine the most recent date to use
if ($signdate > $last_cutoff) {
    $most_recent = $signdate;
    if ($debug == true) echo "Setting \$most_recent to \$signdate: " . $most_recent . "<br>";
} else {
    $most_recent = $last_cutoff;
    if ($debug == true) echo "Setting \$most_recent to \$last_cutoff: " . $most_recent . "<br>";
}



//"SELECT COUNT(ID) AS count FROM members WHERE Status = 'paid' AND Signdate > '$signdate' AND Signdate > '$most_recent'";
// GET PAID SINCE USER SIGN UP AND LAST CUTOFF
$selectFields = ['COUNT(ID) AS count'];
$wherePaidSinceSignUp = [
    'Status' => ['=', 'paid'],
    'Signdate' => [
        '>', $most_recent
    ]
];

// Execute the select query for paid count since sign up
$resultPaidSinceSignUp = select($selectFields, 'members', [], $wherePaidSinceSignUp, null, null, null, 1, 1);
$paid_last_week = ($resultPaidSinceSignUp && count($resultPaidSinceSignUp) > 0) ? $resultPaidSinceSignUp[0]['count'] : 0;

$paid_difference = $paid - $paid_last_week;


// NOT SURE IF SHOULD DO NEXT LINE - WILL THROW NUMBERS OFF
//if ($paid_difference == 0) $paid_difference = $paid;

/* THE VARS
$unpaid
$paid
$paid_difference
$paid_last_week
*/

// GET THE TOTAL COUNT!
$selectFields = ['COUNT(DISTINCT ID) AS cnt'];
$mainTable = 'members';
$where = ['Signdate' => ['>', $signdate]];

// Execute the select query using PHPCPR's select function
$resultTotalCount = select($selectFields, $mainTable, [], $where, null, null, null, 1, 1);

// Fetch the result
if ($resultTotalCount && count($resultTotalCount) > 0) {
    $buffer = $resultTotalCount[0]; // Assuming the select function returns an array of results
    $totalCount = $buffer['cnt'];

    if ($debug == true) {
        echo "Total count of unique members since {$signdate}: " . $totalCount . "<br><br>";
    }
} else {
    // Handle the case when no results are found or an error occurred
    $totalCount = 0;

    if ($debug == true) {
        echo "No members found.<br><br>";
    }
}


//paging params
$results_per_page = 25;
$total_pages = ceil($buffer['cnt']/$results_per_page);
$page = (isset($_GET['page']) && ctype_digit((string)$_GET['page']) ? $_GET['page']:1);
if ($page > $total_pages && $total_pages > 0) {
	$page = $total_pages;
} elseif ($page < 1) {
	$page = 1;
}
?>

<?php
//GET REAL DATA -- ALL MEMBERS WHO JOINED AFTER THIS GUY
/*$query_rows = "SELECT * FROM members WHERE Signdate > '{$signdate}'";
$query = "{$query_rows} LIMIT ".(($page-1)*$results_per_page).', '.$results_per_page;
if ($debug == true) echo $query.'<br><br>';
$result_rows = mysql_query($query_rows) or die(mysql_error());
$rows = mysql_num_rows($result_rows);*/

// Prepare to get the total count of matching rows
$countFields = ['COUNT(*) AS total_count'];
$countWhere = ['Signdate' => ['>', $signdate]];

// Execute the count query
$resultCount = select($countFields, $mainTable, [], $countWhere);
$rows = ($resultCount && count($resultCount) > 0) ? $resultCount[0]['total_count'] : 0;

// Prepare to get the paginated data
$dataFields = ['*']; // Select all fields for actual data retrieval
$mainTable = 'members';
$joinConditions = [];
$where = ['Signdate' => ['>', $signdate]];
//$limit = $results_per_page;
$offset = ($page - 1) * $results_per_page;

$groupBy = null;
$having = null;
$orderBy = null;
//$limit = null;
$show_debug = 1;

// Using limit as an integer
//$limit = 500;

// Using limit as an array
$limit= ['count' => $results_per_page, 'offset' => $offset]; 
// Execute the select query for the REAL paginated data
$result = select($dataFields, $mainTable, $joinConditions, $where, $groupBy, $having, $orderBy, $limit, $show_debug);
?>
<!-- EXAMPLE
115 Pre-Enrollees and 10 PAID Members Have ALREADY been placed below you in YOUR POWERLINE.
You already missed out on 0 paid members. Join Before Wednesday or you Miss Out on 10 More!-->

<!--
<h4 class="wow fadeInLeft">
<?php echo $unpaid; ?> Pre-Enrollees and <?php echo $paid; ?> PAID Members Have ALREADY been placed below you in YOUR POWERLINE.
</h4>
-->
<br>
<h4 class="wow fadeInLeft">
<?php echo $unpaid; ?> Pre-Enrollees and <?php echo $paid; ?> PAID Members Have ALREADY been placed before you in YOUR POWERLINE.
</h4>

<?php
echo '<h3 class="wow fadeInRight">';

if ($paid_difference > 0) 
	echo 'You already missed out on '.$paid_difference.' paid members.&nbsp;';
else
	echo 'You already missed out on all past paid members.&nbsp;';

if (false && $paid_last_week > 0) 
	echo 'Join Before '.$cutoff_day.' or you Miss Out on '.$paid_last_week.' More!';
else 
	echo 'Join Before '.$cutoff_day.' or you may Miss Out on more paid signups!';

echo '</h3><br>';

echo '*Please note spillover is always possible, but is not guaranteed. This system works best for those who share and promote it.';
?>
<h2 class="wow fadeIn Two" style="text-align:center">View My Powerline</h2>

<br>
<?php
echo '<h5 class="wow fadeIn One">Showing All Signups: ';
echo $rows.' Results</h5>';

if ($rows > 0) { ?>
 

<div class="row">
<div class="table-responsive">
<table class="table">
<tr>
	<td style="font-weight: bold">TYPE</td>
	<td style="font-weight: bold">NAME</td>
	
	<td style="font-weight: bold">DATE</td>
	<td style="width:65px; font-weight: bold">&nbsp;</td>	
</tr>


<?php
// Assuming $result is the array of results returned by the select function
if ($result && count($result) > 0) {
    foreach ($result as $buffer) {
        // Process each row in $buffer
        // Example: accessing a column value from $buffer
        // $columnValue = $buffer['columnName'];
	
	
	//if ($debug == true) print_r($buffer);
	
	$bg_color = ($nr % 2 == 0) ? $color[0] : $color[1]; 

    if ($buffer['Status'] == 'paid') {
        $bg_color = $color[2]; // Change background color for paid members
    }
	?>
	
	<tr bgcolor="<?php echo $bg_color; ?>">
	<td>
	<?php if ($buffer['Status'] == 'paid' || $buffer['Status'] == 'Cancelled') { ?>
	<li class="fa fa-check-square-o btn-success" style="color:#" title="Paid Member" aria-hidden="true"></li>
	<?php } else { ?>
	<i class="fa fa-mail-forward" style="color:#5bc0de" title="Pre Enrollee" aria-hidden="true"></i>		
	<?php } ?>

	<?php if ($buffer['Status'] == 'paid') {
		echo 'Paid Member';
	} else {
		echo 'Pre-Enrollee';
	}?>
	</td>
	<td>
	<?php echo $buffer['First_Name']; ?> <?php echo $buffer['Last_Name']; ?>
	</td>
	<td>
	<?php echo $buffer['Signdate']; ?>
	</td>
	<td>
	</td>	
	</tr>

<?php
	++$nr;
	} // END WHILE LOOP!
}	
?>

<tr>
	<td colspan="4" align="right"><?php echo pagination_links($page, $total_pages, 6, $thisPage.'?uid='.$_GET['uid'].'&', array('page' => 'Page', 'first' => 'first', 'last' => 'last')); ?></td>
</tr>

</table>
</div>
</div>

<div style="text-align:center;">
&copy; Copyright <?php echo date('Y');?>, <?php echo $Global['webpage_name'];?>. All Rights Reserved. <!--<a href="#" data-toggle="modal" data-target="#privacy">Privacy</a>
  <a href="#" data-toggle="modal" data-target="#terms">Terms</a>
&nbsp;<a href="/contact.php?id=<?php echo $SponsorID;?>" style="color:#;">Contact</a>
&nbsp;<a href="/join.php?id=<?php echo $SponsorID;?>" style="color:#;">Join Now</a>-->

<!---->
<br/>
<small>
<a href="https://DirectSalesMLM.com" title="The Preferred MLM Software" target="_blank">
Powered By Direct Sales MLM Software</a>
</small>

</div>

<?php
 
if ($_SERVER['REQUEST_METHOD'] != 'POST') { ?>
<!--		
<script>		
		$(document).ready(function(){
			$.post("visits.php", //Required URL of the page on server
			{ // Data Sending With Request To Server
			page: "1",
			sponsor: '<?php echo $SponsorID; ?>'
			});
			return false;
		});

</script>
-->
<?php 
if (true || $SponsorID == 'test') {
	include 'popup.members.inc.php';	
}
}
?>

</body>
</html>
<?php
}
//include_once './footer.php';
?>